/*
 * Decompiled with CFR 0.152.
 */
package android.inputmethodservice;

import android.compat.annotation.UnsupportedAppUsage;
import android.content.Context;
import android.graphics.Rect;
import android.hardware.input.InputManager;
import android.os.Bundle;
import android.os.Looper;
import android.os.Message;
import android.os.SystemClock;
import android.util.Log;
import android.util.SparseArray;
import android.view.InputChannel;
import android.view.InputEvent;
import android.view.InputEventReceiver;
import android.view.KeyEvent;
import android.view.MotionEvent;
import android.view.inputmethod.CompletionInfo;
import android.view.inputmethod.CursorAnchorInfo;
import android.view.inputmethod.EditorInfo;
import android.view.inputmethod.ExtractedText;
import android.view.inputmethod.Flags;
import android.view.inputmethod.InputMethodSession;
import com.android.internal.inputmethod.IInputMethodSession;
import com.android.internal.inputmethod.IRemoteInputConnection;
import com.android.internal.os.HandlerCaller;
import com.android.internal.os.SomeArgs;
import java.util.Objects;

class IInputMethodSessionWrapper
extends IInputMethodSession.Stub
implements HandlerCaller.Callback {
    private static final String TAG = "InputMethodWrapper";
    private static final int DO_DISPLAY_COMPLETIONS = 65;
    private static final int DO_UPDATE_EXTRACTED_TEXT = 67;
    private static final int DO_UPDATE_SELECTION = 90;
    private static final int DO_UPDATE_CURSOR = 95;
    private static final int DO_UPDATE_CURSOR_ANCHOR_INFO = 99;
    private static final int DO_APP_PRIVATE_COMMAND = 100;
    private static final int DO_FINISH_SESSION = 110;
    private static final int DO_VIEW_CLICKED = 115;
    private static final int DO_REMOVE_IME_SURFACE = 130;
    private static final int DO_FINISH_INPUT = 140;
    private static final int DO_INVALIDATE_INPUT = 150;
    private final Context mContext;
    @UnsupportedAppUsage
    HandlerCaller mCaller;
    InputMethodSession mInputMethodSession;
    InputChannel mChannel;
    ImeInputEventReceiver mReceiver;

    public IInputMethodSessionWrapper(Context context, InputMethodSession inputMethodSession, InputChannel channel) {
        this.mContext = context;
        this.mCaller = new HandlerCaller(context, null, this, true);
        this.mInputMethodSession = inputMethodSession;
        this.mChannel = channel;
        if (channel != null) {
            this.mReceiver = new ImeInputEventReceiver(channel, context.getMainLooper());
        }
    }

    public InputMethodSession getInternalInputMethodSession() {
        return this.mInputMethodSession;
    }

    @Override
    public void executeMessage(Message msg) {
        if (this.mInputMethodSession == null) {
            switch (msg.what) {
                case 90: 
                case 100: {
                    SomeArgs args = (SomeArgs)msg.obj;
                    args.recycle();
                }
            }
            return;
        }
        switch (msg.what) {
            case 65: {
                this.mInputMethodSession.displayCompletions((CompletionInfo[])msg.obj);
                return;
            }
            case 67: {
                this.mInputMethodSession.updateExtractedText(msg.arg1, (ExtractedText)msg.obj);
                return;
            }
            case 90: {
                SomeArgs args = (SomeArgs)msg.obj;
                this.mInputMethodSession.updateSelection(args.argi1, args.argi2, args.argi3, args.argi4, args.argi5, args.argi6);
                args.recycle();
                return;
            }
            case 95: {
                this.mInputMethodSession.updateCursor((Rect)msg.obj);
                return;
            }
            case 99: {
                this.mInputMethodSession.updateCursorAnchorInfo((CursorAnchorInfo)msg.obj);
                return;
            }
            case 100: {
                SomeArgs args = (SomeArgs)msg.obj;
                this.mInputMethodSession.appPrivateCommand((String)args.arg1, (Bundle)args.arg2);
                args.recycle();
                return;
            }
            case 110: {
                this.doFinishSession();
                return;
            }
            case 115: {
                this.mInputMethodSession.viewClicked(msg.arg1 == 1);
                return;
            }
            case 130: {
                this.mInputMethodSession.removeImeSurface();
                return;
            }
            case 140: {
                this.mInputMethodSession.finishInput();
                return;
            }
            case 150: {
                SomeArgs args = (SomeArgs)msg.obj;
                try {
                    this.mInputMethodSession.invalidateInputInternal((EditorInfo)args.arg1, (IRemoteInputConnection)args.arg2, msg.arg1);
                }
                finally {
                    args.recycle();
                }
                return;
            }
        }
        Log.w(TAG, "Unhandled message code: " + msg.what);
    }

    private void doFinishSession() {
        this.mInputMethodSession = null;
        if (this.mReceiver != null) {
            this.mReceiver.dispose();
            this.mReceiver = null;
        }
        if (this.mChannel != null) {
            this.mChannel.dispose();
            this.mChannel = null;
        }
    }

    @Override
    public void displayCompletions(CompletionInfo[] completions) {
        this.mCaller.executeOrSendMessage(this.mCaller.obtainMessageO(65, completions));
    }

    @Override
    public void updateExtractedText(int token, ExtractedText text) {
        this.mCaller.executeOrSendMessage(this.mCaller.obtainMessageIO(67, token, text));
    }

    @Override
    public void updateSelection(int oldSelStart, int oldSelEnd, int newSelStart, int newSelEnd, int candidatesStart, int candidatesEnd) {
        this.mCaller.executeOrSendMessage(this.mCaller.obtainMessageIIIIII(90, oldSelStart, oldSelEnd, newSelStart, newSelEnd, candidatesStart, candidatesEnd));
    }

    @Override
    public void viewClicked(boolean focusChanged) {
        this.mCaller.executeOrSendMessage(this.mCaller.obtainMessageI(115, focusChanged ? 1 : 0));
    }

    @Override
    public void removeImeSurface() {
        this.mCaller.executeOrSendMessage(this.mCaller.obtainMessage(130));
    }

    @Override
    public void updateCursor(Rect newCursor) {
        this.mCaller.executeOrSendMessage(this.mCaller.obtainMessageO(95, newCursor));
    }

    @Override
    public void updateCursorAnchorInfo(CursorAnchorInfo cursorAnchorInfo) {
        this.mCaller.executeOrSendMessage(this.mCaller.obtainMessageO(99, cursorAnchorInfo));
    }

    @Override
    public void appPrivateCommand(String action, Bundle data) {
        this.mCaller.executeOrSendMessage(this.mCaller.obtainMessageOO(100, action, data));
    }

    @Override
    public void finishSession() {
        this.mCaller.executeOrSendMessage(this.mCaller.obtainMessage(110));
    }

    @Override
    public void invalidateInput(EditorInfo editorInfo, IRemoteInputConnection inputConnection, int sessionId) {
        this.mCaller.executeOrSendMessage(this.mCaller.obtainMessageIOO(150, sessionId, editorInfo, inputConnection));
    }

    @Override
    public void finishInput() {
        this.mCaller.executeOrSendMessage(this.mCaller.obtainMessage(140));
    }

    private class ImeInputEventReceiver
    extends InputEventReceiver
    implements InputMethodSession.EventCallback {
        private static final long KEY_EVENT_ALLOW_PERIOD_MS = 100L;
        private final SparseArray<InputEvent> mPendingEvents;

        public ImeInputEventReceiver(InputChannel inputChannel, Looper looper) {
            super(inputChannel, looper);
            this.mPendingEvents = new SparseArray();
        }

        @Override
        public void onInputEvent(InputEvent event) {
            KeyEvent keyEvent;
            if (IInputMethodSessionWrapper.this.mInputMethodSession == null) {
                this.finishInputEvent(event, false);
                return;
            }
            if (event instanceof KeyEvent && this.needsVerification(keyEvent = (KeyEvent)event)) {
                InputManager im = IInputMethodSessionWrapper.this.mContext.getSystemService(InputManager.class);
                Objects.requireNonNull(im);
                long age = SystemClock.uptimeMillis() - keyEvent.getEventTime();
                if (age >= 100L && im.verifyInputEvent(keyEvent) == null) {
                    Log.w(IInputMethodSessionWrapper.TAG, "Unverified or Invalid KeyEvent injected into IME. Dropping " + keyEvent);
                    this.finishInputEvent(event, false);
                    return;
                }
            }
            int seq = event.getSequenceNumber();
            this.mPendingEvents.put(seq, event);
            if (event instanceof KeyEvent) {
                KeyEvent keyEvent2 = (KeyEvent)event;
                IInputMethodSessionWrapper.this.mInputMethodSession.dispatchKeyEvent(seq, keyEvent2, this);
            } else {
                MotionEvent motionEvent = (MotionEvent)event;
                if (motionEvent.isFromSource(4)) {
                    IInputMethodSessionWrapper.this.mInputMethodSession.dispatchTrackballEvent(seq, motionEvent, this);
                } else {
                    IInputMethodSessionWrapper.this.mInputMethodSession.dispatchGenericMotionEvent(seq, motionEvent, this);
                }
            }
        }

        @Override
        public void finishedEvent(int seq, boolean handled) {
            int index = this.mPendingEvents.indexOfKey(seq);
            if (index >= 0) {
                InputEvent event = this.mPendingEvents.valueAt(index);
                this.mPendingEvents.removeAt(index);
                this.finishInputEvent(event, handled);
            }
        }

        private boolean hasKeyModifiers(KeyEvent event) {
            if (event.hasNoModifiers()) {
                return false;
            }
            return event.isCtrlPressed() || event.isAltPressed() || event.isFunctionPressed() || event.isMetaPressed();
        }

        private boolean needsVerification(KeyEvent event) {
            return Flags.verifyKeyEvent() && (this.hasKeyModifiers(event) || IInputMethodSessionWrapper.this.mInputMethodSession.onShouldVerifyKeyEvent(event));
        }
    }
}

