/*
 * Decompiled with CFR 0.152.
 */
package android.health.connect.migration;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.annotation.SystemApi;
import android.health.connect.datatypes.DataOrigin;
import android.health.connect.migration.MigrationPayload;
import android.os.Parcel;
import android.os.Parcelable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@SystemApi
public class PriorityMigrationPayload
extends MigrationPayload
implements Parcelable {
    @NonNull
    public static final Parcelable.Creator<PriorityMigrationPayload> CREATOR = new Parcelable.Creator<PriorityMigrationPayload>(){

        @Override
        public PriorityMigrationPayload createFromParcel(Parcel in) {
            in.readInt();
            return new PriorityMigrationPayload(in);
        }

        public PriorityMigrationPayload[] newArray(int size) {
            return new PriorityMigrationPayload[size];
        }
    };
    private final int mDataCategory;
    private final List<DataOrigin> mDataOrigins;

    private PriorityMigrationPayload(int dataCategory, @NonNull List<DataOrigin> dataOrigins) {
        Objects.requireNonNull(dataOrigins);
        this.mDataCategory = dataCategory;
        this.mDataOrigins = dataOrigins;
    }

    PriorityMigrationPayload(@NonNull Parcel in) {
        this.mDataCategory = in.readInt();
        this.mDataOrigins = Objects.requireNonNull(in.createStringArrayList()).stream().map(PriorityMigrationPayload::dataOriginOf).toList();
    }

    private static DataOrigin dataOriginOf(@Nullable String packageName) {
        return new DataOrigin.Builder().setPackageName(packageName).build();
    }

    @Override
    public void writeToParcel(@NonNull Parcel dest, int flags) {
        dest.writeInt(4);
        dest.writeInt(this.mDataCategory);
        dest.writeStringList(this.mDataOrigins.stream().map(DataOrigin::getPackageName).toList());
    }

    @Override
    public int describeContents() {
        return 0;
    }

    public int getDataCategory() {
        return this.mDataCategory;
    }

    @NonNull
    public List<DataOrigin> getDataOrigins() {
        return this.mDataOrigins;
    }

    public static class Builder {
        private final List<DataOrigin> mDataOrigins = new ArrayList<DataOrigin>();
        private int mDataCategory = 0;

        @NonNull
        public Builder setDataCategory(int dataCategory) {
            this.mDataCategory = dataCategory;
            return this;
        }

        @NonNull
        public Builder addDataOrigin(@NonNull DataOrigin dataOrigin) {
            Objects.requireNonNull(dataOrigin);
            this.mDataOrigins.add(dataOrigin);
            return this;
        }

        @NonNull
        public PriorityMigrationPayload build() {
            return new PriorityMigrationPayload(this.mDataCategory, this.mDataOrigins);
        }
    }
}

