/*
 * Decompiled with CFR 0.152.
 */
package android.health.connect.migration;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.annotation.SystemApi;
import android.health.connect.migration.MigrationPayload;
import android.os.Parcel;
import android.os.Parcelable;
import java.util.Objects;

@SystemApi
public class AppInfoMigrationPayload
extends MigrationPayload
implements Parcelable {
    @NonNull
    public static final Parcelable.Creator<AppInfoMigrationPayload> CREATOR = new Parcelable.Creator<AppInfoMigrationPayload>(){

        @Override
        public AppInfoMigrationPayload createFromParcel(Parcel in) {
            in.readInt();
            return new AppInfoMigrationPayload(in);
        }

        public AppInfoMigrationPayload[] newArray(int size) {
            return new AppInfoMigrationPayload[size];
        }
    };
    private final String mPackageName;
    private final String mAppName;
    private final byte[] mAppIcon;

    private AppInfoMigrationPayload(@NonNull String packageName, @NonNull String appName, @Nullable byte[] appIcon) {
        this.mPackageName = packageName;
        this.mAppName = appName;
        this.mAppIcon = appIcon;
    }

    AppInfoMigrationPayload(@NonNull Parcel in) {
        this.mPackageName = in.readString();
        this.mAppName = in.readString();
        this.mAppIcon = in.createByteArray();
    }

    @Override
    public void writeToParcel(@NonNull Parcel dest, int flags) {
        dest.writeInt(3);
        dest.writeString(this.mPackageName);
        dest.writeString(this.mAppName);
        dest.writeByteArray(this.mAppIcon);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @NonNull
    public String getPackageName() {
        return this.mPackageName;
    }

    @NonNull
    public String getAppName() {
        return this.mAppName;
    }

    @Nullable
    public byte[] getAppIcon() {
        return this.mAppIcon;
    }

    public static class Builder {
        private String mPackageName;
        private String mAppName;
        private byte[] mAppIcon;

        public Builder(@NonNull String packageName, @NonNull String appName) {
            Objects.requireNonNull(packageName);
            Objects.requireNonNull(appName);
            this.mPackageName = packageName;
            this.mAppName = appName;
        }

        @NonNull
        public Builder setPackageName(@NonNull String packageName) {
            Objects.requireNonNull(packageName);
            this.mPackageName = packageName;
            return this;
        }

        @NonNull
        public Builder setAppName(@NonNull String appName) {
            Objects.requireNonNull(appName);
            this.mAppName = appName;
            return this;
        }

        @NonNull
        public Builder setAppIcon(@Nullable byte[] appIcon) {
            this.mAppIcon = appIcon;
            return this;
        }

        @NonNull
        public AppInfoMigrationPayload build() {
            return new AppInfoMigrationPayload(this.mPackageName, this.mAppName, this.mAppIcon);
        }
    }
}

