/*
 * Decompiled with CFR 0.152.
 */
package android.health.connect.internal.datatypes.utils;

import android.annotation.NonNull;
import android.health.connect.internal.datatypes.RecordInternal;
import android.health.connect.internal.datatypes.utils.HealthConnectMappings;
import android.os.Parcel;
import java.lang.reflect.InvocationTargetException;
import java.util.Map;
import java.util.Objects;

public class ParcelRecordConverter {
    private static volatile ParcelRecordConverter sParcelRecordConverter = null;
    private final Map<Integer, Class<? extends RecordInternal<?>>> mDataTypeClassMap = HealthConnectMappings.getInstance().getRecordIdToInternalRecordClassMap();

    private ParcelRecordConverter() {
    }

    @NonNull
    public static synchronized ParcelRecordConverter getInstance() {
        if (sParcelRecordConverter == null) {
            sParcelRecordConverter = new ParcelRecordConverter();
        }
        return sParcelRecordConverter;
    }

    @NonNull
    public RecordInternal<?> getRecord(@NonNull Parcel parcel, int type) throws InstantiationException, IllegalAccessException, NoSuchMethodException, InvocationTargetException {
        Class<RecordInternal<?>> recordClass = this.mDataTypeClassMap.get(type);
        Objects.requireNonNull(recordClass);
        RecordInternal<?> recordInternal = recordClass.getConstructor(new Class[0]).newInstance(new Object[0]);
        recordInternal.populateUsing(parcel);
        return recordInternal;
    }
}

