/*
 * Decompiled with CFR 0.152.
 */
package android.health.connect.internal.datatypes.utils;

import android.annotation.NonNull;
import com.android.healthfitness.flags.AconfigFlagHelper;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

public class FhirResourceTypeStringToIntMapper {
    private static final Map<String, Integer> sFhirResourceTypeStringToIntMap = new HashMap<String, Integer>();
    private static final String FHIR_RESOURCE_TYPE_IMMUNIZATION_STR = "IMMUNIZATION";
    private static final String FHIR_RESOURCE_TYPE_ALLERGY_INTOLERANCE_STR = "ALLERGYINTOLERANCE";
    private static final String FHIR_RESOURCE_TYPE_OBSERVATION_STR = "OBSERVATION";
    private static final String FHIR_RESOURCE_TYPE_CONDITION_STR = "CONDITION";
    private static final String FHIR_RESOURCE_TYPE_PROCEDURE_STR = "PROCEDURE";
    private static final String FHIR_RESOURCE_TYPE_MEDICATION_STR = "MEDICATION";
    private static final String FHIR_RESOURCE_TYPE_MEDICATION_REQUEST_STR = "MEDICATIONREQUEST";
    private static final String FHIR_RESOURCE_TYPE_MEDICATION_STATEMENT_STR = "MEDICATIONSTATEMENT";
    private static final String FHIR_RESOURCE_TYPE_PATIENT_STR = "PATIENT";
    private static final String FHIR_RESOURCE_TYPE_PRACTITIONER_STR = "PRACTITIONER";
    private static final String FHIR_RESOURCE_TYPE_PRACTITIONER_ROLE_STR = "PRACTITIONERROLE";
    private static final String FHIR_RESOURCE_TYPE_ENCOUNTER_STR = "ENCOUNTER";
    private static final String FHIR_RESOURCE_TYPE_LOCATION_STR = "LOCATION";
    private static final String FHIR_RESOURCE_TYPE_ORGANIZATION_STR = "ORGANIZATION";

    public static int getFhirResourceTypeInt(@NonNull String fhirResourceType) {
        if (!AconfigFlagHelper.isPersonalHealthRecordEnabled()) {
            throw new UnsupportedOperationException("getFhirResourceTypeInt is not supported");
        }
        FhirResourceTypeStringToIntMapper.populateFhirResourceTypeStringToIntMap();
        Integer fhirResourceTypeInt = sFhirResourceTypeStringToIntMap.get(fhirResourceType.toUpperCase(Locale.ROOT));
        if (fhirResourceTypeInt == null) {
            throw new IllegalArgumentException("Unsupported FHIR resource type: " + fhirResourceType);
        }
        return fhirResourceTypeInt;
    }

    private static void populateFhirResourceTypeStringToIntMap() {
        if (!AconfigFlagHelper.isPersonalHealthRecordEnabled()) {
            throw new UnsupportedOperationException("populateFhirResourceTypeStringToIntMap is not supported");
        }
        if (!sFhirResourceTypeStringToIntMap.isEmpty()) {
            return;
        }
        sFhirResourceTypeStringToIntMap.put(FHIR_RESOURCE_TYPE_ALLERGY_INTOLERANCE_STR, 2);
        sFhirResourceTypeStringToIntMap.put(FHIR_RESOURCE_TYPE_IMMUNIZATION_STR, 1);
        sFhirResourceTypeStringToIntMap.put(FHIR_RESOURCE_TYPE_OBSERVATION_STR, 3);
        sFhirResourceTypeStringToIntMap.put(FHIR_RESOURCE_TYPE_CONDITION_STR, 4);
        sFhirResourceTypeStringToIntMap.put(FHIR_RESOURCE_TYPE_PROCEDURE_STR, 5);
        sFhirResourceTypeStringToIntMap.put(FHIR_RESOURCE_TYPE_MEDICATION_STR, 6);
        sFhirResourceTypeStringToIntMap.put(FHIR_RESOURCE_TYPE_MEDICATION_REQUEST_STR, 7);
        sFhirResourceTypeStringToIntMap.put(FHIR_RESOURCE_TYPE_MEDICATION_STATEMENT_STR, 8);
        sFhirResourceTypeStringToIntMap.put(FHIR_RESOURCE_TYPE_PATIENT_STR, 9);
        sFhirResourceTypeStringToIntMap.put(FHIR_RESOURCE_TYPE_PRACTITIONER_STR, 10);
        sFhirResourceTypeStringToIntMap.put(FHIR_RESOURCE_TYPE_PRACTITIONER_ROLE_STR, 11);
        sFhirResourceTypeStringToIntMap.put(FHIR_RESOURCE_TYPE_ENCOUNTER_STR, 12);
        sFhirResourceTypeStringToIntMap.put(FHIR_RESOURCE_TYPE_LOCATION_STR, 13);
        sFhirResourceTypeStringToIntMap.put(FHIR_RESOURCE_TYPE_ORGANIZATION_STR, 14);
    }
}

