/*
 * Decompiled with CFR 0.152.
 */
package android.health.connect.internal.datatypes.utils;

import android.annotation.Nullable;
import android.health.connect.datatypes.Record;
import android.health.connect.internal.datatypes.RecordInternal;
import java.util.Objects;

public class DataTypeDescriptor {
    private final int mRecordTypeIdentifier;
    private final int mPermissionCategory;
    private final int mDataCategory;
    private final String mReadPermission;
    private final String mWritePermission;
    private final Class<? extends RecordInternal<?>> mRecordInternalClass;
    private final Class<? extends Record> mRecordClass;

    private DataTypeDescriptor(Builder builder) {
        DataTypeDescriptor.checkArgument(builder.mRecordTypeIdentifier != 0, "Unknown record type");
        DataTypeDescriptor.checkArgument(builder.mHealthPermissionCategory != 0, "Unknown permission category");
        DataTypeDescriptor.checkArgument(builder.mHealthDataCategory != 0, "Unknown health data category");
        this.mRecordTypeIdentifier = builder.mRecordTypeIdentifier;
        this.mPermissionCategory = builder.mHealthPermissionCategory;
        this.mDataCategory = builder.mHealthDataCategory;
        this.mReadPermission = Objects.requireNonNull(builder.mReadPermission);
        this.mWritePermission = Objects.requireNonNull(builder.mWritePermission);
        this.mRecordInternalClass = Objects.requireNonNull(builder.mRecordInternalClass);
        this.mRecordClass = Objects.requireNonNull(builder.mRecordClass);
    }

    public int getRecordTypeIdentifier() {
        return this.mRecordTypeIdentifier;
    }

    public int getPermissionCategory() {
        return this.mPermissionCategory;
    }

    public int getDataCategory() {
        return this.mDataCategory;
    }

    public String getReadPermission() {
        return this.mReadPermission;
    }

    public String getWritePermission() {
        return this.mWritePermission;
    }

    public Class<? extends RecordInternal<?>> getRecordInternalClass() {
        return this.mRecordInternalClass;
    }

    public Class<? extends Record> getRecordClass() {
        return this.mRecordClass;
    }

    static RecordTypeIdentifierBuilderStep builder() {
        return new Builder();
    }

    private static void checkArgument(boolean expression, String errorMsg) {
        if (!expression) {
            throw new IllegalArgumentException(errorMsg);
        }
    }

    private static class Builder
    implements RecordTypeIdentifierBuilderStep,
    PermissionCategoryBuilderStep,
    DataCategoryBuilderStep,
    ReadPermissionBuilderStep,
    WritePermissionBuilderStep,
    RecordClassBuilderStep,
    RecordInternalClassBuilderStep,
    BuildStep {
        private int mRecordTypeIdentifier = 0;
        private int mHealthPermissionCategory = 0;
        private int mHealthDataCategory = 0;
        @Nullable
        private String mReadPermission;
        @Nullable
        private String mWritePermission;
        @Nullable
        private Class<? extends Record> mRecordClass;
        @Nullable
        private Class<? extends RecordInternal<?>> mRecordInternalClass;

        private Builder() {
        }

        @Override
        public PermissionCategoryBuilderStep setRecordTypeIdentifier(int recordTypeIdentifier) {
            DataTypeDescriptor.checkArgument(recordTypeIdentifier != 0, "Unknown record type identifier");
            this.mRecordTypeIdentifier = recordTypeIdentifier;
            return this;
        }

        @Override
        public DataCategoryBuilderStep setPermissionCategory(int permissionCategory) {
            DataTypeDescriptor.checkArgument(permissionCategory != 0, "Unknown permission category");
            this.mHealthPermissionCategory = permissionCategory;
            return this;
        }

        @Override
        public ReadPermissionBuilderStep setDataCategory(int healthDataCategory) {
            DataTypeDescriptor.checkArgument(healthDataCategory != 0, "Unknown health data category");
            this.mHealthDataCategory = healthDataCategory;
            return this;
        }

        @Override
        public WritePermissionBuilderStep setReadPermission(String readPermission) {
            this.mReadPermission = Objects.requireNonNull(readPermission);
            return this;
        }

        @Override
        public RecordClassBuilderStep setWritePermission(String writePermission) {
            this.mWritePermission = Objects.requireNonNull(writePermission);
            return this;
        }

        @Override
        public RecordInternalClassBuilderStep setRecordClass(Class<? extends Record> recordClass) {
            this.mRecordClass = Objects.requireNonNull(recordClass);
            return this;
        }

        @Override
        public BuildStep setRecordInternalClass(Class<? extends RecordInternal<?>> recordInternalClass) {
            this.mRecordInternalClass = Objects.requireNonNull(recordInternalClass);
            return this;
        }

        @Override
        public DataTypeDescriptor build() {
            return new DataTypeDescriptor(this);
        }
    }

    static interface BuildStep {
        public DataTypeDescriptor build();
    }

    static interface RecordInternalClassBuilderStep {
        public BuildStep setRecordInternalClass(Class<? extends RecordInternal<?>> var1);
    }

    static interface RecordClassBuilderStep {
        public RecordInternalClassBuilderStep setRecordClass(Class<? extends Record> var1);
    }

    static interface WritePermissionBuilderStep {
        public RecordClassBuilderStep setWritePermission(String var1);
    }

    static interface ReadPermissionBuilderStep {
        public WritePermissionBuilderStep setReadPermission(String var1);
    }

    static interface DataCategoryBuilderStep {
        public ReadPermissionBuilderStep setDataCategory(int var1);
    }

    static interface PermissionCategoryBuilderStep {
        public DataCategoryBuilderStep setPermissionCategory(int var1);
    }

    static interface RecordTypeIdentifierBuilderStep {
        public PermissionCategoryBuilderStep setRecordTypeIdentifier(int var1);
    }
}

