/*
 * Decompiled with CFR 0.152.
 */
package android.health.connect.internal.datatypes;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.health.connect.datatypes.Identifier;
import android.health.connect.datatypes.PlannedExerciseSessionRecord;
import android.health.connect.internal.datatypes.IntervalRecordInternal;
import android.health.connect.internal.datatypes.PlannedExerciseBlockInternal;
import android.os.Parcel;
import java.time.Duration;
import java.util.Collections;
import java.util.List;
import java.util.UUID;

@Identifier(recordIdentifier=40)
public class PlannedExerciseSessionRecordInternal
extends IntervalRecordInternal<PlannedExerciseSessionRecord> {
    @Nullable
    private String mNotes;
    private int mExerciseType;
    @Nullable
    private String mTitle;
    private boolean mHasExplicitTime;
    private List<PlannedExerciseBlockInternal> mExerciseBlocks = Collections.emptyList();
    @Nullable
    private UUID mCompletedExerciseSessionId;

    @Nullable
    public String getNotes() {
        return this.mNotes;
    }

    @NonNull
    public PlannedExerciseSessionRecordInternal setNotes(String notes) {
        this.mNotes = notes;
        return this;
    }

    @Nullable
    public String getTitle() {
        return this.mTitle;
    }

    @NonNull
    public PlannedExerciseSessionRecordInternal setTitle(String title) {
        this.mTitle = title;
        return this;
    }

    @NonNull
    public PlannedExerciseSessionRecordInternal setHasExplicitTime(boolean hasExplicitTime) {
        this.mHasExplicitTime = hasExplicitTime;
        return this;
    }

    @NonNull
    public PlannedExerciseSessionRecordInternal setExerciseBlocks(List<PlannedExerciseBlockInternal> blocks) {
        this.mExerciseBlocks = blocks;
        return this;
    }

    @NonNull
    public PlannedExerciseSessionRecordInternal setCompletedExerciseSessionId(UUID id2) {
        this.mCompletedExerciseSessionId = id2;
        return this;
    }

    @NonNull
    public List<PlannedExerciseBlockInternal> getExerciseBlocks() {
        return this.mExerciseBlocks;
    }

    @Nullable
    public UUID getCompletedExerciseSessionId() {
        return this.mCompletedExerciseSessionId;
    }

    public boolean getHasExplicitTime() {
        return this.mHasExplicitTime;
    }

    public int getExerciseType() {
        return this.mExerciseType;
    }

    @NonNull
    public PlannedExerciseSessionRecordInternal setExerciseType(int exerciseType) {
        this.mExerciseType = exerciseType;
        return this;
    }

    @Override
    void populateIntervalRecordFrom(Parcel parcel) {
        this.mNotes = parcel.readString();
        this.mExerciseType = parcel.readInt();
        this.mTitle = parcel.readString();
        this.mHasExplicitTime = parcel.readBoolean();
        this.mExerciseBlocks = PlannedExerciseBlockInternal.readFromParcel(parcel);
        String uuid = parcel.readString();
        this.mCompletedExerciseSessionId = uuid == null ? null : UUID.fromString(uuid);
    }

    @Override
    void populateIntervalRecordTo(Parcel parcel) {
        parcel.writeString(this.mNotes);
        parcel.writeInt(this.mExerciseType);
        parcel.writeString(this.mTitle);
        parcel.writeBoolean(this.mHasExplicitTime);
        PlannedExerciseBlockInternal.writeToParcel(this.mExerciseBlocks, parcel);
        parcel.writeString(this.mCompletedExerciseSessionId == null ? null : ((Object)this.mCompletedExerciseSessionId).toString());
    }

    @Override
    public PlannedExerciseSessionRecord toExternalRecord() {
        PlannedExerciseSessionRecord.Builder builder;
        PlannedExerciseSessionRecord.Builder builder2 = builder = this.mHasExplicitTime ? new PlannedExerciseSessionRecord.Builder(this.buildMetaData(), this.getExerciseType(), this.getStartTime(), this.getEndTime()) : new PlannedExerciseSessionRecord.Builder(this.buildMetaData(), this.getExerciseType(), this.getStartTime().atOffset(this.getStartZoneOffset()).toLocalDate(), Duration.between(this.getStartTime(), this.getEndTime()));
        if (this.getStartZoneOffset() != null) {
            builder.setStartZoneOffset(this.getStartZoneOffset());
        }
        if (this.getEndZoneOffset() != null) {
            builder.setEndZoneOffset(this.getEndZoneOffset());
        }
        if (this.getNotes() != null) {
            builder.setNotes(this.getNotes());
        }
        if (this.getTitle() != null) {
            builder.setTitle(this.getTitle());
        }
        for (PlannedExerciseBlockInternal block : this.mExerciseBlocks) {
            builder.addBlock(block.toExternalObject());
        }
        if (this.mCompletedExerciseSessionId != null) {
            builder.setCompletedExerciseSessionId(((Object)this.mCompletedExerciseSessionId).toString());
        }
        return builder.buildWithoutValidation();
    }
}

