/*
 * Decompiled with CFR 0.152.
 */
package android.health.connect.internal.datatypes;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.health.connect.datatypes.ExerciseSessionRecord;
import android.health.connect.datatypes.Identifier;
import android.health.connect.internal.datatypes.ExerciseLapInternal;
import android.health.connect.internal.datatypes.ExerciseRouteInternal;
import android.health.connect.internal.datatypes.ExerciseSegmentInternal;
import android.health.connect.internal.datatypes.IntervalRecordInternal;
import android.os.Parcel;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.UUID;

@Identifier(recordIdentifier=37)
public class ExerciseSessionRecordInternal
extends IntervalRecordInternal<ExerciseSessionRecord> {
    private String mNotes;
    private int mExerciseType;
    private String mTitle;
    private ExerciseRouteInternal mExerciseRoute;
    private List<ExerciseLapInternal> mExerciseLaps;
    private List<ExerciseSegmentInternal> mExerciseSegments;
    private boolean mHasRoute;
    @Nullable
    private UUID mPlannedExerciseSessionId;

    @Nullable
    public String getNotes() {
        return this.mNotes;
    }

    @NonNull
    public ExerciseSessionRecordInternal setNotes(String notes) {
        this.mNotes = notes;
        return this;
    }

    public int getExerciseType() {
        return this.mExerciseType;
    }

    @NonNull
    public ExerciseSessionRecordInternal setExerciseType(int exerciseType) {
        this.mExerciseType = exerciseType;
        return this;
    }

    @Nullable
    public String getTitle() {
        return this.mTitle;
    }

    @NonNull
    public ExerciseSessionRecordInternal setTitle(String title) {
        this.mTitle = title;
        return this;
    }

    @Nullable
    public ExerciseRouteInternal getRoute() {
        return this.mExerciseRoute;
    }

    @NonNull
    public ExerciseSessionRecordInternal setRoute(ExerciseRouteInternal route) {
        this.mExerciseRoute = route;
        if (route != null) {
            this.mHasRoute = true;
        }
        return this;
    }

    public boolean hasRoute() {
        return this.mHasRoute;
    }

    @NonNull
    public ExerciseSessionRecordInternal setHasRoute(boolean hasRoute) {
        if (this.mExerciseRoute != null && !hasRoute) {
            throw new IllegalArgumentException("HasRoute must be true if the route is not null");
        }
        this.mHasRoute = hasRoute;
        return this;
    }

    @Nullable
    public List<ExerciseLapInternal> getLaps() {
        return this.mExerciseLaps;
    }

    public ExerciseSessionRecordInternal setExerciseLaps(@NonNull List<ExerciseLapInternal> exerciseLaps) {
        Objects.requireNonNull(exerciseLaps);
        this.mExerciseLaps = new ArrayList<ExerciseLapInternal>(exerciseLaps);
        return this;
    }

    @Nullable
    public List<ExerciseSegmentInternal> getSegments() {
        return this.mExerciseSegments;
    }

    @NonNull
    public ExerciseSessionRecordInternal setExerciseSegments(@NonNull List<ExerciseSegmentInternal> exerciseSegments) {
        Objects.requireNonNull(exerciseSegments);
        this.mExerciseSegments = new ArrayList<ExerciseSegmentInternal>(exerciseSegments);
        return this;
    }

    @NonNull
    public ExerciseSessionRecordInternal setPlannedExerciseSessionId(@Nullable UUID id2) {
        this.mPlannedExerciseSessionId = id2;
        return this;
    }

    @Nullable
    public UUID getPlannedExerciseSessionId() {
        return this.mPlannedExerciseSessionId;
    }

    @Override
    @NonNull
    public ExerciseSessionRecord toExternalRecord() {
        ExerciseSessionRecord.Builder builder = new ExerciseSessionRecord.Builder(this.buildMetaData(), this.getStartTime(), this.getEndTime(), this.getExerciseType());
        if (this.getStartZoneOffset() != null) {
            builder.setStartZoneOffset(this.getStartZoneOffset());
        }
        if (this.getEndZoneOffset() != null) {
            builder.setEndZoneOffset(this.getEndZoneOffset());
        }
        if (this.getNotes() != null) {
            builder.setNotes(this.getNotes());
        }
        if (this.getTitle() != null) {
            builder.setTitle(this.getTitle());
        }
        if (this.mExerciseRoute != null) {
            builder.setRoute(this.mExerciseRoute.toExternalRoute());
        }
        builder.setHasRoute(this.mHasRoute);
        if (this.getLaps() != null) {
            builder.setLaps(ExerciseLapInternal.getExternalLaps(this.mExerciseLaps));
        }
        if (this.getSegments() != null) {
            builder.setSegments(ExerciseSegmentInternal.getExternalSegments(this.mExerciseSegments));
        }
        builder.setPlannedExerciseSessionId(this.mPlannedExerciseSessionId == null ? null : ((Object)this.mPlannedExerciseSessionId).toString());
        return builder.buildWithoutValidation();
    }

    @Override
    public void populateIntervalRecordTo(@NonNull Parcel parcel) {
        parcel.writeString(this.mNotes);
        parcel.writeInt(this.mExerciseType);
        parcel.writeString(this.mTitle);
        parcel.writeBoolean(this.mHasRoute);
        ExerciseRouteInternal.writeToParcel(this.mExerciseRoute, parcel);
        ExerciseLapInternal.writeLapsToParcel(this.mExerciseLaps, parcel);
        ExerciseSegmentInternal.writeSegmentsToParcel(this.mExerciseSegments, parcel);
        parcel.writeString(this.mPlannedExerciseSessionId == null ? null : ((Object)this.mPlannedExerciseSessionId).toString());
    }

    @Override
    public void populateIntervalRecordFrom(@NonNull Parcel parcel) {
        this.mNotes = parcel.readString();
        this.mExerciseType = parcel.readInt();
        this.mTitle = parcel.readString();
        this.mHasRoute = parcel.readBoolean();
        this.mExerciseRoute = ExerciseRouteInternal.readFromParcel(parcel);
        this.mExerciseLaps = ExerciseLapInternal.populateLapsFromParcel(parcel);
        this.mExerciseSegments = ExerciseSegmentInternal.populateSegmentsFromParcel(parcel);
        String uuid = parcel.readString();
        this.mPlannedExerciseSessionId = uuid == null ? null : UUID.fromString(uuid);
    }

    public void addRouteLocation(ExerciseRouteInternal.LocationInternal location) {
        if (this.mExerciseRoute == null) {
            this.mExerciseRoute = new ExerciseRouteInternal(List.of(location));
            this.mHasRoute = true;
        } else {
            this.mExerciseRoute.addLocation(location);
        }
    }
}

