/*
 * Decompiled with CFR 0.152.
 */
package android.health.connect.internal.datatypes;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.health.connect.datatypes.CyclingPedalingCadenceRecord;
import android.health.connect.datatypes.Identifier;
import android.health.connect.internal.datatypes.SeriesRecordInternal;
import android.os.Parcel;
import java.time.Instant;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;

@Identifier(recordIdentifier=12)
public class CyclingPedalingCadenceRecordInternal
extends SeriesRecordInternal<CyclingPedalingCadenceRecord, CyclingPedalingCadenceRecord.CyclingPedalingCadenceRecordSample> {
    private Set<CyclingPedalingCadenceRecordSample> mCyclingPedalingCadenceRecordSamples;

    @Override
    @NonNull
    public Set<CyclingPedalingCadenceRecordSample> getSamples() {
        return this.mCyclingPedalingCadenceRecordSamples;
    }

    @Override
    @NonNull
    public CyclingPedalingCadenceRecordInternal setSamples(Set<? extends SeriesRecordInternal.Sample> samples) {
        Objects.requireNonNull(samples);
        this.mCyclingPedalingCadenceRecordSamples = samples;
        return this;
    }

    @Override
    @NonNull
    public CyclingPedalingCadenceRecord toExternalRecord() {
        return new CyclingPedalingCadenceRecord.Builder(this.buildMetaData(), this.getStartTime(), this.getEndTime(), this.getExternalSamples()).setStartZoneOffset(this.getStartZoneOffset()).setEndZoneOffset(this.getEndZoneOffset()).buildWithoutValidation();
    }

    @Override
    void populateIntervalRecordFrom(@NonNull Parcel parcel) {
        int size = parcel.readInt();
        this.mCyclingPedalingCadenceRecordSamples = new HashSet<CyclingPedalingCadenceRecordSample>(size);
        for (int i = 0; i < size; ++i) {
            this.mCyclingPedalingCadenceRecordSamples.add(new CyclingPedalingCadenceRecordSample(parcel.readDouble(), parcel.readLong()));
        }
    }

    @Override
    void populateIntervalRecordTo(@NonNull Parcel parcel) {
        parcel.writeInt(this.mCyclingPedalingCadenceRecordSamples.size());
        for (CyclingPedalingCadenceRecordSample cyclingPedalingCadenceRecordSample : this.mCyclingPedalingCadenceRecordSamples) {
            parcel.writeDouble(cyclingPedalingCadenceRecordSample.getRevolutionsPerMinute());
            parcel.writeLong(cyclingPedalingCadenceRecordSample.getEpochMillis());
        }
    }

    private List<CyclingPedalingCadenceRecord.CyclingPedalingCadenceRecordSample> getExternalSamples() {
        ArrayList<CyclingPedalingCadenceRecord.CyclingPedalingCadenceRecordSample> cyclingPedalingCadenceRecords = new ArrayList<CyclingPedalingCadenceRecord.CyclingPedalingCadenceRecordSample>(this.mCyclingPedalingCadenceRecordSamples.size());
        for (CyclingPedalingCadenceRecordSample cyclingPedalingCadenceRecordSample : this.mCyclingPedalingCadenceRecordSamples) {
            cyclingPedalingCadenceRecords.add(new CyclingPedalingCadenceRecord.CyclingPedalingCadenceRecordSample(cyclingPedalingCadenceRecordSample.getRevolutionsPerMinute(), Instant.ofEpochMilli(cyclingPedalingCadenceRecordSample.getEpochMillis()), true));
        }
        return cyclingPedalingCadenceRecords;
    }

    public static class CyclingPedalingCadenceRecordSample
    implements SeriesRecordInternal.Sample {
        private final double mRevolutionsPerMinute;
        private final long mEpochMillis;

        public CyclingPedalingCadenceRecordSample(double revolutionsPerMinute, long epochMillis) {
            this.mRevolutionsPerMinute = revolutionsPerMinute;
            this.mEpochMillis = epochMillis;
        }

        public double getRevolutionsPerMinute() {
            return this.mRevolutionsPerMinute;
        }

        public long getEpochMillis() {
            return this.mEpochMillis;
        }

        public boolean equals(@Nullable Object object) {
            if (super.equals(object) && object instanceof CyclingPedalingCadenceRecordSample) {
                CyclingPedalingCadenceRecordSample other = (CyclingPedalingCadenceRecordSample)object;
                return this.getEpochMillis() == other.getEpochMillis();
            }
            return false;
        }

        public int hashCode() {
            return Objects.hash(this.getEpochMillis());
        }
    }
}

