/*
 * Decompiled with CFR 0.152.
 */
package android.health.connect.internal.datatypes;

import android.annotation.NonNull;
import android.health.connect.datatypes.BloodPressureRecord;
import android.health.connect.datatypes.Identifier;
import android.health.connect.datatypes.units.Pressure;
import android.health.connect.internal.datatypes.InstantRecordInternal;
import android.os.Parcel;

@Identifier(recordIdentifier=23)
public class BloodPressureRecordInternal
extends InstantRecordInternal<BloodPressureRecord> {
    private int mMeasurementLocation;
    private double mSystolic;
    private double mDiastolic;
    private int mBodyPosition;

    public int getMeasurementLocation() {
        return this.mMeasurementLocation;
    }

    @NonNull
    public BloodPressureRecordInternal setMeasurementLocation(int measurementLocation) {
        this.mMeasurementLocation = measurementLocation;
        return this;
    }

    public double getSystolic() {
        return this.mSystolic;
    }

    @NonNull
    public BloodPressureRecordInternal setSystolic(double systolic) {
        this.mSystolic = systolic;
        return this;
    }

    public double getDiastolic() {
        return this.mDiastolic;
    }

    @NonNull
    public BloodPressureRecordInternal setDiastolic(double diastolic) {
        this.mDiastolic = diastolic;
        return this;
    }

    public int getBodyPosition() {
        return this.mBodyPosition;
    }

    @NonNull
    public BloodPressureRecordInternal setBodyPosition(int bodyPosition) {
        this.mBodyPosition = bodyPosition;
        return this;
    }

    @Override
    @NonNull
    public BloodPressureRecord toExternalRecord() {
        return new BloodPressureRecord.Builder(this.buildMetaData(), this.getTime(), this.getMeasurementLocation(), Pressure.fromMillimetersOfMercury(this.getSystolic()), Pressure.fromMillimetersOfMercury(this.getDiastolic()), this.getBodyPosition()).setZoneOffset(this.getZoneOffset()).buildWithoutValidation();
    }

    @Override
    void populateInstantRecordFrom(@NonNull Parcel parcel) {
        this.mMeasurementLocation = parcel.readInt();
        this.mSystolic = parcel.readDouble();
        this.mDiastolic = parcel.readDouble();
        this.mBodyPosition = parcel.readInt();
    }

    @Override
    void populateInstantRecordTo(@NonNull Parcel parcel) {
        parcel.writeInt(this.mMeasurementLocation);
        parcel.writeDouble(this.mSystolic);
        parcel.writeDouble(this.mDiastolic);
        parcel.writeInt(this.mBodyPosition);
    }
}

