/*
 * Decompiled with CFR 0.152.
 */
package android.health.connect.internal.datatypes;

import android.annotation.NonNull;
import android.health.connect.datatypes.BasalBodyTemperatureRecord;
import android.health.connect.datatypes.Identifier;
import android.health.connect.datatypes.units.Temperature;
import android.health.connect.internal.datatypes.InstantRecordInternal;
import android.os.Parcel;

@Identifier(recordIdentifier=20)
public class BasalBodyTemperatureRecordInternal
extends InstantRecordInternal<BasalBodyTemperatureRecord> {
    private int mMeasurementLocation;
    private double mTemperature;

    public int getMeasurementLocation() {
        return this.mMeasurementLocation;
    }

    @NonNull
    public BasalBodyTemperatureRecordInternal setMeasurementLocation(int measurementLocation) {
        this.mMeasurementLocation = measurementLocation;
        return this;
    }

    public double getTemperature() {
        return this.mTemperature;
    }

    @NonNull
    public BasalBodyTemperatureRecordInternal setTemperature(double temperature) {
        this.mTemperature = temperature;
        return this;
    }

    @Override
    @NonNull
    public BasalBodyTemperatureRecord toExternalRecord() {
        return new BasalBodyTemperatureRecord.Builder(this.buildMetaData(), this.getTime(), this.getMeasurementLocation(), Temperature.fromCelsius(this.getTemperature())).setZoneOffset(this.getZoneOffset()).buildWithoutValidation();
    }

    @Override
    void populateInstantRecordFrom(@NonNull Parcel parcel) {
        this.mMeasurementLocation = parcel.readInt();
        this.mTemperature = parcel.readDouble();
    }

    @Override
    void populateInstantRecordTo(@NonNull Parcel parcel) {
        parcel.writeInt(this.mMeasurementLocation);
        parcel.writeDouble(this.mTemperature);
    }
}

