/*
 * Decompiled with CFR 0.152.
 */
package android.health.connect.datatypes;

import android.annotation.FlaggedApi;
import android.annotation.NonNull;
import android.annotation.Nullable;
import android.health.connect.datatypes.AggregationType;
import android.health.connect.datatypes.Identifier;
import android.health.connect.datatypes.IntervalRecord;
import android.health.connect.datatypes.Metadata;
import android.health.connect.datatypes.RecordUtils;
import android.health.connect.datatypes.units.Temperature;
import android.health.connect.datatypes.units.TemperatureDelta;
import android.health.connect.datatypes.validation.ValidationUtils;
import android.health.connect.internal.datatypes.SkinTemperatureRecordInternal;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.time.Instant;
import java.time.ZoneOffset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;

@Identifier(recordIdentifier=39)
@FlaggedApi(value="com.android.healthconnect.flags.skin_temperature")
public class SkinTemperatureRecord
extends IntervalRecord {
    public static final int MEASUREMENT_LOCATION_UNKNOWN = 0;
    public static final int MEASUREMENT_LOCATION_FINGER = 1;
    public static final int MEASUREMENT_LOCATION_TOE = 2;
    public static final int MEASUREMENT_LOCATION_WRIST = 3;
    @NonNull
    public static final AggregationType<TemperatureDelta> SKIN_TEMPERATURE_DELTA_AVG = new AggregationType<TemperatureDelta>(84, 2, 39, TemperatureDelta.class);
    @NonNull
    public static final AggregationType<TemperatureDelta> SKIN_TEMPERATURE_DELTA_MIN = new AggregationType<TemperatureDelta>(85, 1, 39, TemperatureDelta.class);
    @NonNull
    public static final AggregationType<TemperatureDelta> SKIN_TEMPERATURE_DELTA_MAX = new AggregationType<TemperatureDelta>(86, 0, 39, TemperatureDelta.class);
    @Nullable
    private final Temperature mBaseline;
    @NonNull
    private final List<Delta> mDeltas;
    private int mMeasurementLocation;
    public static final Set<Integer> VALID_MEASUREMENT_LOCATIONS = Set.of(Integer.valueOf(0), Integer.valueOf(1), Integer.valueOf(2), Integer.valueOf(3));

    private SkinTemperatureRecord(@NonNull Metadata metadata, @NonNull Instant startTime, @NonNull ZoneOffset startZoneOffset, @NonNull Instant endTime, @NonNull ZoneOffset endZoneOffset, @Nullable Temperature baseline, @NonNull List<Delta> deltas, int measurementLocation, boolean skipValidation) {
        super(metadata, startTime, startZoneOffset, endTime, endZoneOffset, skipValidation, true);
        if (!skipValidation) {
            if (baseline != null) {
                ValidationUtils.requireInRange(baseline.getInCelsius(), 0.0, 100.0, "temperature");
            }
            ValidationUtils.validateIntDefValue(measurementLocation, VALID_MEASUREMENT_LOCATIONS, SkinTemperatureMeasurementLocation.class.getSimpleName());
            ValidationUtils.validateSampleStartAndEndTime(startTime, endTime, deltas.stream().map(Delta::getTime).toList());
        }
        this.mBaseline = baseline;
        this.mDeltas = Collections.unmodifiableList(deltas.stream().sorted(Comparator.comparing(Delta::getTime)).collect(Collectors.toList()));
        this.mMeasurementLocation = measurementLocation;
    }

    @Nullable
    public Temperature getBaseline() {
        return this.mBaseline;
    }

    @NonNull
    public List<Delta> getDeltas() {
        return this.mDeltas;
    }

    public int getMeasurementLocation() {
        return this.mMeasurementLocation;
    }

    @Override
    public boolean equals(@Nullable Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof SkinTemperatureRecord)) {
            return false;
        }
        if (!super.equals(object)) {
            return false;
        }
        SkinTemperatureRecord that = (SkinTemperatureRecord)object;
        if (!Objects.equals(this.getBaseline(), that.getBaseline()) || this.getMeasurementLocation() != that.getMeasurementLocation()) {
            return false;
        }
        return Objects.equals(this.getDeltas(), that.getDeltas());
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.getBaseline(), this.getDeltas());
    }

    public SkinTemperatureRecordInternal toRecordInternal() {
        SkinTemperatureRecordInternal recordInternal = (SkinTemperatureRecordInternal)new SkinTemperatureRecordInternal().setUuid(this.getMetadata().getId()).setPackageName(this.getMetadata().getDataOrigin().getPackageName()).setLastModifiedTime(this.getMetadata().getLastModifiedTime().toEpochMilli()).setClientRecordId(this.getMetadata().getClientRecordId()).setClientRecordVersion(this.getMetadata().getClientRecordVersion()).setManufacturer(this.getMetadata().getDevice().getManufacturer()).setModel(this.getMetadata().getDevice().getModel()).setDeviceType(this.getMetadata().getDevice().getType()).setRecordingMethod(this.getMetadata().getRecordingMethod());
        if (this.getBaseline() != null) {
            recordInternal.setBaseline(this.getBaseline());
        }
        recordInternal.setSamples(this.getDeltas().stream().map(delta -> new SkinTemperatureRecordInternal.SkinTemperatureDeltaSample(delta.getDelta().getInCelsius(), delta.getTime().toEpochMilli())).collect(Collectors.toSet()));
        recordInternal.setMeasurementLocation(this.getMeasurementLocation());
        recordInternal.setStartTime(this.getStartTime().toEpochMilli());
        recordInternal.setEndTime(this.getEndTime().toEpochMilli());
        recordInternal.setStartZoneOffset(this.getStartZoneOffset().getTotalSeconds());
        recordInternal.setEndZoneOffset(this.getEndZoneOffset().getTotalSeconds());
        return recordInternal;
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface SkinTemperatureMeasurementLocation {
    }

    public static class Delta {
        private final TemperatureDelta mDelta;
        private final Instant mTime;

        public Delta(@NonNull TemperatureDelta delta, @NonNull Instant time) {
            this(delta, time, false);
        }

        public Delta(@NonNull TemperatureDelta delta, @NonNull Instant time, boolean skipValidation) {
            Objects.requireNonNull(delta);
            Objects.requireNonNull(time);
            if (!skipValidation) {
                ValidationUtils.requireInRange(delta.getInCelsius(), -30.0, 30.0, "temperature delta");
            }
            this.mDelta = delta;
            this.mTime = time;
        }

        @NonNull
        public TemperatureDelta getDelta() {
            return this.mDelta;
        }

        @NonNull
        public Instant getTime() {
            return this.mTime;
        }

        public boolean equals(@Nullable Object object) {
            if (this == object) {
                return true;
            }
            if (!(object instanceof Delta)) {
                return false;
            }
            Delta that = (Delta)object;
            return Objects.equals(this.getDelta(), that.getDelta()) && this.getTime().toEpochMilli() == that.getTime().toEpochMilli();
        }

        public int hashCode() {
            return Objects.hash(super.hashCode(), this.getDelta(), this.getTime());
        }
    }

    public static class Builder {
        private final Metadata mMetadata;
        private final Instant mStartTime;
        private final Instant mEndTime;
        private ZoneOffset mStartZoneOffset;
        private ZoneOffset mEndZoneOffset;
        @Nullable
        private Temperature mBaseline;
        private final List<Delta> mDeltas;
        private int mMeasurementLocation;

        public Builder(@NonNull Metadata metadata, @NonNull Instant startTime, @NonNull Instant endTime) {
            Objects.requireNonNull(metadata);
            Objects.requireNonNull(startTime);
            Objects.requireNonNull(endTime);
            this.mMetadata = metadata;
            this.mStartTime = startTime;
            this.mEndTime = endTime;
            this.mDeltas = new ArrayList<Delta>();
            this.mMeasurementLocation = 0;
            this.mStartZoneOffset = ZoneOffset.systemDefault().getRules().getOffset(startTime);
            this.mEndZoneOffset = ZoneOffset.systemDefault().getRules().getOffset(endTime);
        }

        @NonNull
        public Builder setStartZoneOffset(@NonNull ZoneOffset startZoneOffset) {
            Objects.requireNonNull(startZoneOffset);
            this.mStartZoneOffset = startZoneOffset;
            return this;
        }

        @NonNull
        public Builder setEndZoneOffset(@NonNull ZoneOffset endZoneOffset) {
            Objects.requireNonNull(endZoneOffset);
            this.mEndZoneOffset = endZoneOffset;
            return this;
        }

        @NonNull
        public Builder clearStartZoneOffset() {
            this.mStartZoneOffset = RecordUtils.getDefaultZoneOffset();
            return this;
        }

        @NonNull
        public Builder clearEndZoneOffset() {
            this.mEndZoneOffset = RecordUtils.getDefaultZoneOffset();
            return this;
        }

        @NonNull
        public Builder setBaseline(@Nullable Temperature baseline) {
            this.mBaseline = baseline;
            return this;
        }

        @NonNull
        public Builder setDeltas(@NonNull List<Delta> deltas) {
            Objects.requireNonNull(deltas);
            this.mDeltas.clear();
            this.mDeltas.addAll(deltas);
            return this;
        }

        @NonNull
        public Builder setMeasurementLocation(int measurementLocation) {
            this.mMeasurementLocation = measurementLocation;
            return this;
        }

        @NonNull
        public SkinTemperatureRecord buildWithoutValidation() {
            return new SkinTemperatureRecord(this.mMetadata, this.mStartTime, this.mStartZoneOffset, this.mEndTime, this.mEndZoneOffset, this.mBaseline, this.mDeltas, this.mMeasurementLocation, true);
        }

        @NonNull
        public SkinTemperatureRecord build() {
            return new SkinTemperatureRecord(this.mMetadata, this.mStartTime, this.mStartZoneOffset, this.mEndTime, this.mEndZoneOffset, this.mBaseline, this.mDeltas, this.mMeasurementLocation, false);
        }
    }
}

