/*
 * Decompiled with CFR 0.152.
 */
package android.health.connect.datatypes;

import android.annotation.NonNull;
import android.health.connect.datatypes.AggregationType;
import android.health.connect.datatypes.Identifier;
import android.health.connect.datatypes.InstantRecord;
import android.health.connect.datatypes.Metadata;
import android.health.connect.datatypes.RecordUtils;
import android.health.connect.datatypes.validation.ValidationUtils;
import android.health.connect.internal.datatypes.RestingHeartRateRecordInternal;
import java.time.Instant;
import java.time.ZoneOffset;
import java.util.Objects;

@Identifier(recordIdentifier=33)
public class RestingHeartRateRecord
extends InstantRecord {
    private final long mBeatsPerMinute;
    @NonNull
    public static final AggregationType<Long> BPM_MAX = new AggregationType<Long>(57, 0, 33, Long.class);
    @NonNull
    public static final AggregationType<Long> BPM_MIN = new AggregationType<Long>(58, 1, 33, Long.class);
    @NonNull
    public static final AggregationType<Long> BPM_AVG = new AggregationType<Long>(65, 2, 33, Long.class);

    private RestingHeartRateRecord(@NonNull Metadata metadata, @NonNull Instant time, @NonNull ZoneOffset zoneOffset, @NonNull long beatsPerMinute, boolean skipValidation) {
        super(metadata, time, zoneOffset, skipValidation);
        Objects.requireNonNull(metadata);
        Objects.requireNonNull(time);
        Objects.requireNonNull(zoneOffset);
        if (!skipValidation) {
            ValidationUtils.requireInRange(beatsPerMinute, 1L, 300L, "beatsPerMinute");
        }
        this.mBeatsPerMinute = beatsPerMinute;
    }

    public long getBeatsPerMinute() {
        return this.mBeatsPerMinute;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!super.equals(o)) {
            return false;
        }
        RestingHeartRateRecord that = (RestingHeartRateRecord)o;
        return this.getBeatsPerMinute() == that.getBeatsPerMinute();
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.getBeatsPerMinute());
    }

    public RestingHeartRateRecordInternal toRecordInternal() {
        RestingHeartRateRecordInternal recordInternal = (RestingHeartRateRecordInternal)new RestingHeartRateRecordInternal().setUuid(this.getMetadata().getId()).setPackageName(this.getMetadata().getDataOrigin().getPackageName()).setLastModifiedTime(this.getMetadata().getLastModifiedTime().toEpochMilli()).setClientRecordId(this.getMetadata().getClientRecordId()).setClientRecordVersion(this.getMetadata().getClientRecordVersion()).setManufacturer(this.getMetadata().getDevice().getManufacturer()).setModel(this.getMetadata().getDevice().getModel()).setDeviceType(this.getMetadata().getDevice().getType()).setRecordingMethod(this.getMetadata().getRecordingMethod());
        recordInternal.setTime(this.getTime().toEpochMilli());
        recordInternal.setZoneOffset(this.getZoneOffset().getTotalSeconds());
        recordInternal.setBeatsPerMinute((int)this.mBeatsPerMinute);
        return recordInternal;
    }

    public static class Builder {
        private final Metadata mMetadata;
        private final Instant mTime;
        private ZoneOffset mZoneOffset;
        private final long mBeatsPerMinute;

        public Builder(@NonNull Metadata metadata, @NonNull Instant time, long beatsPerMinute) {
            Objects.requireNonNull(metadata);
            Objects.requireNonNull(time);
            this.mMetadata = metadata;
            this.mTime = time;
            this.mBeatsPerMinute = beatsPerMinute;
            this.mZoneOffset = ZoneOffset.systemDefault().getRules().getOffset(time);
        }

        @NonNull
        public Builder setZoneOffset(@NonNull ZoneOffset zoneOffset) {
            Objects.requireNonNull(zoneOffset);
            this.mZoneOffset = zoneOffset;
            return this;
        }

        @NonNull
        public Builder clearZoneOffset() {
            this.mZoneOffset = RecordUtils.getDefaultZoneOffset();
            return this;
        }

        @NonNull
        public RestingHeartRateRecord buildWithoutValidation() {
            return new RestingHeartRateRecord(this.mMetadata, this.mTime, this.mZoneOffset, this.mBeatsPerMinute, true);
        }

        @NonNull
        public RestingHeartRateRecord build() {
            return new RestingHeartRateRecord(this.mMetadata, this.mTime, this.mZoneOffset, this.mBeatsPerMinute, false);
        }
    }
}

