/*
 * Decompiled with CFR 0.152.
 */
package android.health.connect.datatypes;

import android.annotation.NonNull;
import android.health.connect.datatypes.Identifier;
import android.health.connect.datatypes.InstantRecord;
import android.health.connect.datatypes.Metadata;
import android.health.connect.datatypes.RecordUtils;
import android.health.connect.datatypes.units.Percentage;
import android.health.connect.datatypes.validation.ValidationUtils;
import android.health.connect.internal.datatypes.OxygenSaturationRecordInternal;
import java.time.Instant;
import java.time.ZoneOffset;
import java.util.Objects;

@Identifier(recordIdentifier=22)
public class OxygenSaturationRecord
extends InstantRecord {
    private final Percentage mPercentage;

    private OxygenSaturationRecord(@NonNull Metadata metadata, @NonNull Instant time, @NonNull ZoneOffset zoneOffset, @NonNull Percentage percentage, boolean skipValidation) {
        super(metadata, time, zoneOffset, skipValidation);
        Objects.requireNonNull(metadata);
        Objects.requireNonNull(time);
        Objects.requireNonNull(zoneOffset);
        Objects.requireNonNull(percentage);
        if (!skipValidation) {
            ValidationUtils.requireInRange(percentage.getValue(), 0.0, 100.0, "percentage");
        }
        this.mPercentage = percentage;
    }

    @NonNull
    public Percentage getPercentage() {
        return this.mPercentage;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!super.equals(o)) {
            return false;
        }
        OxygenSaturationRecord that = (OxygenSaturationRecord)o;
        return Objects.equals(this.getPercentage(), that.getPercentage());
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.getPercentage());
    }

    public OxygenSaturationRecordInternal toRecordInternal() {
        OxygenSaturationRecordInternal recordInternal = (OxygenSaturationRecordInternal)new OxygenSaturationRecordInternal().setUuid(this.getMetadata().getId()).setPackageName(this.getMetadata().getDataOrigin().getPackageName()).setLastModifiedTime(this.getMetadata().getLastModifiedTime().toEpochMilli()).setClientRecordId(this.getMetadata().getClientRecordId()).setClientRecordVersion(this.getMetadata().getClientRecordVersion()).setManufacturer(this.getMetadata().getDevice().getManufacturer()).setModel(this.getMetadata().getDevice().getModel()).setDeviceType(this.getMetadata().getDevice().getType()).setRecordingMethod(this.getMetadata().getRecordingMethod());
        recordInternal.setTime(this.getTime().toEpochMilli());
        recordInternal.setZoneOffset(this.getZoneOffset().getTotalSeconds());
        recordInternal.setPercentage(this.mPercentage.getValue());
        return recordInternal;
    }

    public static class Builder {
        private final Metadata mMetadata;
        private final Instant mTime;
        private ZoneOffset mZoneOffset;
        private final Percentage mPercentage;

        public Builder(@NonNull Metadata metadata, @NonNull Instant time, @NonNull Percentage percentage) {
            Objects.requireNonNull(metadata);
            Objects.requireNonNull(time);
            Objects.requireNonNull(percentage);
            this.mMetadata = metadata;
            this.mTime = time;
            this.mPercentage = percentage;
            this.mZoneOffset = ZoneOffset.systemDefault().getRules().getOffset(time);
        }

        @NonNull
        public Builder setZoneOffset(@NonNull ZoneOffset zoneOffset) {
            Objects.requireNonNull(zoneOffset);
            this.mZoneOffset = zoneOffset;
            return this;
        }

        @NonNull
        public Builder clearZoneOffset() {
            this.mZoneOffset = RecordUtils.getDefaultZoneOffset();
            return this;
        }

        @NonNull
        public OxygenSaturationRecord buildWithoutValidation() {
            return new OxygenSaturationRecord(this.mMetadata, this.mTime, this.mZoneOffset, this.mPercentage, true);
        }

        @NonNull
        public OxygenSaturationRecord build() {
            return new OxygenSaturationRecord(this.mMetadata, this.mTime, this.mZoneOffset, this.mPercentage, false);
        }
    }
}

