/*
 * Decompiled with CFR 0.152.
 */
package android.health.connect.datatypes;

import android.annotation.FlaggedApi;
import android.annotation.NonNull;
import android.annotation.Nullable;
import android.health.connect.datatypes.AggregationType;
import android.health.connect.datatypes.Identifier;
import android.health.connect.datatypes.IntervalRecord;
import android.health.connect.datatypes.Metadata;
import android.health.connect.datatypes.RecordUtils;
import android.health.connect.datatypes.validation.ValidationUtils;
import android.health.connect.internal.datatypes.MindfulnessSessionRecordInternal;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.time.Instant;
import java.time.ZoneOffset;
import java.util.Objects;
import java.util.Set;

@Identifier(recordIdentifier=41)
@FlaggedApi(value="com.android.healthfitness.flags.mindfulness")
public class MindfulnessSessionRecord
extends IntervalRecord {
    @NonNull
    public static final AggregationType<Long> MINDFULNESS_DURATION_TOTAL = new AggregationType<Long>(87, 3, 41, Long.class);
    public static final int MINDFULNESS_SESSION_TYPE_UNKNOWN = 0;
    public static final int MINDFULNESS_SESSION_TYPE_MEDITATION = 1;
    public static final int MINDFULNESS_SESSION_TYPE_OTHER = 2;
    public static final int MINDFULNESS_SESSION_TYPE_BREATHING = 3;
    public static final int MINDFULNESS_SESSION_TYPE_MUSIC = 4;
    public static final int MINDFULNESS_SESSION_TYPE_MOVEMENT = 5;
    public static final int MINDFULNESS_SESSION_TYPE_UNGUIDED = 6;
    private static final Set<Integer> VALID_MINDFULNESS_SESSION_TYPES = Set.of(Integer.valueOf(0), Integer.valueOf(1), Integer.valueOf(2), Integer.valueOf(3), Integer.valueOf(4), Integer.valueOf(5), Integer.valueOf(6));
    private final int mMindfulnessSessionType;
    @Nullable
    private final CharSequence mTitle;
    @Nullable
    private final CharSequence mNotes;

    private MindfulnessSessionRecord(@NonNull Metadata metadata, @NonNull Instant startTime, @NonNull ZoneOffset startZoneOffset, @NonNull Instant endTime, @NonNull ZoneOffset endZoneOffset, int mindfulnessSessionType, @Nullable CharSequence title, @Nullable CharSequence notes, boolean skipValidation) {
        super(metadata, startTime, startZoneOffset, endTime, endZoneOffset, skipValidation, true);
        if (!skipValidation) {
            ValidationUtils.validateIntDefValue(mindfulnessSessionType, VALID_MINDFULNESS_SESSION_TYPES, MindfulnessSessionType.class.getSimpleName());
        }
        this.mMindfulnessSessionType = mindfulnessSessionType;
        this.mTitle = title;
        this.mNotes = notes;
    }

    public int getMindfulnessSessionType() {
        return this.mMindfulnessSessionType;
    }

    @Nullable
    public CharSequence getTitle() {
        return this.mTitle;
    }

    @Nullable
    public CharSequence getNotes() {
        return this.mNotes;
    }

    @Override
    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof MindfulnessSessionRecord)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        MindfulnessSessionRecord that = (MindfulnessSessionRecord)o;
        return this.getMindfulnessSessionType() == that.getMindfulnessSessionType() && RecordUtils.isEqualNullableCharSequences(this.getTitle(), that.getTitle()) && RecordUtils.isEqualNullableCharSequences(this.getNotes(), that.getNotes());
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.getMindfulnessSessionType(), this.getTitle(), this.getNotes());
    }

    public MindfulnessSessionRecordInternal toRecordInternal() {
        MindfulnessSessionRecordInternal recordInternal = (MindfulnessSessionRecordInternal)new MindfulnessSessionRecordInternal().setUuid(this.getMetadata().getId()).setPackageName(this.getMetadata().getDataOrigin().getPackageName()).setLastModifiedTime(this.getMetadata().getLastModifiedTime().toEpochMilli()).setClientRecordId(this.getMetadata().getClientRecordId()).setClientRecordVersion(this.getMetadata().getClientRecordVersion()).setManufacturer(this.getMetadata().getDevice().getManufacturer()).setModel(this.getMetadata().getDevice().getModel()).setDeviceType(this.getMetadata().getDevice().getType()).setRecordingMethod(this.getMetadata().getRecordingMethod());
        recordInternal.setStartTime(this.getStartTime().toEpochMilli());
        recordInternal.setEndTime(this.getEndTime().toEpochMilli());
        recordInternal.setStartZoneOffset(this.getStartZoneOffset().getTotalSeconds());
        recordInternal.setEndZoneOffset(this.getEndZoneOffset().getTotalSeconds());
        recordInternal.setMindfulnessSessionType(this.getMindfulnessSessionType());
        if (this.getTitle() != null) {
            recordInternal.setTitle(this.getTitle().toString());
        }
        if (this.getNotes() != null) {
            recordInternal.setNotes(this.getNotes().toString());
        }
        return recordInternal;
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface MindfulnessSessionType {
    }

    public static class Builder {
        private final Metadata mMetadata;
        private final Instant mStartTime;
        private final Instant mEndTime;
        private ZoneOffset mStartZoneOffset;
        private ZoneOffset mEndZoneOffset;
        private final int mMindfulnessSessionType;
        @Nullable
        private CharSequence mTitle;
        @Nullable
        private CharSequence mNotes;

        public Builder(@NonNull Metadata metadata, @NonNull Instant startTime, @NonNull Instant endTime, int mindfulnessSessionType) {
            Objects.requireNonNull(metadata);
            Objects.requireNonNull(startTime);
            Objects.requireNonNull(endTime);
            this.mMetadata = metadata;
            this.mStartTime = startTime;
            this.mEndTime = endTime;
            this.mMindfulnessSessionType = mindfulnessSessionType;
            this.mStartZoneOffset = ZoneOffset.systemDefault().getRules().getOffset(startTime);
            this.mEndZoneOffset = ZoneOffset.systemDefault().getRules().getOffset(endTime);
        }

        @NonNull
        public Builder setStartZoneOffset(@NonNull ZoneOffset startZoneOffset) {
            Objects.requireNonNull(startZoneOffset);
            this.mStartZoneOffset = startZoneOffset;
            return this;
        }

        @NonNull
        public Builder setEndZoneOffset(@NonNull ZoneOffset endZoneOffset) {
            Objects.requireNonNull(endZoneOffset);
            this.mEndZoneOffset = endZoneOffset;
            return this;
        }

        @NonNull
        public Builder setTitle(@Nullable CharSequence title) {
            this.mTitle = title;
            return this;
        }

        @NonNull
        public Builder setNotes(@Nullable CharSequence notes) {
            this.mNotes = notes;
            return this;
        }

        @NonNull
        public MindfulnessSessionRecord buildWithoutValidation() {
            return new MindfulnessSessionRecord(this.mMetadata, this.mStartTime, this.mStartZoneOffset, this.mEndTime, this.mEndZoneOffset, this.mMindfulnessSessionType, this.mTitle, this.mNotes, true);
        }

        @NonNull
        public MindfulnessSessionRecord build() {
            return new MindfulnessSessionRecord(this.mMetadata, this.mStartTime, this.mStartZoneOffset, this.mEndTime, this.mEndZoneOffset, this.mMindfulnessSessionType, this.mTitle, this.mNotes, false);
        }
    }
}

