/*
 * Decompiled with CFR 0.152.
 */
package android.health.connect.datatypes;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.health.connect.datatypes.units.Length;
import android.health.connect.datatypes.validation.ValidationUtils;
import android.health.connect.internal.datatypes.ExerciseRouteInternal;
import android.os.Parcel;
import android.os.Parcelable;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class ExerciseRoute
implements Parcelable {
    private final List<Location> mRouteLocations;
    @NonNull
    public static final Parcelable.Creator<ExerciseRoute> CREATOR = new Parcelable.Creator<ExerciseRoute>(){

        @Override
        public ExerciseRoute createFromParcel(Parcel source) {
            int size = source.readInt();
            ArrayList<Location> locations = new ArrayList<Location>(size);
            for (int i = 0; i < size; ++i) {
                locations.add(i, Location.CREATOR.createFromParcel(source));
            }
            return new ExerciseRoute(locations);
        }

        public ExerciseRoute[] newArray(int size) {
            return new ExerciseRoute[size];
        }
    };

    public ExerciseRoute(@NonNull List<Location> routeLocations) {
        Objects.requireNonNull(routeLocations);
        this.mRouteLocations = routeLocations;
    }

    @NonNull
    public List<Location> getRouteLocations() {
        return this.mRouteLocations;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ExerciseRoute)) {
            return false;
        }
        ExerciseRoute that = (ExerciseRoute)o;
        return this.getRouteLocations().equals(that.getRouteLocations());
    }

    public int hashCode() {
        return Objects.hash(this.getRouteLocations());
    }

    public ExerciseRouteInternal toRouteInternal() {
        ArrayList<ExerciseRouteInternal.LocationInternal> routeLocations = new ArrayList<ExerciseRouteInternal.LocationInternal>(this.getRouteLocations().size());
        for (Location location : this.getRouteLocations()) {
            routeLocations.add(location.toExerciseRouteLocationInternal());
        }
        return new ExerciseRouteInternal(routeLocations);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(@NonNull Parcel dest, int flags) {
        dest.writeInt(this.mRouteLocations.size());
        for (int i = 0; i < this.mRouteLocations.size(); ++i) {
            this.mRouteLocations.get(i).writeToParcel(dest, flags);
        }
    }

    public static class Location
    implements Parcelable {
        private static final double MIN_LONGITUDE = -180.0;
        private static final double MAX_LONGITUDE = 180.0;
        private static final double MIN_LATITUDE = -90.0;
        private static final double MAX_LATITUDE = 90.0;
        private final Instant mTime;
        private final double mLatitude;
        private final double mLongitude;
        private final Length mHorizontalAccuracy;
        private final Length mVerticalAccuracy;
        private final Length mAltitude;
        @NonNull
        public static final Parcelable.Creator<Location> CREATOR = new Parcelable.Creator<Location>(){

            @Override
            public Location createFromParcel(Parcel source) {
                Instant timestamp = Instant.ofEpochMilli(source.readLong());
                double lat = source.readDouble();
                double lon = source.readDouble();
                Builder builder = new Builder(timestamp, lat, lon);
                if (source.readBoolean()) {
                    builder.setHorizontalAccuracy(Length.fromMeters(source.readDouble()));
                }
                if (source.readBoolean()) {
                    builder.setVerticalAccuracy(Length.fromMeters(source.readDouble()));
                }
                if (source.readBoolean()) {
                    builder.setAltitude(Length.fromMeters(source.readDouble()));
                }
                return builder.build();
            }

            public Location[] newArray(int size) {
                return new Location[size];
            }
        };

        private Location(@NonNull Instant time, double latitude, double longitude, @Nullable Length horizontalAccuracy, @Nullable Length verticalAccuracy, @Nullable Length altitude, boolean skipValidation) {
            Objects.requireNonNull(time);
            if (!skipValidation) {
                ValidationUtils.requireInRange(latitude, -90.0, 90.0, "Latitude");
                ValidationUtils.requireInRange(longitude, -180.0, 180.0, "Longitude");
                if (horizontalAccuracy != null) {
                    ValidationUtils.requireNonNegative(horizontalAccuracy.getInMeters(), "Horizontal accuracy");
                }
                if (verticalAccuracy != null && verticalAccuracy.getInMeters() < 0.0) {
                    ValidationUtils.requireNonNegative(verticalAccuracy.getInMeters(), "Vertical accuracy");
                }
            }
            this.mTime = time;
            this.mLatitude = latitude;
            this.mLongitude = longitude;
            this.mHorizontalAccuracy = horizontalAccuracy;
            this.mVerticalAccuracy = verticalAccuracy;
            this.mAltitude = altitude;
        }

        @NonNull
        public Instant getTime() {
            return this.mTime;
        }

        public double getLongitude() {
            return this.mLongitude;
        }

        public double getLatitude() {
            return this.mLatitude;
        }

        @Nullable
        public Length getHorizontalAccuracy() {
            return this.mHorizontalAccuracy;
        }

        @Nullable
        public Length getVerticalAccuracy() {
            return this.mVerticalAccuracy;
        }

        @Nullable
        public Length getAltitude() {
            return this.mAltitude;
        }

        public ExerciseRouteInternal.LocationInternal toExerciseRouteLocationInternal() {
            ExerciseRouteInternal.LocationInternal locationInternal = new ExerciseRouteInternal.LocationInternal().setTime(this.getTime().toEpochMilli()).setLatitude(this.getLatitude()).setLongitude(this.getLongitude());
            if (this.getHorizontalAccuracy() != null) {
                locationInternal.setHorizontalAccuracy(this.getHorizontalAccuracy().getInMeters());
            }
            if (this.getVerticalAccuracy() != null) {
                locationInternal.setVerticalAccuracy(this.getVerticalAccuracy().getInMeters());
            }
            if (this.getAltitude() != null) {
                locationInternal.setAltitude(this.getAltitude().getInMeters());
            }
            return locationInternal;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Location)) {
                return false;
            }
            Location that = (Location)o;
            return Objects.equals(this.getAltitude(), that.getAltitude()) && ((Object)this.getTime()).equals(that.getTime()) && this.getLatitude() == that.getLatitude() && this.getLongitude() == that.getLongitude() && Objects.equals(this.getHorizontalAccuracy(), that.getHorizontalAccuracy()) && Objects.equals(this.getVerticalAccuracy(), that.getVerticalAccuracy());
        }

        public int hashCode() {
            return Objects.hash(this.getTime(), this.getLatitude(), this.getLongitude(), this.getHorizontalAccuracy(), this.getVerticalAccuracy(), this.getAltitude());
        }

        @Override
        public int describeContents() {
            return 0;
        }

        @Override
        public void writeToParcel(@NonNull Parcel dest, int flags) {
            dest.writeLong(this.mTime.toEpochMilli());
            dest.writeDouble(this.mLatitude);
            dest.writeDouble(this.mLongitude);
            dest.writeBoolean(this.mHorizontalAccuracy != null);
            if (this.mHorizontalAccuracy != null) {
                dest.writeDouble(this.mHorizontalAccuracy.getInMeters());
            }
            dest.writeBoolean(this.mVerticalAccuracy != null);
            if (this.mVerticalAccuracy != null) {
                dest.writeDouble(this.mVerticalAccuracy.getInMeters());
            }
            dest.writeBoolean(this.mAltitude != null);
            if (this.mAltitude != null) {
                dest.writeDouble(this.mAltitude.getInMeters());
            }
        }

        public static class Builder {
            @NonNull
            private final Instant mTime;
            private final double mLatitude;
            private final double mLongitude;
            @Nullable
            private Length mHorizontalAccuracy;
            @Nullable
            private Length mVerticalAccuracy;
            @Nullable
            private Length mAltitude;

            public Builder(@NonNull Instant time, double latitude, double longitude) {
                Objects.requireNonNull(time);
                this.mTime = time;
                this.mLatitude = latitude;
                this.mLongitude = longitude;
            }

            @NonNull
            public Builder setHorizontalAccuracy(@NonNull Length horizontalAccuracy) {
                Objects.requireNonNull(horizontalAccuracy);
                this.mHorizontalAccuracy = horizontalAccuracy;
                return this;
            }

            @NonNull
            public Builder setVerticalAccuracy(@NonNull Length verticalAccuracy) {
                Objects.requireNonNull(verticalAccuracy);
                this.mVerticalAccuracy = verticalAccuracy;
                return this;
            }

            @NonNull
            public Builder setAltitude(@NonNull Length altitude) {
                Objects.requireNonNull(altitude);
                this.mAltitude = altitude;
                return this;
            }

            @NonNull
            public Location buildWithoutValidation() {
                return new Location(this.mTime, this.mLatitude, this.mLongitude, this.mHorizontalAccuracy, this.mVerticalAccuracy, this.mAltitude, true);
            }

            @NonNull
            public Location build() {
                return new Location(this.mTime, this.mLatitude, this.mLongitude, this.mHorizontalAccuracy, this.mVerticalAccuracy, this.mAltitude, false);
            }
        }
    }
}

