/*
 * Decompiled with CFR 0.152.
 */
package android.health.connect.datatypes;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.health.connect.datatypes.TimeInterval;
import android.health.connect.datatypes.units.Length;
import android.health.connect.datatypes.validation.ValidationUtils;
import android.health.connect.internal.datatypes.ExerciseLapInternal;
import java.time.Instant;
import java.util.Objects;

public class ExerciseLap
implements TimeInterval.TimeIntervalHolder {
    private static final int MAX_LAP_LENGTH_METRES = 1000000;
    private final TimeInterval mInterval;
    private final Length mLength;

    private ExerciseLap(@NonNull TimeInterval interval, @Nullable Length length, boolean skipValidation) {
        Objects.requireNonNull(interval);
        if (!skipValidation) {
            ValidationUtils.requireInRangeIfExists(length, Length.fromMeters(0.0), Length.fromMeters(1000000.0), "length");
        }
        this.mInterval = interval;
        this.mLength = length;
    }

    @Nullable
    public Length getLength() {
        return this.mLength;
    }

    @NonNull
    public Instant getStartTime() {
        return this.mInterval.getStartTime();
    }

    @NonNull
    public Instant getEndTime() {
        return this.mInterval.getEndTime();
    }

    @Override
    public TimeInterval getInterval() {
        return this.mInterval;
    }

    public int getType() {
        return 0;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ExerciseLap)) {
            return false;
        }
        ExerciseLap that = (ExerciseLap)o;
        return Objects.equals(this.mInterval, that.mInterval) && Objects.equals(this.getLength(), that.getLength());
    }

    public int hashCode() {
        return Objects.hash(this.mInterval, this.getLength());
    }

    @NonNull
    public ExerciseLapInternal toExerciseLapInternal() {
        ExerciseLapInternal internalLap = new ExerciseLapInternal().setStartTime(this.getStartTime().toEpochMilli()).setEndTime(this.getEndTime().toEpochMilli());
        if (this.getLength() != null) {
            internalLap.setLength(this.getLength().getInMeters());
        }
        return internalLap;
    }

    public static class Builder {
        private final TimeInterval mInterval;
        private Length mLength;

        public Builder(@NonNull Instant startTime, @NonNull Instant endTime) {
            this.mInterval = new TimeInterval(startTime, endTime);
        }

        @NonNull
        public Builder setLength(@NonNull Length length) {
            Objects.requireNonNull(length);
            this.mLength = length;
            return this;
        }

        @NonNull
        public ExerciseLap buildWithoutValidation() {
            return new ExerciseLap(this.mInterval, this.mLength, true);
        }

        @NonNull
        public ExerciseLap build() {
            return new ExerciseLap(this.mInterval, this.mLength, false);
        }
    }
}

