/*
 * Decompiled with CFR 0.152.
 */
package android.health.connect.datatypes;

import android.annotation.NonNull;
import android.health.connect.datatypes.AggregationType;
import android.health.connect.datatypes.Identifier;
import android.health.connect.datatypes.IntervalRecord;
import android.health.connect.datatypes.Metadata;
import android.health.connect.datatypes.RecordUtils;
import android.health.connect.datatypes.units.Length;
import android.health.connect.datatypes.validation.ValidationUtils;
import android.health.connect.internal.datatypes.ElevationGainedRecordInternal;
import java.time.Instant;
import java.time.ZoneOffset;
import java.util.Objects;

@Identifier(recordIdentifier=4)
public class ElevationGainedRecord
extends IntervalRecord {
    @NonNull
    public static final AggregationType<Length> ELEVATION_GAINED_TOTAL = new AggregationType<Length>(6, 3, 4, Length.class);
    private final Length mElevation;

    private ElevationGainedRecord(@NonNull Metadata metadata, @NonNull Instant startTime, @NonNull ZoneOffset startZoneOffset, @NonNull Instant endTime, @NonNull ZoneOffset endZoneOffset, @NonNull Length elevation, boolean skipValidation) {
        super(metadata, startTime, startZoneOffset, endTime, endZoneOffset, skipValidation, true);
        Objects.requireNonNull(elevation);
        if (!skipValidation) {
            ValidationUtils.requireInRange(elevation.getInMeters(), -1000000.0, 1000000.0, "elevation");
        }
        this.mElevation = elevation;
    }

    @NonNull
    public Length getElevation() {
        return this.mElevation;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!super.equals(o)) {
            return false;
        }
        ElevationGainedRecord that = (ElevationGainedRecord)o;
        return this.getElevation().equals(that.getElevation());
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.getElevation());
    }

    public ElevationGainedRecordInternal toRecordInternal() {
        ElevationGainedRecordInternal recordInternal = (ElevationGainedRecordInternal)new ElevationGainedRecordInternal().setUuid(this.getMetadata().getId()).setPackageName(this.getMetadata().getDataOrigin().getPackageName()).setLastModifiedTime(this.getMetadata().getLastModifiedTime().toEpochMilli()).setClientRecordId(this.getMetadata().getClientRecordId()).setClientRecordVersion(this.getMetadata().getClientRecordVersion()).setManufacturer(this.getMetadata().getDevice().getManufacturer()).setModel(this.getMetadata().getDevice().getModel()).setDeviceType(this.getMetadata().getDevice().getType()).setRecordingMethod(this.getMetadata().getRecordingMethod());
        recordInternal.setStartTime(this.getStartTime().toEpochMilli());
        recordInternal.setEndTime(this.getEndTime().toEpochMilli());
        recordInternal.setStartZoneOffset(this.getStartZoneOffset().getTotalSeconds());
        recordInternal.setEndZoneOffset(this.getEndZoneOffset().getTotalSeconds());
        recordInternal.setElevation(this.mElevation.getInMeters());
        return recordInternal;
    }

    public static class Builder {
        private final Metadata mMetadata;
        private final Instant mStartTime;
        private final Instant mEndTime;
        private ZoneOffset mStartZoneOffset;
        private ZoneOffset mEndZoneOffset;
        private final Length mElevation;

        public Builder(@NonNull Metadata metadata, @NonNull Instant startTime, @NonNull Instant endTime, @NonNull Length elevation) {
            Objects.requireNonNull(metadata);
            Objects.requireNonNull(startTime);
            Objects.requireNonNull(endTime);
            Objects.requireNonNull(elevation);
            this.mMetadata = metadata;
            this.mStartTime = startTime;
            this.mEndTime = endTime;
            this.mElevation = elevation;
            this.mStartZoneOffset = ZoneOffset.systemDefault().getRules().getOffset(startTime);
            this.mEndZoneOffset = ZoneOffset.systemDefault().getRules().getOffset(endTime);
        }

        @NonNull
        public Builder setStartZoneOffset(@NonNull ZoneOffset startZoneOffset) {
            Objects.requireNonNull(startZoneOffset);
            this.mStartZoneOffset = startZoneOffset;
            return this;
        }

        @NonNull
        public Builder setEndZoneOffset(@NonNull ZoneOffset endZoneOffset) {
            Objects.requireNonNull(endZoneOffset);
            this.mEndZoneOffset = endZoneOffset;
            return this;
        }

        @NonNull
        public Builder clearStartZoneOffset() {
            this.mStartZoneOffset = RecordUtils.getDefaultZoneOffset();
            return this;
        }

        @NonNull
        public Builder clearEndZoneOffset() {
            this.mEndZoneOffset = RecordUtils.getDefaultZoneOffset();
            return this;
        }

        @NonNull
        public ElevationGainedRecord buildWithoutValidation() {
            return new ElevationGainedRecord(this.mMetadata, this.mStartTime, this.mStartZoneOffset, this.mEndTime, this.mEndZoneOffset, this.mElevation, true);
        }

        @NonNull
        public ElevationGainedRecord build() {
            return new ElevationGainedRecord(this.mMetadata, this.mStartTime, this.mStartZoneOffset, this.mEndTime, this.mEndZoneOffset, this.mElevation, false);
        }
    }
}

