/*
 * Decompiled with CFR 0.152.
 */
package android.health.connect.changelog;

import android.annotation.NonNull;
import android.health.connect.aidl.DeletedLogsParcel;
import android.health.connect.aidl.RecordsParcel;
import android.health.connect.datatypes.Record;
import android.health.connect.internal.datatypes.utils.InternalExternalRecordConverter;
import android.os.Parcel;
import android.os.Parcelable;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class ChangeLogsResponse
implements Parcelable {
    private final List<Record> mUpsertedRecords;
    private final List<DeletedLog> mDeletedLogs;
    private final String mNextChangesToken;
    private final boolean mHasMorePages;
    @NonNull
    public static final Parcelable.Creator<ChangeLogsResponse> CREATOR = new Parcelable.Creator<ChangeLogsResponse>(){

        @Override
        public ChangeLogsResponse createFromParcel(Parcel in) {
            return new ChangeLogsResponse(in);
        }

        public ChangeLogsResponse[] newArray(int size) {
            return new ChangeLogsResponse[size];
        }
    };

    public ChangeLogsResponse(@NonNull RecordsParcel upsertedRecords, @NonNull List<DeletedLog> deletedLogs, @NonNull String nextChangesToken, boolean hasMorePages) {
        Objects.requireNonNull(upsertedRecords);
        Objects.requireNonNull(deletedLogs);
        Objects.requireNonNull(nextChangesToken);
        this.mUpsertedRecords = InternalExternalRecordConverter.getInstance().getExternalRecords(upsertedRecords.getRecords());
        this.mDeletedLogs = deletedLogs;
        this.mNextChangesToken = nextChangesToken;
        this.mHasMorePages = hasMorePages;
    }

    private ChangeLogsResponse(Parcel in) {
        this.mUpsertedRecords = InternalExternalRecordConverter.getInstance().getExternalRecords(in.readParcelable(RecordsParcel.class.getClassLoader(), RecordsParcel.class).getRecords());
        this.mDeletedLogs = in.readParcelable(DeletedLogsParcel.class.getClassLoader(), DeletedLogsParcel.class).getDeletedLogs();
        this.mNextChangesToken = in.readString();
        this.mHasMorePages = in.readBoolean();
    }

    @NonNull
    public List<Record> getUpsertedRecords() {
        return this.mUpsertedRecords;
    }

    @NonNull
    public List<DeletedLog> getDeletedLogs() {
        return this.mDeletedLogs;
    }

    @NonNull
    public String getNextChangesToken() {
        return this.mNextChangesToken;
    }

    public boolean hasMorePages() {
        return this.mHasMorePages;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(@NonNull Parcel dest, int flags) {
        ArrayList recordInternal = new ArrayList();
        for (Record record : this.mUpsertedRecords) {
            recordInternal.add(record.toRecordInternal());
        }
        dest.writeParcelable(new RecordsParcel(recordInternal), 0);
        dest.writeParcelable(new DeletedLogsParcel(this.mDeletedLogs), 0);
        dest.writeString(this.mNextChangesToken);
        dest.writeBoolean(this.mHasMorePages);
    }

    public static class DeletedLog {
        private final String mDeletedRecordId;
        private final Instant mDeletedTime;

        public DeletedLog(@NonNull String deletedRecordId, long deletedTime) {
            Objects.requireNonNull(deletedRecordId);
            this.mDeletedRecordId = deletedRecordId;
            this.mDeletedTime = Instant.ofEpochMilli(deletedTime);
        }

        @NonNull
        public String getDeletedRecordId() {
            return this.mDeletedRecordId;
        }

        @NonNull
        public Instant getDeletedTime() {
            return this.mDeletedTime;
        }
    }
}

