/*
 * Decompiled with CFR 0.152.
 */
package android.health.connect.changelog;

import android.annotation.NonNull;
import android.health.connect.datatypes.DataOrigin;
import android.health.connect.datatypes.Record;
import android.health.connect.internal.datatypes.utils.HealthConnectMappings;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.ArraySet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;

public class ChangeLogTokenRequest
implements Parcelable {
    private final Set<DataOrigin> mDataOriginFilters;
    private final Set<Class<? extends Record>> mRecordTypes;
    @NonNull
    public static final Parcelable.Creator<ChangeLogTokenRequest> CREATOR = new Parcelable.Creator<ChangeLogTokenRequest>(){

        @Override
        public ChangeLogTokenRequest createFromParcel(@NonNull Parcel in) {
            return new ChangeLogTokenRequest(in);
        }

        public ChangeLogTokenRequest[] newArray(int size) {
            return new ChangeLogTokenRequest[size];
        }
    };

    private ChangeLogTokenRequest(@NonNull Set<DataOrigin> dataOriginFilters, @NonNull Set<Class<? extends Record>> recordTypes) {
        Objects.requireNonNull(recordTypes);
        this.verifyRecordTypes(recordTypes);
        Objects.requireNonNull(dataOriginFilters);
        this.mDataOriginFilters = dataOriginFilters;
        this.mRecordTypes = recordTypes;
    }

    private void verifyRecordTypes(Set<Class<? extends Record>> recordTypes) {
        if (recordTypes.isEmpty()) {
            throw new IllegalArgumentException("Requested record types must not be empty");
        }
        Set invalidRecordTypes = recordTypes.stream().filter(recordType -> !HealthConnectMappings.getInstance().hasRecordType((Class<? extends Record>)recordType)).map(Class::getName).collect(Collectors.toSet());
        if (!invalidRecordTypes.isEmpty()) {
            throw new IllegalArgumentException("Requested record types must not contain any of " + invalidRecordTypes);
        }
    }

    private ChangeLogTokenRequest(@NonNull Parcel in) {
        HealthConnectMappings healthConnectMappings = HealthConnectMappings.getInstance();
        ArraySet<Class<? extends Record>> recordTypes = new ArraySet<Class<? extends Record>>();
        for (int recordType : in.createIntArray()) {
            recordTypes.add(healthConnectMappings.getRecordIdToExternalRecordClassMap().get(recordType));
        }
        this.mRecordTypes = recordTypes;
        ArraySet<DataOrigin> dataOrigin = new ArraySet<DataOrigin>();
        for (String packageName : in.createStringArrayList()) {
            dataOrigin.add(new DataOrigin.Builder().setPackageName(packageName).build());
        }
        this.mDataOriginFilters = dataOrigin;
    }

    @NonNull
    public Set<DataOrigin> getDataOriginFilters() {
        return this.mDataOriginFilters;
    }

    @NonNull
    public Set<Class<? extends Record>> getRecordTypes() {
        return this.mRecordTypes;
    }

    @NonNull
    public int[] getRecordTypesArray() {
        return this.getRecordTypesAsInteger();
    }

    @NonNull
    public List<Integer> getRecordTypesList() {
        return Arrays.stream(this.getRecordTypesAsInteger()).boxed().collect(Collectors.toList());
    }

    @NonNull
    public List<String> getPackageNamesToFilter() {
        return this.getPackageNames();
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(@NonNull Parcel dest, int flags) {
        dest.writeIntArray(this.getRecordTypesAsInteger());
        dest.writeStringList(this.getPackageNames());
    }

    @NonNull
    private int[] getRecordTypesAsInteger() {
        int[] recordTypes = new int[this.mRecordTypes.size()];
        int index = 0;
        for (Class<? extends Record> recordClass : this.mRecordTypes) {
            recordTypes[index++] = HealthConnectMappings.getInstance().getRecordType(recordClass);
        }
        return recordTypes;
    }

    @NonNull
    private List<String> getPackageNames() {
        ArrayList<String> packageNamesToFilter = new ArrayList<String>(this.mDataOriginFilters.size());
        this.mDataOriginFilters.forEach(dataOrigin -> packageNamesToFilter.add(dataOrigin.getPackageName()));
        return packageNamesToFilter;
    }

    public static class Builder {
        private final Set<Class<? extends Record>> mRecordTypes = new ArraySet<Class<? extends Record>>();
        private final Set<DataOrigin> mDataOriginFilters = new ArraySet<DataOrigin>();

        @NonNull
        public Builder addRecordType(@NonNull Class<? extends Record> recordType) {
            Objects.requireNonNull(recordType);
            this.mRecordTypes.add(recordType);
            return this;
        }

        @NonNull
        public Builder addDataOriginFilter(@NonNull DataOrigin dataOriginFilter) {
            Objects.requireNonNull(dataOriginFilter);
            this.mDataOriginFilters.add(dataOriginFilter);
            return this;
        }

        @NonNull
        public ChangeLogTokenRequest build() {
            return new ChangeLogTokenRequest(this.mDataOriginFilters, this.mRecordTypes);
        }
    }
}

