/*
 * Decompiled with CFR 0.152.
 */
package android.health.connect.aidl;

import android.content.AttributionSource;
import android.health.connect.CreateMedicalDataSourceRequest;
import android.health.connect.DeleteMedicalResourcesRequest;
import android.health.connect.GetMedicalDataSourcesRequest;
import android.health.connect.MedicalResourceId;
import android.health.connect.UpsertMedicalResourceRequest;
import android.health.connect.aidl.ActivityDatesRequestParcel;
import android.health.connect.aidl.AggregateDataRequestParcel;
import android.health.connect.aidl.DeleteUsingFiltersRequestParcel;
import android.health.connect.aidl.IAccessLogsResponseCallback;
import android.health.connect.aidl.IActivityDatesResponseCallback;
import android.health.connect.aidl.IAggregateRecordsResponseCallback;
import android.health.connect.aidl.IApplicationInfoResponseCallback;
import android.health.connect.aidl.ICanRestoreResponseCallback;
import android.health.connect.aidl.IChangeLogsResponseCallback;
import android.health.connect.aidl.IDataStagingFinishedCallback;
import android.health.connect.aidl.IEmptyResponseCallback;
import android.health.connect.aidl.IGetChangeLogTokenCallback;
import android.health.connect.aidl.IGetChangesForBackupResponseCallback;
import android.health.connect.aidl.IGetHealthConnectDataStateCallback;
import android.health.connect.aidl.IGetHealthConnectMigrationUiStateCallback;
import android.health.connect.aidl.IGetLatestMetadataForBackupResponseCallback;
import android.health.connect.aidl.IGetPriorityResponseCallback;
import android.health.connect.aidl.IInsertRecordsResponseCallback;
import android.health.connect.aidl.IMedicalDataSourceResponseCallback;
import android.health.connect.aidl.IMedicalDataSourcesResponseCallback;
import android.health.connect.aidl.IMedicalResourceListParcelResponseCallback;
import android.health.connect.aidl.IMedicalResourceTypeInfosCallback;
import android.health.connect.aidl.IMedicalResourcesResponseCallback;
import android.health.connect.aidl.IMigrationCallback;
import android.health.connect.aidl.IReadMedicalResourcesResponseCallback;
import android.health.connect.aidl.IReadRecordsResponseCallback;
import android.health.connect.aidl.IRecordTypeInfoResponseCallback;
import android.health.connect.aidl.ReadMedicalResourcesRequestParcel;
import android.health.connect.aidl.ReadRecordsRequestParcel;
import android.health.connect.aidl.RecordsParcel;
import android.health.connect.aidl.UpdatePriorityRequestParcel;
import android.health.connect.aidl.UpsertMedicalResourceRequestsParcel;
import android.health.connect.backuprestore.BackupMetadata;
import android.health.connect.backuprestore.RestoreChange;
import android.health.connect.changelog.ChangeLogTokenRequest;
import android.health.connect.changelog.ChangeLogsRequest;
import android.health.connect.exportimport.IImportStatusCallback;
import android.health.connect.exportimport.IQueryDocumentProvidersCallback;
import android.health.connect.exportimport.IScheduledExportStatusCallback;
import android.health.connect.exportimport.ScheduledExportSettings;
import android.health.connect.migration.MigrationEntityParcel;
import android.health.connect.restore.BackupFileNamesSet;
import android.health.connect.restore.StageRemoteDataRequest;
import android.net.Uri;
import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;
import android.os.UserHandle;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public interface IHealthConnectService
extends IInterface {
    public static final String DESCRIPTOR = "android.health.connect.aidl.IHealthConnectService";

    public void grantHealthPermission(String var1, String var2, UserHandle var3) throws RemoteException;

    public void revokeHealthPermission(String var1, String var2, String var3, UserHandle var4) throws RemoteException;

    public void revokeAllHealthPermissions(String var1, String var2, UserHandle var3) throws RemoteException;

    public List<String> getGrantedHealthPermissions(String var1, UserHandle var2) throws RemoteException;

    public Map getHealthPermissionsFlags(String var1, UserHandle var2, List<String> var3) throws RemoteException;

    public void setHealthPermissionsUserFixedFlagValue(String var1, UserHandle var2, List<String> var3, boolean var4) throws RemoteException;

    public long getHistoricalAccessStartDateInMilliseconds(String var1, UserHandle var2) throws RemoteException;

    public void insertRecords(AttributionSource var1, RecordsParcel var2, IInsertRecordsResponseCallback var3) throws RemoteException;

    public void aggregateRecords(AttributionSource var1, AggregateDataRequestParcel var2, IAggregateRecordsResponseCallback var3) throws RemoteException;

    public void readRecords(AttributionSource var1, ReadRecordsRequestParcel var2, IReadRecordsResponseCallback var3) throws RemoteException;

    public void updateRecords(AttributionSource var1, RecordsParcel var2, IEmptyResponseCallback var3) throws RemoteException;

    public void getChangeLogToken(AttributionSource var1, ChangeLogTokenRequest var2, IGetChangeLogTokenCallback var3) throws RemoteException;

    public void getChangeLogs(AttributionSource var1, ChangeLogsRequest var2, IChangeLogsResponseCallback var3) throws RemoteException;

    public void deleteUsingFilters(AttributionSource var1, DeleteUsingFiltersRequestParcel var2, IEmptyResponseCallback var3) throws RemoteException;

    public void getCurrentPriority(int var1, IGetPriorityResponseCallback var2) throws RemoteException;

    public void updatePriority(UpdatePriorityRequestParcel var1, IEmptyResponseCallback var2) throws RemoteException;

    public void setRecordRetentionPeriodInDays(int var1, UserHandle var2, IEmptyResponseCallback var3) throws RemoteException;

    public int getRecordRetentionPeriodInDays(UserHandle var1) throws RemoteException;

    public void getContributorApplicationsInfo(IApplicationInfoResponseCallback var1) throws RemoteException;

    public void queryAllRecordTypesInfo(IRecordTypeInfoResponseCallback var1) throws RemoteException;

    public void queryAccessLogs(String var1, IAccessLogsResponseCallback var2) throws RemoteException;

    public void getActivityDates(ActivityDatesRequestParcel var1, IActivityDatesResponseCallback var2) throws RemoteException;

    public void startMigration(String var1, IMigrationCallback var2) throws RemoteException;

    public void finishMigration(String var1, IMigrationCallback var2) throws RemoteException;

    public void writeMigrationData(String var1, MigrationEntityParcel var2, IMigrationCallback var3) throws RemoteException;

    public void insertMinDataMigrationSdkExtensionVersion(String var1, int var2, IMigrationCallback var3) throws RemoteException;

    public void stageAllHealthConnectRemoteData(StageRemoteDataRequest var1, UserHandle var2, IDataStagingFinishedCallback var3) throws RemoteException;

    public void getAllDataForBackup(StageRemoteDataRequest var1, UserHandle var2) throws RemoteException;

    public BackupFileNamesSet getAllBackupFileNames(boolean var1) throws RemoteException;

    public void deleteAllStagedRemoteData(UserHandle var1) throws RemoteException;

    public void updateDataDownloadState(int var1) throws RemoteException;

    public void getHealthConnectDataState(IGetHealthConnectDataStateCallback var1) throws RemoteException;

    public void getHealthConnectMigrationUiState(IGetHealthConnectMigrationUiStateCallback var1) throws RemoteException;

    public void configureScheduledExport(ScheduledExportSettings var1, UserHandle var2) throws RemoteException;

    public int getScheduledExportPeriodInDays(UserHandle var1) throws RemoteException;

    public void queryDocumentProviders(UserHandle var1, IQueryDocumentProvidersCallback var2) throws RemoteException;

    public void getScheduledExportStatus(UserHandle var1, IScheduledExportStatusCallback var2) throws RemoteException;

    public void setLowerRateLimitsForTesting(boolean var1) throws RemoteException;

    public void getImportStatus(UserHandle var1, IImportStatusCallback var2) throws RemoteException;

    public void runImport(UserHandle var1, Uri var2, IEmptyResponseCallback var3) throws RemoteException;

    public void runImmediateExport(Uri var1, IEmptyResponseCallback var2) throws RemoteException;

    public void createMedicalDataSource(AttributionSource var1, CreateMedicalDataSourceRequest var2, IMedicalDataSourceResponseCallback var3) throws RemoteException;

    public void getMedicalDataSourcesByIds(AttributionSource var1, List<String> var2, IMedicalDataSourcesResponseCallback var3) throws RemoteException;

    public void getMedicalDataSourcesByRequest(AttributionSource var1, GetMedicalDataSourcesRequest var2, IMedicalDataSourcesResponseCallback var3) throws RemoteException;

    public void deleteMedicalDataSourceWithData(AttributionSource var1, String var2, IEmptyResponseCallback var3) throws RemoteException;

    public void upsertMedicalResources(AttributionSource var1, List<UpsertMedicalResourceRequest> var2, IMedicalResourcesResponseCallback var3) throws RemoteException;

    public void upsertMedicalResourcesFromRequestsParcel(AttributionSource var1, UpsertMedicalResourceRequestsParcel var2, IMedicalResourceListParcelResponseCallback var3) throws RemoteException;

    public void readMedicalResourcesByIds(AttributionSource var1, List<MedicalResourceId> var2, IReadMedicalResourcesResponseCallback var3) throws RemoteException;

    public void readMedicalResourcesByRequest(AttributionSource var1, ReadMedicalResourcesRequestParcel var2, IReadMedicalResourcesResponseCallback var3) throws RemoteException;

    public void deleteMedicalResourcesByIds(AttributionSource var1, List<MedicalResourceId> var2, IEmptyResponseCallback var3) throws RemoteException;

    public void deleteMedicalResourcesByRequest(AttributionSource var1, DeleteMedicalResourcesRequest var2, IEmptyResponseCallback var3) throws RemoteException;

    public void queryAllMedicalResourceTypeInfos(IMedicalResourceTypeInfosCallback var1) throws RemoteException;

    public void getChangesForBackup(String var1, IGetChangesForBackupResponseCallback var2) throws RemoteException;

    public void getLatestMetadataForBackup(IGetLatestMetadataForBackupResponseCallback var1) throws RemoteException;

    public void restoreLatestMetadata(BackupMetadata var1, IEmptyResponseCallback var2) throws RemoteException;

    public void canRestore(int var1, ICanRestoreResponseCallback var2) throws RemoteException;

    public void restoreChanges(List<RestoreChange> var1, IEmptyResponseCallback var2) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements IHealthConnectService {
        static final int TRANSACTION_grantHealthPermission = 1;
        static final int TRANSACTION_revokeHealthPermission = 2;
        static final int TRANSACTION_revokeAllHealthPermissions = 3;
        static final int TRANSACTION_getGrantedHealthPermissions = 4;
        static final int TRANSACTION_getHealthPermissionsFlags = 5;
        static final int TRANSACTION_setHealthPermissionsUserFixedFlagValue = 6;
        static final int TRANSACTION_getHistoricalAccessStartDateInMilliseconds = 7;
        static final int TRANSACTION_insertRecords = 8;
        static final int TRANSACTION_aggregateRecords = 9;
        static final int TRANSACTION_readRecords = 10;
        static final int TRANSACTION_updateRecords = 11;
        static final int TRANSACTION_getChangeLogToken = 12;
        static final int TRANSACTION_getChangeLogs = 13;
        static final int TRANSACTION_deleteUsingFilters = 14;
        static final int TRANSACTION_getCurrentPriority = 15;
        static final int TRANSACTION_updatePriority = 16;
        static final int TRANSACTION_setRecordRetentionPeriodInDays = 17;
        static final int TRANSACTION_getRecordRetentionPeriodInDays = 18;
        static final int TRANSACTION_getContributorApplicationsInfo = 19;
        static final int TRANSACTION_queryAllRecordTypesInfo = 20;
        static final int TRANSACTION_queryAccessLogs = 21;
        static final int TRANSACTION_getActivityDates = 22;
        static final int TRANSACTION_startMigration = 23;
        static final int TRANSACTION_finishMigration = 24;
        static final int TRANSACTION_writeMigrationData = 25;
        static final int TRANSACTION_insertMinDataMigrationSdkExtensionVersion = 26;
        static final int TRANSACTION_stageAllHealthConnectRemoteData = 27;
        static final int TRANSACTION_getAllDataForBackup = 28;
        static final int TRANSACTION_getAllBackupFileNames = 29;
        static final int TRANSACTION_deleteAllStagedRemoteData = 30;
        static final int TRANSACTION_updateDataDownloadState = 31;
        static final int TRANSACTION_getHealthConnectDataState = 32;
        static final int TRANSACTION_getHealthConnectMigrationUiState = 33;
        static final int TRANSACTION_configureScheduledExport = 34;
        static final int TRANSACTION_getScheduledExportPeriodInDays = 35;
        static final int TRANSACTION_queryDocumentProviders = 36;
        static final int TRANSACTION_getScheduledExportStatus = 37;
        static final int TRANSACTION_setLowerRateLimitsForTesting = 38;
        static final int TRANSACTION_getImportStatus = 39;
        static final int TRANSACTION_runImport = 40;
        static final int TRANSACTION_runImmediateExport = 41;
        static final int TRANSACTION_createMedicalDataSource = 42;
        static final int TRANSACTION_getMedicalDataSourcesByIds = 43;
        static final int TRANSACTION_getMedicalDataSourcesByRequest = 44;
        static final int TRANSACTION_deleteMedicalDataSourceWithData = 45;
        static final int TRANSACTION_upsertMedicalResources = 46;
        static final int TRANSACTION_upsertMedicalResourcesFromRequestsParcel = 47;
        static final int TRANSACTION_readMedicalResourcesByIds = 48;
        static final int TRANSACTION_readMedicalResourcesByRequest = 49;
        static final int TRANSACTION_deleteMedicalResourcesByIds = 50;
        static final int TRANSACTION_deleteMedicalResourcesByRequest = 51;
        static final int TRANSACTION_queryAllMedicalResourceTypeInfos = 52;
        static final int TRANSACTION_getChangesForBackup = 53;
        static final int TRANSACTION_getLatestMetadataForBackup = 54;
        static final int TRANSACTION_restoreLatestMetadata = 55;
        static final int TRANSACTION_canRestore = 56;
        static final int TRANSACTION_restoreChanges = 57;

        public Stub() {
            this.attachInterface(this, IHealthConnectService.DESCRIPTOR);
        }

        public static IHealthConnectService asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(IHealthConnectService.DESCRIPTOR);
            if (iin != null && iin instanceof IHealthConnectService) {
                return (IHealthConnectService)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 1: {
                    return "grantHealthPermission";
                }
                case 2: {
                    return "revokeHealthPermission";
                }
                case 3: {
                    return "revokeAllHealthPermissions";
                }
                case 4: {
                    return "getGrantedHealthPermissions";
                }
                case 5: {
                    return "getHealthPermissionsFlags";
                }
                case 6: {
                    return "setHealthPermissionsUserFixedFlagValue";
                }
                case 7: {
                    return "getHistoricalAccessStartDateInMilliseconds";
                }
                case 8: {
                    return "insertRecords";
                }
                case 9: {
                    return "aggregateRecords";
                }
                case 10: {
                    return "readRecords";
                }
                case 11: {
                    return "updateRecords";
                }
                case 12: {
                    return "getChangeLogToken";
                }
                case 13: {
                    return "getChangeLogs";
                }
                case 14: {
                    return "deleteUsingFilters";
                }
                case 15: {
                    return "getCurrentPriority";
                }
                case 16: {
                    return "updatePriority";
                }
                case 17: {
                    return "setRecordRetentionPeriodInDays";
                }
                case 18: {
                    return "getRecordRetentionPeriodInDays";
                }
                case 19: {
                    return "getContributorApplicationsInfo";
                }
                case 20: {
                    return "queryAllRecordTypesInfo";
                }
                case 21: {
                    return "queryAccessLogs";
                }
                case 22: {
                    return "getActivityDates";
                }
                case 23: {
                    return "startMigration";
                }
                case 24: {
                    return "finishMigration";
                }
                case 25: {
                    return "writeMigrationData";
                }
                case 26: {
                    return "insertMinDataMigrationSdkExtensionVersion";
                }
                case 27: {
                    return "stageAllHealthConnectRemoteData";
                }
                case 28: {
                    return "getAllDataForBackup";
                }
                case 29: {
                    return "getAllBackupFileNames";
                }
                case 30: {
                    return "deleteAllStagedRemoteData";
                }
                case 31: {
                    return "updateDataDownloadState";
                }
                case 32: {
                    return "getHealthConnectDataState";
                }
                case 33: {
                    return "getHealthConnectMigrationUiState";
                }
                case 34: {
                    return "configureScheduledExport";
                }
                case 35: {
                    return "getScheduledExportPeriodInDays";
                }
                case 36: {
                    return "queryDocumentProviders";
                }
                case 37: {
                    return "getScheduledExportStatus";
                }
                case 38: {
                    return "setLowerRateLimitsForTesting";
                }
                case 39: {
                    return "getImportStatus";
                }
                case 40: {
                    return "runImport";
                }
                case 41: {
                    return "runImmediateExport";
                }
                case 42: {
                    return "createMedicalDataSource";
                }
                case 43: {
                    return "getMedicalDataSourcesByIds";
                }
                case 44: {
                    return "getMedicalDataSourcesByRequest";
                }
                case 45: {
                    return "deleteMedicalDataSourceWithData";
                }
                case 46: {
                    return "upsertMedicalResources";
                }
                case 47: {
                    return "upsertMedicalResourcesFromRequestsParcel";
                }
                case 48: {
                    return "readMedicalResourcesByIds";
                }
                case 49: {
                    return "readMedicalResourcesByRequest";
                }
                case 50: {
                    return "deleteMedicalResourcesByIds";
                }
                case 51: {
                    return "deleteMedicalResourcesByRequest";
                }
                case 52: {
                    return "queryAllMedicalResourceTypeInfos";
                }
                case 53: {
                    return "getChangesForBackup";
                }
                case 54: {
                    return "getLatestMetadataForBackup";
                }
                case 55: {
                    return "restoreLatestMetadata";
                }
                case 56: {
                    return "canRestore";
                }
                case 57: {
                    return "restoreChanges";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = IHealthConnectService.DESCRIPTOR;
            if (code >= 1 && code <= 0xFFFFFF) {
                data.enforceInterface(descriptor);
            }
            if (code == 1598968902) {
                reply.writeString(descriptor);
                return true;
            }
            switch (code) {
                case 1: {
                    String _arg0 = data.readString();
                    String _arg1 = data.readString();
                    UserHandle _arg2 = data.readTypedObject(UserHandle.CREATOR);
                    data.enforceNoDataAvail();
                    this.grantHealthPermission(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    break;
                }
                case 2: {
                    String _arg0 = data.readString();
                    String _arg1 = data.readString();
                    String _arg2 = data.readString();
                    UserHandle _arg3 = data.readTypedObject(UserHandle.CREATOR);
                    data.enforceNoDataAvail();
                    this.revokeHealthPermission(_arg0, _arg1, _arg2, _arg3);
                    reply.writeNoException();
                    break;
                }
                case 3: {
                    String _arg0 = data.readString();
                    String _arg1 = data.readString();
                    UserHandle _arg2 = data.readTypedObject(UserHandle.CREATOR);
                    data.enforceNoDataAvail();
                    this.revokeAllHealthPermissions(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    break;
                }
                case 4: {
                    String _arg0 = data.readString();
                    UserHandle _arg1 = data.readTypedObject(UserHandle.CREATOR);
                    data.enforceNoDataAvail();
                    List<String> _result = this.getGrantedHealthPermissions(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeStringList(_result);
                    break;
                }
                case 5: {
                    String _arg0 = data.readString();
                    UserHandle _arg1 = data.readTypedObject(UserHandle.CREATOR);
                    ArrayList<String> _arg2 = data.createStringArrayList();
                    data.enforceNoDataAvail();
                    Map _result = this.getHealthPermissionsFlags(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    reply.writeMap(_result);
                    break;
                }
                case 6: {
                    String _arg0 = data.readString();
                    UserHandle _arg1 = data.readTypedObject(UserHandle.CREATOR);
                    ArrayList<String> _arg2 = data.createStringArrayList();
                    boolean _arg3 = data.readBoolean();
                    data.enforceNoDataAvail();
                    this.setHealthPermissionsUserFixedFlagValue(_arg0, _arg1, _arg2, _arg3);
                    reply.writeNoException();
                    break;
                }
                case 7: {
                    String _arg0 = data.readString();
                    UserHandle _arg1 = data.readTypedObject(UserHandle.CREATOR);
                    data.enforceNoDataAvail();
                    long _result = this.getHistoricalAccessStartDateInMilliseconds(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeLong(_result);
                    break;
                }
                case 8: {
                    AttributionSource _arg0 = data.readTypedObject(AttributionSource.CREATOR);
                    RecordsParcel _arg1 = data.readTypedObject(RecordsParcel.CREATOR);
                    IInsertRecordsResponseCallback _arg2 = IInsertRecordsResponseCallback.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.insertRecords(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    break;
                }
                case 9: {
                    AttributionSource _arg0 = data.readTypedObject(AttributionSource.CREATOR);
                    AggregateDataRequestParcel _arg1 = data.readTypedObject(AggregateDataRequestParcel.CREATOR);
                    IAggregateRecordsResponseCallback _arg2 = IAggregateRecordsResponseCallback.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.aggregateRecords(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    break;
                }
                case 10: {
                    AttributionSource _arg0 = data.readTypedObject(AttributionSource.CREATOR);
                    ReadRecordsRequestParcel _arg1 = data.readTypedObject(ReadRecordsRequestParcel.CREATOR);
                    IReadRecordsResponseCallback _arg2 = IReadRecordsResponseCallback.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.readRecords(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    break;
                }
                case 11: {
                    AttributionSource _arg0 = data.readTypedObject(AttributionSource.CREATOR);
                    RecordsParcel _arg1 = data.readTypedObject(RecordsParcel.CREATOR);
                    IEmptyResponseCallback _arg2 = IEmptyResponseCallback.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.updateRecords(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    break;
                }
                case 12: {
                    AttributionSource _arg0 = data.readTypedObject(AttributionSource.CREATOR);
                    ChangeLogTokenRequest _arg1 = data.readTypedObject(ChangeLogTokenRequest.CREATOR);
                    IGetChangeLogTokenCallback _arg2 = IGetChangeLogTokenCallback.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.getChangeLogToken(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    break;
                }
                case 13: {
                    AttributionSource _arg0 = data.readTypedObject(AttributionSource.CREATOR);
                    ChangeLogsRequest _arg1 = data.readTypedObject(ChangeLogsRequest.CREATOR);
                    IChangeLogsResponseCallback _arg2 = IChangeLogsResponseCallback.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.getChangeLogs(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    break;
                }
                case 14: {
                    AttributionSource _arg0 = data.readTypedObject(AttributionSource.CREATOR);
                    DeleteUsingFiltersRequestParcel _arg1 = data.readTypedObject(DeleteUsingFiltersRequestParcel.CREATOR);
                    IEmptyResponseCallback _arg2 = IEmptyResponseCallback.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.deleteUsingFilters(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    break;
                }
                case 15: {
                    int _arg0 = data.readInt();
                    IGetPriorityResponseCallback _arg1 = IGetPriorityResponseCallback.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.getCurrentPriority(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 16: {
                    UpdatePriorityRequestParcel _arg0 = data.readTypedObject(UpdatePriorityRequestParcel.CREATOR);
                    IEmptyResponseCallback _arg1 = IEmptyResponseCallback.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.updatePriority(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 17: {
                    int _arg0 = data.readInt();
                    UserHandle _arg1 = data.readTypedObject(UserHandle.CREATOR);
                    IEmptyResponseCallback _arg2 = IEmptyResponseCallback.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.setRecordRetentionPeriodInDays(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    break;
                }
                case 18: {
                    UserHandle _arg0 = data.readTypedObject(UserHandle.CREATOR);
                    data.enforceNoDataAvail();
                    int _result = this.getRecordRetentionPeriodInDays(_arg0);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    break;
                }
                case 19: {
                    IApplicationInfoResponseCallback _arg0 = IApplicationInfoResponseCallback.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.getContributorApplicationsInfo(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 20: {
                    IRecordTypeInfoResponseCallback _arg0 = IRecordTypeInfoResponseCallback.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.queryAllRecordTypesInfo(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 21: {
                    String _arg0 = data.readString();
                    IAccessLogsResponseCallback _arg1 = IAccessLogsResponseCallback.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.queryAccessLogs(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 22: {
                    ActivityDatesRequestParcel _arg0 = data.readTypedObject(ActivityDatesRequestParcel.CREATOR);
                    IActivityDatesResponseCallback _arg1 = IActivityDatesResponseCallback.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.getActivityDates(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 23: {
                    String _arg0 = data.readString();
                    IMigrationCallback _arg1 = IMigrationCallback.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.startMigration(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 24: {
                    String _arg0 = data.readString();
                    IMigrationCallback _arg1 = IMigrationCallback.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.finishMigration(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 25: {
                    String _arg0 = data.readString();
                    MigrationEntityParcel _arg1 = data.readTypedObject(MigrationEntityParcel.CREATOR);
                    IMigrationCallback _arg2 = IMigrationCallback.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.writeMigrationData(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    break;
                }
                case 26: {
                    String _arg0 = data.readString();
                    int _arg1 = data.readInt();
                    IMigrationCallback _arg2 = IMigrationCallback.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.insertMinDataMigrationSdkExtensionVersion(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    break;
                }
                case 27: {
                    StageRemoteDataRequest _arg0 = data.readTypedObject(StageRemoteDataRequest.CREATOR);
                    UserHandle _arg1 = data.readTypedObject(UserHandle.CREATOR);
                    IDataStagingFinishedCallback _arg2 = IDataStagingFinishedCallback.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.stageAllHealthConnectRemoteData(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    break;
                }
                case 28: {
                    StageRemoteDataRequest _arg0 = data.readTypedObject(StageRemoteDataRequest.CREATOR);
                    UserHandle _arg1 = data.readTypedObject(UserHandle.CREATOR);
                    data.enforceNoDataAvail();
                    this.getAllDataForBackup(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 29: {
                    boolean _arg0 = data.readBoolean();
                    data.enforceNoDataAvail();
                    BackupFileNamesSet _result = this.getAllBackupFileNames(_arg0);
                    reply.writeNoException();
                    reply.writeTypedObject(_result, 1);
                    break;
                }
                case 30: {
                    UserHandle _arg0 = data.readTypedObject(UserHandle.CREATOR);
                    data.enforceNoDataAvail();
                    this.deleteAllStagedRemoteData(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 31: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    this.updateDataDownloadState(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 32: {
                    IGetHealthConnectDataStateCallback _arg0 = IGetHealthConnectDataStateCallback.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.getHealthConnectDataState(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 33: {
                    IGetHealthConnectMigrationUiStateCallback _arg0 = IGetHealthConnectMigrationUiStateCallback.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.getHealthConnectMigrationUiState(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 34: {
                    ScheduledExportSettings _arg0 = data.readTypedObject(ScheduledExportSettings.CREATOR);
                    UserHandle _arg1 = data.readTypedObject(UserHandle.CREATOR);
                    data.enforceNoDataAvail();
                    this.configureScheduledExport(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 35: {
                    UserHandle _arg0 = data.readTypedObject(UserHandle.CREATOR);
                    data.enforceNoDataAvail();
                    int _result = this.getScheduledExportPeriodInDays(_arg0);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    break;
                }
                case 36: {
                    UserHandle _arg0 = data.readTypedObject(UserHandle.CREATOR);
                    IQueryDocumentProvidersCallback _arg1 = IQueryDocumentProvidersCallback.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.queryDocumentProviders(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 37: {
                    UserHandle _arg0 = data.readTypedObject(UserHandle.CREATOR);
                    IScheduledExportStatusCallback _arg1 = IScheduledExportStatusCallback.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.getScheduledExportStatus(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 38: {
                    boolean _arg0 = data.readBoolean();
                    data.enforceNoDataAvail();
                    this.setLowerRateLimitsForTesting(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 39: {
                    UserHandle _arg0 = data.readTypedObject(UserHandle.CREATOR);
                    IImportStatusCallback _arg1 = IImportStatusCallback.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.getImportStatus(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 40: {
                    UserHandle _arg0 = data.readTypedObject(UserHandle.CREATOR);
                    Uri _arg1 = data.readTypedObject(Uri.CREATOR);
                    IEmptyResponseCallback _arg2 = IEmptyResponseCallback.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.runImport(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    break;
                }
                case 41: {
                    Uri _arg0 = data.readTypedObject(Uri.CREATOR);
                    IEmptyResponseCallback _arg1 = IEmptyResponseCallback.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.runImmediateExport(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 42: {
                    AttributionSource _arg0 = data.readTypedObject(AttributionSource.CREATOR);
                    CreateMedicalDataSourceRequest _arg1 = data.readTypedObject(CreateMedicalDataSourceRequest.CREATOR);
                    IMedicalDataSourceResponseCallback _arg2 = IMedicalDataSourceResponseCallback.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.createMedicalDataSource(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    break;
                }
                case 43: {
                    AttributionSource _arg0 = data.readTypedObject(AttributionSource.CREATOR);
                    ArrayList<String> _arg1 = data.createStringArrayList();
                    IMedicalDataSourcesResponseCallback _arg2 = IMedicalDataSourcesResponseCallback.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.getMedicalDataSourcesByIds(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    break;
                }
                case 44: {
                    AttributionSource _arg0 = data.readTypedObject(AttributionSource.CREATOR);
                    GetMedicalDataSourcesRequest _arg1 = data.readTypedObject(GetMedicalDataSourcesRequest.CREATOR);
                    IMedicalDataSourcesResponseCallback _arg2 = IMedicalDataSourcesResponseCallback.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.getMedicalDataSourcesByRequest(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    break;
                }
                case 45: {
                    AttributionSource _arg0 = data.readTypedObject(AttributionSource.CREATOR);
                    String _arg1 = data.readString();
                    IEmptyResponseCallback _arg2 = IEmptyResponseCallback.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.deleteMedicalDataSourceWithData(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    break;
                }
                case 46: {
                    AttributionSource _arg0 = data.readTypedObject(AttributionSource.CREATOR);
                    ArrayList<UpsertMedicalResourceRequest> _arg1 = data.createTypedArrayList(UpsertMedicalResourceRequest.CREATOR);
                    IMedicalResourcesResponseCallback _arg2 = IMedicalResourcesResponseCallback.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.upsertMedicalResources(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    break;
                }
                case 47: {
                    AttributionSource _arg0 = data.readTypedObject(AttributionSource.CREATOR);
                    UpsertMedicalResourceRequestsParcel _arg1 = data.readTypedObject(UpsertMedicalResourceRequestsParcel.CREATOR);
                    IMedicalResourceListParcelResponseCallback _arg2 = IMedicalResourceListParcelResponseCallback.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.upsertMedicalResourcesFromRequestsParcel(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    break;
                }
                case 48: {
                    AttributionSource _arg0 = data.readTypedObject(AttributionSource.CREATOR);
                    ArrayList<MedicalResourceId> _arg1 = data.createTypedArrayList(MedicalResourceId.CREATOR);
                    IReadMedicalResourcesResponseCallback _arg2 = IReadMedicalResourcesResponseCallback.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.readMedicalResourcesByIds(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    break;
                }
                case 49: {
                    AttributionSource _arg0 = data.readTypedObject(AttributionSource.CREATOR);
                    ReadMedicalResourcesRequestParcel _arg1 = data.readTypedObject(ReadMedicalResourcesRequestParcel.CREATOR);
                    IReadMedicalResourcesResponseCallback _arg2 = IReadMedicalResourcesResponseCallback.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.readMedicalResourcesByRequest(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    break;
                }
                case 50: {
                    AttributionSource _arg0 = data.readTypedObject(AttributionSource.CREATOR);
                    ArrayList<MedicalResourceId> _arg1 = data.createTypedArrayList(MedicalResourceId.CREATOR);
                    IEmptyResponseCallback _arg2 = IEmptyResponseCallback.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.deleteMedicalResourcesByIds(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    break;
                }
                case 51: {
                    AttributionSource _arg0 = data.readTypedObject(AttributionSource.CREATOR);
                    DeleteMedicalResourcesRequest _arg1 = data.readTypedObject(DeleteMedicalResourcesRequest.CREATOR);
                    IEmptyResponseCallback _arg2 = IEmptyResponseCallback.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.deleteMedicalResourcesByRequest(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    break;
                }
                case 52: {
                    IMedicalResourceTypeInfosCallback _arg0 = IMedicalResourceTypeInfosCallback.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.queryAllMedicalResourceTypeInfos(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 53: {
                    String _arg0 = data.readString();
                    IGetChangesForBackupResponseCallback _arg1 = IGetChangesForBackupResponseCallback.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.getChangesForBackup(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 54: {
                    IGetLatestMetadataForBackupResponseCallback _arg0 = IGetLatestMetadataForBackupResponseCallback.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.getLatestMetadataForBackup(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 55: {
                    BackupMetadata _arg0 = data.readTypedObject(BackupMetadata.CREATOR);
                    IEmptyResponseCallback _arg1 = IEmptyResponseCallback.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.restoreLatestMetadata(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 56: {
                    int _arg0 = data.readInt();
                    ICanRestoreResponseCallback _arg1 = ICanRestoreResponseCallback.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.canRestore(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 57: {
                    ArrayList<RestoreChange> _arg0 = data.createTypedArrayList(RestoreChange.CREATOR);
                    IEmptyResponseCallback _arg1 = IEmptyResponseCallback.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.restoreChanges(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                default: {
                    return super.onTransact(code, data, reply, flags);
                }
            }
            return true;
        }

        @Override
        public int getMaxTransactionId() {
            return 56;
        }

        private static class Proxy
        implements IHealthConnectService {
            private IBinder mRemote;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return IHealthConnectService.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void grantHealthPermission(String packageName, String permissionName, UserHandle user) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IHealthConnectService.DESCRIPTOR);
                    _data.writeString(packageName);
                    _data.writeString(permissionName);
                    _data.writeTypedObject(user, 0);
                    boolean _status = this.mRemote.transact(1, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void revokeHealthPermission(String packageName, String permissionName, String reason, UserHandle user) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IHealthConnectService.DESCRIPTOR);
                    _data.writeString(packageName);
                    _data.writeString(permissionName);
                    _data.writeString(reason);
                    _data.writeTypedObject(user, 0);
                    boolean _status = this.mRemote.transact(2, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void revokeAllHealthPermissions(String packageName, String reason, UserHandle user) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IHealthConnectService.DESCRIPTOR);
                    _data.writeString(packageName);
                    _data.writeString(reason);
                    _data.writeTypedObject(user, 0);
                    boolean _status = this.mRemote.transact(3, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public List<String> getGrantedHealthPermissions(String packageName, UserHandle user) throws RemoteException {
                ArrayList<String> _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IHealthConnectService.DESCRIPTOR);
                    _data.writeString(packageName);
                    _data.writeTypedObject(user, 0);
                    boolean _status = this.mRemote.transact(4, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.createStringArrayList();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Map getHealthPermissionsFlags(String packageName, UserHandle user, List<String> permissions) throws RemoteException {
                HashMap _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IHealthConnectService.DESCRIPTOR);
                    _data.writeString(packageName);
                    _data.writeTypedObject(user, 0);
                    _data.writeStringList(permissions);
                    boolean _status = this.mRemote.transact(5, _data, _reply, 0);
                    _reply.readException();
                    ClassLoader cl = this.getClass().getClassLoader();
                    _result = _reply.readHashMap(cl);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setHealthPermissionsUserFixedFlagValue(String packageName, UserHandle user, List<String> permissions, boolean value) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IHealthConnectService.DESCRIPTOR);
                    _data.writeString(packageName);
                    _data.writeTypedObject(user, 0);
                    _data.writeStringList(permissions);
                    _data.writeBoolean(value);
                    boolean _status = this.mRemote.transact(6, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public long getHistoricalAccessStartDateInMilliseconds(String packageName, UserHandle user) throws RemoteException {
                long _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IHealthConnectService.DESCRIPTOR);
                    _data.writeString(packageName);
                    _data.writeTypedObject(user, 0);
                    boolean _status = this.mRemote.transact(7, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readLong();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void insertRecords(AttributionSource attributionSource, RecordsParcel recordsParcel, IInsertRecordsResponseCallback callback) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IHealthConnectService.DESCRIPTOR);
                    _data.writeTypedObject(attributionSource, 0);
                    _data.writeTypedObject(recordsParcel, 0);
                    _data.writeStrongInterface(callback);
                    boolean _status = this.mRemote.transact(8, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void aggregateRecords(AttributionSource attributionSource, AggregateDataRequestParcel request, IAggregateRecordsResponseCallback callback) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IHealthConnectService.DESCRIPTOR);
                    _data.writeTypedObject(attributionSource, 0);
                    _data.writeTypedObject(request, 0);
                    _data.writeStrongInterface(callback);
                    boolean _status = this.mRemote.transact(9, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void readRecords(AttributionSource attributionSource, ReadRecordsRequestParcel request, IReadRecordsResponseCallback callback) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IHealthConnectService.DESCRIPTOR);
                    _data.writeTypedObject(attributionSource, 0);
                    _data.writeTypedObject(request, 0);
                    _data.writeStrongInterface(callback);
                    boolean _status = this.mRemote.transact(10, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void updateRecords(AttributionSource attributionSource, RecordsParcel recordsParcel, IEmptyResponseCallback callback) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IHealthConnectService.DESCRIPTOR);
                    _data.writeTypedObject(attributionSource, 0);
                    _data.writeTypedObject(recordsParcel, 0);
                    _data.writeStrongInterface(callback);
                    boolean _status = this.mRemote.transact(11, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void getChangeLogToken(AttributionSource attributionSource, ChangeLogTokenRequest request, IGetChangeLogTokenCallback callback) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IHealthConnectService.DESCRIPTOR);
                    _data.writeTypedObject(attributionSource, 0);
                    _data.writeTypedObject(request, 0);
                    _data.writeStrongInterface(callback);
                    boolean _status = this.mRemote.transact(12, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void getChangeLogs(AttributionSource attributionSource, ChangeLogsRequest token, IChangeLogsResponseCallback callback) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IHealthConnectService.DESCRIPTOR);
                    _data.writeTypedObject(attributionSource, 0);
                    _data.writeTypedObject(token, 0);
                    _data.writeStrongInterface(callback);
                    boolean _status = this.mRemote.transact(13, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void deleteUsingFilters(AttributionSource attributionSource, DeleteUsingFiltersRequestParcel request, IEmptyResponseCallback callback) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IHealthConnectService.DESCRIPTOR);
                    _data.writeTypedObject(attributionSource, 0);
                    _data.writeTypedObject(request, 0);
                    _data.writeStrongInterface(callback);
                    boolean _status = this.mRemote.transact(14, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void getCurrentPriority(int permissionCategory, IGetPriorityResponseCallback callback) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IHealthConnectService.DESCRIPTOR);
                    _data.writeInt(permissionCategory);
                    _data.writeStrongInterface(callback);
                    boolean _status = this.mRemote.transact(15, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void updatePriority(UpdatePriorityRequestParcel request, IEmptyResponseCallback callback) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IHealthConnectService.DESCRIPTOR);
                    _data.writeTypedObject(request, 0);
                    _data.writeStrongInterface(callback);
                    boolean _status = this.mRemote.transact(16, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setRecordRetentionPeriodInDays(int days, UserHandle userHandle, IEmptyResponseCallback callback) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IHealthConnectService.DESCRIPTOR);
                    _data.writeInt(days);
                    _data.writeTypedObject(userHandle, 0);
                    _data.writeStrongInterface(callback);
                    boolean _status = this.mRemote.transact(17, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int getRecordRetentionPeriodInDays(UserHandle userHandle) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IHealthConnectService.DESCRIPTOR);
                    _data.writeTypedObject(userHandle, 0);
                    boolean _status = this.mRemote.transact(18, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void getContributorApplicationsInfo(IApplicationInfoResponseCallback callback) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IHealthConnectService.DESCRIPTOR);
                    _data.writeStrongInterface(callback);
                    boolean _status = this.mRemote.transact(19, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void queryAllRecordTypesInfo(IRecordTypeInfoResponseCallback callback) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IHealthConnectService.DESCRIPTOR);
                    _data.writeStrongInterface(callback);
                    boolean _status = this.mRemote.transact(20, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void queryAccessLogs(String packageName, IAccessLogsResponseCallback callback) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IHealthConnectService.DESCRIPTOR);
                    _data.writeString(packageName);
                    _data.writeStrongInterface(callback);
                    boolean _status = this.mRemote.transact(21, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void getActivityDates(ActivityDatesRequestParcel recordTypes, IActivityDatesResponseCallback callback) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IHealthConnectService.DESCRIPTOR);
                    _data.writeTypedObject(recordTypes, 0);
                    _data.writeStrongInterface(callback);
                    boolean _status = this.mRemote.transact(22, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void startMigration(String packageName, IMigrationCallback callback) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IHealthConnectService.DESCRIPTOR);
                    _data.writeString(packageName);
                    _data.writeStrongInterface(callback);
                    boolean _status = this.mRemote.transact(23, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void finishMigration(String packageName, IMigrationCallback callback) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IHealthConnectService.DESCRIPTOR);
                    _data.writeString(packageName);
                    _data.writeStrongInterface(callback);
                    boolean _status = this.mRemote.transact(24, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void writeMigrationData(String packageName, MigrationEntityParcel parcel, IMigrationCallback callback) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IHealthConnectService.DESCRIPTOR);
                    _data.writeString(packageName);
                    _data.writeTypedObject(parcel, 0);
                    _data.writeStrongInterface(callback);
                    boolean _status = this.mRemote.transact(25, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void insertMinDataMigrationSdkExtensionVersion(String packageName, int requiredSdkExtension, IMigrationCallback callback) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IHealthConnectService.DESCRIPTOR);
                    _data.writeString(packageName);
                    _data.writeInt(requiredSdkExtension);
                    _data.writeStrongInterface(callback);
                    boolean _status = this.mRemote.transact(26, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void stageAllHealthConnectRemoteData(StageRemoteDataRequest stageRemoteDataRequest, UserHandle userHandle, IDataStagingFinishedCallback callback) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IHealthConnectService.DESCRIPTOR);
                    _data.writeTypedObject(stageRemoteDataRequest, 0);
                    _data.writeTypedObject(userHandle, 0);
                    _data.writeStrongInterface(callback);
                    boolean _status = this.mRemote.transact(27, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void getAllDataForBackup(StageRemoteDataRequest stageRemoteDataRequest, UserHandle userHandle) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IHealthConnectService.DESCRIPTOR);
                    _data.writeTypedObject(stageRemoteDataRequest, 0);
                    _data.writeTypedObject(userHandle, 0);
                    boolean _status = this.mRemote.transact(28, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public BackupFileNamesSet getAllBackupFileNames(boolean forDeviceToDevice) throws RemoteException {
                BackupFileNamesSet _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IHealthConnectService.DESCRIPTOR);
                    _data.writeBoolean(forDeviceToDevice);
                    boolean _status = this.mRemote.transact(29, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readTypedObject(BackupFileNamesSet.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void deleteAllStagedRemoteData(UserHandle userHandle) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IHealthConnectService.DESCRIPTOR);
                    _data.writeTypedObject(userHandle, 0);
                    boolean _status = this.mRemote.transact(30, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void updateDataDownloadState(int downloadState) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IHealthConnectService.DESCRIPTOR);
                    _data.writeInt(downloadState);
                    boolean _status = this.mRemote.transact(31, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void getHealthConnectDataState(IGetHealthConnectDataStateCallback callback) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IHealthConnectService.DESCRIPTOR);
                    _data.writeStrongInterface(callback);
                    boolean _status = this.mRemote.transact(32, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void getHealthConnectMigrationUiState(IGetHealthConnectMigrationUiStateCallback callback) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IHealthConnectService.DESCRIPTOR);
                    _data.writeStrongInterface(callback);
                    boolean _status = this.mRemote.transact(33, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void configureScheduledExport(ScheduledExportSettings settings, UserHandle userHandle) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IHealthConnectService.DESCRIPTOR);
                    _data.writeTypedObject(settings, 0);
                    _data.writeTypedObject(userHandle, 0);
                    boolean _status = this.mRemote.transact(34, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int getScheduledExportPeriodInDays(UserHandle userHandle) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IHealthConnectService.DESCRIPTOR);
                    _data.writeTypedObject(userHandle, 0);
                    boolean _status = this.mRemote.transact(35, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void queryDocumentProviders(UserHandle userHandle, IQueryDocumentProvidersCallback callback) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IHealthConnectService.DESCRIPTOR);
                    _data.writeTypedObject(userHandle, 0);
                    _data.writeStrongInterface(callback);
                    boolean _status = this.mRemote.transact(36, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void getScheduledExportStatus(UserHandle userHandle, IScheduledExportStatusCallback callback) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IHealthConnectService.DESCRIPTOR);
                    _data.writeTypedObject(userHandle, 0);
                    _data.writeStrongInterface(callback);
                    boolean _status = this.mRemote.transact(37, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setLowerRateLimitsForTesting(boolean enabled) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IHealthConnectService.DESCRIPTOR);
                    _data.writeBoolean(enabled);
                    boolean _status = this.mRemote.transact(38, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void getImportStatus(UserHandle userHandle, IImportStatusCallback callback) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IHealthConnectService.DESCRIPTOR);
                    _data.writeTypedObject(userHandle, 0);
                    _data.writeStrongInterface(callback);
                    boolean _status = this.mRemote.transact(39, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void runImport(UserHandle userHandle, Uri file, IEmptyResponseCallback callback) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IHealthConnectService.DESCRIPTOR);
                    _data.writeTypedObject(userHandle, 0);
                    _data.writeTypedObject(file, 0);
                    _data.writeStrongInterface(callback);
                    boolean _status = this.mRemote.transact(40, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void runImmediateExport(Uri file, IEmptyResponseCallback callback) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IHealthConnectService.DESCRIPTOR);
                    _data.writeTypedObject(file, 0);
                    _data.writeStrongInterface(callback);
                    boolean _status = this.mRemote.transact(41, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void createMedicalDataSource(AttributionSource attributionSource, CreateMedicalDataSourceRequest request, IMedicalDataSourceResponseCallback callback) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IHealthConnectService.DESCRIPTOR);
                    _data.writeTypedObject(attributionSource, 0);
                    _data.writeTypedObject(request, 0);
                    _data.writeStrongInterface(callback);
                    boolean _status = this.mRemote.transact(42, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void getMedicalDataSourcesByIds(AttributionSource attributionSource, List<String> ids, IMedicalDataSourcesResponseCallback callback) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IHealthConnectService.DESCRIPTOR);
                    _data.writeTypedObject(attributionSource, 0);
                    _data.writeStringList(ids);
                    _data.writeStrongInterface(callback);
                    boolean _status = this.mRemote.transact(43, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void getMedicalDataSourcesByRequest(AttributionSource attributionSource, GetMedicalDataSourcesRequest request, IMedicalDataSourcesResponseCallback callback) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IHealthConnectService.DESCRIPTOR);
                    _data.writeTypedObject(attributionSource, 0);
                    _data.writeTypedObject(request, 0);
                    _data.writeStrongInterface(callback);
                    boolean _status = this.mRemote.transact(44, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void deleteMedicalDataSourceWithData(AttributionSource attributionSource, String id2, IEmptyResponseCallback callback) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IHealthConnectService.DESCRIPTOR);
                    _data.writeTypedObject(attributionSource, 0);
                    _data.writeString(id2);
                    _data.writeStrongInterface(callback);
                    boolean _status = this.mRemote.transact(45, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void upsertMedicalResources(AttributionSource attributionSource, List<UpsertMedicalResourceRequest> requests, IMedicalResourcesResponseCallback callback) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IHealthConnectService.DESCRIPTOR);
                    _data.writeTypedObject(attributionSource, 0);
                    _data.writeTypedList(requests, 0);
                    _data.writeStrongInterface(callback);
                    boolean _status = this.mRemote.transact(46, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void upsertMedicalResourcesFromRequestsParcel(AttributionSource attributionSource, UpsertMedicalResourceRequestsParcel requestsParcel, IMedicalResourceListParcelResponseCallback callback) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IHealthConnectService.DESCRIPTOR);
                    _data.writeTypedObject(attributionSource, 0);
                    _data.writeTypedObject(requestsParcel, 0);
                    _data.writeStrongInterface(callback);
                    boolean _status = this.mRemote.transact(47, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void readMedicalResourcesByIds(AttributionSource attributionSource, List<MedicalResourceId> medicalResourceIds, IReadMedicalResourcesResponseCallback callback) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IHealthConnectService.DESCRIPTOR);
                    _data.writeTypedObject(attributionSource, 0);
                    _data.writeTypedList(medicalResourceIds, 0);
                    _data.writeStrongInterface(callback);
                    boolean _status = this.mRemote.transact(48, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void readMedicalResourcesByRequest(AttributionSource attributionSource, ReadMedicalResourcesRequestParcel request, IReadMedicalResourcesResponseCallback callback) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IHealthConnectService.DESCRIPTOR);
                    _data.writeTypedObject(attributionSource, 0);
                    _data.writeTypedObject(request, 0);
                    _data.writeStrongInterface(callback);
                    boolean _status = this.mRemote.transact(49, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void deleteMedicalResourcesByIds(AttributionSource attributionSource, List<MedicalResourceId> medicalResourceIds, IEmptyResponseCallback callback) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IHealthConnectService.DESCRIPTOR);
                    _data.writeTypedObject(attributionSource, 0);
                    _data.writeTypedList(medicalResourceIds, 0);
                    _data.writeStrongInterface(callback);
                    boolean _status = this.mRemote.transact(50, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void deleteMedicalResourcesByRequest(AttributionSource attributionSource, DeleteMedicalResourcesRequest request, IEmptyResponseCallback callback) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IHealthConnectService.DESCRIPTOR);
                    _data.writeTypedObject(attributionSource, 0);
                    _data.writeTypedObject(request, 0);
                    _data.writeStrongInterface(callback);
                    boolean _status = this.mRemote.transact(51, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void queryAllMedicalResourceTypeInfos(IMedicalResourceTypeInfosCallback callback) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IHealthConnectService.DESCRIPTOR);
                    _data.writeStrongInterface(callback);
                    boolean _status = this.mRemote.transact(52, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void getChangesForBackup(String changeToken, IGetChangesForBackupResponseCallback callback) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IHealthConnectService.DESCRIPTOR);
                    _data.writeString(changeToken);
                    _data.writeStrongInterface(callback);
                    boolean _status = this.mRemote.transact(53, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void getLatestMetadataForBackup(IGetLatestMetadataForBackupResponseCallback callback) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IHealthConnectService.DESCRIPTOR);
                    _data.writeStrongInterface(callback);
                    boolean _status = this.mRemote.transact(54, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void restoreLatestMetadata(BackupMetadata backupMetadata, IEmptyResponseCallback callback) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IHealthConnectService.DESCRIPTOR);
                    _data.writeTypedObject(backupMetadata, 0);
                    _data.writeStrongInterface(callback);
                    boolean _status = this.mRemote.transact(55, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void canRestore(int dataVersion, ICanRestoreResponseCallback callback) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IHealthConnectService.DESCRIPTOR);
                    _data.writeInt(dataVersion);
                    _data.writeStrongInterface(callback);
                    boolean _status = this.mRemote.transact(56, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void restoreChanges(List<RestoreChange> changes, IEmptyResponseCallback callback) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IHealthConnectService.DESCRIPTOR);
                    _data.writeTypedList(changes, 0);
                    _data.writeStrongInterface(callback);
                    boolean _status = this.mRemote.transact(57, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }
        }
    }

    public static class Default
    implements IHealthConnectService {
        @Override
        public void grantHealthPermission(String packageName, String permissionName, UserHandle user) throws RemoteException {
        }

        @Override
        public void revokeHealthPermission(String packageName, String permissionName, String reason, UserHandle user) throws RemoteException {
        }

        @Override
        public void revokeAllHealthPermissions(String packageName, String reason, UserHandle user) throws RemoteException {
        }

        @Override
        public List<String> getGrantedHealthPermissions(String packageName, UserHandle user) throws RemoteException {
            return null;
        }

        @Override
        public Map getHealthPermissionsFlags(String packageName, UserHandle user, List<String> permissions) throws RemoteException {
            return null;
        }

        @Override
        public void setHealthPermissionsUserFixedFlagValue(String packageName, UserHandle user, List<String> permissions, boolean value) throws RemoteException {
        }

        @Override
        public long getHistoricalAccessStartDateInMilliseconds(String packageName, UserHandle user) throws RemoteException {
            return 0L;
        }

        @Override
        public void insertRecords(AttributionSource attributionSource, RecordsParcel recordsParcel, IInsertRecordsResponseCallback callback) throws RemoteException {
        }

        @Override
        public void aggregateRecords(AttributionSource attributionSource, AggregateDataRequestParcel request, IAggregateRecordsResponseCallback callback) throws RemoteException {
        }

        @Override
        public void readRecords(AttributionSource attributionSource, ReadRecordsRequestParcel request, IReadRecordsResponseCallback callback) throws RemoteException {
        }

        @Override
        public void updateRecords(AttributionSource attributionSource, RecordsParcel recordsParcel, IEmptyResponseCallback callback) throws RemoteException {
        }

        @Override
        public void getChangeLogToken(AttributionSource attributionSource, ChangeLogTokenRequest request, IGetChangeLogTokenCallback callback) throws RemoteException {
        }

        @Override
        public void getChangeLogs(AttributionSource attributionSource, ChangeLogsRequest token, IChangeLogsResponseCallback callback) throws RemoteException {
        }

        @Override
        public void deleteUsingFilters(AttributionSource attributionSource, DeleteUsingFiltersRequestParcel request, IEmptyResponseCallback callback) throws RemoteException {
        }

        @Override
        public void getCurrentPriority(int permissionCategory, IGetPriorityResponseCallback callback) throws RemoteException {
        }

        @Override
        public void updatePriority(UpdatePriorityRequestParcel request, IEmptyResponseCallback callback) throws RemoteException {
        }

        @Override
        public void setRecordRetentionPeriodInDays(int days, UserHandle userHandle, IEmptyResponseCallback callback) throws RemoteException {
        }

        @Override
        public int getRecordRetentionPeriodInDays(UserHandle userHandle) throws RemoteException {
            return 0;
        }

        @Override
        public void getContributorApplicationsInfo(IApplicationInfoResponseCallback callback) throws RemoteException {
        }

        @Override
        public void queryAllRecordTypesInfo(IRecordTypeInfoResponseCallback callback) throws RemoteException {
        }

        @Override
        public void queryAccessLogs(String packageName, IAccessLogsResponseCallback callback) throws RemoteException {
        }

        @Override
        public void getActivityDates(ActivityDatesRequestParcel recordTypes, IActivityDatesResponseCallback callback) throws RemoteException {
        }

        @Override
        public void startMigration(String packageName, IMigrationCallback callback) throws RemoteException {
        }

        @Override
        public void finishMigration(String packageName, IMigrationCallback callback) throws RemoteException {
        }

        @Override
        public void writeMigrationData(String packageName, MigrationEntityParcel parcel, IMigrationCallback callback) throws RemoteException {
        }

        @Override
        public void insertMinDataMigrationSdkExtensionVersion(String packageName, int requiredSdkExtension, IMigrationCallback callback) throws RemoteException {
        }

        @Override
        public void stageAllHealthConnectRemoteData(StageRemoteDataRequest stageRemoteDataRequest, UserHandle userHandle, IDataStagingFinishedCallback callback) throws RemoteException {
        }

        @Override
        public void getAllDataForBackup(StageRemoteDataRequest stageRemoteDataRequest, UserHandle userHandle) throws RemoteException {
        }

        @Override
        public BackupFileNamesSet getAllBackupFileNames(boolean forDeviceToDevice) throws RemoteException {
            return null;
        }

        @Override
        public void deleteAllStagedRemoteData(UserHandle userHandle) throws RemoteException {
        }

        @Override
        public void updateDataDownloadState(int downloadState) throws RemoteException {
        }

        @Override
        public void getHealthConnectDataState(IGetHealthConnectDataStateCallback callback) throws RemoteException {
        }

        @Override
        public void getHealthConnectMigrationUiState(IGetHealthConnectMigrationUiStateCallback callback) throws RemoteException {
        }

        @Override
        public void configureScheduledExport(ScheduledExportSettings settings, UserHandle userHandle) throws RemoteException {
        }

        @Override
        public int getScheduledExportPeriodInDays(UserHandle userHandle) throws RemoteException {
            return 0;
        }

        @Override
        public void queryDocumentProviders(UserHandle userHandle, IQueryDocumentProvidersCallback callback) throws RemoteException {
        }

        @Override
        public void getScheduledExportStatus(UserHandle userHandle, IScheduledExportStatusCallback callback) throws RemoteException {
        }

        @Override
        public void setLowerRateLimitsForTesting(boolean enabled) throws RemoteException {
        }

        @Override
        public void getImportStatus(UserHandle userHandle, IImportStatusCallback callback) throws RemoteException {
        }

        @Override
        public void runImport(UserHandle userHandle, Uri file, IEmptyResponseCallback callback) throws RemoteException {
        }

        @Override
        public void runImmediateExport(Uri file, IEmptyResponseCallback callback) throws RemoteException {
        }

        @Override
        public void createMedicalDataSource(AttributionSource attributionSource, CreateMedicalDataSourceRequest request, IMedicalDataSourceResponseCallback callback) throws RemoteException {
        }

        @Override
        public void getMedicalDataSourcesByIds(AttributionSource attributionSource, List<String> ids, IMedicalDataSourcesResponseCallback callback) throws RemoteException {
        }

        @Override
        public void getMedicalDataSourcesByRequest(AttributionSource attributionSource, GetMedicalDataSourcesRequest request, IMedicalDataSourcesResponseCallback callback) throws RemoteException {
        }

        @Override
        public void deleteMedicalDataSourceWithData(AttributionSource attributionSource, String id2, IEmptyResponseCallback callback) throws RemoteException {
        }

        @Override
        public void upsertMedicalResources(AttributionSource attributionSource, List<UpsertMedicalResourceRequest> requests, IMedicalResourcesResponseCallback callback) throws RemoteException {
        }

        @Override
        public void upsertMedicalResourcesFromRequestsParcel(AttributionSource attributionSource, UpsertMedicalResourceRequestsParcel requestsParcel, IMedicalResourceListParcelResponseCallback callback) throws RemoteException {
        }

        @Override
        public void readMedicalResourcesByIds(AttributionSource attributionSource, List<MedicalResourceId> medicalResourceIds, IReadMedicalResourcesResponseCallback callback) throws RemoteException {
        }

        @Override
        public void readMedicalResourcesByRequest(AttributionSource attributionSource, ReadMedicalResourcesRequestParcel request, IReadMedicalResourcesResponseCallback callback) throws RemoteException {
        }

        @Override
        public void deleteMedicalResourcesByIds(AttributionSource attributionSource, List<MedicalResourceId> medicalResourceIds, IEmptyResponseCallback callback) throws RemoteException {
        }

        @Override
        public void deleteMedicalResourcesByRequest(AttributionSource attributionSource, DeleteMedicalResourcesRequest request, IEmptyResponseCallback callback) throws RemoteException {
        }

        @Override
        public void queryAllMedicalResourceTypeInfos(IMedicalResourceTypeInfosCallback callback) throws RemoteException {
        }

        @Override
        public void getChangesForBackup(String changeToken, IGetChangesForBackupResponseCallback callback) throws RemoteException {
        }

        @Override
        public void getLatestMetadataForBackup(IGetLatestMetadataForBackupResponseCallback callback) throws RemoteException {
        }

        @Override
        public void restoreLatestMetadata(BackupMetadata backupMetadata, IEmptyResponseCallback callback) throws RemoteException {
        }

        @Override
        public void canRestore(int dataVersion, ICanRestoreResponseCallback callback) throws RemoteException {
        }

        @Override
        public void restoreChanges(List<RestoreChange> changes, IEmptyResponseCallback callback) throws RemoteException {
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

