/*
 * Decompiled with CFR 0.152.
 */
package android.health.connect;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.health.connect.PageTokenWrapper;
import android.health.connect.ReadRecordsRequest;
import android.health.connect.TimeRangeFilter;
import android.health.connect.aidl.ReadRecordsRequestParcel;
import android.health.connect.datatypes.DataOrigin;
import android.health.connect.datatypes.Record;
import android.util.ArraySet;
import java.util.Objects;
import java.util.Set;

public class ReadRecordsRequestUsingFilters<T extends Record>
extends ReadRecordsRequest<T> {
    private final TimeRangeFilter mTimeRangeFilter;
    private final Set<DataOrigin> mDataOrigins;
    private final int mPageSize;
    private final long mPageToken;
    private final boolean mAscending;

    private ReadRecordsRequestUsingFilters(@NonNull TimeRangeFilter timeRangeFilter, @NonNull Class<T> recordType, @NonNull Set<DataOrigin> dataOrigins, int pageSize, long pageToken, boolean ascending) {
        super(recordType);
        Objects.requireNonNull(dataOrigins);
        this.mTimeRangeFilter = timeRangeFilter;
        this.mDataOrigins = dataOrigins;
        this.mPageSize = pageSize;
        this.mAscending = PageTokenWrapper.from(pageToken, ascending).isAscending();
        this.mPageToken = pageToken;
    }

    @Nullable
    public TimeRangeFilter getTimeRangeFilter() {
        return this.mTimeRangeFilter;
    }

    @NonNull
    public Set<DataOrigin> getDataOrigins() {
        return this.mDataOrigins;
    }

    public int getPageSize() {
        return this.mPageSize;
    }

    public long getPageToken() {
        return this.mPageToken;
    }

    public boolean isAscending() {
        return this.mAscending;
    }

    @Override
    @NonNull
    public ReadRecordsRequestParcel toReadRecordsRequestParcel() {
        return new ReadRecordsRequestParcel(this);
    }

    public static class Builder<T extends Record> {
        private final Class<T> mRecordType;
        private final Set<DataOrigin> mDataOrigins = new ArraySet<DataOrigin>();
        private TimeRangeFilter mTimeRangeFilter;
        private int mPageSize = 1000;
        private long mPageToken = -1L;
        private boolean mAscending = true;
        private boolean mIsOrderingSet = false;

        public Builder(@NonNull Class<T> recordType) {
            Objects.requireNonNull(recordType);
            this.mRecordType = recordType;
        }

        @NonNull
        public Builder<T> addDataOrigins(@NonNull DataOrigin dataOrigin) {
            Objects.requireNonNull(dataOrigin);
            this.mDataOrigins.add(dataOrigin);
            return this;
        }

        @NonNull
        public Builder<T> setTimeRangeFilter(@Nullable TimeRangeFilter timeRangeFilter) {
            this.mTimeRangeFilter = timeRangeFilter;
            return this;
        }

        @NonNull
        public Builder<T> setPageSize(int pageSize) {
            if (pageSize < 1 || pageSize > 5000) {
                throw new IllegalArgumentException("Valid pageSize range is 1 - 5000, requested " + pageSize);
            }
            this.mPageSize = pageSize;
            return this;
        }

        @NonNull
        public Builder<T> setPageToken(long pageToken) {
            this.mPageToken = pageToken;
            return this;
        }

        @NonNull
        public Builder<T> setAscending(boolean ascending) {
            this.mAscending = ascending;
            this.mIsOrderingSet = true;
            return this;
        }

        @NonNull
        public ReadRecordsRequestUsingFilters<T> build() {
            if (this.mPageToken != -1L && this.mIsOrderingSet) {
                throw new IllegalStateException("Cannot set both pageToken and sort order");
            }
            return new ReadRecordsRequestUsingFilters<T>(this.mTimeRangeFilter, this.mRecordType, this.mDataOrigins, this.mPageSize, this.mPageToken, this.mAscending);
        }
    }
}

