/*
 * Decompiled with CFR 0.152.
 */
package android.health.connect;

import android.annotation.FlaggedApi;
import android.annotation.NonNull;
import android.health.connect.ReadMedicalResourcesRequest;
import android.health.connect.aidl.ReadMedicalResourcesRequestParcel;
import android.health.connect.datatypes.validation.ValidationUtils;
import java.util.Objects;

@FlaggedApi(value="com.android.healthfitness.flags.personal_health_record")
public class ReadMedicalResourcesPageRequest
extends ReadMedicalResourcesRequest {
    @NonNull
    private final String mPageToken;

    private ReadMedicalResourcesPageRequest(@NonNull String pageToken, int pageSize) {
        super(pageSize);
        Objects.requireNonNull(pageToken);
        this.mPageToken = pageToken;
    }

    @NonNull
    public String getPageToken() {
        return this.mPageToken;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ReadMedicalResourcesPageRequest)) {
            return false;
        }
        ReadMedicalResourcesPageRequest that = (ReadMedicalResourcesPageRequest)o;
        return this.getPageToken().equals(that.getPageToken()) && this.getPageSize() == that.getPageSize();
    }

    public int hashCode() {
        return Objects.hash(this.getPageToken(), this.getPageSize());
    }

    public String toString() {
        return this.getClass().getSimpleName() + "{pageToken=" + this.getPageToken() + ",pageSize=" + this.getPageSize() + "}";
    }

    @Override
    public ReadMedicalResourcesRequestParcel toParcel() {
        return new ReadMedicalResourcesRequestParcel(this);
    }

    public static class Builder {
        @NonNull
        private String mPageToken;
        private int mPageSize = 1000;

        public Builder(@NonNull String pageToken) {
            Objects.requireNonNull(pageToken);
            this.mPageToken = pageToken;
        }

        public Builder(@NonNull Builder other) {
            this.mPageToken = other.mPageToken;
            this.mPageSize = other.mPageSize;
        }

        public Builder(@NonNull ReadMedicalResourcesPageRequest other) {
            this.mPageToken = other.getPageToken();
            this.mPageSize = other.getPageSize();
        }

        @NonNull
        public Builder setPageToken(@NonNull String pageToken) {
            Objects.requireNonNull(pageToken);
            this.mPageToken = pageToken;
            return this;
        }

        @NonNull
        public Builder setPageSize(int pageSize) {
            ValidationUtils.requireInRange(pageSize, 1, 5000, "pageSize");
            this.mPageSize = pageSize;
            return this;
        }

        @NonNull
        public ReadMedicalResourcesPageRequest build() {
            return new ReadMedicalResourcesPageRequest(this.mPageToken, this.mPageSize);
        }
    }
}

