/*
 * Decompiled with CFR 0.152.
 */
package android.health.connect;

import android.annotation.FlaggedApi;
import android.annotation.NonNull;
import android.annotation.Nullable;
import android.annotation.RequiresPermission;
import android.annotation.SystemApi;
import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.pm.PermissionGroupInfo;
import android.content.pm.PermissionInfo;
import android.health.connect.AggregateRecordsGroupedByDurationResponse;
import android.health.connect.AggregateRecordsGroupedByPeriodResponse;
import android.health.connect.AggregateRecordsRequest;
import android.health.connect.AggregateRecordsResponse;
import android.health.connect.ApplicationInfoResponse;
import android.health.connect.CreateMedicalDataSourceRequest;
import android.health.connect.DeleteMedicalResourcesRequest;
import android.health.connect.DeleteUsingFiltersRequest;
import android.health.connect.FetchDataOriginsPriorityOrderResponse;
import android.health.connect.GetMedicalDataSourcesRequest;
import android.health.connect.HealthConnectDataState;
import android.health.connect.HealthConnectException;
import android.health.connect.HealthPermissions;
import android.health.connect.InsertRecordsResponse;
import android.health.connect.MedicalResourceId;
import android.health.connect.MedicalResourceTypeInfo;
import android.health.connect.ReadMedicalResourcesRequest;
import android.health.connect.ReadMedicalResourcesResponse;
import android.health.connect.ReadRecordsRequest;
import android.health.connect.ReadRecordsResponse;
import android.health.connect.RecordIdFilter;
import android.health.connect.RecordTypeInfoResponse;
import android.health.connect.TimeRangeFilter;
import android.health.connect.UpdateDataOriginPriorityOrderRequest;
import android.health.connect.UpsertMedicalResourceRequest;
import android.health.connect.accesslog.AccessLog;
import android.health.connect.accesslog.AccessLogsResponseParcel;
import android.health.connect.aidl.ActivityDatesRequestParcel;
import android.health.connect.aidl.ActivityDatesResponseParcel;
import android.health.connect.aidl.AggregateDataRequestParcel;
import android.health.connect.aidl.AggregateDataResponseParcel;
import android.health.connect.aidl.ApplicationInfoResponseParcel;
import android.health.connect.aidl.DeleteUsingFiltersRequestParcel;
import android.health.connect.aidl.GetPriorityResponseParcel;
import android.health.connect.aidl.HealthConnectExceptionParcel;
import android.health.connect.aidl.IAccessLogsResponseCallback;
import android.health.connect.aidl.IActivityDatesResponseCallback;
import android.health.connect.aidl.IAggregateRecordsResponseCallback;
import android.health.connect.aidl.IApplicationInfoResponseCallback;
import android.health.connect.aidl.ICanRestoreResponseCallback;
import android.health.connect.aidl.IChangeLogsResponseCallback;
import android.health.connect.aidl.IDataStagingFinishedCallback;
import android.health.connect.aidl.IEmptyResponseCallback;
import android.health.connect.aidl.IGetChangeLogTokenCallback;
import android.health.connect.aidl.IGetChangesForBackupResponseCallback;
import android.health.connect.aidl.IGetHealthConnectDataStateCallback;
import android.health.connect.aidl.IGetHealthConnectMigrationUiStateCallback;
import android.health.connect.aidl.IGetLatestMetadataForBackupResponseCallback;
import android.health.connect.aidl.IGetPriorityResponseCallback;
import android.health.connect.aidl.IHealthConnectService;
import android.health.connect.aidl.IInsertRecordsResponseCallback;
import android.health.connect.aidl.IMedicalDataSourceResponseCallback;
import android.health.connect.aidl.IMedicalDataSourcesResponseCallback;
import android.health.connect.aidl.IMedicalResourceListParcelResponseCallback;
import android.health.connect.aidl.IMedicalResourceTypeInfosCallback;
import android.health.connect.aidl.IMedicalResourcesResponseCallback;
import android.health.connect.aidl.IMigrationCallback;
import android.health.connect.aidl.IReadMedicalResourcesResponseCallback;
import android.health.connect.aidl.IReadRecordsResponseCallback;
import android.health.connect.aidl.IRecordTypeInfoResponseCallback;
import android.health.connect.aidl.InsertRecordsResponseParcel;
import android.health.connect.aidl.MedicalResourceListParcel;
import android.health.connect.aidl.ReadRecordsResponseParcel;
import android.health.connect.aidl.RecordIdFiltersParcel;
import android.health.connect.aidl.RecordTypeInfoResponseParcel;
import android.health.connect.aidl.RecordsParcel;
import android.health.connect.aidl.UpdatePriorityRequestParcel;
import android.health.connect.aidl.UpsertMedicalResourceRequestsParcel;
import android.health.connect.backuprestore.BackupMetadata;
import android.health.connect.backuprestore.GetChangesForBackupResponse;
import android.health.connect.backuprestore.GetLatestMetadataForBackupResponse;
import android.health.connect.backuprestore.RestoreChange;
import android.health.connect.changelog.ChangeLogTokenRequest;
import android.health.connect.changelog.ChangeLogTokenResponse;
import android.health.connect.changelog.ChangeLogsRequest;
import android.health.connect.changelog.ChangeLogsResponse;
import android.health.connect.datatypes.DataOrigin;
import android.health.connect.datatypes.MedicalDataSource;
import android.health.connect.datatypes.MedicalResource;
import android.health.connect.datatypes.Record;
import android.health.connect.exportimport.ExportImportDocumentProvider;
import android.health.connect.exportimport.IImportStatusCallback;
import android.health.connect.exportimport.IQueryDocumentProvidersCallback;
import android.health.connect.exportimport.IScheduledExportStatusCallback;
import android.health.connect.exportimport.ImportStatus;
import android.health.connect.exportimport.ScheduledExportSettings;
import android.health.connect.exportimport.ScheduledExportStatus;
import android.health.connect.internal.datatypes.RecordInternal;
import android.health.connect.internal.datatypes.utils.InternalExternalRecordConverter;
import android.health.connect.migration.HealthConnectMigrationUiState;
import android.health.connect.migration.MigrationEntity;
import android.health.connect.migration.MigrationEntityParcel;
import android.health.connect.migration.MigrationException;
import android.health.connect.restore.StageRemoteDataException;
import android.health.connect.restore.StageRemoteDataRequest;
import android.net.Uri;
import android.os.Binder;
import android.os.OutcomeReceiver;
import android.os.ParcelFileDescriptor;
import android.os.RemoteException;
import android.util.Log;
import com.android.healthfitness.flags.Flags;
import com.android.internal.annotations.VisibleForTesting;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.Period;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.stream.Collectors;

public class HealthConnectManager {
    public static final String CATEGORY_HEALTH_PERMISSIONS = "android.intent.category.HEALTH_PERMISSIONS";
    public static final String ACTION_MANAGE_HEALTH_PERMISSIONS = "android.health.connect.action.MANAGE_HEALTH_PERMISSIONS";
    public static final String ACTION_REQUEST_EXERCISE_ROUTE = "android.health.connect.action.REQUEST_EXERCISE_ROUTE";
    public static final String EXTRA_SESSION_ID = "android.health.connect.extra.SESSION_ID";
    public static final String EXTRA_EXERCISE_ROUTE = "android.health.connect.extra.EXERCISE_ROUTE";
    @SystemApi
    public static final String ACTION_REQUEST_HEALTH_PERMISSIONS = "android.health.connect.action.REQUEST_HEALTH_PERMISSIONS";
    @SystemApi
    public static final String ACTION_HEALTH_HOME_SETTINGS = "android.health.connect.action.HEALTH_HOME_SETTINGS";
    @SystemApi
    public static final String ACTION_MANAGE_HEALTH_DATA = "android.health.connect.action.MANAGE_HEALTH_DATA";
    @SystemApi
    public static final String ACTION_SHOW_MIGRATION_INFO = "android.health.connect.action.SHOW_MIGRATION_INFO";
    @SystemApi
    public static final String ACTION_HEALTH_CONNECT_MIGRATION_READY = "android.health.connect.action.HEALTH_CONNECT_MIGRATION_READY";
    @SystemApi
    public static final int DATA_DOWNLOAD_STATE_UNKNOWN = 0;
    @SystemApi
    public static final int DATA_DOWNLOAD_STARTED = 1;
    @SystemApi
    public static final int DATA_DOWNLOAD_RETRY = 2;
    @SystemApi
    public static final int DATA_DOWNLOAD_FAILED = 3;
    @SystemApi
    public static final int DATA_DOWNLOAD_COMPLETE = 4;
    public static final String ACTION_SHOW_ONBOARDING = "android.health.connect.action.SHOW_ONBOARDING";
    private static final String TAG = "HealthConnectManager";
    private static final String HEALTH_PERMISSION_PREFIX = "android.permission.health.";
    @Nullable
    private static volatile Set<String> sHealthPermissions;
    private final Context mContext;
    private final IHealthConnectService mService;
    private final InternalExternalRecordConverter mInternalExternalRecordConverter;

    HealthConnectManager(@NonNull Context context, @NonNull IHealthConnectService service) {
        this.mContext = context;
        this.mService = service;
        this.mInternalExternalRecordConverter = InternalExternalRecordConverter.getInstance();
    }

    @RequiresPermission(value="android.permission.MANAGE_HEALTH_PERMISSIONS")
    public void grantHealthPermission(@NonNull String packageName, @NonNull String permissionName) {
        try {
            this.mService.grantHealthPermission(packageName, permissionName, this.mContext.getUser());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.MANAGE_HEALTH_PERMISSIONS")
    public void revokeHealthPermission(@NonNull String packageName, @NonNull String permissionName, @Nullable String reason) {
        try {
            this.mService.revokeHealthPermission(packageName, permissionName, reason, this.mContext.getUser());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.MANAGE_HEALTH_PERMISSIONS")
    public void revokeAllHealthPermissions(@NonNull String packageName, @Nullable String reason) {
        try {
            this.mService.revokeAllHealthPermissions(packageName, reason, this.mContext.getUser());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.MANAGE_HEALTH_PERMISSIONS")
    public List<String> getGrantedHealthPermissions(@NonNull String packageName) {
        try {
            return this.mService.getGrantedHealthPermissions(packageName, this.mContext.getUser());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.MANAGE_HEALTH_PERMISSIONS")
    public Map<String, Integer> getHealthPermissionsFlags(@NonNull String packageName, @NonNull List<String> permissions) {
        try {
            return this.mService.getHealthPermissionsFlags(packageName, this.mContext.getUser(), permissions);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.MANAGE_HEALTH_PERMISSIONS")
    public void setHealthPermissionsUserFixedFlagValue(@NonNull String packageName, @NonNull List<String> permissions, boolean value) {
        try {
            this.mService.setHealthPermissionsUserFixedFlagValue(packageName, this.mContext.getUser(), permissions, value);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.MANAGE_HEALTH_PERMISSIONS")
    @Nullable
    public Instant getHealthDataHistoricalAccessStartDate(@NonNull String packageName) {
        try {
            long dateMilli = this.mService.getHistoricalAccessStartDateInMilliseconds(packageName, this.mContext.getUser());
            if (dateMilli == -1L) {
                return null;
            }
            return Instant.ofEpochMilli(dateMilli);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public void insertRecords(@NonNull List<Record> records, final @NonNull Executor executor, final @NonNull OutcomeReceiver<InsertRecordsResponse, HealthConnectException> callback) {
        Objects.requireNonNull(records);
        Objects.requireNonNull(executor);
        Objects.requireNonNull(callback);
        try {
            records.forEach(record -> record.getMetadata().setId(""));
            final List<RecordInternal<?>> recordInternals = records.stream().map(record -> record.toRecordInternal().setPackageName(this.mContext.getPackageName())).collect(Collectors.toList());
            this.mService.insertRecords(this.mContext.getAttributionSource(), new RecordsParcel(recordInternals), new IInsertRecordsResponseCallback.Stub(){

                @Override
                public void onResult(InsertRecordsResponseParcel parcel) {
                    Binder.clearCallingIdentity();
                    executor.execute(() -> callback.onResult(new InsertRecordsResponse(HealthConnectManager.this.toExternalRecordsWithUuids(recordInternals, parcel.getUids()))));
                }

                @Override
                public void onError(HealthConnectExceptionParcel exception) {
                    HealthConnectManager.this.returnError(executor, exception, callback);
                }
            });
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public <T> void aggregate(@NonNull AggregateRecordsRequest<T> request, final @NonNull Executor executor, final @NonNull OutcomeReceiver<AggregateRecordsResponse<T>, HealthConnectException> callback) {
        Objects.requireNonNull(request);
        Objects.requireNonNull(executor);
        Objects.requireNonNull(callback);
        try {
            this.mService.aggregateRecords(this.mContext.getAttributionSource(), new AggregateDataRequestParcel(request), new IAggregateRecordsResponseCallback.Stub(){

                @Override
                public void onResult(AggregateDataResponseParcel parcel) {
                    Binder.clearCallingIdentity();
                    try {
                        executor.execute(() -> callback.onResult(parcel.getAggregateDataResponse()));
                    }
                    catch (Exception exception) {
                        callback.onError(new HealthConnectException(2));
                    }
                }

                @Override
                public void onError(HealthConnectExceptionParcel exception) {
                    HealthConnectManager.this.returnError(executor, exception, callback);
                }
            });
        }
        catch (ClassCastException classCastException) {
            this.returnError(executor, new HealthConnectExceptionParcel(new HealthConnectException(2)), callback);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public <T> void aggregateGroupByDuration(@NonNull AggregateRecordsRequest<T> request, @NonNull Duration duration, final @NonNull Executor executor, final @NonNull OutcomeReceiver<List<AggregateRecordsGroupedByDurationResponse<T>>, HealthConnectException> callback) {
        Objects.requireNonNull(request);
        Objects.requireNonNull(duration);
        if (duration.toMillis() < 1L) {
            throw new IllegalArgumentException("Duration should be at least 1 millisecond");
        }
        Objects.requireNonNull(executor);
        Objects.requireNonNull(callback);
        try {
            this.mService.aggregateRecords(this.mContext.getAttributionSource(), new AggregateDataRequestParcel(request, duration), new IAggregateRecordsResponseCallback.Stub(){

                @Override
                public void onResult(AggregateDataResponseParcel parcel) {
                    Binder.clearCallingIdentity();
                    ArrayList result = new ArrayList();
                    for (AggregateRecordsGroupedByDurationResponse<?> aggregateRecordsGroupedByDurationResponse : parcel.getAggregateDataResponseGroupedByDuration()) {
                        result.add(aggregateRecordsGroupedByDurationResponse);
                    }
                    executor.execute(() -> callback.onResult(result));
                }

                @Override
                public void onError(HealthConnectExceptionParcel exception) {
                    HealthConnectManager.this.returnError(executor, exception, callback);
                }
            });
        }
        catch (ClassCastException classCastException) {
            this.returnError(executor, new HealthConnectExceptionParcel(new HealthConnectException(2)), callback);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public <T> void aggregateGroupByPeriod(@NonNull AggregateRecordsRequest<T> request, @NonNull Period period, final @NonNull Executor executor, final @NonNull OutcomeReceiver<List<AggregateRecordsGroupedByPeriodResponse<T>>, HealthConnectException> callback) {
        Objects.requireNonNull(request);
        Objects.requireNonNull(period);
        if (period == Period.ZERO) {
            throw new IllegalArgumentException("Period duration should be at least a day");
        }
        Objects.requireNonNull(executor);
        Objects.requireNonNull(callback);
        try {
            this.mService.aggregateRecords(this.mContext.getAttributionSource(), new AggregateDataRequestParcel(request, period), new IAggregateRecordsResponseCallback.Stub(){

                @Override
                public void onResult(AggregateDataResponseParcel parcel) {
                    Binder.clearCallingIdentity();
                    ArrayList result = new ArrayList();
                    for (AggregateRecordsGroupedByPeriodResponse<?> aggregateRecordsGroupedByPeriodResponse : parcel.getAggregateDataResponseGroupedByPeriod()) {
                        result.add(aggregateRecordsGroupedByPeriodResponse);
                    }
                    executor.execute(() -> callback.onResult(result));
                }

                @Override
                public void onError(HealthConnectExceptionParcel exception) {
                    HealthConnectManager.this.returnError(executor, exception, callback);
                }
            });
        }
        catch (ClassCastException classCastException) {
            this.returnError(executor, new HealthConnectExceptionParcel(new HealthConnectException(2)), callback);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @SystemApi
    @RequiresPermission(value="android.permission.MANAGE_HEALTH_PERMISSIONS")
    public void deleteRecords(@NonNull DeleteUsingFiltersRequest request, final @NonNull Executor executor, final @NonNull OutcomeReceiver<Void, HealthConnectException> callback) {
        Objects.requireNonNull(request);
        Objects.requireNonNull(executor);
        Objects.requireNonNull(callback);
        try {
            this.mService.deleteUsingFilters(this.mContext.getAttributionSource(), new DeleteUsingFiltersRequestParcel(request), new IEmptyResponseCallback.Stub(){

                @Override
                public void onResult() {
                    executor.execute(() -> callback.onResult(null));
                }

                @Override
                public void onError(HealthConnectExceptionParcel exception) {
                    HealthConnectManager.this.returnError(executor, exception, callback);
                }
            });
        }
        catch (RemoteException remoteException) {
            remoteException.rethrowFromSystemServer();
        }
    }

    public void deleteRecords(@NonNull List<RecordIdFilter> recordIds, final @NonNull Executor executor, final @NonNull OutcomeReceiver<Void, HealthConnectException> callback) {
        Objects.requireNonNull(recordIds);
        Objects.requireNonNull(executor);
        Objects.requireNonNull(callback);
        if (recordIds.isEmpty()) {
            throw new IllegalArgumentException("record ids can't be empty");
        }
        try {
            this.mService.deleteUsingFilters(this.mContext.getAttributionSource(), new DeleteUsingFiltersRequestParcel(new RecordIdFiltersParcel(recordIds), this.mContext.getPackageName()), new IEmptyResponseCallback.Stub(){

                @Override
                public void onResult() {
                    executor.execute(() -> callback.onResult(null));
                }

                @Override
                public void onError(HealthConnectExceptionParcel exception) {
                    HealthConnectManager.this.returnError(executor, exception, callback);
                }
            });
        }
        catch (RemoteException remoteException) {
            remoteException.rethrowFromSystemServer();
        }
    }

    public void deleteRecords(@NonNull Class<? extends Record> recordType, @NonNull TimeRangeFilter timeRangeFilter, final @NonNull Executor executor, final @NonNull OutcomeReceiver<Void, HealthConnectException> callback) {
        Objects.requireNonNull(recordType);
        Objects.requireNonNull(timeRangeFilter);
        Objects.requireNonNull(executor);
        Objects.requireNonNull(callback);
        try {
            this.mService.deleteUsingFilters(this.mContext.getAttributionSource(), new DeleteUsingFiltersRequestParcel(new DeleteUsingFiltersRequest.Builder().addDataOrigin(new DataOrigin.Builder().setPackageName(this.mContext.getPackageName()).build()).addRecordType(recordType).setTimeRangeFilter(timeRangeFilter).build()), new IEmptyResponseCallback.Stub(){

                @Override
                public void onResult() {
                    executor.execute(() -> callback.onResult(null));
                }

                @Override
                public void onError(HealthConnectExceptionParcel exception) {
                    HealthConnectManager.this.returnError(executor, exception, callback);
                }
            });
        }
        catch (RemoteException remoteException) {
            remoteException.rethrowFromSystemServer();
        }
    }

    public void getChangeLogs(@NonNull ChangeLogsRequest changeLogsRequest, final @NonNull Executor executor, final @NonNull OutcomeReceiver<ChangeLogsResponse, HealthConnectException> callback) {
        Objects.requireNonNull(changeLogsRequest);
        Objects.requireNonNull(executor);
        Objects.requireNonNull(callback);
        try {
            this.mService.getChangeLogs(this.mContext.getAttributionSource(), changeLogsRequest, new IChangeLogsResponseCallback.Stub(){

                @Override
                public void onResult(ChangeLogsResponse parcel) {
                    Binder.clearCallingIdentity();
                    executor.execute(() -> callback.onResult(parcel));
                }

                @Override
                public void onError(HealthConnectExceptionParcel exception) {
                    HealthConnectManager.this.returnError(executor, exception, callback);
                }
            });
        }
        catch (ClassCastException invalidArgumentException) {
            callback.onError(new HealthConnectException(3, invalidArgumentException.getMessage()));
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public void getChangeLogToken(@NonNull ChangeLogTokenRequest request, final @NonNull Executor executor, final @NonNull OutcomeReceiver<ChangeLogTokenResponse, HealthConnectException> callback) {
        try {
            this.mService.getChangeLogToken(this.mContext.getAttributionSource(), request, new IGetChangeLogTokenCallback.Stub(){

                @Override
                public void onResult(ChangeLogTokenResponse parcel) {
                    Binder.clearCallingIdentity();
                    executor.execute(() -> callback.onResult(parcel));
                }

                @Override
                public void onError(HealthConnectExceptionParcel exception) {
                    HealthConnectManager.this.returnError(executor, exception, callback);
                }
            });
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @SystemApi
    @RequiresPermission(value="android.permission.MANAGE_HEALTH_DATA")
    public void fetchDataOriginsPriorityOrder(int dataCategory, final @NonNull Executor executor, final @NonNull OutcomeReceiver<FetchDataOriginsPriorityOrderResponse, HealthConnectException> callback) {
        try {
            this.mService.getCurrentPriority(dataCategory, new IGetPriorityResponseCallback.Stub(){

                @Override
                public void onResult(GetPriorityResponseParcel response) {
                    Binder.clearCallingIdentity();
                    executor.execute(() -> callback.onResult(response.getPriorityResponse()));
                }

                @Override
                public void onError(HealthConnectExceptionParcel exception) {
                    HealthConnectManager.this.returnError(executor, exception, callback);
                }
            });
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @SystemApi
    @RequiresPermission(value="android.permission.MANAGE_HEALTH_DATA")
    public void updateDataOriginPriorityOrder(@NonNull UpdateDataOriginPriorityOrderRequest request, final @NonNull Executor executor, final @NonNull OutcomeReceiver<Void, HealthConnectException> callback) {
        try {
            this.mService.updatePriority(new UpdatePriorityRequestParcel(request), new IEmptyResponseCallback.Stub(){

                @Override
                public void onResult() {
                    Binder.clearCallingIdentity();
                    executor.execute(() -> callback.onResult(null));
                }

                @Override
                public void onError(HealthConnectExceptionParcel exception) {
                    HealthConnectManager.this.returnError(executor, exception, callback);
                }
            });
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @SystemApi
    @RequiresPermission(value="android.permission.MANAGE_HEALTH_DATA")
    public void queryAllRecordTypesInfo(final @NonNull Executor executor, final @NonNull OutcomeReceiver<Map<Class<? extends Record>, RecordTypeInfoResponse>, HealthConnectException> callback) {
        Objects.requireNonNull(executor);
        Objects.requireNonNull(callback);
        try {
            this.mService.queryAllRecordTypesInfo(new IRecordTypeInfoResponseCallback.Stub(){

                @Override
                public void onResult(RecordTypeInfoResponseParcel parcel) {
                    Binder.clearCallingIdentity();
                    executor.execute(() -> callback.onResult(parcel.getRecordTypeInfoResponses()));
                }

                @Override
                public void onError(HealthConnectExceptionParcel exception) {
                    HealthConnectManager.this.returnError(executor, exception, callback);
                }
            });
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @SystemApi
    @RequiresPermission(value="android.permission.MANAGE_HEALTH_DATA")
    public int getRecordRetentionPeriodInDays() {
        try {
            return this.mService.getRecordRetentionPeriodInDays(this.mContext.getUser());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @SystemApi
    @RequiresPermission(value="android.permission.MANAGE_HEALTH_DATA")
    public void setRecordRetentionPeriodInDays(int days, final @NonNull Executor executor, final @NonNull OutcomeReceiver<Void, HealthConnectException> callback) {
        Objects.requireNonNull(executor);
        Objects.requireNonNull(callback);
        if (days < 0 || days > 7300) {
            throw new IllegalArgumentException("days should be between 0 and 7300");
        }
        try {
            this.mService.setRecordRetentionPeriodInDays(days, this.mContext.getUser(), new IEmptyResponseCallback.Stub(){

                @Override
                public void onResult() {
                    Binder.clearCallingIdentity();
                    executor.execute(() -> callback.onResult(null));
                }

                @Override
                public void onError(HealthConnectExceptionParcel exception) {
                    HealthConnectManager.this.returnError(executor, exception, callback);
                }
            });
        }
        catch (RemoteException e) {
            e.rethrowFromSystemServer();
        }
    }

    @SystemApi
    @RequiresPermission(value="android.permission.MANAGE_HEALTH_DATA")
    public void queryAccessLogs(final @NonNull Executor executor, final @NonNull OutcomeReceiver<List<AccessLog>, HealthConnectException> callback) {
        Objects.requireNonNull(executor);
        Objects.requireNonNull(callback);
        try {
            this.mService.queryAccessLogs(this.mContext.getPackageName(), new IAccessLogsResponseCallback.Stub(){

                @Override
                public void onResult(AccessLogsResponseParcel parcel) {
                    Binder.clearCallingIdentity();
                    executor.execute(() -> callback.onResult(parcel.getAccessLogs()));
                }

                @Override
                public void onError(HealthConnectExceptionParcel exception) {
                    HealthConnectManager.this.returnError(executor, exception, callback);
                }
            });
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public <T extends Record> void readRecords(@NonNull ReadRecordsRequest<T> request, @NonNull Executor executor, @NonNull OutcomeReceiver<ReadRecordsResponse<T>, HealthConnectException> callback) {
        Objects.requireNonNull(request);
        Objects.requireNonNull(executor);
        Objects.requireNonNull(callback);
        try {
            this.mService.readRecords(this.mContext.getAttributionSource(), request.toReadRecordsRequestParcel(), this.getReadCallback(executor, callback));
        }
        catch (RemoteException remoteException) {
            remoteException.rethrowFromSystemServer();
        }
    }

    public void updateRecords(@NonNull List<Record> records, final @NonNull Executor executor, final @NonNull OutcomeReceiver<Void, HealthConnectException> callback) {
        Objects.requireNonNull(records);
        Objects.requireNonNull(executor);
        Objects.requireNonNull(callback);
        try {
            List<RecordInternal<?>> recordInternals = records.stream().map(Record::toRecordInternal).collect(Collectors.toList());
            for (RecordInternal recordInternal : recordInternals) {
                if (recordInternal.getClientRecordId() != null && !recordInternal.getClientRecordId().isEmpty() || recordInternal.getUuid() != null) continue;
                throw new IllegalArgumentException("At least one of the records is missing both ClientRecordID and UUID. RecordType of the input: " + recordInternal.getRecordType());
            }
            this.mService.updateRecords(this.mContext.getAttributionSource(), new RecordsParcel(recordInternals), new IEmptyResponseCallback.Stub(this){

                @Override
                public void onResult() {
                    Binder.clearCallingIdentity();
                    executor.execute(() -> callback.onResult(null));
                }

                @Override
                public void onError(HealthConnectExceptionParcel exception) {
                    Binder.clearCallingIdentity();
                    callback.onError(exception.getHealthConnectException());
                }
            });
        }
        catch (ArithmeticException | ClassCastException | IllegalArgumentException invalidArgumentException) {
            throw new IllegalArgumentException(invalidArgumentException);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @SystemApi
    @RequiresPermission(value="android.permission.MANAGE_HEALTH_DATA")
    public void getContributorApplicationsInfo(final @NonNull Executor executor, final @NonNull OutcomeReceiver<ApplicationInfoResponse, HealthConnectException> callback) {
        Objects.requireNonNull(executor);
        Objects.requireNonNull(callback);
        try {
            this.mService.getContributorApplicationsInfo(new IApplicationInfoResponseCallback.Stub(){

                @Override
                public void onResult(ApplicationInfoResponseParcel parcel) {
                    Binder.clearCallingIdentity();
                    executor.execute(() -> callback.onResult(new ApplicationInfoResponse(parcel.getAppInfoList())));
                }

                @Override
                public void onError(HealthConnectExceptionParcel exception) {
                    HealthConnectManager.this.returnError(executor, exception, callback);
                }
            });
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @SystemApi
    @RequiresPermission(value="android.permission.STAGE_HEALTH_CONNECT_REMOTE_DATA")
    public void stageAllHealthConnectRemoteData(@NonNull Map<String, ParcelFileDescriptor> pfdsByFileName, final @NonNull Executor executor, final @NonNull OutcomeReceiver<Void, StageRemoteDataException> callback) throws NullPointerException {
        Objects.requireNonNull(pfdsByFileName);
        Objects.requireNonNull(executor);
        Objects.requireNonNull(callback);
        try {
            this.mService.stageAllHealthConnectRemoteData(new StageRemoteDataRequest(pfdsByFileName), this.mContext.getUser(), new IDataStagingFinishedCallback.Stub(this){

                @Override
                public void onResult() {
                    Binder.clearCallingIdentity();
                    executor.execute(() -> callback.onResult(null));
                }

                @Override
                public void onError(StageRemoteDataException stageRemoteDataException) {
                    Binder.clearCallingIdentity();
                    executor.execute(() -> callback.onError(stageRemoteDataException));
                }
            });
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public void getAllDataForBackup(@NonNull Map<String, ParcelFileDescriptor> pfdsByFileName) {
        Objects.requireNonNull(pfdsByFileName);
        try {
            this.mService.getAllDataForBackup(new StageRemoteDataRequest(pfdsByFileName), this.mContext.getUser());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public Set<String> getAllBackupFileNames(boolean forDeviceToDevice) {
        try {
            return this.mService.getAllBackupFileNames(forDeviceToDevice).getFileNames();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public void deleteAllStagedRemoteData() throws NullPointerException {
        try {
            this.mService.deleteAllStagedRemoteData(this.mContext.getUser());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public void setLowerRateLimitsForTesting(boolean enabled) throws NullPointerException {
        try {
            this.mService.setLowerRateLimitsForTesting(enabled);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @SystemApi
    @RequiresPermission(value="android.permission.STAGE_HEALTH_CONNECT_REMOTE_DATA")
    public void updateDataDownloadState(int downloadState) {
        try {
            this.mService.updateDataDownloadState(downloadState);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.MANAGE_HEALTH_DATA")
    public void getHealthConnectMigrationUiState(final @NonNull Executor executor, final @NonNull OutcomeReceiver<HealthConnectMigrationUiState, HealthConnectException> callback) {
        Objects.requireNonNull(executor);
        Objects.requireNonNull(callback);
        try {
            this.mService.getHealthConnectMigrationUiState(new IGetHealthConnectMigrationUiStateCallback.Stub(this){

                @Override
                public void onResult(HealthConnectMigrationUiState migrationUiState) {
                    Binder.clearCallingIdentity();
                    executor.execute(() -> callback.onResult(migrationUiState));
                }

                @Override
                public void onError(HealthConnectExceptionParcel exception) {
                    Binder.clearCallingIdentity();
                    executor.execute(() -> callback.onError(exception.getHealthConnectException()));
                }
            });
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @SystemApi
    @RequiresPermission(anyOf={"android.permission.MANAGE_HEALTH_DATA", "android.permission.MIGRATE_HEALTH_CONNECT_DATA"})
    public void getHealthConnectDataState(final @NonNull Executor executor, final @NonNull OutcomeReceiver<HealthConnectDataState, HealthConnectException> callback) {
        Objects.requireNonNull(executor);
        Objects.requireNonNull(callback);
        try {
            this.mService.getHealthConnectDataState(new IGetHealthConnectDataStateCallback.Stub(this){

                @Override
                public void onResult(HealthConnectDataState healthConnectDataState) {
                    Binder.clearCallingIdentity();
                    executor.execute(() -> callback.onResult(healthConnectDataState));
                }

                @Override
                public void onError(HealthConnectExceptionParcel exception) {
                    Binder.clearCallingIdentity();
                    executor.execute(() -> callback.onError(exception.getHealthConnectException()));
                }
            });
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @SystemApi
    @RequiresPermission(value="android.permission.MANAGE_HEALTH_DATA")
    public void queryActivityDates(@NonNull List<Class<? extends Record>> recordTypes, final @NonNull Executor executor, final @NonNull OutcomeReceiver<List<LocalDate>, HealthConnectException> callback) {
        Objects.requireNonNull(executor);
        Objects.requireNonNull(callback);
        Objects.requireNonNull(recordTypes);
        if (recordTypes.isEmpty()) {
            throw new IllegalArgumentException("Record types list can not be empty");
        }
        try {
            this.mService.getActivityDates(new ActivityDatesRequestParcel(recordTypes), new IActivityDatesResponseCallback.Stub(){

                @Override
                public void onResult(ActivityDatesResponseParcel parcel) {
                    Binder.clearCallingIdentity();
                    executor.execute(() -> callback.onResult(parcel.getDates()));
                }

                @Override
                public void onError(HealthConnectExceptionParcel exception) {
                    HealthConnectManager.this.returnError(executor, exception, callback);
                }
            });
        }
        catch (RemoteException exception) {
            exception.rethrowFromSystemServer();
        }
    }

    @SystemApi
    @RequiresPermission(value="android.permission.MIGRATE_HEALTH_CONNECT_DATA")
    public void startMigration(@NonNull Executor executor, @NonNull OutcomeReceiver<Void, MigrationException> callback) {
        Objects.requireNonNull(executor);
        Objects.requireNonNull(callback);
        try {
            this.mService.startMigration(this.mContext.getPackageName(), HealthConnectManager.wrapMigrationCallback(executor, callback));
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @SystemApi
    @RequiresPermission(value="android.permission.MIGRATE_HEALTH_CONNECT_DATA")
    public void finishMigration(@NonNull Executor executor, @NonNull OutcomeReceiver<Void, MigrationException> callback) {
        Objects.requireNonNull(executor);
        Objects.requireNonNull(callback);
        try {
            this.mService.finishMigration(this.mContext.getPackageName(), HealthConnectManager.wrapMigrationCallback(executor, callback));
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @SystemApi
    @RequiresPermission(value="android.permission.MIGRATE_HEALTH_CONNECT_DATA")
    public void writeMigrationData(@NonNull List<MigrationEntity> entities, @NonNull Executor executor, @NonNull OutcomeReceiver<Void, MigrationException> callback) {
        Objects.requireNonNull(entities);
        Objects.requireNonNull(executor);
        Objects.requireNonNull(callback);
        try {
            this.mService.writeMigrationData(this.mContext.getPackageName(), new MigrationEntityParcel(entities), HealthConnectManager.wrapMigrationCallback(executor, callback));
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @SystemApi
    @RequiresPermission(value="android.permission.MIGRATE_HEALTH_CONNECT_DATA")
    public void insertMinDataMigrationSdkExtensionVersion(int requiredSdkExtension, @NonNull Executor executor, @NonNull OutcomeReceiver<Void, MigrationException> callback) {
        Objects.requireNonNull(executor);
        Objects.requireNonNull(callback);
        try {
            this.mService.insertMinDataMigrationSdkExtensionVersion(this.mContext.getPackageName(), requiredSdkExtension, HealthConnectManager.wrapMigrationCallback(executor, callback));
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.MANAGE_HEALTH_DATA")
    public void configureScheduledExport(@Nullable ScheduledExportSettings settings) {
        try {
            this.mService.configureScheduledExport(settings, this.mContext.getUser());
        }
        catch (RemoteException e) {
            e.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.MANAGE_HEALTH_DATA")
    public void getScheduledExportStatus(final @NonNull Executor executor, final @NonNull OutcomeReceiver<ScheduledExportStatus, HealthConnectException> callback) {
        Objects.requireNonNull(executor);
        Objects.requireNonNull(callback);
        try {
            this.mService.getScheduledExportStatus(this.mContext.getUser(), new IScheduledExportStatusCallback.Stub(){

                @Override
                public void onResult(ScheduledExportStatus status) {
                    Binder.clearCallingIdentity();
                    executor.execute(() -> callback.onResult(status));
                }

                @Override
                public void onError(HealthConnectExceptionParcel exception) {
                    HealthConnectManager.this.returnError(executor, exception, callback);
                }
            });
        }
        catch (RemoteException e) {
            e.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.MANAGE_HEALTH_DATA")
    public void getImportStatus(final @NonNull Executor executor, final @NonNull OutcomeReceiver<ImportStatus, HealthConnectException> callback) {
        Objects.requireNonNull(executor);
        Objects.requireNonNull(callback);
        try {
            this.mService.getImportStatus(this.mContext.getUser(), new IImportStatusCallback.Stub(){

                @Override
                public void onResult(ImportStatus status) {
                    Binder.clearCallingIdentity();
                    executor.execute(() -> callback.onResult(status));
                }

                @Override
                public void onError(HealthConnectExceptionParcel exception) {
                    HealthConnectManager.this.returnError(executor, exception, callback);
                }
            });
        }
        catch (RemoteException e) {
            e.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.MANAGE_HEALTH_DATA")
    public void runImport(@NonNull Uri file, final @NonNull Executor executor, final @NonNull OutcomeReceiver<Void, HealthConnectException> callback) {
        Objects.requireNonNull(file);
        Objects.requireNonNull(executor);
        Objects.requireNonNull(callback);
        try {
            this.mService.runImport(this.mContext.getUser(), file, new IEmptyResponseCallback.Stub(){

                @Override
                public void onResult() {
                    Binder.clearCallingIdentity();
                    executor.execute(() -> callback.onResult(null));
                }

                @Override
                public void onError(HealthConnectExceptionParcel exception) {
                    HealthConnectManager.this.returnError(executor, exception, callback);
                }
            });
        }
        catch (RemoteException e) {
            e.rethrowFromSystemServer();
        }
    }

    @FlaggedApi(value="com.android.healthfitness.flags.immediate_export")
    @RequiresPermission(value="android.permission.MANAGE_HEALTH_DATA")
    public void runImmediateExport(@NonNull Uri file, final @NonNull Executor executor, final @NonNull OutcomeReceiver<Void, HealthConnectException> callback) {
        Objects.requireNonNull(file);
        Objects.requireNonNull(executor);
        Objects.requireNonNull(callback);
        try {
            this.mService.runImmediateExport(file, new IEmptyResponseCallback.Stub(){

                @Override
                public void onResult() {
                    Binder.clearCallingIdentity();
                    executor.execute(() -> callback.onResult(null));
                }

                @Override
                public void onError(HealthConnectExceptionParcel exception) {
                    HealthConnectManager.this.returnError(executor, exception, callback);
                }
            });
        }
        catch (RemoteException e) {
            e.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.MANAGE_HEALTH_DATA")
    public int getScheduledExportPeriodInDays() {
        try {
            return this.mService.getScheduledExportPeriodInDays(this.mContext.getUser());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.MANAGE_HEALTH_DATA")
    public void queryDocumentProviders(final @NonNull Executor executor, final @NonNull OutcomeReceiver<List<ExportImportDocumentProvider>, HealthConnectException> callback) {
        Objects.requireNonNull(executor);
        Objects.requireNonNull(callback);
        try {
            this.mService.queryDocumentProviders(this.mContext.getUser(), new IQueryDocumentProvidersCallback.Stub(){

                @Override
                public void onResult(List<ExportImportDocumentProvider> providers) {
                    Binder.clearCallingIdentity();
                    executor.execute(() -> callback.onResult(providers));
                }

                @Override
                public void onError(HealthConnectExceptionParcel exception) {
                    HealthConnectManager.this.returnError(executor, exception, callback);
                }
            });
        }
        catch (RemoteException e) {
            e.rethrowFromSystemServer();
        }
    }

    private <T extends Record> IReadRecordsResponseCallback.Stub getReadCallback(final @NonNull Executor executor, final @NonNull OutcomeReceiver<ReadRecordsResponse<T>, HealthConnectException> callback) {
        return new IReadRecordsResponseCallback.Stub(){

            @Override
            public void onResult(ReadRecordsResponseParcel parcel) {
                Binder.clearCallingIdentity();
                try {
                    List<Record> externalRecords = HealthConnectManager.this.mInternalExternalRecordConverter.getExternalRecords(parcel.getRecordsParcel().getRecords());
                    executor.execute(() -> callback.onResult(new ReadRecordsResponse(externalRecords, parcel.getPageToken())));
                }
                catch (ClassCastException castException) {
                    HealthConnectException healthConnectException = new HealthConnectException(2, castException.getMessage());
                    HealthConnectManager.this.returnError(executor, new HealthConnectExceptionParcel(healthConnectException), callback);
                }
            }

            @Override
            public void onError(HealthConnectExceptionParcel exception) {
                HealthConnectManager.this.returnError(executor, exception, callback);
            }
        };
    }

    private List<Record> toExternalRecordsWithUuids(List<RecordInternal<?>> recordInternals, List<String> uuids) {
        int i = 0;
        ArrayList<Record> records = new ArrayList<Record>();
        for (RecordInternal<?> recordInternal : recordInternals) {
            recordInternal.setUuid(uuids.get(i++));
            records.add((Record)recordInternal.toExternalRecord());
        }
        return records;
    }

    private static <RES, ERR extends Throwable> void returnResult(Executor executor, @Nullable RES result, OutcomeReceiver<RES, ERR> callback) {
        Binder.clearCallingIdentity();
        executor.execute(() -> callback.onResult(result));
    }

    private void returnError(Executor executor, HealthConnectExceptionParcel exception, OutcomeReceiver<?, HealthConnectException> callback) {
        Binder.clearCallingIdentity();
        executor.execute(() -> callback.onError(exception.getHealthConnectException()));
    }

    @SystemApi
    public static boolean isHealthPermission(@NonNull Context context, @NonNull String permission2) {
        if (!permission2.startsWith(HEALTH_PERMISSION_PREFIX)) {
            return false;
        }
        return HealthConnectManager.getHealthPermissions(context).contains(permission2);
    }

    @SystemApi
    @NonNull
    public static Set<String> getHealthPermissions(@NonNull Context context) {
        PackageInfo packageInfo;
        if (sHealthPermissions != null) {
            return sHealthPermissions;
        }
        try {
            PackageManager pm = context.getApplicationContext().getPackageManager();
            PermissionGroupInfo permGroupInfo = pm.getPermissionGroupInfo("android.permission-group.HEALTH", 0);
            packageInfo = pm.getPackageInfo(permGroupInfo.packageName, PackageManager.PackageInfoFlags.of(4096L));
        }
        catch (PackageManager.NameNotFoundException ex) {
            Log.e(TAG, "Health permission group or HC package not found", ex);
            Set<String> result = Collections.emptySet();
            sHealthPermissions = result;
            return result;
        }
        HashSet<String> permissions = new HashSet<String>();
        Object result = packageInfo.permissions;
        int n = ((PermissionInfo[])result).length;
        for (int i = 0; i < n; ++i) {
            PermissionInfo perm = result[i];
            if (!HealthPermissions.isValidHealthPermission(perm)) continue;
            permissions.add(perm.name);
        }
        sHealthPermissions = result = Collections.unmodifiableSet(permissions);
        return result;
    }

    @VisibleForTesting
    public static void resetHealthPermissionsCache() {
        sHealthPermissions = null;
    }

    @NonNull
    private static IMigrationCallback wrapMigrationCallback(final @NonNull Executor executor, final @NonNull OutcomeReceiver<Void, MigrationException> callback) {
        return new IMigrationCallback.Stub(){

            @Override
            public void onSuccess() {
                Binder.clearCallingIdentity();
                executor.execute(() -> callback.onResult(null));
            }

            @Override
            public void onError(MigrationException exception) {
                Binder.clearCallingIdentity();
                executor.execute(() -> callback.onError(exception));
            }
        };
    }

    @FlaggedApi(value="com.android.healthfitness.flags.personal_health_record")
    @RequiresPermission(value="android.permission.health.WRITE_MEDICAL_DATA")
    public void upsertMedicalResources(@NonNull List<UpsertMedicalResourceRequest> requests, final @NonNull Executor executor, final @NonNull OutcomeReceiver<List<MedicalResource>, HealthConnectException> callback) {
        Objects.requireNonNull(requests);
        Objects.requireNonNull(executor);
        Objects.requireNonNull(callback);
        if (requests.isEmpty()) {
            HealthConnectManager.returnResult(executor, List.of(), callback);
            return;
        }
        try {
            if (Flags.phrUpsertFixUseSharedMemory()) {
                this.mService.upsertMedicalResourcesFromRequestsParcel(this.mContext.getAttributionSource(), new UpsertMedicalResourceRequestsParcel(requests), new IMedicalResourceListParcelResponseCallback.Stub(){

                    @Override
                    public void onResult(MedicalResourceListParcel medicalResourceListParcel) {
                        HealthConnectManager.returnResult(executor, medicalResourceListParcel.getMedicalResources(), callback);
                    }

                    @Override
                    public void onError(HealthConnectExceptionParcel exception) {
                        HealthConnectManager.this.returnError(executor, exception, callback);
                    }
                });
            } else {
                this.mService.upsertMedicalResources(this.mContext.getAttributionSource(), requests, new IMedicalResourcesResponseCallback.Stub(){

                    @Override
                    public void onResult(List<MedicalResource> medicalResources) {
                        HealthConnectManager.returnResult(executor, medicalResources, callback);
                    }

                    @Override
                    public void onError(HealthConnectExceptionParcel exception) {
                        HealthConnectManager.this.returnError(executor, exception, callback);
                    }
                });
            }
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @FlaggedApi(value="com.android.healthfitness.flags.personal_health_record")
    public void readMedicalResources(@NonNull List<MedicalResourceId> ids, final @NonNull Executor executor, final @NonNull OutcomeReceiver<List<MedicalResource>, HealthConnectException> callback) {
        Objects.requireNonNull(ids);
        Objects.requireNonNull(executor);
        Objects.requireNonNull(callback);
        if (ids.isEmpty()) {
            HealthConnectManager.returnResult(executor, List.of(), callback);
            return;
        }
        if (ids.size() > 5000) {
            throw new IllegalArgumentException("The number of requested IDs must be <= 5000");
        }
        try {
            this.mService.readMedicalResourcesByIds(this.mContext.getAttributionSource(), ids, new IReadMedicalResourcesResponseCallback.Stub(){

                @Override
                public void onResult(ReadMedicalResourcesResponse response) {
                    HealthConnectManager.returnResult(executor, response.getMedicalResources(), callback);
                }

                @Override
                public void onError(HealthConnectExceptionParcel exception) {
                    HealthConnectManager.this.returnError(executor, exception, callback);
                }
            });
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @FlaggedApi(value="com.android.healthfitness.flags.personal_health_record")
    public void readMedicalResources(@NonNull ReadMedicalResourcesRequest request, final @NonNull Executor executor, final @NonNull OutcomeReceiver<ReadMedicalResourcesResponse, HealthConnectException> callback) {
        Objects.requireNonNull(request);
        Objects.requireNonNull(executor);
        Objects.requireNonNull(callback);
        try {
            this.mService.readMedicalResourcesByRequest(this.mContext.getAttributionSource(), request.toParcel(), new IReadMedicalResourcesResponseCallback.Stub(){

                @Override
                public void onResult(ReadMedicalResourcesResponse response) {
                    HealthConnectManager.returnResult(executor, response, callback);
                }

                @Override
                public void onError(HealthConnectExceptionParcel exception) {
                    HealthConnectManager.this.returnError(executor, exception, callback);
                }
            });
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @FlaggedApi(value="com.android.healthfitness.flags.personal_health_record")
    @RequiresPermission(anyOf={"android.permission.health.WRITE_MEDICAL_DATA", "android.permission.MANAGE_HEALTH_DATA"})
    public void deleteMedicalResources(@NonNull DeleteMedicalResourcesRequest request, final @NonNull Executor executor, final @NonNull OutcomeReceiver<Void, HealthConnectException> callback) {
        Objects.requireNonNull(request);
        Objects.requireNonNull(executor);
        Objects.requireNonNull(callback);
        try {
            this.mService.deleteMedicalResourcesByRequest(this.mContext.getAttributionSource(), request, new IEmptyResponseCallback.Stub(){

                @Override
                public void onResult() {
                    HealthConnectManager.returnResult(executor, null, callback);
                }

                @Override
                public void onError(HealthConnectExceptionParcel exception) {
                    HealthConnectManager.this.returnError(executor, exception, callback);
                }
            });
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @FlaggedApi(value="com.android.healthfitness.flags.personal_health_record")
    @RequiresPermission(anyOf={"android.permission.health.WRITE_MEDICAL_DATA", "android.permission.MANAGE_HEALTH_DATA"})
    public void deleteMedicalResources(@NonNull List<MedicalResourceId> ids, final @NonNull Executor executor, final @NonNull OutcomeReceiver<Void, HealthConnectException> callback) {
        Objects.requireNonNull(ids);
        Objects.requireNonNull(executor);
        Objects.requireNonNull(callback);
        if (ids.isEmpty()) {
            HealthConnectManager.returnResult(executor, null, callback);
            return;
        }
        try {
            this.mService.deleteMedicalResourcesByIds(this.mContext.getAttributionSource(), ids, new IEmptyResponseCallback.Stub(){

                @Override
                public void onResult() {
                    HealthConnectManager.returnResult(executor, null, callback);
                }

                @Override
                public void onError(HealthConnectExceptionParcel exception) {
                    HealthConnectManager.this.returnError(executor, exception, callback);
                }
            });
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @SystemApi
    @FlaggedApi(value="com.android.healthfitness.flags.personal_health_record")
    @RequiresPermission(value="android.permission.MANAGE_HEALTH_DATA")
    public void queryAllMedicalResourceTypeInfos(final @NonNull Executor executor, final @NonNull OutcomeReceiver<List<MedicalResourceTypeInfo>, HealthConnectException> callback) {
        Objects.requireNonNull(executor);
        Objects.requireNonNull(callback);
        try {
            this.mService.queryAllMedicalResourceTypeInfos(new IMedicalResourceTypeInfosCallback.Stub(){

                @Override
                public void onResult(List<MedicalResourceTypeInfo> response) {
                    Binder.clearCallingIdentity();
                    executor.execute(() -> callback.onResult(response));
                }

                @Override
                public void onError(HealthConnectExceptionParcel exception) {
                    HealthConnectManager.this.returnError(executor, exception, callback);
                }
            });
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @FlaggedApi(value="com.android.healthfitness.flags.personal_health_record")
    @RequiresPermission(value="android.permission.health.WRITE_MEDICAL_DATA")
    public void createMedicalDataSource(@NonNull CreateMedicalDataSourceRequest request, final @NonNull Executor executor, final @NonNull OutcomeReceiver<MedicalDataSource, HealthConnectException> callback) {
        Objects.requireNonNull(request);
        Objects.requireNonNull(executor);
        Objects.requireNonNull(callback);
        try {
            this.mService.createMedicalDataSource(this.mContext.getAttributionSource(), request, new IMedicalDataSourceResponseCallback.Stub(){

                @Override
                public void onResult(MedicalDataSource dataSource) {
                    HealthConnectManager.returnResult(executor, dataSource, callback);
                }

                @Override
                public void onError(HealthConnectExceptionParcel exception) {
                    HealthConnectManager.this.returnError(executor, exception, callback);
                }
            });
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @FlaggedApi(value="com.android.healthfitness.flags.personal_health_record")
    public void getMedicalDataSources(@NonNull List<String> ids, final @NonNull Executor executor, final @NonNull OutcomeReceiver<List<MedicalDataSource>, HealthConnectException> callback) {
        Objects.requireNonNull(ids);
        Objects.requireNonNull(executor);
        Objects.requireNonNull(callback);
        if (ids.isEmpty()) {
            HealthConnectManager.returnResult(executor, List.of(), callback);
            return;
        }
        if (ids.size() > 5000) {
            throw new IllegalArgumentException("The number of requested IDs must be <= 5000");
        }
        try {
            this.mService.getMedicalDataSourcesByIds(this.mContext.getAttributionSource(), ids, new IMedicalDataSourcesResponseCallback.Stub(){

                @Override
                public void onResult(List<MedicalDataSource> result) {
                    HealthConnectManager.returnResult(executor, result, callback);
                }

                @Override
                public void onError(HealthConnectExceptionParcel exception) {
                    HealthConnectManager.this.returnError(executor, exception, callback);
                }
            });
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @FlaggedApi(value="com.android.healthfitness.flags.personal_health_record")
    public void getMedicalDataSources(@NonNull GetMedicalDataSourcesRequest request, final @NonNull Executor executor, final @NonNull OutcomeReceiver<List<MedicalDataSource>, HealthConnectException> callback) {
        Objects.requireNonNull(request);
        Objects.requireNonNull(executor);
        Objects.requireNonNull(callback);
        try {
            this.mService.getMedicalDataSourcesByRequest(this.mContext.getAttributionSource(), request, new IMedicalDataSourcesResponseCallback.Stub(){

                @Override
                public void onResult(List<MedicalDataSource> result) {
                    HealthConnectManager.returnResult(executor, result, callback);
                }

                @Override
                public void onError(HealthConnectExceptionParcel exception) {
                    HealthConnectManager.this.returnError(executor, exception, callback);
                }
            });
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @FlaggedApi(value="com.android.healthfitness.flags.personal_health_record")
    @RequiresPermission(anyOf={"android.permission.health.WRITE_MEDICAL_DATA", "android.permission.MANAGE_HEALTH_DATA"})
    public void deleteMedicalDataSourceWithData(@NonNull String id2, final @NonNull Executor executor, final @NonNull OutcomeReceiver<Void, HealthConnectException> callback) {
        Objects.requireNonNull(id2);
        Objects.requireNonNull(executor);
        Objects.requireNonNull(callback);
        try {
            this.mService.deleteMedicalDataSourceWithData(this.mContext.getAttributionSource(), id2, new IEmptyResponseCallback.Stub(){

                @Override
                public void onResult() {
                    HealthConnectManager.returnResult(executor, null, callback);
                }

                @Override
                public void onError(HealthConnectExceptionParcel exception) {
                    HealthConnectManager.this.returnError(executor, exception, callback);
                }
            });
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @SystemApi
    @FlaggedApi(value="com.android.healthfitness.flags.cloud_backup_and_restore")
    @RequiresPermission(value="android.permission.BACKUP_HEALTH_CONNECT_DATA_AND_SETTINGS")
    public void getChangesForBackup(@Nullable String changeToken, final @NonNull Executor executor, final @NonNull OutcomeReceiver<GetChangesForBackupResponse, HealthConnectException> callback) {
        Objects.requireNonNull(executor);
        Objects.requireNonNull(callback);
        try {
            this.mService.getChangesForBackup(changeToken, new IGetChangesForBackupResponseCallback.Stub(){

                @Override
                public void onResult(GetChangesForBackupResponse response) {
                    HealthConnectManager.returnResult(executor, response, callback);
                }

                @Override
                public void onError(HealthConnectExceptionParcel exception) {
                    HealthConnectManager.this.returnError(executor, exception, callback);
                }
            });
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @SystemApi
    @FlaggedApi(value="com.android.healthfitness.flags.cloud_backup_and_restore")
    @RequiresPermission(value="android.permission.BACKUP_HEALTH_CONNECT_DATA_AND_SETTINGS")
    public void getLatestMetadataForBackup(final @NonNull Executor executor, final @NonNull OutcomeReceiver<GetLatestMetadataForBackupResponse, HealthConnectException> callback) {
        Objects.requireNonNull(executor);
        Objects.requireNonNull(callback);
        try {
            this.mService.getLatestMetadataForBackup(new IGetLatestMetadataForBackupResponseCallback.Stub(){

                @Override
                public void onResult(GetLatestMetadataForBackupResponse response) {
                    HealthConnectManager.returnResult(executor, response, callback);
                }

                @Override
                public void onError(HealthConnectExceptionParcel exception) {
                    HealthConnectManager.this.returnError(executor, exception, callback);
                }
            });
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @SystemApi
    @FlaggedApi(value="com.android.healthfitness.flags.cloud_backup_and_restore")
    @RequiresPermission(value="android.permission.RESTORE_HEALTH_CONNECT_DATA_AND_SETTINGS")
    public void restoreLatestMetadata(@NonNull BackupMetadata backupMetadata, final @NonNull Executor executor, final @NonNull OutcomeReceiver<Void, HealthConnectException> callback) {
        Objects.requireNonNull(backupMetadata);
        Objects.requireNonNull(executor);
        Objects.requireNonNull(callback);
        try {
            this.mService.restoreLatestMetadata(backupMetadata, new IEmptyResponseCallback.Stub(){

                @Override
                public void onResult() {
                    HealthConnectManager.returnResult(executor, null, callback);
                }

                @Override
                public void onError(HealthConnectExceptionParcel exception) {
                    HealthConnectManager.this.returnError(executor, exception, callback);
                }
            });
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @SystemApi
    @FlaggedApi(value="com.android.healthfitness.flags.cloud_backup_and_restore")
    @RequiresPermission(value="android.permission.RESTORE_HEALTH_CONNECT_DATA_AND_SETTINGS")
    public void canRestore(int dataVersion, final @NonNull Executor executor, final @NonNull OutcomeReceiver<Boolean, HealthConnectException> callback) {
        Objects.requireNonNull(executor);
        Objects.requireNonNull(callback);
        try {
            this.mService.canRestore(dataVersion, new ICanRestoreResponseCallback.Stub(){

                @Override
                public void onResult(boolean canRestore) {
                    HealthConnectManager.returnResult(executor, canRestore, callback);
                }

                @Override
                public void onError(HealthConnectExceptionParcel exception) {
                    HealthConnectManager.this.returnError(executor, exception, callback);
                }
            });
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @SystemApi
    @FlaggedApi(value="com.android.healthfitness.flags.cloud_backup_and_restore")
    @RequiresPermission(value="android.permission.RESTORE_HEALTH_CONNECT_DATA_AND_SETTINGS")
    public void restoreChanges(@NonNull List<RestoreChange> restoreChanges, final @NonNull Executor executor, final @NonNull OutcomeReceiver<Void, HealthConnectException> callback) {
        Objects.requireNonNull(restoreChanges);
        Objects.requireNonNull(executor);
        Objects.requireNonNull(callback);
        try {
            this.mService.restoreChanges(restoreChanges, new IEmptyResponseCallback.Stub(){

                @Override
                public void onResult() {
                    HealthConnectManager.returnResult(executor, null, callback);
                }

                @Override
                public void onError(HealthConnectExceptionParcel exception) {
                    HealthConnectManager.this.returnError(executor, exception, callback);
                }
            });
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface DataDownloadState {
    }
}

