/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.input;

import android.annotation.NonNull;
import android.hardware.input.VirtualInputDeviceConfig;
import android.os.Parcel;

abstract class VirtualTouchDeviceConfig
extends VirtualInputDeviceConfig {
    private final int mWidth;
    private final int mHeight;

    VirtualTouchDeviceConfig(@NonNull Builder<? extends Builder<?>> builder) {
        super(builder);
        this.mWidth = builder.mWidth;
        this.mHeight = builder.mHeight;
    }

    VirtualTouchDeviceConfig(@NonNull Parcel in) {
        super(in);
        this.mWidth = in.readInt();
        this.mHeight = in.readInt();
    }

    public int getWidth() {
        return this.mWidth;
    }

    public int getHeight() {
        return this.mHeight;
    }

    @Override
    void writeToParcel(@NonNull Parcel dest, int flags) {
        super.writeToParcel(dest, flags);
        dest.writeInt(this.mWidth);
        dest.writeInt(this.mHeight);
    }

    @Override
    @NonNull
    String additionalFieldsToString() {
        return " width=" + this.mWidth + " height=" + this.mHeight;
    }

    static abstract class Builder<T extends Builder<T>>
    extends VirtualInputDeviceConfig.Builder<T> {
        private final int mWidth;
        private final int mHeight;

        Builder(int touchDeviceWidth, int touchDeviceHeight) {
            if (touchDeviceHeight <= 0 || touchDeviceWidth <= 0) {
                throw new IllegalArgumentException("Cannot create a virtual touch-based device, dimensions must be positive. Got: (" + touchDeviceHeight + ", " + touchDeviceWidth + ")");
            }
            this.mHeight = touchDeviceHeight;
            this.mWidth = touchDeviceWidth;
        }
    }
}

