/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.input;

import android.annotation.NonNull;
import android.annotation.SystemApi;
import android.companion.virtual.IVirtualDevice;
import android.graphics.PointF;
import android.hardware.input.VirtualInputDevice;
import android.hardware.input.VirtualMouseButtonEvent;
import android.hardware.input.VirtualMouseConfig;
import android.hardware.input.VirtualMouseRelativeEvent;
import android.hardware.input.VirtualMouseScrollEvent;
import android.os.IBinder;
import android.os.RemoteException;
import android.util.Log;

@SystemApi
public class VirtualMouse
extends VirtualInputDevice {
    public VirtualMouse(VirtualMouseConfig config, IVirtualDevice virtualDevice, IBinder token) {
        super(config, virtualDevice, token);
    }

    public void sendButtonEvent(@NonNull VirtualMouseButtonEvent event) {
        try {
            if (!this.mVirtualDevice.sendButtonEvent(this.mToken, event)) {
                Log.w("VirtualInputDevice", "Failed to send button event to virtual mouse " + this.mConfig.getInputDeviceName());
            }
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public void sendScrollEvent(@NonNull VirtualMouseScrollEvent event) {
        try {
            if (!this.mVirtualDevice.sendScrollEvent(this.mToken, event)) {
                Log.w("VirtualInputDevice", "Failed to send scroll event to virtual mouse " + this.mConfig.getInputDeviceName());
            }
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public void sendRelativeEvent(@NonNull VirtualMouseRelativeEvent event) {
        try {
            if (!this.mVirtualDevice.sendRelativeEvent(this.mToken, event)) {
                Log.w("VirtualInputDevice", "Failed to send relative event to virtual mouse " + this.mConfig.getInputDeviceName());
            }
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @NonNull
    public PointF getCursorPosition() {
        try {
            return this.mVirtualDevice.getCursorPosition(this.mToken);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }
}

