/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.input;

import android.annotation.EnforcePermission;
import android.annotation.RequiresPermission;
import android.app.ActivityThread;
import android.compat.annotation.UnsupportedAppUsage;
import android.hardware.input.AidlInputGestureData;
import android.hardware.input.HostUsiVersion;
import android.hardware.input.IInputDeviceBatteryListener;
import android.hardware.input.IInputDeviceBatteryState;
import android.hardware.input.IInputDevicesChangedListener;
import android.hardware.input.IInputSensorEventListener;
import android.hardware.input.IKeyEventActivityListener;
import android.hardware.input.IKeyGestureEventListener;
import android.hardware.input.IKeyGestureHandler;
import android.hardware.input.IKeyboardBacklightListener;
import android.hardware.input.IStickyModifierStateListener;
import android.hardware.input.ITabletModeChangedListener;
import android.hardware.input.InputDeviceIdentifier;
import android.hardware.input.InputSensorInfo;
import android.hardware.input.KeyGlyphMap;
import android.hardware.input.KeyboardLayout;
import android.hardware.input.KeyboardLayoutSelectionResult;
import android.hardware.input.TouchCalibration;
import android.hardware.lights.Light;
import android.hardware.lights.LightState;
import android.os.BadParcelableException;
import android.os.Binder;
import android.os.CombinedVibration;
import android.os.IBinder;
import android.os.IInterface;
import android.os.IVibratorStateListener;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.PermissionEnforcer;
import android.os.RemoteException;
import android.os.VibrationEffect;
import android.view.InputDevice;
import android.view.InputEvent;
import android.view.InputMonitor;
import android.view.KeyCharacterMap;
import android.view.PointerIcon;
import android.view.VerifiedInputEvent;
import android.view.inputmethod.InputMethodInfo;
import android.view.inputmethod.InputMethodSubtype;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public interface IInputManager
extends IInterface {
    public String getVelocityTrackerStrategy() throws RemoteException;

    public InputDevice getInputDevice(int var1) throws RemoteException;

    public int[] getInputDeviceIds() throws RemoteException;

    public void enableInputDevice(int var1) throws RemoteException;

    public void disableInputDevice(int var1) throws RemoteException;

    public boolean hasKeys(int var1, int var2, int[] var3, boolean[] var4) throws RemoteException;

    public int getKeyCodeForKeyLocation(int var1, int var2) throws RemoteException;

    public KeyCharacterMap getKeyCharacterMap(String var1) throws RemoteException;

    public int getMousePointerSpeed() throws RemoteException;

    public void tryPointerSpeed(int var1) throws RemoteException;

    @UnsupportedAppUsage(overrideSourcePosition="frameworks/base/core/java/android/hardware/input/IInputManager.aidl:83:1:83:25")
    public boolean injectInputEvent(InputEvent var1, int var2) throws RemoteException;

    public boolean injectInputEventToTarget(InputEvent var1, int var2, int var3) throws RemoteException;

    public VerifiedInputEvent verifyInputEvent(InputEvent var1) throws RemoteException;

    public TouchCalibration getTouchCalibrationForInputDevice(String var1, int var2) throws RemoteException;

    public void setTouchCalibrationForInputDevice(String var1, int var2, TouchCalibration var3) throws RemoteException;

    public KeyboardLayout[] getKeyboardLayouts() throws RemoteException;

    public KeyboardLayout getKeyboardLayout(String var1) throws RemoteException;

    public KeyboardLayoutSelectionResult getKeyboardLayoutForInputDevice(InputDeviceIdentifier var1, int var2, InputMethodInfo var3, InputMethodSubtype var4) throws RemoteException;

    @RequiresPermission(value="android.permission.SET_KEYBOARD_LAYOUT")
    @EnforcePermission(value="android.permission.SET_KEYBOARD_LAYOUT")
    public void setKeyboardLayoutOverrideForInputDevice(InputDeviceIdentifier var1, String var2) throws RemoteException;

    @RequiresPermission(value="android.permission.SET_KEYBOARD_LAYOUT")
    @EnforcePermission(value="android.permission.SET_KEYBOARD_LAYOUT")
    public void setKeyboardLayoutForInputDevice(InputDeviceIdentifier var1, int var2, InputMethodInfo var3, InputMethodSubtype var4, String var5) throws RemoteException;

    public KeyboardLayout[] getKeyboardLayoutListForInputDevice(InputDeviceIdentifier var1, int var2, InputMethodInfo var3, InputMethodSubtype var4) throws RemoteException;

    @RequiresPermission(value="android.permission.REMAP_MODIFIER_KEYS")
    @EnforcePermission(value="android.permission.REMAP_MODIFIER_KEYS")
    public void remapModifierKey(int var1, int var2) throws RemoteException;

    @RequiresPermission(value="android.permission.REMAP_MODIFIER_KEYS")
    @EnforcePermission(value="android.permission.REMAP_MODIFIER_KEYS")
    public void clearAllModifierKeyRemappings() throws RemoteException;

    @RequiresPermission(value="android.permission.REMAP_MODIFIER_KEYS")
    @EnforcePermission(value="android.permission.REMAP_MODIFIER_KEYS")
    public Map getModifierKeyRemapping() throws RemoteException;

    public void registerInputDevicesChangedListener(IInputDevicesChangedListener var1) throws RemoteException;

    public int isInTabletMode() throws RemoteException;

    public void registerTabletModeChangedListener(ITabletModeChangedListener var1) throws RemoteException;

    public int isMicMuted() throws RemoteException;

    public void vibrate(int var1, VibrationEffect var2, IBinder var3) throws RemoteException;

    public void vibrateCombined(int var1, CombinedVibration var2, IBinder var3) throws RemoteException;

    public void cancelVibrate(int var1, IBinder var2) throws RemoteException;

    public int[] getVibratorIds(int var1) throws RemoteException;

    public boolean isVibrating(int var1) throws RemoteException;

    public boolean registerVibratorStateListener(int var1, IVibratorStateListener var2) throws RemoteException;

    public boolean unregisterVibratorStateListener(int var1, IVibratorStateListener var2) throws RemoteException;

    public IInputDeviceBatteryState getBatteryState(int var1) throws RemoteException;

    public boolean setPointerIcon(PointerIcon var1, int var2, int var3, int var4, IBinder var5) throws RemoteException;

    public void requestPointerCapture(IBinder var1, boolean var2) throws RemoteException;

    public InputMonitor monitorGestureInput(IBinder var1, String var2, int var3) throws RemoteException;

    public void addPortAssociation(String var1, int var2) throws RemoteException;

    public void removePortAssociation(String var1) throws RemoteException;

    public void addUniqueIdAssociationByDescriptor(String var1, String var2) throws RemoteException;

    public void removeUniqueIdAssociationByDescriptor(String var1) throws RemoteException;

    public void addUniqueIdAssociationByPort(String var1, String var2) throws RemoteException;

    public void removeUniqueIdAssociationByPort(String var1) throws RemoteException;

    public InputSensorInfo[] getSensorList(int var1) throws RemoteException;

    public boolean registerSensorListener(IInputSensorEventListener var1) throws RemoteException;

    public void unregisterSensorListener(IInputSensorEventListener var1) throws RemoteException;

    public boolean enableSensor(int var1, int var2, int var3, int var4) throws RemoteException;

    public void disableSensor(int var1, int var2) throws RemoteException;

    public boolean flushSensor(int var1, int var2) throws RemoteException;

    public List<Light> getLights(int var1) throws RemoteException;

    public LightState getLightState(int var1, int var2) throws RemoteException;

    public void setLightStates(int var1, int[] var2, LightState[] var3, IBinder var4) throws RemoteException;

    public void openLightSession(int var1, String var2, IBinder var3) throws RemoteException;

    public void closeLightSession(int var1, IBinder var2) throws RemoteException;

    public void cancelCurrentTouch() throws RemoteException;

    public void registerBatteryListener(int var1, IInputDeviceBatteryListener var2) throws RemoteException;

    public void unregisterBatteryListener(int var1, IInputDeviceBatteryListener var2) throws RemoteException;

    @RequiresPermission(value="android.permission.LISTEN_FOR_KEY_ACTIVITY")
    @EnforcePermission(value="android.permission.LISTEN_FOR_KEY_ACTIVITY")
    public boolean registerKeyEventActivityListener(IKeyEventActivityListener var1) throws RemoteException;

    @RequiresPermission(value="android.permission.LISTEN_FOR_KEY_ACTIVITY")
    @EnforcePermission(value="android.permission.LISTEN_FOR_KEY_ACTIVITY")
    public boolean unregisterKeyEventActivityListener(IKeyEventActivityListener var1) throws RemoteException;

    @RequiresPermission(value="android.permission.BLUETOOTH")
    @EnforcePermission(value="android.permission.BLUETOOTH")
    public String getInputDeviceBluetoothAddress(int var1) throws RemoteException;

    @RequiresPermission(value="android.permission.MONITOR_INPUT")
    @EnforcePermission(value="android.permission.MONITOR_INPUT")
    public void pilferPointers(IBinder var1) throws RemoteException;

    @RequiresPermission(value="android.permission.MONITOR_KEYBOARD_BACKLIGHT")
    @EnforcePermission(value="android.permission.MONITOR_KEYBOARD_BACKLIGHT")
    public void registerKeyboardBacklightListener(IKeyboardBacklightListener var1) throws RemoteException;

    @RequiresPermission(value="android.permission.MONITOR_KEYBOARD_BACKLIGHT")
    @EnforcePermission(value="android.permission.MONITOR_KEYBOARD_BACKLIGHT")
    public void unregisterKeyboardBacklightListener(IKeyboardBacklightListener var1) throws RemoteException;

    public HostUsiVersion getHostUsiVersionFromDisplayConfig(int var1) throws RemoteException;

    @RequiresPermission(value="android.permission.MONITOR_STICKY_MODIFIER_STATE")
    @EnforcePermission(value="android.permission.MONITOR_STICKY_MODIFIER_STATE")
    public void registerStickyModifierStateListener(IStickyModifierStateListener var1) throws RemoteException;

    @RequiresPermission(value="android.permission.MONITOR_STICKY_MODIFIER_STATE")
    @EnforcePermission(value="android.permission.MONITOR_STICKY_MODIFIER_STATE")
    public void unregisterStickyModifierStateListener(IStickyModifierStateListener var1) throws RemoteException;

    public KeyGlyphMap getKeyGlyphMap(int var1) throws RemoteException;

    @RequiresPermission(value="android.permission.MANAGE_KEY_GESTURES")
    public void registerKeyGestureEventListener(IKeyGestureEventListener var1) throws RemoteException;

    @RequiresPermission(value="android.permission.MANAGE_KEY_GESTURES")
    public void unregisterKeyGestureEventListener(IKeyGestureEventListener var1) throws RemoteException;

    @RequiresPermission(value="android.permission.MANAGE_KEY_GESTURES")
    public void registerKeyGestureHandler(int[] var1, IKeyGestureHandler var2) throws RemoteException;

    @RequiresPermission(value="android.permission.MANAGE_KEY_GESTURES")
    public void unregisterKeyGestureHandler(IKeyGestureHandler var1) throws RemoteException;

    @RequiresPermission(value="android.permission.MANAGE_KEY_GESTURES")
    public AidlInputGestureData getInputGesture(int var1, AidlInputGestureData.Trigger var2) throws RemoteException;

    @RequiresPermission(value="android.permission.MANAGE_KEY_GESTURES")
    public int addCustomInputGesture(int var1, AidlInputGestureData var2) throws RemoteException;

    @RequiresPermission(value="android.permission.MANAGE_KEY_GESTURES")
    public int removeCustomInputGesture(int var1, AidlInputGestureData var2) throws RemoteException;

    @RequiresPermission(value="android.permission.MANAGE_KEY_GESTURES")
    public void removeAllCustomInputGestures(int var1, int var2) throws RemoteException;

    public AidlInputGestureData[] getCustomInputGestures(int var1, int var2) throws RemoteException;

    public AidlInputGestureData[] getAppLaunchBookmarks() throws RemoteException;

    public void resetLockedModifierState() throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements IInputManager {
        private final PermissionEnforcer mEnforcer;
        public static final String DESCRIPTOR = "android.hardware.input.IInputManager";
        static final int TRANSACTION_getVelocityTrackerStrategy = 1;
        static final int TRANSACTION_getInputDevice = 2;
        static final int TRANSACTION_getInputDeviceIds = 3;
        static final int TRANSACTION_enableInputDevice = 4;
        static final int TRANSACTION_disableInputDevice = 5;
        static final int TRANSACTION_hasKeys = 6;
        static final int TRANSACTION_getKeyCodeForKeyLocation = 7;
        static final int TRANSACTION_getKeyCharacterMap = 8;
        static final int TRANSACTION_getMousePointerSpeed = 9;
        static final int TRANSACTION_tryPointerSpeed = 10;
        static final int TRANSACTION_injectInputEvent = 11;
        static final int TRANSACTION_injectInputEventToTarget = 12;
        static final int TRANSACTION_verifyInputEvent = 13;
        static final int TRANSACTION_getTouchCalibrationForInputDevice = 14;
        static final int TRANSACTION_setTouchCalibrationForInputDevice = 15;
        static final int TRANSACTION_getKeyboardLayouts = 16;
        static final int TRANSACTION_getKeyboardLayout = 17;
        static final int TRANSACTION_getKeyboardLayoutForInputDevice = 18;
        static final int TRANSACTION_setKeyboardLayoutOverrideForInputDevice = 19;
        static final int TRANSACTION_setKeyboardLayoutForInputDevice = 20;
        static final int TRANSACTION_getKeyboardLayoutListForInputDevice = 21;
        static final int TRANSACTION_remapModifierKey = 22;
        static final int TRANSACTION_clearAllModifierKeyRemappings = 23;
        static final int TRANSACTION_getModifierKeyRemapping = 24;
        static final int TRANSACTION_registerInputDevicesChangedListener = 25;
        static final int TRANSACTION_isInTabletMode = 26;
        static final int TRANSACTION_registerTabletModeChangedListener = 27;
        static final int TRANSACTION_isMicMuted = 28;
        static final int TRANSACTION_vibrate = 29;
        static final int TRANSACTION_vibrateCombined = 30;
        static final int TRANSACTION_cancelVibrate = 31;
        static final int TRANSACTION_getVibratorIds = 32;
        static final int TRANSACTION_isVibrating = 33;
        static final int TRANSACTION_registerVibratorStateListener = 34;
        static final int TRANSACTION_unregisterVibratorStateListener = 35;
        static final int TRANSACTION_getBatteryState = 36;
        static final int TRANSACTION_setPointerIcon = 37;
        static final int TRANSACTION_requestPointerCapture = 38;
        static final int TRANSACTION_monitorGestureInput = 39;
        static final int TRANSACTION_addPortAssociation = 40;
        static final int TRANSACTION_removePortAssociation = 41;
        static final int TRANSACTION_addUniqueIdAssociationByDescriptor = 42;
        static final int TRANSACTION_removeUniqueIdAssociationByDescriptor = 43;
        static final int TRANSACTION_addUniqueIdAssociationByPort = 44;
        static final int TRANSACTION_removeUniqueIdAssociationByPort = 45;
        static final int TRANSACTION_getSensorList = 46;
        static final int TRANSACTION_registerSensorListener = 47;
        static final int TRANSACTION_unregisterSensorListener = 48;
        static final int TRANSACTION_enableSensor = 49;
        static final int TRANSACTION_disableSensor = 50;
        static final int TRANSACTION_flushSensor = 51;
        static final int TRANSACTION_getLights = 52;
        static final int TRANSACTION_getLightState = 53;
        static final int TRANSACTION_setLightStates = 54;
        static final int TRANSACTION_openLightSession = 55;
        static final int TRANSACTION_closeLightSession = 56;
        static final int TRANSACTION_cancelCurrentTouch = 57;
        static final int TRANSACTION_registerBatteryListener = 58;
        static final int TRANSACTION_unregisterBatteryListener = 59;
        static final int TRANSACTION_registerKeyEventActivityListener = 60;
        static final int TRANSACTION_unregisterKeyEventActivityListener = 61;
        static final int TRANSACTION_getInputDeviceBluetoothAddress = 62;
        static final int TRANSACTION_pilferPointers = 63;
        static final int TRANSACTION_registerKeyboardBacklightListener = 64;
        static final int TRANSACTION_unregisterKeyboardBacklightListener = 65;
        static final int TRANSACTION_getHostUsiVersionFromDisplayConfig = 66;
        static final int TRANSACTION_registerStickyModifierStateListener = 67;
        static final int TRANSACTION_unregisterStickyModifierStateListener = 68;
        static final int TRANSACTION_getKeyGlyphMap = 69;
        static final int TRANSACTION_registerKeyGestureEventListener = 70;
        static final int TRANSACTION_unregisterKeyGestureEventListener = 71;
        static final int TRANSACTION_registerKeyGestureHandler = 72;
        static final int TRANSACTION_unregisterKeyGestureHandler = 73;
        static final int TRANSACTION_getInputGesture = 74;
        static final int TRANSACTION_addCustomInputGesture = 75;
        static final int TRANSACTION_removeCustomInputGesture = 76;
        static final int TRANSACTION_removeAllCustomInputGestures = 77;
        static final int TRANSACTION_getCustomInputGestures = 78;
        static final int TRANSACTION_getAppLaunchBookmarks = 79;
        static final int TRANSACTION_resetLockedModifierState = 80;

        public Stub(PermissionEnforcer enforcer) {
            this.attachInterface(this, DESCRIPTOR);
            if (enforcer == null) {
                throw new IllegalArgumentException("enforcer cannot be null");
            }
            this.mEnforcer = enforcer;
        }

        @Deprecated
        public Stub() {
            this(PermissionEnforcer.fromContext(ActivityThread.currentActivityThread().getSystemContext()));
        }

        public static IInputManager asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(DESCRIPTOR);
            if (iin != null && iin instanceof IInputManager) {
                return (IInputManager)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 1: {
                    return "getVelocityTrackerStrategy";
                }
                case 2: {
                    return "getInputDevice";
                }
                case 3: {
                    return "getInputDeviceIds";
                }
                case 4: {
                    return "enableInputDevice";
                }
                case 5: {
                    return "disableInputDevice";
                }
                case 6: {
                    return "hasKeys";
                }
                case 7: {
                    return "getKeyCodeForKeyLocation";
                }
                case 8: {
                    return "getKeyCharacterMap";
                }
                case 9: {
                    return "getMousePointerSpeed";
                }
                case 10: {
                    return "tryPointerSpeed";
                }
                case 11: {
                    return "injectInputEvent";
                }
                case 12: {
                    return "injectInputEventToTarget";
                }
                case 13: {
                    return "verifyInputEvent";
                }
                case 14: {
                    return "getTouchCalibrationForInputDevice";
                }
                case 15: {
                    return "setTouchCalibrationForInputDevice";
                }
                case 16: {
                    return "getKeyboardLayouts";
                }
                case 17: {
                    return "getKeyboardLayout";
                }
                case 18: {
                    return "getKeyboardLayoutForInputDevice";
                }
                case 19: {
                    return "setKeyboardLayoutOverrideForInputDevice";
                }
                case 20: {
                    return "setKeyboardLayoutForInputDevice";
                }
                case 21: {
                    return "getKeyboardLayoutListForInputDevice";
                }
                case 22: {
                    return "remapModifierKey";
                }
                case 23: {
                    return "clearAllModifierKeyRemappings";
                }
                case 24: {
                    return "getModifierKeyRemapping";
                }
                case 25: {
                    return "registerInputDevicesChangedListener";
                }
                case 26: {
                    return "isInTabletMode";
                }
                case 27: {
                    return "registerTabletModeChangedListener";
                }
                case 28: {
                    return "isMicMuted";
                }
                case 29: {
                    return "vibrate";
                }
                case 30: {
                    return "vibrateCombined";
                }
                case 31: {
                    return "cancelVibrate";
                }
                case 32: {
                    return "getVibratorIds";
                }
                case 33: {
                    return "isVibrating";
                }
                case 34: {
                    return "registerVibratorStateListener";
                }
                case 35: {
                    return "unregisterVibratorStateListener";
                }
                case 36: {
                    return "getBatteryState";
                }
                case 37: {
                    return "setPointerIcon";
                }
                case 38: {
                    return "requestPointerCapture";
                }
                case 39: {
                    return "monitorGestureInput";
                }
                case 40: {
                    return "addPortAssociation";
                }
                case 41: {
                    return "removePortAssociation";
                }
                case 42: {
                    return "addUniqueIdAssociationByDescriptor";
                }
                case 43: {
                    return "removeUniqueIdAssociationByDescriptor";
                }
                case 44: {
                    return "addUniqueIdAssociationByPort";
                }
                case 45: {
                    return "removeUniqueIdAssociationByPort";
                }
                case 46: {
                    return "getSensorList";
                }
                case 47: {
                    return "registerSensorListener";
                }
                case 48: {
                    return "unregisterSensorListener";
                }
                case 49: {
                    return "enableSensor";
                }
                case 50: {
                    return "disableSensor";
                }
                case 51: {
                    return "flushSensor";
                }
                case 52: {
                    return "getLights";
                }
                case 53: {
                    return "getLightState";
                }
                case 54: {
                    return "setLightStates";
                }
                case 55: {
                    return "openLightSession";
                }
                case 56: {
                    return "closeLightSession";
                }
                case 57: {
                    return "cancelCurrentTouch";
                }
                case 58: {
                    return "registerBatteryListener";
                }
                case 59: {
                    return "unregisterBatteryListener";
                }
                case 60: {
                    return "registerKeyEventActivityListener";
                }
                case 61: {
                    return "unregisterKeyEventActivityListener";
                }
                case 62: {
                    return "getInputDeviceBluetoothAddress";
                }
                case 63: {
                    return "pilferPointers";
                }
                case 64: {
                    return "registerKeyboardBacklightListener";
                }
                case 65: {
                    return "unregisterKeyboardBacklightListener";
                }
                case 66: {
                    return "getHostUsiVersionFromDisplayConfig";
                }
                case 67: {
                    return "registerStickyModifierStateListener";
                }
                case 68: {
                    return "unregisterStickyModifierStateListener";
                }
                case 69: {
                    return "getKeyGlyphMap";
                }
                case 70: {
                    return "registerKeyGestureEventListener";
                }
                case 71: {
                    return "unregisterKeyGestureEventListener";
                }
                case 72: {
                    return "registerKeyGestureHandler";
                }
                case 73: {
                    return "unregisterKeyGestureHandler";
                }
                case 74: {
                    return "getInputGesture";
                }
                case 75: {
                    return "addCustomInputGesture";
                }
                case 76: {
                    return "removeCustomInputGesture";
                }
                case 77: {
                    return "removeAllCustomInputGestures";
                }
                case 78: {
                    return "getCustomInputGestures";
                }
                case 79: {
                    return "getAppLaunchBookmarks";
                }
                case 80: {
                    return "resetLockedModifierState";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = DESCRIPTOR;
            if (code >= 1 && code <= 0xFFFFFF) {
                data.enforceInterface(descriptor);
            }
            if (code == 1598968902) {
                reply.writeString(descriptor);
                return true;
            }
            switch (code) {
                case 1: {
                    String _result = this.getVelocityTrackerStrategy();
                    reply.writeNoException();
                    reply.writeString(_result);
                    break;
                }
                case 2: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    InputDevice _result = this.getInputDevice(_arg0);
                    reply.writeNoException();
                    reply.writeTypedObject(_result, 1);
                    break;
                }
                case 3: {
                    int[] _result = this.getInputDeviceIds();
                    reply.writeNoException();
                    reply.writeIntArray(_result);
                    break;
                }
                case 4: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    this.enableInputDevice(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 5: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    this.disableInputDevice(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 6: {
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    int[] _arg2 = data.createIntArray();
                    int _arg3_length = data.readInt();
                    if (_arg3_length > 1000000) {
                        throw new BadParcelableException("Array too large: " + _arg3_length);
                    }
                    boolean[] _arg3 = _arg3_length < 0 ? null : new boolean[_arg3_length];
                    data.enforceNoDataAvail();
                    boolean _result = this.hasKeys(_arg0, _arg1, _arg2, _arg3);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    reply.writeBooleanArray(_arg3);
                    break;
                }
                case 7: {
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    int _result = this.getKeyCodeForKeyLocation(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    break;
                }
                case 8: {
                    String _arg0 = data.readString();
                    data.enforceNoDataAvail();
                    KeyCharacterMap _result = this.getKeyCharacterMap(_arg0);
                    reply.writeNoException();
                    reply.writeTypedObject(_result, 1);
                    break;
                }
                case 9: {
                    int _result = this.getMousePointerSpeed();
                    reply.writeNoException();
                    reply.writeInt(_result);
                    break;
                }
                case 10: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    this.tryPointerSpeed(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 11: {
                    InputEvent _arg0 = data.readTypedObject(InputEvent.CREATOR);
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    boolean _result = this.injectInputEvent(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 12: {
                    InputEvent _arg0 = data.readTypedObject(InputEvent.CREATOR);
                    int _arg1 = data.readInt();
                    int _arg2 = data.readInt();
                    data.enforceNoDataAvail();
                    boolean _result = this.injectInputEventToTarget(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 13: {
                    InputEvent _arg0 = data.readTypedObject(InputEvent.CREATOR);
                    data.enforceNoDataAvail();
                    VerifiedInputEvent _result = this.verifyInputEvent(_arg0);
                    reply.writeNoException();
                    reply.writeTypedObject(_result, 1);
                    break;
                }
                case 14: {
                    String _arg0 = data.readString();
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    TouchCalibration _result = this.getTouchCalibrationForInputDevice(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeTypedObject(_result, 1);
                    break;
                }
                case 15: {
                    String _arg0 = data.readString();
                    int _arg1 = data.readInt();
                    TouchCalibration _arg2 = data.readTypedObject(TouchCalibration.CREATOR);
                    data.enforceNoDataAvail();
                    this.setTouchCalibrationForInputDevice(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    break;
                }
                case 16: {
                    Parcelable[] _result = this.getKeyboardLayouts();
                    reply.writeNoException();
                    reply.writeTypedArray(_result, 1);
                    break;
                }
                case 17: {
                    String _arg0 = data.readString();
                    data.enforceNoDataAvail();
                    KeyboardLayout _result = this.getKeyboardLayout(_arg0);
                    reply.writeNoException();
                    reply.writeTypedObject(_result, 1);
                    break;
                }
                case 18: {
                    InputDeviceIdentifier _arg0 = data.readTypedObject(InputDeviceIdentifier.CREATOR);
                    int _arg1 = data.readInt();
                    InputMethodInfo _arg2 = data.readTypedObject(InputMethodInfo.CREATOR);
                    InputMethodSubtype _arg3 = data.readTypedObject(InputMethodSubtype.CREATOR);
                    data.enforceNoDataAvail();
                    KeyboardLayoutSelectionResult _result = this.getKeyboardLayoutForInputDevice(_arg0, _arg1, _arg2, _arg3);
                    reply.writeNoException();
                    reply.writeTypedObject(_result, 1);
                    break;
                }
                case 19: {
                    InputDeviceIdentifier _arg0 = data.readTypedObject(InputDeviceIdentifier.CREATOR);
                    String _arg1 = data.readString();
                    data.enforceNoDataAvail();
                    this.setKeyboardLayoutOverrideForInputDevice(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 20: {
                    InputDeviceIdentifier _arg0 = data.readTypedObject(InputDeviceIdentifier.CREATOR);
                    int _arg1 = data.readInt();
                    InputMethodInfo _arg2 = data.readTypedObject(InputMethodInfo.CREATOR);
                    InputMethodSubtype _arg3 = data.readTypedObject(InputMethodSubtype.CREATOR);
                    String _arg4 = data.readString();
                    data.enforceNoDataAvail();
                    this.setKeyboardLayoutForInputDevice(_arg0, _arg1, _arg2, _arg3, _arg4);
                    reply.writeNoException();
                    break;
                }
                case 21: {
                    InputDeviceIdentifier _arg0 = data.readTypedObject(InputDeviceIdentifier.CREATOR);
                    int _arg1 = data.readInt();
                    InputMethodInfo _arg2 = data.readTypedObject(InputMethodInfo.CREATOR);
                    InputMethodSubtype _arg3 = data.readTypedObject(InputMethodSubtype.CREATOR);
                    data.enforceNoDataAvail();
                    Parcelable[] _result = this.getKeyboardLayoutListForInputDevice(_arg0, _arg1, _arg2, _arg3);
                    reply.writeNoException();
                    reply.writeTypedArray(_result, 1);
                    break;
                }
                case 22: {
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    this.remapModifierKey(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 23: {
                    this.clearAllModifierKeyRemappings();
                    reply.writeNoException();
                    break;
                }
                case 24: {
                    Map _result = this.getModifierKeyRemapping();
                    reply.writeNoException();
                    reply.writeMap(_result);
                    break;
                }
                case 25: {
                    IInputDevicesChangedListener _arg0 = IInputDevicesChangedListener.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.registerInputDevicesChangedListener(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 26: {
                    int _result = this.isInTabletMode();
                    reply.writeNoException();
                    reply.writeInt(_result);
                    break;
                }
                case 27: {
                    ITabletModeChangedListener _arg0 = ITabletModeChangedListener.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.registerTabletModeChangedListener(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 28: {
                    int _result = this.isMicMuted();
                    reply.writeNoException();
                    reply.writeInt(_result);
                    break;
                }
                case 29: {
                    int _arg0 = data.readInt();
                    VibrationEffect _arg1 = data.readTypedObject(VibrationEffect.CREATOR);
                    IBinder _arg2 = data.readStrongBinder();
                    data.enforceNoDataAvail();
                    this.vibrate(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    break;
                }
                case 30: {
                    int _arg0 = data.readInt();
                    CombinedVibration _arg1 = data.readTypedObject(CombinedVibration.CREATOR);
                    IBinder _arg2 = data.readStrongBinder();
                    data.enforceNoDataAvail();
                    this.vibrateCombined(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    break;
                }
                case 31: {
                    int _arg0 = data.readInt();
                    IBinder _arg1 = data.readStrongBinder();
                    data.enforceNoDataAvail();
                    this.cancelVibrate(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 32: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    int[] _result = this.getVibratorIds(_arg0);
                    reply.writeNoException();
                    reply.writeIntArray(_result);
                    break;
                }
                case 33: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    boolean _result = this.isVibrating(_arg0);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 34: {
                    int _arg0 = data.readInt();
                    IVibratorStateListener _arg1 = IVibratorStateListener.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    boolean _result = this.registerVibratorStateListener(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 35: {
                    int _arg0 = data.readInt();
                    IVibratorStateListener _arg1 = IVibratorStateListener.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    boolean _result = this.unregisterVibratorStateListener(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 36: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    IInputDeviceBatteryState _result = this.getBatteryState(_arg0);
                    reply.writeNoException();
                    reply.writeTypedObject(_result, 1);
                    break;
                }
                case 37: {
                    PointerIcon _arg0 = data.readTypedObject(PointerIcon.CREATOR);
                    int _arg1 = data.readInt();
                    int _arg2 = data.readInt();
                    int _arg3 = data.readInt();
                    IBinder _arg4 = data.readStrongBinder();
                    data.enforceNoDataAvail();
                    boolean _result = this.setPointerIcon(_arg0, _arg1, _arg2, _arg3, _arg4);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 38: {
                    IBinder _arg0 = data.readStrongBinder();
                    boolean _arg1 = data.readBoolean();
                    data.enforceNoDataAvail();
                    this.requestPointerCapture(_arg0, _arg1);
                    break;
                }
                case 39: {
                    IBinder _arg0 = data.readStrongBinder();
                    String _arg1 = data.readString();
                    int _arg2 = data.readInt();
                    data.enforceNoDataAvail();
                    InputMonitor _result = this.monitorGestureInput(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    reply.writeTypedObject(_result, 1);
                    break;
                }
                case 40: {
                    String _arg0 = data.readString();
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    this.addPortAssociation(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 41: {
                    String _arg0 = data.readString();
                    data.enforceNoDataAvail();
                    this.removePortAssociation(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 42: {
                    String _arg0 = data.readString();
                    String _arg1 = data.readString();
                    data.enforceNoDataAvail();
                    this.addUniqueIdAssociationByDescriptor(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 43: {
                    String _arg0 = data.readString();
                    data.enforceNoDataAvail();
                    this.removeUniqueIdAssociationByDescriptor(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 44: {
                    String _arg0 = data.readString();
                    String _arg1 = data.readString();
                    data.enforceNoDataAvail();
                    this.addUniqueIdAssociationByPort(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 45: {
                    String _arg0 = data.readString();
                    data.enforceNoDataAvail();
                    this.removeUniqueIdAssociationByPort(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 46: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    Parcelable[] _result = this.getSensorList(_arg0);
                    reply.writeNoException();
                    reply.writeTypedArray(_result, 1);
                    break;
                }
                case 47: {
                    IInputSensorEventListener _arg0 = IInputSensorEventListener.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    boolean _result = this.registerSensorListener(_arg0);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 48: {
                    IInputSensorEventListener _arg0 = IInputSensorEventListener.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.unregisterSensorListener(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 49: {
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    int _arg2 = data.readInt();
                    int _arg3 = data.readInt();
                    data.enforceNoDataAvail();
                    boolean _result = this.enableSensor(_arg0, _arg1, _arg2, _arg3);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 50: {
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    this.disableSensor(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 51: {
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    boolean _result = this.flushSensor(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 52: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    List<Light> _result = this.getLights(_arg0);
                    reply.writeNoException();
                    reply.writeTypedList(_result, 1);
                    break;
                }
                case 53: {
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    LightState _result = this.getLightState(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeTypedObject(_result, 1);
                    break;
                }
                case 54: {
                    int _arg0 = data.readInt();
                    int[] _arg1 = data.createIntArray();
                    LightState[] _arg2 = data.createTypedArray(LightState.CREATOR);
                    IBinder _arg3 = data.readStrongBinder();
                    data.enforceNoDataAvail();
                    this.setLightStates(_arg0, _arg1, _arg2, _arg3);
                    reply.writeNoException();
                    break;
                }
                case 55: {
                    int _arg0 = data.readInt();
                    String _arg1 = data.readString();
                    IBinder _arg2 = data.readStrongBinder();
                    data.enforceNoDataAvail();
                    this.openLightSession(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    break;
                }
                case 56: {
                    int _arg0 = data.readInt();
                    IBinder _arg1 = data.readStrongBinder();
                    data.enforceNoDataAvail();
                    this.closeLightSession(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 57: {
                    this.cancelCurrentTouch();
                    reply.writeNoException();
                    break;
                }
                case 58: {
                    int _arg0 = data.readInt();
                    IInputDeviceBatteryListener _arg1 = IInputDeviceBatteryListener.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.registerBatteryListener(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 59: {
                    int _arg0 = data.readInt();
                    IInputDeviceBatteryListener _arg1 = IInputDeviceBatteryListener.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.unregisterBatteryListener(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 60: {
                    IKeyEventActivityListener _arg0 = IKeyEventActivityListener.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    boolean _result = this.registerKeyEventActivityListener(_arg0);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 61: {
                    IKeyEventActivityListener _arg0 = IKeyEventActivityListener.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    boolean _result = this.unregisterKeyEventActivityListener(_arg0);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 62: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    String _result = this.getInputDeviceBluetoothAddress(_arg0);
                    reply.writeNoException();
                    reply.writeString(_result);
                    break;
                }
                case 63: {
                    IBinder _arg0 = data.readStrongBinder();
                    data.enforceNoDataAvail();
                    this.pilferPointers(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 64: {
                    IKeyboardBacklightListener _arg0 = IKeyboardBacklightListener.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.registerKeyboardBacklightListener(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 65: {
                    IKeyboardBacklightListener _arg0 = IKeyboardBacklightListener.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.unregisterKeyboardBacklightListener(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 66: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    HostUsiVersion _result = this.getHostUsiVersionFromDisplayConfig(_arg0);
                    reply.writeNoException();
                    reply.writeTypedObject(_result, 1);
                    break;
                }
                case 67: {
                    IStickyModifierStateListener _arg0 = IStickyModifierStateListener.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.registerStickyModifierStateListener(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 68: {
                    IStickyModifierStateListener _arg0 = IStickyModifierStateListener.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.unregisterStickyModifierStateListener(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 69: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    KeyGlyphMap _result = this.getKeyGlyphMap(_arg0);
                    reply.writeNoException();
                    reply.writeTypedObject(_result, 1);
                    break;
                }
                case 70: {
                    IKeyGestureEventListener _arg0 = IKeyGestureEventListener.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.registerKeyGestureEventListener(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 71: {
                    IKeyGestureEventListener _arg0 = IKeyGestureEventListener.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.unregisterKeyGestureEventListener(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 72: {
                    int[] _arg0 = data.createIntArray();
                    IKeyGestureHandler _arg1 = IKeyGestureHandler.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.registerKeyGestureHandler(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 73: {
                    IKeyGestureHandler _arg0 = IKeyGestureHandler.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.unregisterKeyGestureHandler(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 74: {
                    int _arg0 = data.readInt();
                    AidlInputGestureData.Trigger _arg1 = data.readTypedObject(AidlInputGestureData.Trigger.CREATOR);
                    data.enforceNoDataAvail();
                    AidlInputGestureData _result = this.getInputGesture(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeTypedObject(_result, 1);
                    break;
                }
                case 75: {
                    int _arg0 = data.readInt();
                    AidlInputGestureData _arg1 = data.readTypedObject(AidlInputGestureData.CREATOR);
                    data.enforceNoDataAvail();
                    int _result = this.addCustomInputGesture(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    break;
                }
                case 76: {
                    int _arg0 = data.readInt();
                    AidlInputGestureData _arg1 = data.readTypedObject(AidlInputGestureData.CREATOR);
                    data.enforceNoDataAvail();
                    int _result = this.removeCustomInputGesture(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    break;
                }
                case 77: {
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    this.removeAllCustomInputGestures(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 78: {
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    Parcelable[] _result = this.getCustomInputGestures(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeTypedArray(_result, 1);
                    break;
                }
                case 79: {
                    Parcelable[] _result = this.getAppLaunchBookmarks();
                    reply.writeNoException();
                    reply.writeTypedArray(_result, 1);
                    break;
                }
                case 80: {
                    this.resetLockedModifierState();
                    reply.writeNoException();
                    break;
                }
                default: {
                    return super.onTransact(code, data, reply, flags);
                }
            }
            return true;
        }

        protected void setKeyboardLayoutOverrideForInputDevice_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.SET_KEYBOARD_LAYOUT", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void setKeyboardLayoutForInputDevice_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.SET_KEYBOARD_LAYOUT", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void remapModifierKey_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.REMAP_MODIFIER_KEYS", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void clearAllModifierKeyRemappings_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.REMAP_MODIFIER_KEYS", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void getModifierKeyRemapping_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.REMAP_MODIFIER_KEYS", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void registerKeyEventActivityListener_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.LISTEN_FOR_KEY_ACTIVITY", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void unregisterKeyEventActivityListener_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.LISTEN_FOR_KEY_ACTIVITY", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void getInputDeviceBluetoothAddress_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.BLUETOOTH", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void pilferPointers_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.MONITOR_INPUT", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void registerKeyboardBacklightListener_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.MONITOR_KEYBOARD_BACKLIGHT", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void unregisterKeyboardBacklightListener_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.MONITOR_KEYBOARD_BACKLIGHT", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void registerStickyModifierStateListener_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.MONITOR_STICKY_MODIFIER_STATE", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void unregisterStickyModifierStateListener_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.MONITOR_STICKY_MODIFIER_STATE", Stub.getCallingPid(), Stub.getCallingUid());
        }

        @Override
        public int getMaxTransactionId() {
            return 79;
        }

        private static class Proxy
        implements IInputManager {
            private IBinder mRemote;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return Stub.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public String getVelocityTrackerStrategy() throws RemoteException {
                String _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(1, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readString();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public InputDevice getInputDevice(int deviceId) throws RemoteException {
                InputDevice _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(deviceId);
                    boolean _status = this.mRemote.transact(2, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readTypedObject(InputDevice.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int[] getInputDeviceIds() throws RemoteException {
                int[] _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(3, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.createIntArray();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void enableInputDevice(int deviceId) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(deviceId);
                    boolean _status = this.mRemote.transact(4, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void disableInputDevice(int deviceId) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(deviceId);
                    boolean _status = this.mRemote.transact(5, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean hasKeys(int deviceId, int sourceMask, int[] keyCodes, boolean[] keyExists) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(deviceId);
                    _data.writeInt(sourceMask);
                    _data.writeIntArray(keyCodes);
                    _data.writeInt(keyExists.length);
                    boolean _status = this.mRemote.transact(6, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                    _reply.readBooleanArray(keyExists);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int getKeyCodeForKeyLocation(int deviceId, int locationKeyCode) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(deviceId);
                    _data.writeInt(locationKeyCode);
                    boolean _status = this.mRemote.transact(7, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public KeyCharacterMap getKeyCharacterMap(String layoutDescriptor) throws RemoteException {
                KeyCharacterMap _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(layoutDescriptor);
                    boolean _status = this.mRemote.transact(8, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readTypedObject(KeyCharacterMap.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int getMousePointerSpeed() throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(9, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void tryPointerSpeed(int speed) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(speed);
                    boolean _status = this.mRemote.transact(10, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean injectInputEvent(InputEvent ev, int mode) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(ev, 0);
                    _data.writeInt(mode);
                    boolean _status = this.mRemote.transact(11, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean injectInputEventToTarget(InputEvent ev, int mode, int targetUid) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(ev, 0);
                    _data.writeInt(mode);
                    _data.writeInt(targetUid);
                    boolean _status = this.mRemote.transact(12, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public VerifiedInputEvent verifyInputEvent(InputEvent ev) throws RemoteException {
                VerifiedInputEvent _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(ev, 0);
                    boolean _status = this.mRemote.transact(13, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readTypedObject(VerifiedInputEvent.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public TouchCalibration getTouchCalibrationForInputDevice(String inputDeviceDescriptor, int rotation) throws RemoteException {
                TouchCalibration _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(inputDeviceDescriptor);
                    _data.writeInt(rotation);
                    boolean _status = this.mRemote.transact(14, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readTypedObject(TouchCalibration.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setTouchCalibrationForInputDevice(String inputDeviceDescriptor, int rotation, TouchCalibration calibration) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(inputDeviceDescriptor);
                    _data.writeInt(rotation);
                    _data.writeTypedObject(calibration, 0);
                    boolean _status = this.mRemote.transact(15, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public KeyboardLayout[] getKeyboardLayouts() throws RemoteException {
                KeyboardLayout[] _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(16, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.createTypedArray(KeyboardLayout.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public KeyboardLayout getKeyboardLayout(String keyboardLayoutDescriptor) throws RemoteException {
                KeyboardLayout _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(keyboardLayoutDescriptor);
                    boolean _status = this.mRemote.transact(17, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readTypedObject(KeyboardLayout.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public KeyboardLayoutSelectionResult getKeyboardLayoutForInputDevice(InputDeviceIdentifier identifier, int userId, InputMethodInfo imeInfo, InputMethodSubtype imeSubtype) throws RemoteException {
                KeyboardLayoutSelectionResult _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(identifier, 0);
                    _data.writeInt(userId);
                    _data.writeTypedObject(imeInfo, 0);
                    _data.writeTypedObject(imeSubtype, 0);
                    boolean _status = this.mRemote.transact(18, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readTypedObject(KeyboardLayoutSelectionResult.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setKeyboardLayoutOverrideForInputDevice(InputDeviceIdentifier identifier, String keyboardLayoutDescriptor) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(identifier, 0);
                    _data.writeString(keyboardLayoutDescriptor);
                    boolean _status = this.mRemote.transact(19, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setKeyboardLayoutForInputDevice(InputDeviceIdentifier identifier, int userId, InputMethodInfo imeInfo, InputMethodSubtype imeSubtype, String keyboardLayoutDescriptor) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(identifier, 0);
                    _data.writeInt(userId);
                    _data.writeTypedObject(imeInfo, 0);
                    _data.writeTypedObject(imeSubtype, 0);
                    _data.writeString(keyboardLayoutDescriptor);
                    boolean _status = this.mRemote.transact(20, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public KeyboardLayout[] getKeyboardLayoutListForInputDevice(InputDeviceIdentifier identifier, int userId, InputMethodInfo imeInfo, InputMethodSubtype imeSubtype) throws RemoteException {
                KeyboardLayout[] _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(identifier, 0);
                    _data.writeInt(userId);
                    _data.writeTypedObject(imeInfo, 0);
                    _data.writeTypedObject(imeSubtype, 0);
                    boolean _status = this.mRemote.transact(21, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.createTypedArray(KeyboardLayout.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void remapModifierKey(int fromKey, int toKey) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(fromKey);
                    _data.writeInt(toKey);
                    boolean _status = this.mRemote.transact(22, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void clearAllModifierKeyRemappings() throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(23, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Map getModifierKeyRemapping() throws RemoteException {
                HashMap _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(24, _data, _reply, 0);
                    _reply.readException();
                    ClassLoader cl = this.getClass().getClassLoader();
                    _result = _reply.readHashMap(cl);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void registerInputDevicesChangedListener(IInputDevicesChangedListener listener) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(listener);
                    boolean _status = this.mRemote.transact(25, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int isInTabletMode() throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(26, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void registerTabletModeChangedListener(ITabletModeChangedListener listener) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(listener);
                    boolean _status = this.mRemote.transact(27, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int isMicMuted() throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(28, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void vibrate(int deviceId, VibrationEffect effect, IBinder token) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(deviceId);
                    _data.writeTypedObject(effect, 0);
                    _data.writeStrongBinder(token);
                    boolean _status = this.mRemote.transact(29, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void vibrateCombined(int deviceId, CombinedVibration vibration, IBinder token) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(deviceId);
                    _data.writeTypedObject(vibration, 0);
                    _data.writeStrongBinder(token);
                    boolean _status = this.mRemote.transact(30, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void cancelVibrate(int deviceId, IBinder token) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(deviceId);
                    _data.writeStrongBinder(token);
                    boolean _status = this.mRemote.transact(31, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int[] getVibratorIds(int deviceId) throws RemoteException {
                int[] _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(deviceId);
                    boolean _status = this.mRemote.transact(32, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.createIntArray();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isVibrating(int deviceId) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(deviceId);
                    boolean _status = this.mRemote.transact(33, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean registerVibratorStateListener(int deviceId, IVibratorStateListener listener) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(deviceId);
                    _data.writeStrongInterface(listener);
                    boolean _status = this.mRemote.transact(34, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean unregisterVibratorStateListener(int deviceId, IVibratorStateListener listener) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(deviceId);
                    _data.writeStrongInterface(listener);
                    boolean _status = this.mRemote.transact(35, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public IInputDeviceBatteryState getBatteryState(int deviceId) throws RemoteException {
                IInputDeviceBatteryState _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(deviceId);
                    boolean _status = this.mRemote.transact(36, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readTypedObject(IInputDeviceBatteryState.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean setPointerIcon(PointerIcon icon, int displayId, int deviceId, int pointerId, IBinder inputToken) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(icon, 0);
                    _data.writeInt(displayId);
                    _data.writeInt(deviceId);
                    _data.writeInt(pointerId);
                    _data.writeStrongBinder(inputToken);
                    boolean _status = this.mRemote.transact(37, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void requestPointerCapture(IBinder inputChannelToken, boolean enabled) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongBinder(inputChannelToken);
                    _data.writeBoolean(enabled);
                    boolean bl = this.mRemote.transact(38, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public InputMonitor monitorGestureInput(IBinder token, String name, int displayId) throws RemoteException {
                InputMonitor _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongBinder(token);
                    _data.writeString(name);
                    _data.writeInt(displayId);
                    boolean _status = this.mRemote.transact(39, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readTypedObject(InputMonitor.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void addPortAssociation(String inputPort, int displayPort) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(inputPort);
                    _data.writeInt(displayPort);
                    boolean _status = this.mRemote.transact(40, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void removePortAssociation(String inputPort) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(inputPort);
                    boolean _status = this.mRemote.transact(41, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void addUniqueIdAssociationByDescriptor(String inputDeviceDescriptor, String displayUniqueId) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(inputDeviceDescriptor);
                    _data.writeString(displayUniqueId);
                    boolean _status = this.mRemote.transact(42, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void removeUniqueIdAssociationByDescriptor(String inputDeviceDescriptor) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(inputDeviceDescriptor);
                    boolean _status = this.mRemote.transact(43, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void addUniqueIdAssociationByPort(String inputPort, String displayUniqueId) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(inputPort);
                    _data.writeString(displayUniqueId);
                    boolean _status = this.mRemote.transact(44, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void removeUniqueIdAssociationByPort(String inputPort) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(inputPort);
                    boolean _status = this.mRemote.transact(45, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public InputSensorInfo[] getSensorList(int deviceId) throws RemoteException {
                InputSensorInfo[] _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(deviceId);
                    boolean _status = this.mRemote.transact(46, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.createTypedArray(InputSensorInfo.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean registerSensorListener(IInputSensorEventListener listener) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(listener);
                    boolean _status = this.mRemote.transact(47, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void unregisterSensorListener(IInputSensorEventListener listener) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(listener);
                    boolean _status = this.mRemote.transact(48, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean enableSensor(int deviceId, int sensorType, int samplingPeriodUs, int maxBatchReportLatencyUs) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(deviceId);
                    _data.writeInt(sensorType);
                    _data.writeInt(samplingPeriodUs);
                    _data.writeInt(maxBatchReportLatencyUs);
                    boolean _status = this.mRemote.transact(49, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void disableSensor(int deviceId, int sensorType) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(deviceId);
                    _data.writeInt(sensorType);
                    boolean _status = this.mRemote.transact(50, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean flushSensor(int deviceId, int sensorType) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(deviceId);
                    _data.writeInt(sensorType);
                    boolean _status = this.mRemote.transact(51, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public List<Light> getLights(int deviceId) throws RemoteException {
                ArrayList<Light> _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(deviceId);
                    boolean _status = this.mRemote.transact(52, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.createTypedArrayList(Light.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public LightState getLightState(int deviceId, int lightId) throws RemoteException {
                LightState _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(deviceId);
                    _data.writeInt(lightId);
                    boolean _status = this.mRemote.transact(53, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readTypedObject(LightState.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setLightStates(int deviceId, int[] lightIds, LightState[] states, IBinder token) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(deviceId);
                    _data.writeIntArray(lightIds);
                    _data.writeTypedArray(states, 0);
                    _data.writeStrongBinder(token);
                    boolean _status = this.mRemote.transact(54, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void openLightSession(int deviceId, String opPkg, IBinder token) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(deviceId);
                    _data.writeString(opPkg);
                    _data.writeStrongBinder(token);
                    boolean _status = this.mRemote.transact(55, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void closeLightSession(int deviceId, IBinder token) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(deviceId);
                    _data.writeStrongBinder(token);
                    boolean _status = this.mRemote.transact(56, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void cancelCurrentTouch() throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(57, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void registerBatteryListener(int deviceId, IInputDeviceBatteryListener listener) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(deviceId);
                    _data.writeStrongInterface(listener);
                    boolean _status = this.mRemote.transact(58, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void unregisterBatteryListener(int deviceId, IInputDeviceBatteryListener listener) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(deviceId);
                    _data.writeStrongInterface(listener);
                    boolean _status = this.mRemote.transact(59, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean registerKeyEventActivityListener(IKeyEventActivityListener listener) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(listener);
                    boolean _status = this.mRemote.transact(60, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean unregisterKeyEventActivityListener(IKeyEventActivityListener listener) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(listener);
                    boolean _status = this.mRemote.transact(61, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public String getInputDeviceBluetoothAddress(int deviceId) throws RemoteException {
                String _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(deviceId);
                    boolean _status = this.mRemote.transact(62, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readString();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void pilferPointers(IBinder inputChannelToken) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongBinder(inputChannelToken);
                    boolean _status = this.mRemote.transact(63, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void registerKeyboardBacklightListener(IKeyboardBacklightListener listener) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(listener);
                    boolean _status = this.mRemote.transact(64, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void unregisterKeyboardBacklightListener(IKeyboardBacklightListener listener) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(listener);
                    boolean _status = this.mRemote.transact(65, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public HostUsiVersion getHostUsiVersionFromDisplayConfig(int displayId) throws RemoteException {
                HostUsiVersion _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(displayId);
                    boolean _status = this.mRemote.transact(66, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readTypedObject(HostUsiVersion.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void registerStickyModifierStateListener(IStickyModifierStateListener listener) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(listener);
                    boolean _status = this.mRemote.transact(67, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void unregisterStickyModifierStateListener(IStickyModifierStateListener listener) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(listener);
                    boolean _status = this.mRemote.transact(68, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public KeyGlyphMap getKeyGlyphMap(int deviceId) throws RemoteException {
                KeyGlyphMap _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(deviceId);
                    boolean _status = this.mRemote.transact(69, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readTypedObject(KeyGlyphMap.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void registerKeyGestureEventListener(IKeyGestureEventListener listener) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(listener);
                    boolean _status = this.mRemote.transact(70, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void unregisterKeyGestureEventListener(IKeyGestureEventListener listener) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(listener);
                    boolean _status = this.mRemote.transact(71, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void registerKeyGestureHandler(int[] keyGesturesToHandle, IKeyGestureHandler handler) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeIntArray(keyGesturesToHandle);
                    _data.writeStrongInterface(handler);
                    boolean _status = this.mRemote.transact(72, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void unregisterKeyGestureHandler(IKeyGestureHandler handler) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(handler);
                    boolean _status = this.mRemote.transact(73, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public AidlInputGestureData getInputGesture(int userId, AidlInputGestureData.Trigger trigger) throws RemoteException {
                AidlInputGestureData _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(userId);
                    _data.writeTypedObject(trigger, 0);
                    boolean _status = this.mRemote.transact(74, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readTypedObject(AidlInputGestureData.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int addCustomInputGesture(int userId, AidlInputGestureData data) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(userId);
                    _data.writeTypedObject(data, 0);
                    boolean _status = this.mRemote.transact(75, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int removeCustomInputGesture(int userId, AidlInputGestureData data) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(userId);
                    _data.writeTypedObject(data, 0);
                    boolean _status = this.mRemote.transact(76, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void removeAllCustomInputGestures(int userId, int tag) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(userId);
                    _data.writeInt(tag);
                    boolean _status = this.mRemote.transact(77, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public AidlInputGestureData[] getCustomInputGestures(int userId, int tag) throws RemoteException {
                AidlInputGestureData[] _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(userId);
                    _data.writeInt(tag);
                    boolean _status = this.mRemote.transact(78, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.createTypedArray(AidlInputGestureData.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public AidlInputGestureData[] getAppLaunchBookmarks() throws RemoteException {
                AidlInputGestureData[] _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(79, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.createTypedArray(AidlInputGestureData.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void resetLockedModifierState() throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(80, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }
        }
    }

    public static class Default
    implements IInputManager {
        @Override
        public String getVelocityTrackerStrategy() throws RemoteException {
            return null;
        }

        @Override
        public InputDevice getInputDevice(int deviceId) throws RemoteException {
            return null;
        }

        @Override
        public int[] getInputDeviceIds() throws RemoteException {
            return null;
        }

        @Override
        public void enableInputDevice(int deviceId) throws RemoteException {
        }

        @Override
        public void disableInputDevice(int deviceId) throws RemoteException {
        }

        @Override
        public boolean hasKeys(int deviceId, int sourceMask, int[] keyCodes, boolean[] keyExists) throws RemoteException {
            return false;
        }

        @Override
        public int getKeyCodeForKeyLocation(int deviceId, int locationKeyCode) throws RemoteException {
            return 0;
        }

        @Override
        public KeyCharacterMap getKeyCharacterMap(String layoutDescriptor) throws RemoteException {
            return null;
        }

        @Override
        public int getMousePointerSpeed() throws RemoteException {
            return 0;
        }

        @Override
        public void tryPointerSpeed(int speed) throws RemoteException {
        }

        @Override
        public boolean injectInputEvent(InputEvent ev, int mode) throws RemoteException {
            return false;
        }

        @Override
        public boolean injectInputEventToTarget(InputEvent ev, int mode, int targetUid) throws RemoteException {
            return false;
        }

        @Override
        public VerifiedInputEvent verifyInputEvent(InputEvent ev) throws RemoteException {
            return null;
        }

        @Override
        public TouchCalibration getTouchCalibrationForInputDevice(String inputDeviceDescriptor, int rotation) throws RemoteException {
            return null;
        }

        @Override
        public void setTouchCalibrationForInputDevice(String inputDeviceDescriptor, int rotation, TouchCalibration calibration) throws RemoteException {
        }

        @Override
        public KeyboardLayout[] getKeyboardLayouts() throws RemoteException {
            return null;
        }

        @Override
        public KeyboardLayout getKeyboardLayout(String keyboardLayoutDescriptor) throws RemoteException {
            return null;
        }

        @Override
        public KeyboardLayoutSelectionResult getKeyboardLayoutForInputDevice(InputDeviceIdentifier identifier, int userId, InputMethodInfo imeInfo, InputMethodSubtype imeSubtype) throws RemoteException {
            return null;
        }

        @Override
        public void setKeyboardLayoutOverrideForInputDevice(InputDeviceIdentifier identifier, String keyboardLayoutDescriptor) throws RemoteException {
        }

        @Override
        public void setKeyboardLayoutForInputDevice(InputDeviceIdentifier identifier, int userId, InputMethodInfo imeInfo, InputMethodSubtype imeSubtype, String keyboardLayoutDescriptor) throws RemoteException {
        }

        @Override
        public KeyboardLayout[] getKeyboardLayoutListForInputDevice(InputDeviceIdentifier identifier, int userId, InputMethodInfo imeInfo, InputMethodSubtype imeSubtype) throws RemoteException {
            return null;
        }

        @Override
        public void remapModifierKey(int fromKey, int toKey) throws RemoteException {
        }

        @Override
        public void clearAllModifierKeyRemappings() throws RemoteException {
        }

        @Override
        public Map getModifierKeyRemapping() throws RemoteException {
            return null;
        }

        @Override
        public void registerInputDevicesChangedListener(IInputDevicesChangedListener listener) throws RemoteException {
        }

        @Override
        public int isInTabletMode() throws RemoteException {
            return 0;
        }

        @Override
        public void registerTabletModeChangedListener(ITabletModeChangedListener listener) throws RemoteException {
        }

        @Override
        public int isMicMuted() throws RemoteException {
            return 0;
        }

        @Override
        public void vibrate(int deviceId, VibrationEffect effect, IBinder token) throws RemoteException {
        }

        @Override
        public void vibrateCombined(int deviceId, CombinedVibration vibration, IBinder token) throws RemoteException {
        }

        @Override
        public void cancelVibrate(int deviceId, IBinder token) throws RemoteException {
        }

        @Override
        public int[] getVibratorIds(int deviceId) throws RemoteException {
            return null;
        }

        @Override
        public boolean isVibrating(int deviceId) throws RemoteException {
            return false;
        }

        @Override
        public boolean registerVibratorStateListener(int deviceId, IVibratorStateListener listener) throws RemoteException {
            return false;
        }

        @Override
        public boolean unregisterVibratorStateListener(int deviceId, IVibratorStateListener listener) throws RemoteException {
            return false;
        }

        @Override
        public IInputDeviceBatteryState getBatteryState(int deviceId) throws RemoteException {
            return null;
        }

        @Override
        public boolean setPointerIcon(PointerIcon icon, int displayId, int deviceId, int pointerId, IBinder inputToken) throws RemoteException {
            return false;
        }

        @Override
        public void requestPointerCapture(IBinder inputChannelToken, boolean enabled) throws RemoteException {
        }

        @Override
        public InputMonitor monitorGestureInput(IBinder token, String name, int displayId) throws RemoteException {
            return null;
        }

        @Override
        public void addPortAssociation(String inputPort, int displayPort) throws RemoteException {
        }

        @Override
        public void removePortAssociation(String inputPort) throws RemoteException {
        }

        @Override
        public void addUniqueIdAssociationByDescriptor(String inputDeviceDescriptor, String displayUniqueId) throws RemoteException {
        }

        @Override
        public void removeUniqueIdAssociationByDescriptor(String inputDeviceDescriptor) throws RemoteException {
        }

        @Override
        public void addUniqueIdAssociationByPort(String inputPort, String displayUniqueId) throws RemoteException {
        }

        @Override
        public void removeUniqueIdAssociationByPort(String inputPort) throws RemoteException {
        }

        @Override
        public InputSensorInfo[] getSensorList(int deviceId) throws RemoteException {
            return null;
        }

        @Override
        public boolean registerSensorListener(IInputSensorEventListener listener) throws RemoteException {
            return false;
        }

        @Override
        public void unregisterSensorListener(IInputSensorEventListener listener) throws RemoteException {
        }

        @Override
        public boolean enableSensor(int deviceId, int sensorType, int samplingPeriodUs, int maxBatchReportLatencyUs) throws RemoteException {
            return false;
        }

        @Override
        public void disableSensor(int deviceId, int sensorType) throws RemoteException {
        }

        @Override
        public boolean flushSensor(int deviceId, int sensorType) throws RemoteException {
            return false;
        }

        @Override
        public List<Light> getLights(int deviceId) throws RemoteException {
            return null;
        }

        @Override
        public LightState getLightState(int deviceId, int lightId) throws RemoteException {
            return null;
        }

        @Override
        public void setLightStates(int deviceId, int[] lightIds, LightState[] states, IBinder token) throws RemoteException {
        }

        @Override
        public void openLightSession(int deviceId, String opPkg, IBinder token) throws RemoteException {
        }

        @Override
        public void closeLightSession(int deviceId, IBinder token) throws RemoteException {
        }

        @Override
        public void cancelCurrentTouch() throws RemoteException {
        }

        @Override
        public void registerBatteryListener(int deviceId, IInputDeviceBatteryListener listener) throws RemoteException {
        }

        @Override
        public void unregisterBatteryListener(int deviceId, IInputDeviceBatteryListener listener) throws RemoteException {
        }

        @Override
        public boolean registerKeyEventActivityListener(IKeyEventActivityListener listener) throws RemoteException {
            return false;
        }

        @Override
        public boolean unregisterKeyEventActivityListener(IKeyEventActivityListener listener) throws RemoteException {
            return false;
        }

        @Override
        public String getInputDeviceBluetoothAddress(int deviceId) throws RemoteException {
            return null;
        }

        @Override
        public void pilferPointers(IBinder inputChannelToken) throws RemoteException {
        }

        @Override
        public void registerKeyboardBacklightListener(IKeyboardBacklightListener listener) throws RemoteException {
        }

        @Override
        public void unregisterKeyboardBacklightListener(IKeyboardBacklightListener listener) throws RemoteException {
        }

        @Override
        public HostUsiVersion getHostUsiVersionFromDisplayConfig(int displayId) throws RemoteException {
            return null;
        }

        @Override
        public void registerStickyModifierStateListener(IStickyModifierStateListener listener) throws RemoteException {
        }

        @Override
        public void unregisterStickyModifierStateListener(IStickyModifierStateListener listener) throws RemoteException {
        }

        @Override
        public KeyGlyphMap getKeyGlyphMap(int deviceId) throws RemoteException {
            return null;
        }

        @Override
        public void registerKeyGestureEventListener(IKeyGestureEventListener listener) throws RemoteException {
        }

        @Override
        public void unregisterKeyGestureEventListener(IKeyGestureEventListener listener) throws RemoteException {
        }

        @Override
        public void registerKeyGestureHandler(int[] keyGesturesToHandle, IKeyGestureHandler handler) throws RemoteException {
        }

        @Override
        public void unregisterKeyGestureHandler(IKeyGestureHandler handler) throws RemoteException {
        }

        @Override
        public AidlInputGestureData getInputGesture(int userId, AidlInputGestureData.Trigger trigger) throws RemoteException {
            return null;
        }

        @Override
        public int addCustomInputGesture(int userId, AidlInputGestureData data) throws RemoteException {
            return 0;
        }

        @Override
        public int removeCustomInputGesture(int userId, AidlInputGestureData data) throws RemoteException {
            return 0;
        }

        @Override
        public void removeAllCustomInputGestures(int userId, int tag) throws RemoteException {
        }

        @Override
        public AidlInputGestureData[] getCustomInputGestures(int userId, int tag) throws RemoteException {
            return null;
        }

        @Override
        public AidlInputGestureData[] getAppLaunchBookmarks() throws RemoteException {
            return null;
        }

        @Override
        public void resetLockedModifierState() throws RemoteException {
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

