/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.input;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.text.TextUtils;
import java.util.Objects;

public interface AppLaunchData {
    @NonNull
    public static AppLaunchData createLaunchDataForCategory(@NonNull String category) {
        return new CategoryData(category);
    }

    @NonNull
    public static AppLaunchData createLaunchDataForRole(@NonNull String role) {
        return new RoleData(role);
    }

    @NonNull
    public static AppLaunchData createLaunchDataForComponent(@NonNull String packageName, @NonNull String className) {
        return new ComponentData(packageName, className);
    }

    @Nullable
    public static AppLaunchData createLaunchData(@Nullable String category, @Nullable String role, @Nullable String packageName, @Nullable String className) {
        if (!TextUtils.isEmpty(category)) {
            return new CategoryData(category);
        }
        if (!TextUtils.isEmpty(role)) {
            return new RoleData(role);
        }
        if (!TextUtils.isEmpty(packageName) && !TextUtils.isEmpty(className)) {
            return new ComponentData(packageName, className);
        }
        return null;
    }

    public static class CategoryData
    implements AppLaunchData {
        @NonNull
        private final String mCategory;

        public CategoryData(@NonNull String category) {
            this.mCategory = category;
        }

        @NonNull
        public String getCategory() {
            return this.mCategory;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof CategoryData)) {
                return false;
            }
            CategoryData that = (CategoryData)o;
            return Objects.equals(this.mCategory, that.mCategory);
        }

        public int hashCode() {
            return Objects.hash(this.mCategory);
        }

        public String toString() {
            return "CategoryData{mCategory='" + this.mCategory + '\'' + '}';
        }
    }

    public static class RoleData
    implements AppLaunchData {
        @NonNull
        private final String mRole;

        public RoleData(@NonNull String role) {
            this.mRole = role;
        }

        @NonNull
        public String getRole() {
            return this.mRole;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof RoleData)) {
                return false;
            }
            RoleData roleData = (RoleData)o;
            return Objects.equals(this.mRole, roleData.mRole);
        }

        public int hashCode() {
            return Objects.hash(this.mRole);
        }

        public String toString() {
            return "RoleData{mRole='" + this.mRole + '\'' + '}';
        }
    }

    public static class ComponentData
    implements AppLaunchData {
        @NonNull
        private final String mPackageName;
        @NonNull
        private final String mClassName;

        public ComponentData(@NonNull String packageName, @NonNull String className) {
            this.mPackageName = packageName;
            this.mClassName = className;
        }

        @NonNull
        public String getPackageName() {
            return this.mPackageName;
        }

        @NonNull
        public String getClassName() {
            return this.mClassName;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof ComponentData)) {
                return false;
            }
            ComponentData that = (ComponentData)o;
            return Objects.equals(this.mPackageName, that.mPackageName) && Objects.equals(this.mClassName, that.mClassName);
        }

        public int hashCode() {
            return Objects.hash(this.mPackageName, this.mClassName);
        }

        public String toString() {
            return "ComponentData{mPackageName='" + this.mPackageName + '\'' + ", mClassName='" + this.mClassName + '\'' + '}';
        }
    }
}

