/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.face;

import android.annotation.NonNull;
import android.content.Context;
import android.hardware.biometrics.common.CommonProps;
import android.hardware.biometrics.face.SensorProps;

public class HidlFaceSensorConfig
extends SensorProps {
    private int mSensorId;
    private int mModality;
    private int mStrength;

    public void parse(@NonNull String config, @NonNull Context context) throws IllegalArgumentException {
        String[] elems = config.split(":");
        if (elems.length < 3) {
            throw new IllegalArgumentException();
        }
        this.mSensorId = Integer.parseInt(elems[0]);
        this.mModality = Integer.parseInt(elems[1]);
        this.mStrength = Integer.parseInt(elems[2]);
        this.mapHidlToAidlFaceSensorConfigurations(context);
    }

    public int getModality() {
        return this.mModality;
    }

    private void mapHidlToAidlFaceSensorConfigurations(@NonNull Context context) {
        this.commonProps = new CommonProps();
        this.commonProps.sensorId = this.mSensorId;
        this.commonProps.sensorStrength = this.authenticatorStrengthToPropertyStrength(this.mStrength);
        this.halControlsPreview = context.getResources().getBoolean(17891752);
        this.commonProps.maxEnrollmentsPerUser = context.getResources().getInteger(17694878);
        this.commonProps.componentInfo = null;
        this.supportsDetectInteraction = false;
    }

    private byte authenticatorStrengthToPropertyStrength(int strength) {
        switch (strength) {
            case 4095: {
                return 0;
            }
            case 255: {
                return 1;
            }
            case 15: {
                return 2;
            }
        }
        throw new IllegalArgumentException("Unknown strength: " + strength);
    }
}

