/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.face;

import android.annotation.Nullable;
import android.content.Context;
import android.hardware.biometrics.face.IFace;
import android.hardware.biometrics.face.SensorProps;
import android.hardware.biometrics.face.virtualhal.IVirtualHal;
import android.hardware.face.HidlFaceSensorConfig;
import android.os.Binder;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.util.Log;
import android.util.Slog;
import com.android.layoutlib.androidx.annotation.NonNull;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;

public class FaceSensorConfigurations
implements Parcelable {
    private static final String TAG = "FaceSensorConfigurations";
    private final boolean mResetLockoutRequiresChallenge;
    private final Map<String, SensorProps[]> mSensorPropsMap;
    public static final Parcelable.Creator<FaceSensorConfigurations> CREATOR = new Parcelable.Creator<FaceSensorConfigurations>(){

        @Override
        public FaceSensorConfigurations createFromParcel(Parcel in) {
            return new FaceSensorConfigurations(in);
        }

        public FaceSensorConfigurations[] newArray(int size) {
            return new FaceSensorConfigurations[size];
        }
    };

    public FaceSensorConfigurations(boolean resetLockoutRequiresChallenge) {
        this.mResetLockoutRequiresChallenge = resetLockoutRequiresChallenge;
        this.mSensorPropsMap = new HashMap<String, SensorProps[]>();
    }

    protected FaceSensorConfigurations(Parcel in) {
        this.mResetLockoutRequiresChallenge = in.readByte() != 0;
        this.mSensorPropsMap = in.readHashMap(null, String.class, SensorProps[].class);
    }

    public void addAidlConfigs(@NonNull String[] aidlInstances) {
        for (String aidlInstance : aidlInstances) {
            this.mSensorPropsMap.put(aidlInstance, null);
        }
    }

    public void addHidlConfigs(@NonNull String[] hidlConfigStrings, @NonNull Context context) {
        ArrayList<HidlFaceSensorConfig> hidlFaceSensorConfigs = new ArrayList<HidlFaceSensorConfig>();
        for (String hidlConfig : hidlConfigStrings) {
            HidlFaceSensorConfig hidlFaceSensorConfig = new HidlFaceSensorConfig();
            try {
                hidlFaceSensorConfig.parse(hidlConfig, context);
            }
            catch (Exception e) {
                Log.e(TAG, "HIDL sensor configuration format is incorrect.");
                continue;
            }
            if (hidlFaceSensorConfig.getModality() != 8) continue;
            hidlFaceSensorConfigs.add(hidlFaceSensorConfig);
        }
        String hidlHalInstanceName = "defaultHIDL";
        this.mSensorPropsMap.put("defaultHIDL", hidlFaceSensorConfigs.toArray(new SensorProps[hidlFaceSensorConfigs.size()]));
    }

    public boolean hasSensorConfigurations() {
        return this.mSensorPropsMap.size() > 0;
    }

    public boolean isSingleSensorConfigurationPresent() {
        return this.mSensorPropsMap.size() == 1;
    }

    @Nullable
    public boolean doesInstanceExist(String instance) {
        return this.mSensorPropsMap.containsKey(instance);
    }

    @Nullable
    public String getSensorNameNotForInstance(String instance) {
        Optional<String> notAVirtualInstance = this.mSensorPropsMap.keySet().stream().filter(instanceName -> !instanceName.equals(instance)).findFirst();
        return notAVirtualInstance.orElse(null);
    }

    @Nullable
    public String getSensorInstance() {
        Optional optionalInstance = this.mSensorPropsMap.keySet().stream().findFirst();
        return optionalInstance.orElse(null);
    }

    public boolean getResetLockoutRequiresChallenge() {
        return this.mResetLockoutRequiresChallenge;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(@NonNull Parcel dest, int flags) {
        dest.writeByte((byte)(this.mResetLockoutRequiresChallenge ? 1 : 0));
        dest.writeMap(this.mSensorPropsMap);
    }

    public static String remapFqName(String fqName) {
        if (!fqName.contains(IFace.DESCRIPTOR + "/virtual")) {
            return fqName;
        }
        return fqName.replace("IFace", "virtualhal.IVirtualHal");
    }

    public static IFace getIFace(String fqName) {
        if (fqName.contains("virtual")) {
            String fqNameMapped = FaceSensorConfigurations.remapFqName(fqName);
            Slog.i(TAG, "getIFace fqName is mapped: " + fqName + "->" + fqNameMapped);
            try {
                IVirtualHal vhal = IVirtualHal.Stub.asInterface(Binder.allowBlocking(ServiceManager.waitForService((String)fqNameMapped)));
                return vhal.getFaceHal();
            }
            catch (RemoteException e) {
                Slog.e(TAG, "Remote exception in vhal.getFaceHal() call" + fqNameMapped);
            }
        }
        return IFace.Stub.asInterface(Binder.allowBlocking(ServiceManager.waitForDeclaredService((String)fqName)));
    }

    @Nullable
    public SensorProps[] getSensorPropForInstance(String instance) {
        SensorProps[] props = this.mSensorPropsMap.get(instance);
        if (props != null) {
            return props;
        }
        try {
            String fqName = IFace.DESCRIPTOR + "/" + instance;
            IFace fp = FaceSensorConfigurations.getIFace(fqName);
            if (fp != null) {
                props = fp.getSensorProps();
            } else {
                Log.d(TAG, "IFace null for instance " + instance);
            }
        }
        catch (RemoteException e) {
            Log.d(TAG, "Unable to get sensor properties!");
        }
        return props;
    }
}

