/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.display;

import android.annotation.EnforcePermission;
import android.app.ActivityThread;
import android.compat.annotation.UnsupportedAppUsage;
import android.content.pm.ParceledListSlice;
import android.graphics.Point;
import android.hardware.OverlayProperties;
import android.hardware.display.BrightnessConfiguration;
import android.hardware.display.BrightnessInfo;
import android.hardware.display.Curve;
import android.hardware.display.DisplayTopology;
import android.hardware.display.HdrConversionMode;
import android.hardware.display.IDisplayManagerCallback;
import android.hardware.display.IVirtualDisplayCallback;
import android.hardware.display.VirtualDisplayConfig;
import android.hardware.display.WifiDisplayStatus;
import android.hardware.graphics.common.DisplayDecorationSupport;
import android.media.projection.IMediaProjection;
import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.PermissionEnforcer;
import android.os.RemoteException;
import android.view.Display;
import android.view.DisplayInfo;
import android.view.Surface;

public interface IDisplayManager
extends IInterface {
    @UnsupportedAppUsage(overrideSourcePosition="frameworks/base/core/java/android/hardware/display/IDisplayManager.aidl:40:1:40:25")
    public DisplayInfo getDisplayInfo(int var1) throws RemoteException;

    public int[] getDisplayIds(boolean var1) throws RemoteException;

    public boolean isUidPresentOnDisplay(int var1, int var2) throws RemoteException;

    public void registerCallback(IDisplayManagerCallback var1) throws RemoteException;

    public void registerCallbackWithEventMask(IDisplayManagerCallback var1, long var2) throws RemoteException;

    @EnforcePermission(value="android.permission.CONFIGURE_WIFI_DISPLAY")
    public void startWifiDisplayScan() throws RemoteException;

    @EnforcePermission(value="android.permission.CONFIGURE_WIFI_DISPLAY")
    public void stopWifiDisplayScan() throws RemoteException;

    @EnforcePermission(value="android.permission.CONFIGURE_WIFI_DISPLAY")
    public void connectWifiDisplay(String var1) throws RemoteException;

    public void disconnectWifiDisplay() throws RemoteException;

    @EnforcePermission(value="android.permission.CONFIGURE_WIFI_DISPLAY")
    public void renameWifiDisplay(String var1, String var2) throws RemoteException;

    @EnforcePermission(value="android.permission.CONFIGURE_WIFI_DISPLAY")
    public void forgetWifiDisplay(String var1) throws RemoteException;

    @EnforcePermission(value="android.permission.CONFIGURE_WIFI_DISPLAY")
    public void pauseWifiDisplay() throws RemoteException;

    @EnforcePermission(value="android.permission.CONFIGURE_WIFI_DISPLAY")
    public void resumeWifiDisplay() throws RemoteException;

    public WifiDisplayStatus getWifiDisplayStatus() throws RemoteException;

    @EnforcePermission(value="android.permission.WRITE_SECURE_SETTINGS")
    public void setUserDisabledHdrTypes(int[] var1) throws RemoteException;

    @EnforcePermission(value="android.permission.WRITE_SECURE_SETTINGS")
    public void setAreUserDisabledHdrTypesAllowed(boolean var1) throws RemoteException;

    public boolean areUserDisabledHdrTypesAllowed() throws RemoteException;

    public int[] getUserDisabledHdrTypes() throws RemoteException;

    public void overrideHdrTypes(int var1, int[] var2) throws RemoteException;

    @EnforcePermission(value="android.permission.CONFIGURE_DISPLAY_COLOR_MODE")
    public void requestColorMode(int var1, int var2) throws RemoteException;

    public int createVirtualDisplay(VirtualDisplayConfig var1, IVirtualDisplayCallback var2, IMediaProjection var3, String var4) throws RemoteException;

    public void resizeVirtualDisplay(IVirtualDisplayCallback var1, int var2, int var3, int var4) throws RemoteException;

    public void setVirtualDisplaySurface(IVirtualDisplayCallback var1, Surface var2) throws RemoteException;

    public void releaseVirtualDisplay(IVirtualDisplayCallback var1) throws RemoteException;

    public void setVirtualDisplayRotation(IVirtualDisplayCallback var1, int var2) throws RemoteException;

    public Point getStableDisplaySize() throws RemoteException;

    @EnforcePermission(value="android.permission.BRIGHTNESS_SLIDER_USAGE")
    public ParceledListSlice getBrightnessEvents(String var1) throws RemoteException;

    @EnforcePermission(value="android.permission.ACCESS_AMBIENT_LIGHT_STATS")
    public ParceledListSlice getAmbientBrightnessStats() throws RemoteException;

    @EnforcePermission(value="android.permission.CONFIGURE_DISPLAY_BRIGHTNESS")
    public void setBrightnessConfigurationForUser(BrightnessConfiguration var1, int var2, String var3) throws RemoteException;

    @EnforcePermission(value="android.permission.CONFIGURE_DISPLAY_BRIGHTNESS")
    public void setBrightnessConfigurationForDisplay(BrightnessConfiguration var1, String var2, int var3, String var4) throws RemoteException;

    @EnforcePermission(value="android.permission.CONFIGURE_DISPLAY_BRIGHTNESS")
    public BrightnessConfiguration getBrightnessConfigurationForDisplay(String var1, int var2) throws RemoteException;

    public BrightnessConfiguration getBrightnessConfigurationForUser(int var1) throws RemoteException;

    @EnforcePermission(value="android.permission.CONFIGURE_DISPLAY_BRIGHTNESS")
    public BrightnessConfiguration getDefaultBrightnessConfiguration() throws RemoteException;

    public boolean isMinimalPostProcessingRequested(int var1) throws RemoteException;

    @EnforcePermission(value="android.permission.CONTROL_DISPLAY_BRIGHTNESS")
    public void setTemporaryBrightness(int var1, float var2) throws RemoteException;

    @EnforcePermission(value="android.permission.CONTROL_DISPLAY_BRIGHTNESS")
    public void setBrightness(int var1, float var2) throws RemoteException;

    @EnforcePermission(value="android.permission.CONTROL_DISPLAY_BRIGHTNESS")
    public float getBrightness(int var1) throws RemoteException;

    @EnforcePermission(value="android.permission.CONTROL_DISPLAY_BRIGHTNESS")
    public void setTemporaryAutoBrightnessAdjustment(float var1) throws RemoteException;

    public Curve getMinimumBrightnessCurve() throws RemoteException;

    @EnforcePermission(value="android.permission.CONTROL_DISPLAY_BRIGHTNESS")
    public BrightnessInfo getBrightnessInfo(int var1) throws RemoteException;

    public int getPreferredWideGamutColorSpaceId() throws RemoteException;

    @EnforcePermission(value="android.permission.MODIFY_USER_PREFERRED_DISPLAY_MODE")
    public void setUserPreferredDisplayMode(int var1, Display.Mode var2) throws RemoteException;

    public Display.Mode getUserPreferredDisplayMode(int var1) throws RemoteException;

    public Display.Mode getSystemPreferredDisplayMode(int var1) throws RemoteException;

    @EnforcePermission(value="android.permission.MODIFY_HDR_CONVERSION_MODE")
    public void setHdrConversionMode(HdrConversionMode var1) throws RemoteException;

    public HdrConversionMode getHdrConversionModeSetting() throws RemoteException;

    public HdrConversionMode getHdrConversionMode() throws RemoteException;

    public int[] getSupportedHdrOutputTypes() throws RemoteException;

    @EnforcePermission(value="android.permission.OVERRIDE_DISPLAY_MODE_REQUESTS")
    public void setShouldAlwaysRespectAppRequestedMode(boolean var1) throws RemoteException;

    @EnforcePermission(value="android.permission.OVERRIDE_DISPLAY_MODE_REQUESTS")
    public boolean shouldAlwaysRespectAppRequestedMode() throws RemoteException;

    @EnforcePermission(value="android.permission.MODIFY_REFRESH_RATE_SWITCHING_TYPE")
    public void setRefreshRateSwitchingType(int var1) throws RemoteException;

    public int getRefreshRateSwitchingType() throws RemoteException;

    public DisplayDecorationSupport getDisplayDecorationSupport(int var1) throws RemoteException;

    public void setDisplayIdToMirror(IBinder var1, int var2) throws RemoteException;

    public OverlayProperties getOverlaySupport() throws RemoteException;

    @EnforcePermission(value="android.permission.MANAGE_DISPLAYS")
    public void enableConnectedDisplay(int var1) throws RemoteException;

    @EnforcePermission(value="android.permission.MANAGE_DISPLAYS")
    public void disableConnectedDisplay(int var1) throws RemoteException;

    @EnforcePermission(value="android.permission.MANAGE_DISPLAYS")
    public boolean requestDisplayPower(int var1, int var2) throws RemoteException;

    @EnforcePermission(value="android.permission.RESTRICT_DISPLAY_MODES")
    public void requestDisplayModes(IBinder var1, int var2, int[] var3) throws RemoteException;

    public float getHighestHdrSdrRatio(int var1) throws RemoteException;

    @EnforcePermission(value="android.permission.CONTROL_DISPLAY_BRIGHTNESS")
    public float[] getDozeBrightnessSensorValueToBrightness(int var1) throws RemoteException;

    @EnforcePermission(value="android.permission.CONTROL_DISPLAY_BRIGHTNESS")
    public float getDefaultDozeBrightness(int var1) throws RemoteException;

    @EnforcePermission(value="android.permission.MANAGE_DISPLAYS")
    public DisplayTopology getDisplayTopology() throws RemoteException;

    @EnforcePermission(value="android.permission.MANAGE_DISPLAYS")
    public void setDisplayTopology(DisplayTopology var1) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements IDisplayManager {
        private final PermissionEnforcer mEnforcer;
        public static final String DESCRIPTOR = "android.hardware.display.IDisplayManager";
        static final int TRANSACTION_getDisplayInfo = 1;
        static final int TRANSACTION_getDisplayIds = 2;
        static final int TRANSACTION_isUidPresentOnDisplay = 3;
        static final int TRANSACTION_registerCallback = 4;
        static final int TRANSACTION_registerCallbackWithEventMask = 5;
        static final int TRANSACTION_startWifiDisplayScan = 6;
        static final int TRANSACTION_stopWifiDisplayScan = 7;
        static final int TRANSACTION_connectWifiDisplay = 8;
        static final int TRANSACTION_disconnectWifiDisplay = 9;
        static final int TRANSACTION_renameWifiDisplay = 10;
        static final int TRANSACTION_forgetWifiDisplay = 11;
        static final int TRANSACTION_pauseWifiDisplay = 12;
        static final int TRANSACTION_resumeWifiDisplay = 13;
        static final int TRANSACTION_getWifiDisplayStatus = 14;
        static final int TRANSACTION_setUserDisabledHdrTypes = 15;
        static final int TRANSACTION_setAreUserDisabledHdrTypesAllowed = 16;
        static final int TRANSACTION_areUserDisabledHdrTypesAllowed = 17;
        static final int TRANSACTION_getUserDisabledHdrTypes = 18;
        static final int TRANSACTION_overrideHdrTypes = 19;
        static final int TRANSACTION_requestColorMode = 20;
        static final int TRANSACTION_createVirtualDisplay = 21;
        static final int TRANSACTION_resizeVirtualDisplay = 22;
        static final int TRANSACTION_setVirtualDisplaySurface = 23;
        static final int TRANSACTION_releaseVirtualDisplay = 24;
        static final int TRANSACTION_setVirtualDisplayRotation = 25;
        static final int TRANSACTION_getStableDisplaySize = 26;
        static final int TRANSACTION_getBrightnessEvents = 27;
        static final int TRANSACTION_getAmbientBrightnessStats = 28;
        static final int TRANSACTION_setBrightnessConfigurationForUser = 29;
        static final int TRANSACTION_setBrightnessConfigurationForDisplay = 30;
        static final int TRANSACTION_getBrightnessConfigurationForDisplay = 31;
        static final int TRANSACTION_getBrightnessConfigurationForUser = 32;
        static final int TRANSACTION_getDefaultBrightnessConfiguration = 33;
        static final int TRANSACTION_isMinimalPostProcessingRequested = 34;
        static final int TRANSACTION_setTemporaryBrightness = 35;
        static final int TRANSACTION_setBrightness = 36;
        static final int TRANSACTION_getBrightness = 37;
        static final int TRANSACTION_setTemporaryAutoBrightnessAdjustment = 38;
        static final int TRANSACTION_getMinimumBrightnessCurve = 39;
        static final int TRANSACTION_getBrightnessInfo = 40;
        static final int TRANSACTION_getPreferredWideGamutColorSpaceId = 41;
        static final int TRANSACTION_setUserPreferredDisplayMode = 42;
        static final int TRANSACTION_getUserPreferredDisplayMode = 43;
        static final int TRANSACTION_getSystemPreferredDisplayMode = 44;
        static final int TRANSACTION_setHdrConversionMode = 45;
        static final int TRANSACTION_getHdrConversionModeSetting = 46;
        static final int TRANSACTION_getHdrConversionMode = 47;
        static final int TRANSACTION_getSupportedHdrOutputTypes = 48;
        static final int TRANSACTION_setShouldAlwaysRespectAppRequestedMode = 49;
        static final int TRANSACTION_shouldAlwaysRespectAppRequestedMode = 50;
        static final int TRANSACTION_setRefreshRateSwitchingType = 51;
        static final int TRANSACTION_getRefreshRateSwitchingType = 52;
        static final int TRANSACTION_getDisplayDecorationSupport = 53;
        static final int TRANSACTION_setDisplayIdToMirror = 54;
        static final int TRANSACTION_getOverlaySupport = 55;
        static final int TRANSACTION_enableConnectedDisplay = 56;
        static final int TRANSACTION_disableConnectedDisplay = 57;
        static final int TRANSACTION_requestDisplayPower = 58;
        static final int TRANSACTION_requestDisplayModes = 59;
        static final int TRANSACTION_getHighestHdrSdrRatio = 60;
        static final int TRANSACTION_getDozeBrightnessSensorValueToBrightness = 61;
        static final int TRANSACTION_getDefaultDozeBrightness = 62;
        static final int TRANSACTION_getDisplayTopology = 63;
        static final int TRANSACTION_setDisplayTopology = 64;

        public Stub(PermissionEnforcer enforcer) {
            this.attachInterface(this, DESCRIPTOR);
            if (enforcer == null) {
                throw new IllegalArgumentException("enforcer cannot be null");
            }
            this.mEnforcer = enforcer;
        }

        @Deprecated
        public Stub() {
            this(PermissionEnforcer.fromContext(ActivityThread.currentActivityThread().getSystemContext()));
        }

        public static IDisplayManager asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(DESCRIPTOR);
            if (iin != null && iin instanceof IDisplayManager) {
                return (IDisplayManager)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 1: {
                    return "getDisplayInfo";
                }
                case 2: {
                    return "getDisplayIds";
                }
                case 3: {
                    return "isUidPresentOnDisplay";
                }
                case 4: {
                    return "registerCallback";
                }
                case 5: {
                    return "registerCallbackWithEventMask";
                }
                case 6: {
                    return "startWifiDisplayScan";
                }
                case 7: {
                    return "stopWifiDisplayScan";
                }
                case 8: {
                    return "connectWifiDisplay";
                }
                case 9: {
                    return "disconnectWifiDisplay";
                }
                case 10: {
                    return "renameWifiDisplay";
                }
                case 11: {
                    return "forgetWifiDisplay";
                }
                case 12: {
                    return "pauseWifiDisplay";
                }
                case 13: {
                    return "resumeWifiDisplay";
                }
                case 14: {
                    return "getWifiDisplayStatus";
                }
                case 15: {
                    return "setUserDisabledHdrTypes";
                }
                case 16: {
                    return "setAreUserDisabledHdrTypesAllowed";
                }
                case 17: {
                    return "areUserDisabledHdrTypesAllowed";
                }
                case 18: {
                    return "getUserDisabledHdrTypes";
                }
                case 19: {
                    return "overrideHdrTypes";
                }
                case 20: {
                    return "requestColorMode";
                }
                case 21: {
                    return "createVirtualDisplay";
                }
                case 22: {
                    return "resizeVirtualDisplay";
                }
                case 23: {
                    return "setVirtualDisplaySurface";
                }
                case 24: {
                    return "releaseVirtualDisplay";
                }
                case 25: {
                    return "setVirtualDisplayRotation";
                }
                case 26: {
                    return "getStableDisplaySize";
                }
                case 27: {
                    return "getBrightnessEvents";
                }
                case 28: {
                    return "getAmbientBrightnessStats";
                }
                case 29: {
                    return "setBrightnessConfigurationForUser";
                }
                case 30: {
                    return "setBrightnessConfigurationForDisplay";
                }
                case 31: {
                    return "getBrightnessConfigurationForDisplay";
                }
                case 32: {
                    return "getBrightnessConfigurationForUser";
                }
                case 33: {
                    return "getDefaultBrightnessConfiguration";
                }
                case 34: {
                    return "isMinimalPostProcessingRequested";
                }
                case 35: {
                    return "setTemporaryBrightness";
                }
                case 36: {
                    return "setBrightness";
                }
                case 37: {
                    return "getBrightness";
                }
                case 38: {
                    return "setTemporaryAutoBrightnessAdjustment";
                }
                case 39: {
                    return "getMinimumBrightnessCurve";
                }
                case 40: {
                    return "getBrightnessInfo";
                }
                case 41: {
                    return "getPreferredWideGamutColorSpaceId";
                }
                case 42: {
                    return "setUserPreferredDisplayMode";
                }
                case 43: {
                    return "getUserPreferredDisplayMode";
                }
                case 44: {
                    return "getSystemPreferredDisplayMode";
                }
                case 45: {
                    return "setHdrConversionMode";
                }
                case 46: {
                    return "getHdrConversionModeSetting";
                }
                case 47: {
                    return "getHdrConversionMode";
                }
                case 48: {
                    return "getSupportedHdrOutputTypes";
                }
                case 49: {
                    return "setShouldAlwaysRespectAppRequestedMode";
                }
                case 50: {
                    return "shouldAlwaysRespectAppRequestedMode";
                }
                case 51: {
                    return "setRefreshRateSwitchingType";
                }
                case 52: {
                    return "getRefreshRateSwitchingType";
                }
                case 53: {
                    return "getDisplayDecorationSupport";
                }
                case 54: {
                    return "setDisplayIdToMirror";
                }
                case 55: {
                    return "getOverlaySupport";
                }
                case 56: {
                    return "enableConnectedDisplay";
                }
                case 57: {
                    return "disableConnectedDisplay";
                }
                case 58: {
                    return "requestDisplayPower";
                }
                case 59: {
                    return "requestDisplayModes";
                }
                case 60: {
                    return "getHighestHdrSdrRatio";
                }
                case 61: {
                    return "getDozeBrightnessSensorValueToBrightness";
                }
                case 62: {
                    return "getDefaultDozeBrightness";
                }
                case 63: {
                    return "getDisplayTopology";
                }
                case 64: {
                    return "setDisplayTopology";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = DESCRIPTOR;
            if (code >= 1 && code <= 0xFFFFFF) {
                data.enforceInterface(descriptor);
            }
            if (code == 1598968902) {
                reply.writeString(descriptor);
                return true;
            }
            switch (code) {
                case 1: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    DisplayInfo _result = this.getDisplayInfo(_arg0);
                    reply.writeNoException();
                    reply.writeTypedObject(_result, 1);
                    break;
                }
                case 2: {
                    boolean _arg0 = data.readBoolean();
                    data.enforceNoDataAvail();
                    int[] _result = this.getDisplayIds(_arg0);
                    reply.writeNoException();
                    reply.writeIntArray(_result);
                    break;
                }
                case 3: {
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    boolean _result = this.isUidPresentOnDisplay(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 4: {
                    IDisplayManagerCallback _arg0 = IDisplayManagerCallback.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.registerCallback(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 5: {
                    IDisplayManagerCallback _arg0 = IDisplayManagerCallback.Stub.asInterface(data.readStrongBinder());
                    long _arg1 = data.readLong();
                    data.enforceNoDataAvail();
                    this.registerCallbackWithEventMask(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 6: {
                    this.startWifiDisplayScan();
                    reply.writeNoException();
                    break;
                }
                case 7: {
                    this.stopWifiDisplayScan();
                    reply.writeNoException();
                    break;
                }
                case 8: {
                    String _arg0 = data.readString();
                    data.enforceNoDataAvail();
                    this.connectWifiDisplay(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 9: {
                    this.disconnectWifiDisplay();
                    reply.writeNoException();
                    break;
                }
                case 10: {
                    String _arg0 = data.readString();
                    String _arg1 = data.readString();
                    data.enforceNoDataAvail();
                    this.renameWifiDisplay(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 11: {
                    String _arg0 = data.readString();
                    data.enforceNoDataAvail();
                    this.forgetWifiDisplay(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 12: {
                    this.pauseWifiDisplay();
                    reply.writeNoException();
                    break;
                }
                case 13: {
                    this.resumeWifiDisplay();
                    reply.writeNoException();
                    break;
                }
                case 14: {
                    WifiDisplayStatus _result = this.getWifiDisplayStatus();
                    reply.writeNoException();
                    reply.writeTypedObject(_result, 1);
                    break;
                }
                case 15: {
                    int[] _arg0 = data.createIntArray();
                    data.enforceNoDataAvail();
                    this.setUserDisabledHdrTypes(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 16: {
                    boolean _arg0 = data.readBoolean();
                    data.enforceNoDataAvail();
                    this.setAreUserDisabledHdrTypesAllowed(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 17: {
                    boolean _result = this.areUserDisabledHdrTypesAllowed();
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 18: {
                    int[] _result = this.getUserDisabledHdrTypes();
                    reply.writeNoException();
                    reply.writeIntArray(_result);
                    break;
                }
                case 19: {
                    int _arg0 = data.readInt();
                    int[] _arg1 = data.createIntArray();
                    data.enforceNoDataAvail();
                    this.overrideHdrTypes(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 20: {
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    this.requestColorMode(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 21: {
                    VirtualDisplayConfig _arg0 = data.readTypedObject(VirtualDisplayConfig.CREATOR);
                    IVirtualDisplayCallback _arg1 = IVirtualDisplayCallback.Stub.asInterface(data.readStrongBinder());
                    IMediaProjection _arg2 = IMediaProjection.Stub.asInterface(data.readStrongBinder());
                    String _arg3 = data.readString();
                    data.enforceNoDataAvail();
                    int _result = this.createVirtualDisplay(_arg0, _arg1, _arg2, _arg3);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    break;
                }
                case 22: {
                    IVirtualDisplayCallback _arg0 = IVirtualDisplayCallback.Stub.asInterface(data.readStrongBinder());
                    int _arg1 = data.readInt();
                    int _arg2 = data.readInt();
                    int _arg3 = data.readInt();
                    data.enforceNoDataAvail();
                    this.resizeVirtualDisplay(_arg0, _arg1, _arg2, _arg3);
                    reply.writeNoException();
                    break;
                }
                case 23: {
                    IVirtualDisplayCallback _arg0 = IVirtualDisplayCallback.Stub.asInterface(data.readStrongBinder());
                    Surface _arg1 = data.readTypedObject(Surface.CREATOR);
                    data.enforceNoDataAvail();
                    this.setVirtualDisplaySurface(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 24: {
                    IVirtualDisplayCallback _arg0 = IVirtualDisplayCallback.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.releaseVirtualDisplay(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 25: {
                    IVirtualDisplayCallback _arg0 = IVirtualDisplayCallback.Stub.asInterface(data.readStrongBinder());
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    this.setVirtualDisplayRotation(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 26: {
                    Point _result = this.getStableDisplaySize();
                    reply.writeNoException();
                    reply.writeTypedObject(_result, 1);
                    break;
                }
                case 27: {
                    String _arg0 = data.readString();
                    data.enforceNoDataAvail();
                    ParceledListSlice _result = this.getBrightnessEvents(_arg0);
                    reply.writeNoException();
                    reply.writeTypedObject(_result, 1);
                    break;
                }
                case 28: {
                    ParceledListSlice _result = this.getAmbientBrightnessStats();
                    reply.writeNoException();
                    reply.writeTypedObject(_result, 1);
                    break;
                }
                case 29: {
                    BrightnessConfiguration _arg0 = data.readTypedObject(BrightnessConfiguration.CREATOR);
                    int _arg1 = data.readInt();
                    String _arg2 = data.readString();
                    data.enforceNoDataAvail();
                    this.setBrightnessConfigurationForUser(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    break;
                }
                case 30: {
                    BrightnessConfiguration _arg0 = data.readTypedObject(BrightnessConfiguration.CREATOR);
                    String _arg1 = data.readString();
                    int _arg2 = data.readInt();
                    String _arg3 = data.readString();
                    data.enforceNoDataAvail();
                    this.setBrightnessConfigurationForDisplay(_arg0, _arg1, _arg2, _arg3);
                    reply.writeNoException();
                    break;
                }
                case 31: {
                    String _arg0 = data.readString();
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    BrightnessConfiguration _result = this.getBrightnessConfigurationForDisplay(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeTypedObject(_result, 1);
                    break;
                }
                case 32: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    BrightnessConfiguration _result = this.getBrightnessConfigurationForUser(_arg0);
                    reply.writeNoException();
                    reply.writeTypedObject(_result, 1);
                    break;
                }
                case 33: {
                    BrightnessConfiguration _result = this.getDefaultBrightnessConfiguration();
                    reply.writeNoException();
                    reply.writeTypedObject(_result, 1);
                    break;
                }
                case 34: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    boolean _result = this.isMinimalPostProcessingRequested(_arg0);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 35: {
                    int _arg0 = data.readInt();
                    float _arg1 = data.readFloat();
                    data.enforceNoDataAvail();
                    this.setTemporaryBrightness(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 36: {
                    int _arg0 = data.readInt();
                    float _arg1 = data.readFloat();
                    data.enforceNoDataAvail();
                    this.setBrightness(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 37: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    float _result = this.getBrightness(_arg0);
                    reply.writeNoException();
                    reply.writeFloat(_result);
                    break;
                }
                case 38: {
                    float _arg0 = data.readFloat();
                    data.enforceNoDataAvail();
                    this.setTemporaryAutoBrightnessAdjustment(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 39: {
                    Curve _result = this.getMinimumBrightnessCurve();
                    reply.writeNoException();
                    reply.writeTypedObject(_result, 1);
                    break;
                }
                case 40: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    BrightnessInfo _result = this.getBrightnessInfo(_arg0);
                    reply.writeNoException();
                    reply.writeTypedObject(_result, 1);
                    break;
                }
                case 41: {
                    int _result = this.getPreferredWideGamutColorSpaceId();
                    reply.writeNoException();
                    reply.writeInt(_result);
                    break;
                }
                case 42: {
                    int _arg0 = data.readInt();
                    Display.Mode _arg1 = data.readTypedObject(Display.Mode.CREATOR);
                    data.enforceNoDataAvail();
                    this.setUserPreferredDisplayMode(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 43: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    Display.Mode _result = this.getUserPreferredDisplayMode(_arg0);
                    reply.writeNoException();
                    reply.writeTypedObject(_result, 1);
                    break;
                }
                case 44: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    Display.Mode _result = this.getSystemPreferredDisplayMode(_arg0);
                    reply.writeNoException();
                    reply.writeTypedObject(_result, 1);
                    break;
                }
                case 45: {
                    HdrConversionMode _arg0 = data.readTypedObject(HdrConversionMode.CREATOR);
                    data.enforceNoDataAvail();
                    this.setHdrConversionMode(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 46: {
                    HdrConversionMode _result = this.getHdrConversionModeSetting();
                    reply.writeNoException();
                    reply.writeTypedObject(_result, 1);
                    break;
                }
                case 47: {
                    HdrConversionMode _result = this.getHdrConversionMode();
                    reply.writeNoException();
                    reply.writeTypedObject(_result, 1);
                    break;
                }
                case 48: {
                    int[] _result = this.getSupportedHdrOutputTypes();
                    reply.writeNoException();
                    reply.writeIntArray(_result);
                    break;
                }
                case 49: {
                    boolean _arg0 = data.readBoolean();
                    data.enforceNoDataAvail();
                    this.setShouldAlwaysRespectAppRequestedMode(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 50: {
                    boolean _result = this.shouldAlwaysRespectAppRequestedMode();
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 51: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    this.setRefreshRateSwitchingType(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 52: {
                    int _result = this.getRefreshRateSwitchingType();
                    reply.writeNoException();
                    reply.writeInt(_result);
                    break;
                }
                case 53: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    DisplayDecorationSupport _result = this.getDisplayDecorationSupport(_arg0);
                    reply.writeNoException();
                    reply.writeTypedObject(_result, 1);
                    break;
                }
                case 54: {
                    IBinder _arg0 = data.readStrongBinder();
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    this.setDisplayIdToMirror(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 55: {
                    OverlayProperties _result = this.getOverlaySupport();
                    reply.writeNoException();
                    reply.writeTypedObject(_result, 1);
                    break;
                }
                case 56: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    this.enableConnectedDisplay(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 57: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    this.disableConnectedDisplay(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 58: {
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    boolean _result = this.requestDisplayPower(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 59: {
                    IBinder _arg0 = data.readStrongBinder();
                    int _arg1 = data.readInt();
                    int[] _arg2 = data.createIntArray();
                    data.enforceNoDataAvail();
                    this.requestDisplayModes(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    break;
                }
                case 60: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    float _result = this.getHighestHdrSdrRatio(_arg0);
                    reply.writeNoException();
                    reply.writeFloat(_result);
                    break;
                }
                case 61: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    float[] _result = this.getDozeBrightnessSensorValueToBrightness(_arg0);
                    reply.writeNoException();
                    reply.writeFloatArray(_result);
                    break;
                }
                case 62: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    float _result = this.getDefaultDozeBrightness(_arg0);
                    reply.writeNoException();
                    reply.writeFloat(_result);
                    break;
                }
                case 63: {
                    DisplayTopology _result = this.getDisplayTopology();
                    reply.writeNoException();
                    reply.writeTypedObject(_result, 1);
                    break;
                }
                case 64: {
                    DisplayTopology _arg0 = data.readTypedObject(DisplayTopology.CREATOR);
                    data.enforceNoDataAvail();
                    this.setDisplayTopology(_arg0);
                    reply.writeNoException();
                    break;
                }
                default: {
                    return super.onTransact(code, data, reply, flags);
                }
            }
            return true;
        }

        protected void startWifiDisplayScan_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.CONFIGURE_WIFI_DISPLAY", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void stopWifiDisplayScan_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.CONFIGURE_WIFI_DISPLAY", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void connectWifiDisplay_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.CONFIGURE_WIFI_DISPLAY", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void renameWifiDisplay_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.CONFIGURE_WIFI_DISPLAY", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void forgetWifiDisplay_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.CONFIGURE_WIFI_DISPLAY", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void pauseWifiDisplay_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.CONFIGURE_WIFI_DISPLAY", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void resumeWifiDisplay_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.CONFIGURE_WIFI_DISPLAY", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void setUserDisabledHdrTypes_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.WRITE_SECURE_SETTINGS", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void setAreUserDisabledHdrTypesAllowed_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.WRITE_SECURE_SETTINGS", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void requestColorMode_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.CONFIGURE_DISPLAY_COLOR_MODE", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void getBrightnessEvents_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.BRIGHTNESS_SLIDER_USAGE", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void getAmbientBrightnessStats_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.ACCESS_AMBIENT_LIGHT_STATS", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void setBrightnessConfigurationForUser_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.CONFIGURE_DISPLAY_BRIGHTNESS", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void setBrightnessConfigurationForDisplay_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.CONFIGURE_DISPLAY_BRIGHTNESS", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void getBrightnessConfigurationForDisplay_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.CONFIGURE_DISPLAY_BRIGHTNESS", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void getDefaultBrightnessConfiguration_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.CONFIGURE_DISPLAY_BRIGHTNESS", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void setTemporaryBrightness_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.CONTROL_DISPLAY_BRIGHTNESS", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void setBrightness_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.CONTROL_DISPLAY_BRIGHTNESS", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void getBrightness_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.CONTROL_DISPLAY_BRIGHTNESS", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void setTemporaryAutoBrightnessAdjustment_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.CONTROL_DISPLAY_BRIGHTNESS", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void getBrightnessInfo_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.CONTROL_DISPLAY_BRIGHTNESS", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void setUserPreferredDisplayMode_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.MODIFY_USER_PREFERRED_DISPLAY_MODE", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void setHdrConversionMode_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.MODIFY_HDR_CONVERSION_MODE", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void setShouldAlwaysRespectAppRequestedMode_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.OVERRIDE_DISPLAY_MODE_REQUESTS", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void shouldAlwaysRespectAppRequestedMode_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.OVERRIDE_DISPLAY_MODE_REQUESTS", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void setRefreshRateSwitchingType_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.MODIFY_REFRESH_RATE_SWITCHING_TYPE", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void enableConnectedDisplay_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.MANAGE_DISPLAYS", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void disableConnectedDisplay_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.MANAGE_DISPLAYS", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void requestDisplayPower_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.MANAGE_DISPLAYS", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void requestDisplayModes_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.RESTRICT_DISPLAY_MODES", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void getDozeBrightnessSensorValueToBrightness_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.CONTROL_DISPLAY_BRIGHTNESS", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void getDefaultDozeBrightness_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.CONTROL_DISPLAY_BRIGHTNESS", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void getDisplayTopology_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.MANAGE_DISPLAYS", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void setDisplayTopology_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.MANAGE_DISPLAYS", Stub.getCallingPid(), Stub.getCallingUid());
        }

        @Override
        public int getMaxTransactionId() {
            return 63;
        }

        private static class Proxy
        implements IDisplayManager {
            private IBinder mRemote;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return Stub.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public DisplayInfo getDisplayInfo(int displayId) throws RemoteException {
                DisplayInfo _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(displayId);
                    boolean _status = this.mRemote.transact(1, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readTypedObject(DisplayInfo.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int[] getDisplayIds(boolean includeDisabled) throws RemoteException {
                int[] _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeBoolean(includeDisabled);
                    boolean _status = this.mRemote.transact(2, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.createIntArray();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isUidPresentOnDisplay(int uid, int displayId) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(uid);
                    _data.writeInt(displayId);
                    boolean _status = this.mRemote.transact(3, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void registerCallback(IDisplayManagerCallback callback) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(callback);
                    boolean _status = this.mRemote.transact(4, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void registerCallbackWithEventMask(IDisplayManagerCallback callback, long eventsMask) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(callback);
                    _data.writeLong(eventsMask);
                    boolean _status = this.mRemote.transact(5, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void startWifiDisplayScan() throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(6, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void stopWifiDisplayScan() throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(7, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void connectWifiDisplay(String address) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(address);
                    boolean _status = this.mRemote.transact(8, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void disconnectWifiDisplay() throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(9, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void renameWifiDisplay(String address, String alias) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(address);
                    _data.writeString(alias);
                    boolean _status = this.mRemote.transact(10, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void forgetWifiDisplay(String address) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(address);
                    boolean _status = this.mRemote.transact(11, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void pauseWifiDisplay() throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(12, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void resumeWifiDisplay() throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(13, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public WifiDisplayStatus getWifiDisplayStatus() throws RemoteException {
                WifiDisplayStatus _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(14, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readTypedObject(WifiDisplayStatus.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setUserDisabledHdrTypes(int[] userDisabledTypes) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeIntArray(userDisabledTypes);
                    boolean _status = this.mRemote.transact(15, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setAreUserDisabledHdrTypesAllowed(boolean areUserDisabledHdrTypesAllowed) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeBoolean(areUserDisabledHdrTypesAllowed);
                    boolean _status = this.mRemote.transact(16, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean areUserDisabledHdrTypesAllowed() throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(17, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int[] getUserDisabledHdrTypes() throws RemoteException {
                int[] _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(18, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.createIntArray();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void overrideHdrTypes(int displayId, int[] modes) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(displayId);
                    _data.writeIntArray(modes);
                    boolean _status = this.mRemote.transact(19, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void requestColorMode(int displayId, int colorMode) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(displayId);
                    _data.writeInt(colorMode);
                    boolean _status = this.mRemote.transact(20, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int createVirtualDisplay(VirtualDisplayConfig virtualDisplayConfig, IVirtualDisplayCallback callback, IMediaProjection projectionToken, String packageName) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(virtualDisplayConfig, 0);
                    _data.writeStrongInterface(callback);
                    _data.writeStrongInterface(projectionToken);
                    _data.writeString(packageName);
                    boolean _status = this.mRemote.transact(21, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void resizeVirtualDisplay(IVirtualDisplayCallback token, int width, int height, int densityDpi) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(token);
                    _data.writeInt(width);
                    _data.writeInt(height);
                    _data.writeInt(densityDpi);
                    boolean _status = this.mRemote.transact(22, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setVirtualDisplaySurface(IVirtualDisplayCallback token, Surface surface) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(token);
                    _data.writeTypedObject(surface, 0);
                    boolean _status = this.mRemote.transact(23, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void releaseVirtualDisplay(IVirtualDisplayCallback token) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(token);
                    boolean _status = this.mRemote.transact(24, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setVirtualDisplayRotation(IVirtualDisplayCallback token, int rotation) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(token);
                    _data.writeInt(rotation);
                    boolean _status = this.mRemote.transact(25, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Point getStableDisplaySize() throws RemoteException {
                Point _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(26, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readTypedObject(Point.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public ParceledListSlice getBrightnessEvents(String callingPackage) throws RemoteException {
                ParceledListSlice _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(callingPackage);
                    boolean _status = this.mRemote.transact(27, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readTypedObject(ParceledListSlice.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public ParceledListSlice getAmbientBrightnessStats() throws RemoteException {
                ParceledListSlice _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(28, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readTypedObject(ParceledListSlice.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setBrightnessConfigurationForUser(BrightnessConfiguration c, int userId, String packageName) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(c, 0);
                    _data.writeInt(userId);
                    _data.writeString(packageName);
                    boolean _status = this.mRemote.transact(29, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setBrightnessConfigurationForDisplay(BrightnessConfiguration c, String uniqueDisplayId, int userId, String packageName) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(c, 0);
                    _data.writeString(uniqueDisplayId);
                    _data.writeInt(userId);
                    _data.writeString(packageName);
                    boolean _status = this.mRemote.transact(30, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public BrightnessConfiguration getBrightnessConfigurationForDisplay(String uniqueDisplayId, int userId) throws RemoteException {
                BrightnessConfiguration _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(uniqueDisplayId);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(31, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readTypedObject(BrightnessConfiguration.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public BrightnessConfiguration getBrightnessConfigurationForUser(int userId) throws RemoteException {
                BrightnessConfiguration _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(32, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readTypedObject(BrightnessConfiguration.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public BrightnessConfiguration getDefaultBrightnessConfiguration() throws RemoteException {
                BrightnessConfiguration _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(33, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readTypedObject(BrightnessConfiguration.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isMinimalPostProcessingRequested(int displayId) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(displayId);
                    boolean _status = this.mRemote.transact(34, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setTemporaryBrightness(int displayId, float brightness) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(displayId);
                    _data.writeFloat(brightness);
                    boolean _status = this.mRemote.transact(35, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setBrightness(int displayId, float brightness) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(displayId);
                    _data.writeFloat(brightness);
                    boolean _status = this.mRemote.transact(36, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public float getBrightness(int displayId) throws RemoteException {
                float _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(displayId);
                    boolean _status = this.mRemote.transact(37, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readFloat();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setTemporaryAutoBrightnessAdjustment(float adjustment) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeFloat(adjustment);
                    boolean _status = this.mRemote.transact(38, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Curve getMinimumBrightnessCurve() throws RemoteException {
                Curve _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(39, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readTypedObject(Curve.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public BrightnessInfo getBrightnessInfo(int displayId) throws RemoteException {
                BrightnessInfo _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(displayId);
                    boolean _status = this.mRemote.transact(40, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readTypedObject(BrightnessInfo.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int getPreferredWideGamutColorSpaceId() throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(41, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setUserPreferredDisplayMode(int displayId, Display.Mode mode) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(displayId);
                    _data.writeTypedObject(mode, 0);
                    boolean _status = this.mRemote.transact(42, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Display.Mode getUserPreferredDisplayMode(int displayId) throws RemoteException {
                Display.Mode _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(displayId);
                    boolean _status = this.mRemote.transact(43, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readTypedObject(Display.Mode.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Display.Mode getSystemPreferredDisplayMode(int displayId) throws RemoteException {
                Display.Mode _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(displayId);
                    boolean _status = this.mRemote.transact(44, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readTypedObject(Display.Mode.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setHdrConversionMode(HdrConversionMode hdrConversionMode) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(hdrConversionMode, 0);
                    boolean _status = this.mRemote.transact(45, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public HdrConversionMode getHdrConversionModeSetting() throws RemoteException {
                HdrConversionMode _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(46, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readTypedObject(HdrConversionMode.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public HdrConversionMode getHdrConversionMode() throws RemoteException {
                HdrConversionMode _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(47, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readTypedObject(HdrConversionMode.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int[] getSupportedHdrOutputTypes() throws RemoteException {
                int[] _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(48, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.createIntArray();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setShouldAlwaysRespectAppRequestedMode(boolean enabled) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeBoolean(enabled);
                    boolean _status = this.mRemote.transact(49, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean shouldAlwaysRespectAppRequestedMode() throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(50, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setRefreshRateSwitchingType(int newValue) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(newValue);
                    boolean _status = this.mRemote.transact(51, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int getRefreshRateSwitchingType() throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(52, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public DisplayDecorationSupport getDisplayDecorationSupport(int displayId) throws RemoteException {
                DisplayDecorationSupport _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(displayId);
                    boolean _status = this.mRemote.transact(53, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readTypedObject(DisplayDecorationSupport.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setDisplayIdToMirror(IBinder token, int displayId) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongBinder(token);
                    _data.writeInt(displayId);
                    boolean _status = this.mRemote.transact(54, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public OverlayProperties getOverlaySupport() throws RemoteException {
                OverlayProperties _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(55, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readTypedObject(OverlayProperties.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void enableConnectedDisplay(int displayId) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(displayId);
                    boolean _status = this.mRemote.transact(56, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void disableConnectedDisplay(int displayId) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(displayId);
                    boolean _status = this.mRemote.transact(57, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean requestDisplayPower(int displayId, int state) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(displayId);
                    _data.writeInt(state);
                    boolean _status = this.mRemote.transact(58, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void requestDisplayModes(IBinder token, int displayId, int[] modeIds) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongBinder(token);
                    _data.writeInt(displayId);
                    _data.writeIntArray(modeIds);
                    boolean _status = this.mRemote.transact(59, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public float getHighestHdrSdrRatio(int displayId) throws RemoteException {
                float _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(displayId);
                    boolean _status = this.mRemote.transact(60, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readFloat();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public float[] getDozeBrightnessSensorValueToBrightness(int displayId) throws RemoteException {
                float[] _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(displayId);
                    boolean _status = this.mRemote.transact(61, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.createFloatArray();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public float getDefaultDozeBrightness(int displayId) throws RemoteException {
                float _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(displayId);
                    boolean _status = this.mRemote.transact(62, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readFloat();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public DisplayTopology getDisplayTopology() throws RemoteException {
                DisplayTopology _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(63, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readTypedObject(DisplayTopology.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setDisplayTopology(DisplayTopology topology) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(topology, 0);
                    boolean _status = this.mRemote.transact(64, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }
        }
    }

    public static class Default
    implements IDisplayManager {
        @Override
        public DisplayInfo getDisplayInfo(int displayId) throws RemoteException {
            return null;
        }

        @Override
        public int[] getDisplayIds(boolean includeDisabled) throws RemoteException {
            return null;
        }

        @Override
        public boolean isUidPresentOnDisplay(int uid, int displayId) throws RemoteException {
            return false;
        }

        @Override
        public void registerCallback(IDisplayManagerCallback callback) throws RemoteException {
        }

        @Override
        public void registerCallbackWithEventMask(IDisplayManagerCallback callback, long eventsMask) throws RemoteException {
        }

        @Override
        public void startWifiDisplayScan() throws RemoteException {
        }

        @Override
        public void stopWifiDisplayScan() throws RemoteException {
        }

        @Override
        public void connectWifiDisplay(String address) throws RemoteException {
        }

        @Override
        public void disconnectWifiDisplay() throws RemoteException {
        }

        @Override
        public void renameWifiDisplay(String address, String alias) throws RemoteException {
        }

        @Override
        public void forgetWifiDisplay(String address) throws RemoteException {
        }

        @Override
        public void pauseWifiDisplay() throws RemoteException {
        }

        @Override
        public void resumeWifiDisplay() throws RemoteException {
        }

        @Override
        public WifiDisplayStatus getWifiDisplayStatus() throws RemoteException {
            return null;
        }

        @Override
        public void setUserDisabledHdrTypes(int[] userDisabledTypes) throws RemoteException {
        }

        @Override
        public void setAreUserDisabledHdrTypesAllowed(boolean areUserDisabledHdrTypesAllowed) throws RemoteException {
        }

        @Override
        public boolean areUserDisabledHdrTypesAllowed() throws RemoteException {
            return false;
        }

        @Override
        public int[] getUserDisabledHdrTypes() throws RemoteException {
            return null;
        }

        @Override
        public void overrideHdrTypes(int displayId, int[] modes) throws RemoteException {
        }

        @Override
        public void requestColorMode(int displayId, int colorMode) throws RemoteException {
        }

        @Override
        public int createVirtualDisplay(VirtualDisplayConfig virtualDisplayConfig, IVirtualDisplayCallback callback, IMediaProjection projectionToken, String packageName) throws RemoteException {
            return 0;
        }

        @Override
        public void resizeVirtualDisplay(IVirtualDisplayCallback token, int width, int height, int densityDpi) throws RemoteException {
        }

        @Override
        public void setVirtualDisplaySurface(IVirtualDisplayCallback token, Surface surface) throws RemoteException {
        }

        @Override
        public void releaseVirtualDisplay(IVirtualDisplayCallback token) throws RemoteException {
        }

        @Override
        public void setVirtualDisplayRotation(IVirtualDisplayCallback token, int rotation) throws RemoteException {
        }

        @Override
        public Point getStableDisplaySize() throws RemoteException {
            return null;
        }

        @Override
        public ParceledListSlice getBrightnessEvents(String callingPackage) throws RemoteException {
            return null;
        }

        @Override
        public ParceledListSlice getAmbientBrightnessStats() throws RemoteException {
            return null;
        }

        @Override
        public void setBrightnessConfigurationForUser(BrightnessConfiguration c, int userId, String packageName) throws RemoteException {
        }

        @Override
        public void setBrightnessConfigurationForDisplay(BrightnessConfiguration c, String uniqueDisplayId, int userId, String packageName) throws RemoteException {
        }

        @Override
        public BrightnessConfiguration getBrightnessConfigurationForDisplay(String uniqueDisplayId, int userId) throws RemoteException {
            return null;
        }

        @Override
        public BrightnessConfiguration getBrightnessConfigurationForUser(int userId) throws RemoteException {
            return null;
        }

        @Override
        public BrightnessConfiguration getDefaultBrightnessConfiguration() throws RemoteException {
            return null;
        }

        @Override
        public boolean isMinimalPostProcessingRequested(int displayId) throws RemoteException {
            return false;
        }

        @Override
        public void setTemporaryBrightness(int displayId, float brightness) throws RemoteException {
        }

        @Override
        public void setBrightness(int displayId, float brightness) throws RemoteException {
        }

        @Override
        public float getBrightness(int displayId) throws RemoteException {
            return 0.0f;
        }

        @Override
        public void setTemporaryAutoBrightnessAdjustment(float adjustment) throws RemoteException {
        }

        @Override
        public Curve getMinimumBrightnessCurve() throws RemoteException {
            return null;
        }

        @Override
        public BrightnessInfo getBrightnessInfo(int displayId) throws RemoteException {
            return null;
        }

        @Override
        public int getPreferredWideGamutColorSpaceId() throws RemoteException {
            return 0;
        }

        @Override
        public void setUserPreferredDisplayMode(int displayId, Display.Mode mode) throws RemoteException {
        }

        @Override
        public Display.Mode getUserPreferredDisplayMode(int displayId) throws RemoteException {
            return null;
        }

        @Override
        public Display.Mode getSystemPreferredDisplayMode(int displayId) throws RemoteException {
            return null;
        }

        @Override
        public void setHdrConversionMode(HdrConversionMode hdrConversionMode) throws RemoteException {
        }

        @Override
        public HdrConversionMode getHdrConversionModeSetting() throws RemoteException {
            return null;
        }

        @Override
        public HdrConversionMode getHdrConversionMode() throws RemoteException {
            return null;
        }

        @Override
        public int[] getSupportedHdrOutputTypes() throws RemoteException {
            return null;
        }

        @Override
        public void setShouldAlwaysRespectAppRequestedMode(boolean enabled) throws RemoteException {
        }

        @Override
        public boolean shouldAlwaysRespectAppRequestedMode() throws RemoteException {
            return false;
        }

        @Override
        public void setRefreshRateSwitchingType(int newValue) throws RemoteException {
        }

        @Override
        public int getRefreshRateSwitchingType() throws RemoteException {
            return 0;
        }

        @Override
        public DisplayDecorationSupport getDisplayDecorationSupport(int displayId) throws RemoteException {
            return null;
        }

        @Override
        public void setDisplayIdToMirror(IBinder token, int displayId) throws RemoteException {
        }

        @Override
        public OverlayProperties getOverlaySupport() throws RemoteException {
            return null;
        }

        @Override
        public void enableConnectedDisplay(int displayId) throws RemoteException {
        }

        @Override
        public void disableConnectedDisplay(int displayId) throws RemoteException {
        }

        @Override
        public boolean requestDisplayPower(int displayId, int state) throws RemoteException {
            return false;
        }

        @Override
        public void requestDisplayModes(IBinder token, int displayId, int[] modeIds) throws RemoteException {
        }

        @Override
        public float getHighestHdrSdrRatio(int displayId) throws RemoteException {
            return 0.0f;
        }

        @Override
        public float[] getDozeBrightnessSensorValueToBrightness(int displayId) throws RemoteException {
            return null;
        }

        @Override
        public float getDefaultDozeBrightness(int displayId) throws RemoteException {
            return 0.0f;
        }

        @Override
        public DisplayTopology getDisplayTopology() throws RemoteException {
            return null;
        }

        @Override
        public void setDisplayTopology(DisplayTopology topology) throws RemoteException {
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

