/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.display;

import android.hardware.display.DisplayTopology;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;

public class DisplayTopologyGraph
extends Record {
    private final int primaryDisplayId;
    private final DisplayNode[] displayNodes;

    public DisplayTopologyGraph(int primaryDisplayId, DisplayNode[] displayNodes) {
        this.primaryDisplayId = primaryDisplayId;
        this.displayNodes = displayNodes;
    }

    @Override
    public String toString() {
        return ObjectMethods.bootstrap("toString", new MethodHandle[]{DisplayTopologyGraph.class, "primaryDisplayId;displayNodes", "primaryDisplayId", "displayNodes"}, this);
    }

    @Override
    public int hashCode() {
        return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{DisplayTopologyGraph.class, "primaryDisplayId;displayNodes", "primaryDisplayId", "displayNodes"}, this);
    }

    @Override
    public boolean equals(Object o) {
        return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{DisplayTopologyGraph.class, "primaryDisplayId;displayNodes", "primaryDisplayId", "displayNodes"}, this, o);
    }

    public int primaryDisplayId() {
        return this.primaryDisplayId;
    }

    public DisplayNode[] displayNodes() {
        return this.displayNodes;
    }

    public static class DisplayNode
    extends Record {
        private final int displayId;
        private final int density;
        private final AdjacentDisplay[] adjacentDisplays;

        public DisplayNode(int displayId, int density, AdjacentDisplay[] adjacentDisplays) {
            this.displayId = displayId;
            this.density = density;
            this.adjacentDisplays = adjacentDisplays;
        }

        @Override
        public String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{DisplayNode.class, "displayId;density;adjacentDisplays", "displayId", "density", "adjacentDisplays"}, this);
        }

        @Override
        public int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{DisplayNode.class, "displayId;density;adjacentDisplays", "displayId", "density", "adjacentDisplays"}, this);
        }

        @Override
        public boolean equals(Object o) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{DisplayNode.class, "displayId;density;adjacentDisplays", "displayId", "density", "adjacentDisplays"}, this, o);
        }

        public int displayId() {
            return this.displayId;
        }

        public int density() {
            return this.density;
        }

        public AdjacentDisplay[] adjacentDisplays() {
            return this.adjacentDisplays;
        }
    }

    public static class AdjacentDisplay
    extends Record {
        private final int displayId;
        private final int position;
        private final float offsetDp;

        public AdjacentDisplay(int displayId, int position, float offsetDp) {
            this.displayId = displayId;
            this.position = position;
            this.offsetDp = offsetDp;
        }

        @Override
        public String toString() {
            return "AdjacentDisplay{displayId=" + this.displayId + ", position=" + DisplayTopology.TreeNode.positionToString(this.position) + ", offsetDp=" + this.offsetDp + '}';
        }

        @Override
        public int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{AdjacentDisplay.class, "displayId;position;offsetDp", "displayId", "position", "offsetDp"}, this);
        }

        @Override
        public boolean equals(Object o) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{AdjacentDisplay.class, "displayId;position;offsetDp", "displayId", "position", "offsetDp"}, this, o);
        }

        public int displayId() {
            return this.displayId;
        }

        public int position() {
            return this.position;
        }

        public float offsetDp() {
            return this.offsetDp;
        }
    }
}

