/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.display;

import android.annotation.FlaggedApi;
import android.annotation.NonNull;
import android.annotation.Nullable;
import android.graphics.PointF;
import android.graphics.RectF;
import android.hardware.display.DisplayTopologyGraph;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.IndentingPrintWriter;
import android.util.MathUtils;
import android.util.Pair;
import android.util.Slog;
import android.util.SparseArray;
import android.util.SparseIntArray;
import com.android.internal.annotations.VisibleForTesting;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

@FlaggedApi(value="com.android.server.display.feature.flags.display_topology")
public class DisplayTopology
implements Parcelable {
    private static final String TAG = "DisplayTopology";
    private static final float EPSILON = 1.0E-4f;
    private static final float MAX_GAP = 5.0f;
    @NonNull
    public static final Parcelable.Creator<DisplayTopology> CREATOR = new Parcelable.Creator<DisplayTopology>(){

        @Override
        public DisplayTopology createFromParcel(Parcel source) {
            return new DisplayTopology(source);
        }

        public DisplayTopology[] newArray(int size) {
            return new DisplayTopology[size];
        }
    };
    @Nullable
    private TreeNode mRoot;
    private int mPrimaryDisplayId = -1;

    public static float pxToDp(float px, int dpi) {
        return px * 160.0f / (float)dpi;
    }

    public static float dpToPx(float dp, int dpi) {
        return dp * (float)dpi / 160.0f;
    }

    public DisplayTopology() {
    }

    public DisplayTopology(@Nullable TreeNode root, int primaryDisplayId) {
        this.mRoot = root;
        if (this.mRoot != null) {
            this.mRoot.mPosition = 0;
            this.mRoot.mOffset = 0.0f;
        }
        this.mPrimaryDisplayId = primaryDisplayId;
    }

    public DisplayTopology(Parcel source) {
        this(source.readTypedObject(TreeNode.CREATOR), source.readInt());
    }

    @Nullable
    public TreeNode getRoot() {
        return this.mRoot;
    }

    public int getPrimaryDisplayId() {
        return this.mPrimaryDisplayId;
    }

    public void addDisplay(int displayId, float width, float height) {
        if (DisplayTopology.findDisplay(displayId, this.mRoot) != null) {
            return;
        }
        if (this.mRoot == null) {
            this.mRoot = new TreeNode(displayId, width, height, 0, 0.0f);
            this.mPrimaryDisplayId = displayId;
        } else if (this.mRoot.mChildren.isEmpty()) {
            float offset = this.mRoot.mWidth / 2.0f - width / 2.0f;
            TreeNode display = new TreeNode(displayId, width, height, 1, offset);
            this.mRoot.mChildren.add(display);
        } else {
            TreeNode rightMostDisplay = (TreeNode)DisplayTopology.findRightMostDisplay((TreeNode)this.mRoot, (float)this.mRoot.mWidth).first;
            TreeNode newDisplay = new TreeNode(displayId, width, height, 2, 0.0f);
            rightMostDisplay.mChildren.add(newDisplay);
        }
    }

    public boolean updateDisplay(int displayId, float width, float height) {
        TreeNode display = DisplayTopology.findDisplay(displayId, this.mRoot);
        if (display == null) {
            return false;
        }
        if (DisplayTopology.floatEquals(display.mWidth, width) && DisplayTopology.floatEquals(display.mHeight, height)) {
            return false;
        }
        display.mWidth = width;
        display.mHeight = height;
        this.normalize();
        Slog.i(TAG, "Display with ID " + displayId + " updated, new width: " + width + ", new height: " + height);
        return true;
    }

    public boolean removeDisplay(int displayId) {
        if (DisplayTopology.findDisplay(displayId, this.mRoot) == null) {
            return false;
        }
        ArrayDeque<TreeNode> queue = new ArrayDeque<TreeNode>();
        queue.add(this.mRoot);
        this.mRoot = null;
        while (!queue.isEmpty()) {
            TreeNode node = (TreeNode)queue.poll();
            if (node.mDisplayId != displayId) {
                this.addDisplay(node.mDisplayId, node.mWidth, node.mHeight);
            }
            queue.addAll(node.mChildren);
        }
        if (this.mPrimaryDisplayId == displayId) {
            this.mPrimaryDisplayId = this.mRoot != null ? this.mRoot.mDisplayId : -1;
        }
        return true;
    }

    public void rearrange(Map<Integer, PointF> newPos) {
        if (this.mRoot == null) {
            return;
        }
        ArrayList<TreeNode> availableParents = new ArrayList<TreeNode>();
        availableParents.addLast(this.mRoot);
        Map<Integer, TreeNode> needsParent = this.allNodesIdMap();
        if (needsParent.size() != newPos.size()) {
            throw new IllegalArgumentException("newPos has wrong number of entries: " + newPos);
        }
        this.mRoot.mChildren.clear();
        for (TreeNode n : needsParent.values()) {
            n.mChildren.clear();
        }
        needsParent.remove(this.mRoot.mDisplayId);
        while (!needsParent.isEmpty()) {
            double bestDist = Double.POSITIVE_INFINITY;
            TreeNode bestChild = null;
            TreeNode bestParent = null;
            for (TreeNode child : needsParent.values()) {
                PointF childPos = newPos.get(child.mDisplayId);
                float childRight = childPos.x + child.getWidth();
                float childBottom = childPos.y + child.getHeight();
                for (TreeNode parent : availableParents) {
                    float offset;
                    int pos;
                    float yDeviation;
                    float xDeviation;
                    float yOverlap;
                    PointF parentPos = newPos.get(parent.mDisplayId);
                    float parentRight = parentPos.x + parent.getWidth();
                    float parentBottom = parentPos.y + parent.getHeight();
                    float xOverlap = Math.min(parentRight, childRight) - Math.max(parentPos.x, childPos.x);
                    if (xOverlap > (yOverlap = Math.min(parentBottom, childBottom) - Math.max(parentPos.y, childPos.y))) {
                        xDeviation = Math.min(child.getWidth(), parent.getWidth()) - xOverlap;
                        if (childPos.y < parentPos.y) {
                            yDeviation = childBottom - parentPos.y;
                            pos = 1;
                        } else {
                            yDeviation = parentBottom - childPos.y;
                            pos = 3;
                        }
                        offset = childPos.x - parentPos.x;
                    } else {
                        yDeviation = Math.min(child.getHeight(), parent.getHeight()) - yOverlap;
                        if (childPos.x < parentPos.x) {
                            xDeviation = childRight - parentPos.x;
                            pos = 0;
                        } else {
                            xDeviation = parentRight - childPos.x;
                            pos = 2;
                        }
                        offset = childPos.y - parentPos.y;
                    }
                    double dist = Math.hypot(xDeviation, yDeviation);
                    if (dist >= bestDist) continue;
                    bestDist = dist;
                    bestChild = child;
                    bestParent = parent;
                    bestChild.mPosition = pos;
                    bestChild.mOffset = offset;
                }
            }
            assert (bestParent != null & bestChild != null);
            bestParent.addChild(bestChild);
            if (null == needsParent.remove(bestChild.mDisplayId)) {
                throw new IllegalStateException("child not in pending set! " + bestChild);
            }
            availableParents.add(bestChild);
        }
        this.normalize();
    }

    public void normalize() {
        if (this.mRoot == null) {
            return;
        }
        this.clampOffsets(this.mRoot);
        HashMap<TreeNode, RectF> bounds = new HashMap<TreeNode, RectF>();
        HashMap<TreeNode, Integer> depths = new HashMap<TreeNode, Integer>();
        HashMap<TreeNode, TreeNode> parents = new HashMap<TreeNode, TreeNode>();
        DisplayTopology.getInfo(bounds, depths, parents, this.mRoot, 0.0f, 0.0f, 0);
        Comparator comparator = (d1, d2) -> {
            if (d1 == d2) {
                return 0;
            }
            int compareDepths = Integer.compare((Integer)depths.get(d1), (Integer)depths.get(d2));
            if (compareDepths != 0) {
                return compareDepths;
            }
            RectF bounds1 = (RectF)bounds.get(d1);
            RectF bounds2 = (RectF)bounds.get(d2);
            return Double.compare(Math.hypot(bounds1.left, bounds1.top), Math.hypot(bounds2.left, bounds2.top));
        };
        ArrayList displays = new ArrayList(bounds.keySet());
        displays.sort(comparator);
        for (int i = 1; i < displays.size(); ++i) {
            boolean bl;
            boolean bl2;
            TreeNode parent;
            TreeNode targetDisplay = (TreeNode)displays.get(i);
            TreeNode lastIntersectingSourceDisplay = null;
            float lastOffsetX = 0.0f;
            float lastOffsetY = 0.0f;
            for (int j = 0; j < i; ++j) {
                float offsetY;
                RectF targetBounds;
                TreeNode sourceDisplay = (TreeNode)displays.get(j);
                RectF sourceBounds = (RectF)bounds.get(sourceDisplay);
                if (!RectF.intersects(sourceBounds, targetBounds = (RectF)bounds.get(targetDisplay))) continue;
                float offsetX = targetBounds.left >= 0.0f ? sourceBounds.right - targetBounds.left : sourceBounds.left - targetBounds.right;
                float f = offsetY = targetBounds.top >= 0.0f ? sourceBounds.bottom - targetBounds.top : sourceBounds.top - targetBounds.bottom;
                if (Math.abs(offsetX) <= Math.abs(offsetY)) {
                    targetBounds.left += offsetX;
                    targetBounds.right += offsetX;
                    if (targetDisplay.mPosition == 1 || targetDisplay.mPosition == 3) {
                        targetDisplay.mOffset += offsetX;
                    }
                    offsetY = 0.0f;
                } else {
                    targetBounds.top += offsetY;
                    targetBounds.bottom += offsetY;
                    if (targetDisplay.mPosition == 0 || targetDisplay.mPosition == 2) {
                        targetDisplay.mOffset += offsetY;
                    }
                    offsetX = 0.0f;
                }
                lastIntersectingSourceDisplay = sourceDisplay;
                lastOffsetX = offsetX;
                lastOffsetY = offsetY;
            }
            if (lastIntersectingSourceDisplay == null || (parent = (TreeNode)parents.get(targetDisplay)) == lastIntersectingSourceDisplay) continue;
            RectF childBounds = (RectF)bounds.get(targetDisplay);
            RectF parentBounds = (RectF)bounds.get(parent);
            switch (targetDisplay.mPosition) {
                case 0: {
                    bl2 = DisplayTopology.floatEquals(parentBounds.left, childBounds.right);
                    break;
                }
                case 2: {
                    bl2 = DisplayTopology.floatEquals(parentBounds.right, childBounds.left);
                    break;
                }
                case 1: {
                    bl2 = DisplayTopology.floatEquals(parentBounds.top, childBounds.bottom);
                    break;
                }
                case 3: {
                    bl2 = DisplayTopology.floatEquals(parentBounds.bottom, childBounds.top);
                    break;
                }
                default: {
                    throw new IllegalStateException("Unexpected value: " + targetDisplay.mPosition);
                }
            }
            boolean areTouching = bl2;
            switch (targetDisplay.mPosition) {
                case 0: 
                case 2: {
                    if (childBounds.bottom + 1.0E-4f > parentBounds.top && childBounds.top < parentBounds.bottom + 1.0E-4f) {
                        bl = true;
                        break;
                    }
                    bl = false;
                    break;
                }
                case 1: 
                case 3: {
                    if (childBounds.right + 1.0E-4f > parentBounds.left && childBounds.left < parentBounds.right + 1.0E-4f) {
                        bl = true;
                        break;
                    }
                    bl = false;
                    break;
                }
                default: {
                    throw new IllegalStateException("Unexpected value: " + targetDisplay.mPosition);
                }
            }
            if (areTouching &= bl) continue;
            parent.mChildren.remove(targetDisplay);
            RectF lastIntersectingSourceDisplayBounds = (RectF)bounds.get(lastIntersectingSourceDisplay);
            lastIntersectingSourceDisplay.mChildren.add(targetDisplay);
            if (lastOffsetX != 0.0f) {
                targetDisplay.mPosition = lastOffsetX > 0.0f ? 2 : 0;
                targetDisplay.mOffset = childBounds.top - lastIntersectingSourceDisplayBounds.top;
                continue;
            }
            if (lastOffsetY == 0.0f) continue;
            targetDisplay.mPosition = lastOffsetY > 0.0f ? 3 : 1;
            targetDisplay.mOffset = childBounds.left - lastIntersectingSourceDisplayBounds.left;
        }
        Comparator idComparator = (d1, d2) -> Integer.compare(d1.mDisplayId, d2.mDisplayId);
        for (TreeNode display : displays) {
            display.mChildren.sort(idComparator);
        }
    }

    public DisplayTopology copy() {
        TreeNode rootCopy = this.mRoot == null ? null : this.mRoot.copy();
        return new DisplayTopology(rootCopy, this.mPrimaryDisplayId);
    }

    @com.android.layoutlib.androidx.annotation.NonNull
    public SparseArray<RectF> getAbsoluteBounds() {
        HashMap<TreeNode, RectF> bounds = new HashMap<TreeNode, RectF>();
        DisplayTopology.getInfo(bounds, null, null, this.mRoot, 0.0f, 0.0f, 0);
        SparseArray<RectF> boundsById = new SparseArray<RectF>();
        for (Map.Entry entry : bounds.entrySet()) {
            boundsById.append(((TreeNode)entry.getKey()).mDisplayId, (RectF)entry.getValue());
        }
        return boundsById;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(@com.android.layoutlib.androidx.annotation.NonNull Parcel dest, int flags) {
        dest.writeTypedObject(this.mRoot, flags);
        dest.writeInt(this.mPrimaryDisplayId);
    }

    public void dump(PrintWriter pw) {
        pw.println("DisplayTopology:");
        pw.println("--------------------");
        IndentingPrintWriter ipw = new IndentingPrintWriter(pw);
        ipw.increaseIndent();
        ipw.println("mPrimaryDisplayId: " + this.mPrimaryDisplayId);
        ipw.println("Topology tree:");
        if (this.mRoot != null) {
            ipw.increaseIndent();
            this.mRoot.dump(ipw);
            ipw.decreaseIndent();
        }
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof DisplayTopology)) {
            return false;
        }
        return obj.toString().equals(this.toString());
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public String toString() {
        StringWriter out = new StringWriter();
        PrintWriter writer = new PrintWriter(out);
        this.dump(writer);
        return ((Object)out).toString();
    }

    private static Pair<TreeNode, Float> findRightMostDisplay(TreeNode display, float xPos) {
        Pair<TreeNode, Float> result = new Pair<TreeNode, Float>(display, Float.valueOf(xPos));
        for (TreeNode child : display.mChildren) {
            float childXPos;
            switch (child.mPosition) {
                case 0: {
                    childXPos = xPos - display.mWidth;
                    break;
                }
                case 1: 
                case 3: {
                    childXPos = xPos - display.mWidth + child.mOffset + child.mWidth;
                    break;
                }
                case 2: {
                    childXPos = xPos + child.mWidth;
                    break;
                }
                default: {
                    throw new IllegalStateException("Unexpected value: " + child.mPosition);
                }
            }
            Pair<TreeNode, Float> childResult = DisplayTopology.findRightMostDisplay(child, childXPos);
            if (!(((Float)childResult.second).floatValue() > ((Float)result.second).floatValue())) continue;
            result = new Pair<TreeNode, Float>((TreeNode)childResult.first, (Float)childResult.second);
        }
        return result;
    }

    @Nullable
    public static TreeNode findDisplay(int displayId, @Nullable TreeNode startingNode) {
        if (startingNode == null) {
            return null;
        }
        if (startingNode.mDisplayId == displayId) {
            return startingNode;
        }
        for (TreeNode child : startingNode.mChildren) {
            TreeNode display = DisplayTopology.findDisplay(displayId, child);
            if (display == null) continue;
            return display;
        }
        return null;
    }

    private static void getInfo(@Nullable Map<TreeNode, RectF> bounds, @Nullable Map<TreeNode, Integer> depths, @Nullable Map<TreeNode, TreeNode> parents, @Nullable TreeNode display, float x, float y, int depth) {
        if (display == null) {
            return;
        }
        if (bounds != null) {
            bounds.put(display, new RectF(x, y, x + display.mWidth, y + display.mHeight));
        }
        if (depths != null) {
            depths.put(display, depth);
        }
        for (TreeNode child : display.mChildren) {
            if (parents != null) {
                parents.put(child, display);
            }
            if (child.mPosition == 0) {
                DisplayTopology.getInfo(bounds, depths, parents, child, x - child.mWidth, y + child.mOffset, depth + 1);
                continue;
            }
            if (child.mPosition == 2) {
                DisplayTopology.getInfo(bounds, depths, parents, child, x + display.mWidth, y + child.mOffset, depth + 1);
                continue;
            }
            if (child.mPosition == 1) {
                DisplayTopology.getInfo(bounds, depths, parents, child, x + child.mOffset, y - child.mHeight, depth + 1);
                continue;
            }
            if (child.mPosition != 3) continue;
            DisplayTopology.getInfo(bounds, depths, parents, child, x + child.mOffset, y + display.mHeight, depth + 1);
        }
    }

    private List<Pair<Integer, Float>> findDisplayPlacements(RectF bounds1, RectF bounds2) {
        ArrayList<Pair<Integer, Float>> placements = new ArrayList<Pair<Integer, Float>>();
        if (bounds1.top <= bounds2.bottom + 5.0f && bounds2.top <= bounds1.bottom + 5.0f) {
            if (MathUtils.abs(bounds1.left - bounds2.right) <= 5.0f) {
                placements.add(new Pair<Integer, Float>(0, Float.valueOf(bounds2.top - bounds1.top)));
            }
            if (MathUtils.abs(bounds1.right - bounds2.left) <= 5.0f) {
                placements.add(new Pair<Integer, Float>(2, Float.valueOf(bounds2.top - bounds1.top)));
            }
        }
        if (bounds1.left <= bounds2.right + 5.0f && bounds2.left <= bounds1.right + 5.0f) {
            if (MathUtils.abs(bounds1.top - bounds2.bottom) < 5.0f) {
                placements.add(new Pair<Integer, Float>(1, Float.valueOf(bounds2.left - bounds1.left)));
            }
            if (MathUtils.abs(bounds1.bottom - bounds2.top) < 5.0f) {
                placements.add(new Pair<Integer, Float>(3, Float.valueOf(bounds2.left - bounds1.left)));
            }
        }
        return placements;
    }

    @Nullable
    public DisplayTopologyGraph getGraph(SparseIntArray densityPerDisplay) {
        SparseArray<RectF> bounds = this.getAbsoluteBounds();
        Comparator comparator = (displayId1, displayId2) -> {
            RectF bounds1 = (RectF)bounds.get((int)displayId1);
            RectF bounds2 = (RectF)bounds.get((int)displayId2);
            int compareX = Float.compare(bounds1.left, bounds2.left);
            if (compareX != 0) {
                return compareX;
            }
            return Float.compare(bounds1.top, bounds2.top);
        };
        ArrayList<Integer> displayIds = new ArrayList<Integer>(bounds.size());
        for (int i = 0; i < bounds.size(); ++i) {
            displayIds.add(bounds.keyAt(i));
        }
        displayIds.sort(comparator);
        SparseArray adjacentDisplaysPerId = new SparseArray();
        Iterator iterator = displayIds.iterator();
        while (iterator.hasNext()) {
            int id2 = (Integer)iterator.next();
            if (densityPerDisplay.get(id2) == 0) {
                Slog.e(TAG, "Cannot construct graph, no density for display " + id2);
                return null;
            }
            adjacentDisplaysPerId.append(id2, new ArrayList(Math.min(10, displayIds.size())));
        }
        block2: for (int i = 0; i < displayIds.size(); ++i) {
            int displayId12 = (Integer)displayIds.get(i);
            RectF bounds1 = bounds.get(displayId12);
            List adjacentDisplays1 = (List)adjacentDisplaysPerId.get(displayId12);
            for (int j = i + 1; j < displayIds.size(); ++j) {
                int displayId22 = (Integer)displayIds.get(j);
                RectF bounds2 = bounds.get(displayId22);
                List adjacentDisplays2 = (List)adjacentDisplaysPerId.get(displayId22);
                List<Pair<Integer, Float>> placements1 = this.findDisplayPlacements(bounds1, bounds2);
                List<Pair<Integer, Float>> placements2 = this.findDisplayPlacements(bounds2, bounds1);
                for (Pair<Integer, Float> placement : placements1) {
                    adjacentDisplays1.add(new DisplayTopologyGraph.AdjacentDisplay(displayId22, (Integer)placement.first, ((Float)placement.second).floatValue()));
                }
                for (Pair<Integer, Float> placement : placements2) {
                    adjacentDisplays2.add(new DisplayTopologyGraph.AdjacentDisplay(displayId12, (Integer)placement.first, ((Float)placement.second).floatValue()));
                }
                if (bounds2.left >= bounds1.right + 1.0E-4f) continue block2;
            }
        }
        DisplayTopologyGraph.DisplayNode[] nodes = new DisplayTopologyGraph.DisplayNode[adjacentDisplaysPerId.size()];
        for (int i = 0; i < nodes.length; ++i) {
            int displayId = adjacentDisplaysPerId.keyAt(i);
            nodes[i] = new DisplayTopologyGraph.DisplayNode(displayId, densityPerDisplay.get(displayId), ((List)adjacentDisplaysPerId.valueAt(i)).toArray(new DisplayTopologyGraph.AdjacentDisplay[0]));
        }
        return new DisplayTopologyGraph(this.mPrimaryDisplayId, nodes);
    }

    private static boolean floatEquals(float a, float b) {
        return a == b || Float.isNaN(a) && Float.isNaN(b) || Math.abs(a - b) < 1.0E-4f;
    }

    private Map<Integer, TreeNode> allNodesIdMap() {
        ArrayDeque<TreeNode> pend = new ArrayDeque<TreeNode>();
        HashMap<Integer, TreeNode> found = new HashMap<Integer, TreeNode>();
        pend.push(this.mRoot);
        do {
            TreeNode node = (TreeNode)pend.pop();
            found.put(node.mDisplayId, node);
            pend.addAll(node.mChildren);
        } while (!pend.isEmpty());
        return found;
    }

    private void clampOffsets(@Nullable TreeNode display) {
        if (display == null) {
            return;
        }
        for (TreeNode child : display.mChildren) {
            if (child.mPosition == 0 || child.mPosition == 2) {
                child.mOffset = MathUtils.constrain(child.mOffset, -child.mHeight, display.mHeight);
            } else if (child.mPosition == 1 || child.mPosition == 3) {
                child.mOffset = MathUtils.constrain(child.mOffset, -child.mWidth, display.mWidth);
            }
            this.clampOffsets(child);
        }
    }

    public static class TreeNode
    implements Parcelable {
        public static final int POSITION_LEFT = 0;
        public static final int POSITION_TOP = 1;
        public static final int POSITION_RIGHT = 2;
        public static final int POSITION_BOTTOM = 3;
        @NonNull
        public static final Parcelable.Creator<TreeNode> CREATOR = new Parcelable.Creator<TreeNode>(){

            @Override
            public TreeNode createFromParcel(Parcel source) {
                return new TreeNode(source);
            }

            public TreeNode[] newArray(int size) {
                return new TreeNode[size];
            }
        };
        private final int mDisplayId;
        private float mWidth;
        private float mHeight;
        private int mPosition;
        private float mOffset;
        private final List<TreeNode> mChildren;

        @VisibleForTesting
        public TreeNode(int displayId, float width, float height, int position, float offset) {
            this(displayId, width, height, position, offset, List.of());
        }

        public TreeNode(int displayId, float width, float height, int position, float offset, List<TreeNode> children) {
            this.mDisplayId = displayId;
            this.mWidth = width;
            this.mHeight = height;
            this.mPosition = position;
            this.mOffset = offset;
            this.mChildren = new ArrayList<TreeNode>(children);
        }

        public TreeNode(Parcel source) {
            this(source.readInt(), source.readFloat(), source.readFloat(), source.readInt(), source.readFloat());
            source.readTypedList(this.mChildren, CREATOR);
        }

        public int getDisplayId() {
            return this.mDisplayId;
        }

        public float getWidth() {
            return this.mWidth;
        }

        public float getHeight() {
            return this.mHeight;
        }

        public int getPosition() {
            return this.mPosition;
        }

        public float getOffset() {
            return this.mOffset;
        }

        public List<TreeNode> getChildren() {
            return Collections.unmodifiableList(this.mChildren);
        }

        public TreeNode copy() {
            TreeNode copy = new TreeNode(this.mDisplayId, this.mWidth, this.mHeight, this.mPosition, this.mOffset);
            for (TreeNode child : this.mChildren) {
                copy.mChildren.add(child.copy());
            }
            return copy;
        }

        public String toString() {
            return "Display {id=" + this.mDisplayId + ", width=" + this.mWidth + ", height=" + this.mHeight + ", position=" + TreeNode.positionToString(this.mPosition) + ", offset=" + this.mOffset + "}";
        }

        public static String positionToString(int position) {
            String string2;
            switch (position) {
                case 0: {
                    string2 = "left";
                    break;
                }
                case 1: {
                    string2 = "top";
                    break;
                }
                case 2: {
                    string2 = "right";
                    break;
                }
                case 3: {
                    string2 = "bottom";
                    break;
                }
                default: {
                    throw new IllegalStateException("Unexpected value: " + position);
                }
            }
            return string2;
        }

        @Override
        public int describeContents() {
            return 0;
        }

        @Override
        public void writeToParcel(@com.android.layoutlib.androidx.annotation.NonNull Parcel dest, int flags) {
            dest.writeInt(this.mDisplayId);
            dest.writeFloat(this.mWidth);
            dest.writeFloat(this.mHeight);
            dest.writeInt(this.mPosition);
            dest.writeFloat(this.mOffset);
            dest.writeTypedList(this.mChildren);
        }

        public void dump(IndentingPrintWriter ipw) {
            ipw.println(this);
            ipw.increaseIndent();
            for (TreeNode child : this.mChildren) {
                child.dump(ipw);
            }
            ipw.decreaseIndent();
        }

        @VisibleForTesting
        public void addChild(TreeNode child) {
            this.mChildren.add(child);
        }

        @Retention(value=RetentionPolicy.SOURCE)
        public static @interface Position {
        }
    }
}

