/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.contexthub;

import android.annotation.EnforcePermission;
import android.app.ActivityThread;
import android.hardware.contexthub.HubEndpointInfo;
import android.hardware.contexthub.HubMessage;
import android.hardware.location.IContextHubTransactionCallback;
import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.PermissionEnforcer;
import android.os.RemoteException;

public interface IContextHubEndpoint
extends IInterface {
    public static final String DESCRIPTOR = "android.hardware.contexthub.IContextHubEndpoint";

    public HubEndpointInfo getAssignedHubEndpointInfo() throws RemoteException;

    @EnforcePermission(value="android.permission.ACCESS_CONTEXT_HUB")
    public int openSession(HubEndpointInfo var1, String var2) throws RemoteException;

    @EnforcePermission(value="android.permission.ACCESS_CONTEXT_HUB")
    public void closeSession(int var1, int var2) throws RemoteException;

    @EnforcePermission(value="android.permission.ACCESS_CONTEXT_HUB")
    public void openSessionRequestComplete(int var1) throws RemoteException;

    @EnforcePermission(value="android.permission.ACCESS_CONTEXT_HUB")
    public void unregister() throws RemoteException;

    @EnforcePermission(value="android.permission.ACCESS_CONTEXT_HUB")
    public void sendMessage(int var1, HubMessage var2, IContextHubTransactionCallback var3) throws RemoteException;

    @EnforcePermission(value="android.permission.ACCESS_CONTEXT_HUB")
    public void sendMessageDeliveryStatus(int var1, int var2, byte var3) throws RemoteException;

    @EnforcePermission(value="android.permission.ACCESS_CONTEXT_HUB")
    public void onCallbackFinished() throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements IContextHubEndpoint {
        private final PermissionEnforcer mEnforcer;
        static final int TRANSACTION_getAssignedHubEndpointInfo = 1;
        static final int TRANSACTION_openSession = 2;
        static final int TRANSACTION_closeSession = 3;
        static final int TRANSACTION_openSessionRequestComplete = 4;
        static final int TRANSACTION_unregister = 5;
        static final int TRANSACTION_sendMessage = 6;
        static final int TRANSACTION_sendMessageDeliveryStatus = 7;
        static final int TRANSACTION_onCallbackFinished = 8;

        public Stub(PermissionEnforcer enforcer) {
            this.attachInterface(this, IContextHubEndpoint.DESCRIPTOR);
            if (enforcer == null) {
                throw new IllegalArgumentException("enforcer cannot be null");
            }
            this.mEnforcer = enforcer;
        }

        @Deprecated
        public Stub() {
            this(PermissionEnforcer.fromContext(ActivityThread.currentActivityThread().getSystemContext()));
        }

        public static IContextHubEndpoint asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(IContextHubEndpoint.DESCRIPTOR);
            if (iin != null && iin instanceof IContextHubEndpoint) {
                return (IContextHubEndpoint)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 1: {
                    return "getAssignedHubEndpointInfo";
                }
                case 2: {
                    return "openSession";
                }
                case 3: {
                    return "closeSession";
                }
                case 4: {
                    return "openSessionRequestComplete";
                }
                case 5: {
                    return "unregister";
                }
                case 6: {
                    return "sendMessage";
                }
                case 7: {
                    return "sendMessageDeliveryStatus";
                }
                case 8: {
                    return "onCallbackFinished";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = IContextHubEndpoint.DESCRIPTOR;
            if (code >= 1 && code <= 0xFFFFFF) {
                data.enforceInterface(descriptor);
            }
            if (code == 1598968902) {
                reply.writeString(descriptor);
                return true;
            }
            switch (code) {
                case 1: {
                    HubEndpointInfo _result = this.getAssignedHubEndpointInfo();
                    reply.writeNoException();
                    reply.writeTypedObject(_result, 1);
                    break;
                }
                case 2: {
                    HubEndpointInfo _arg0 = data.readTypedObject(HubEndpointInfo.CREATOR);
                    String _arg1 = data.readString();
                    data.enforceNoDataAvail();
                    int _result = this.openSession(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    break;
                }
                case 3: {
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    this.closeSession(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 4: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    this.openSessionRequestComplete(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 5: {
                    this.unregister();
                    reply.writeNoException();
                    break;
                }
                case 6: {
                    int _arg0 = data.readInt();
                    HubMessage _arg1 = data.readTypedObject(HubMessage.CREATOR);
                    IContextHubTransactionCallback _arg2 = IContextHubTransactionCallback.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.sendMessage(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    break;
                }
                case 7: {
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    byte _arg2 = data.readByte();
                    data.enforceNoDataAvail();
                    this.sendMessageDeliveryStatus(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    break;
                }
                case 8: {
                    this.onCallbackFinished();
                    break;
                }
                default: {
                    return super.onTransact(code, data, reply, flags);
                }
            }
            return true;
        }

        protected void openSession_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.ACCESS_CONTEXT_HUB", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void closeSession_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.ACCESS_CONTEXT_HUB", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void openSessionRequestComplete_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.ACCESS_CONTEXT_HUB", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void unregister_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.ACCESS_CONTEXT_HUB", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void sendMessage_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.ACCESS_CONTEXT_HUB", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void sendMessageDeliveryStatus_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.ACCESS_CONTEXT_HUB", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void onCallbackFinished_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.ACCESS_CONTEXT_HUB", Stub.getCallingPid(), Stub.getCallingUid());
        }

        @Override
        public int getMaxTransactionId() {
            return 7;
        }

        private static class Proxy
        implements IContextHubEndpoint {
            private IBinder mRemote;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return IContextHubEndpoint.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public HubEndpointInfo getAssignedHubEndpointInfo() throws RemoteException {
                HubEndpointInfo _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IContextHubEndpoint.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(1, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readTypedObject(HubEndpointInfo.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int openSession(HubEndpointInfo destination, String serviceDescriptor) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IContextHubEndpoint.DESCRIPTOR);
                    _data.writeTypedObject(destination, 0);
                    _data.writeString(serviceDescriptor);
                    boolean _status = this.mRemote.transact(2, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void closeSession(int sessionId, int reason) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IContextHubEndpoint.DESCRIPTOR);
                    _data.writeInt(sessionId);
                    _data.writeInt(reason);
                    boolean _status = this.mRemote.transact(3, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void openSessionRequestComplete(int sessionId) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IContextHubEndpoint.DESCRIPTOR);
                    _data.writeInt(sessionId);
                    boolean _status = this.mRemote.transact(4, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void unregister() throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IContextHubEndpoint.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(5, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void sendMessage(int sessionId, HubMessage message, IContextHubTransactionCallback transactionCallback) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IContextHubEndpoint.DESCRIPTOR);
                    _data.writeInt(sessionId);
                    _data.writeTypedObject(message, 0);
                    _data.writeStrongInterface(transactionCallback);
                    boolean _status = this.mRemote.transact(6, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void sendMessageDeliveryStatus(int sessionId, int messageSeqNumber, byte errorCode) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IContextHubEndpoint.DESCRIPTOR);
                    _data.writeInt(sessionId);
                    _data.writeInt(messageSeqNumber);
                    _data.writeByte(errorCode);
                    boolean _status = this.mRemote.transact(7, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            @Override
            public void onCallbackFinished() throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(IContextHubEndpoint.DESCRIPTOR);
                    boolean bl = this.mRemote.transact(8, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }
        }
    }

    public static class Default
    implements IContextHubEndpoint {
        @Override
        public HubEndpointInfo getAssignedHubEndpointInfo() throws RemoteException {
            return null;
        }

        @Override
        public int openSession(HubEndpointInfo destination, String serviceDescriptor) throws RemoteException {
            return 0;
        }

        @Override
        public void closeSession(int sessionId, int reason) throws RemoteException {
        }

        @Override
        public void openSessionRequestComplete(int sessionId) throws RemoteException {
        }

        @Override
        public void unregister() throws RemoteException {
        }

        @Override
        public void sendMessage(int sessionId, HubMessage message, IContextHubTransactionCallback transactionCallback) throws RemoteException {
        }

        @Override
        public void sendMessageDeliveryStatus(int sessionId, int messageSeqNumber, byte errorCode) throws RemoteException {
        }

        @Override
        public void onCallbackFinished() throws RemoteException {
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

