/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.contexthub;

import android.annotation.FlaggedApi;
import android.annotation.NonNull;
import android.annotation.Nullable;
import android.annotation.RequiresPermission;
import android.annotation.SystemApi;
import android.hardware.contexthub.HubEndpoint;
import android.hardware.contexthub.HubEndpointInfo;
import android.hardware.contexthub.HubMessage;
import android.hardware.location.ContextHubTransaction;
import android.hardware.location.ContextHubTransactionHelper;
import android.hardware.location.IContextHubTransactionCallback;
import android.util.CloseGuard;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;

@SystemApi
@FlaggedApi(value="android.chre.flags.offload_api")
public class HubEndpointSession
implements AutoCloseable {
    private final CloseGuard mCloseGuard = new CloseGuard();
    private final int mId;
    @NonNull
    private final HubEndpoint mHubEndpoint;
    @NonNull
    private final HubEndpointInfo mInitiator;
    @NonNull
    private final HubEndpointInfo mDestination;
    @Nullable
    private final String mServiceDescriptor;
    private final AtomicBoolean mIsClosed = new AtomicBoolean(true);

    HubEndpointSession(int id2, @NonNull HubEndpoint hubEndpoint, @NonNull HubEndpointInfo destination, @NonNull HubEndpointInfo initiator, @Nullable String serviceDescriptor) {
        this.mId = id2;
        this.mHubEndpoint = hubEndpoint;
        this.mDestination = destination;
        this.mInitiator = initiator;
        this.mServiceDescriptor = serviceDescriptor;
    }

    @NonNull
    @RequiresPermission(value="android.permission.ACCESS_CONTEXT_HUB")
    public ContextHubTransaction<Void> sendMessage(@NonNull HubMessage message) {
        if (this.mIsClosed.get()) {
            throw new IllegalStateException("Session is already closed.");
        }
        boolean isResponseRequired = message.isResponseRequired();
        ContextHubTransaction<Void> ret = new ContextHubTransaction<Void>(isResponseRequired ? 7 : 6);
        if (!isResponseRequired) {
            this.mHubEndpoint.sendMessage(this, message, null);
            ret.setResponse(new ContextHubTransaction.Response<Object>(0, null));
        } else {
            IContextHubTransactionCallback callback = ContextHubTransactionHelper.createTransactionCallback(ret);
            this.mHubEndpoint.sendMessage(this, message, callback);
        }
        return ret;
    }

    public int getId() {
        return this.mId;
    }

    public void setOpened() {
        this.mIsClosed.set(false);
        this.mCloseGuard.open("close");
    }

    public void setClosed() {
        this.mIsClosed.set(true);
        this.mCloseGuard.close();
    }

    @Override
    @RequiresPermission(value="android.permission.ACCESS_CONTEXT_HUB")
    public void close() {
        if (!this.mIsClosed.getAndSet(true)) {
            this.mCloseGuard.close();
            this.mHubEndpoint.closeSession(this);
        }
    }

    @Nullable
    public String getServiceDescriptor() {
        return this.mServiceDescriptor;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Session [");
        stringBuilder.append(this.mId);
        stringBuilder.append("]: [");
        stringBuilder.append(this.mInitiator);
        stringBuilder.append("]->[");
        stringBuilder.append(this.mDestination);
        stringBuilder.append("]");
        return stringBuilder.toString();
    }

    public boolean equals(@Nullable Object object) {
        if (object == this) {
            return true;
        }
        boolean isEqual = false;
        if (object instanceof HubEndpointSession) {
            HubEndpointSession other = (HubEndpointSession)object;
            boolean bl = isEqual = other.getId() == this.mId;
            isEqual = this.mServiceDescriptor != null ? (isEqual &= this.mServiceDescriptor.equals(other.getServiceDescriptor())) : (isEqual &= other.getServiceDescriptor() == null);
            isEqual &= this.mInitiator.equals(other.mInitiator) && this.mDestination.equals(other.mDestination);
        }
        return isEqual;
    }

    public int hashCode() {
        return Objects.hash(this.mId, this.mServiceDescriptor, this.mInitiator, this.mDestination);
    }

    protected void finalize() throws Throwable {
        try {
            if (this.mCloseGuard != null) {
                this.mCloseGuard.warnIfOpen();
            }
            this.close();
        }
        finally {
            super.finalize();
        }
    }
}

