/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.camera2.utils;

import android.compat.annotation.UnsupportedAppUsage;
import android.hardware.camera2.params.StreamConfigurationMap;
import android.system.OsConstants;
import android.util.Range;
import android.util.Size;
import android.view.Surface;
import com.android.internal.util.Preconditions;
import com.android.tools.layoutlib.create.OverrideMethod;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

public class SurfaceUtils {
    private static final int USAGE_RENDERSCRIPT = 0x100000;
    private static final int USAGE_HW_COMPOSER = 2048;
    private static final int BGRA_8888 = 5;
    private static final int BAD_VALUE = -OsConstants.EINVAL;

    public static boolean isSurfaceForPreview(Surface surface) {
        Preconditions.checkNotNull(surface);
        long usageFlags = SurfaceUtils.nativeDetectSurfaceUsageFlags(surface);
        long disallowedFlags = 0x110003L;
        long allowedFlags = 2816L;
        boolean previewConsumer = (usageFlags & disallowedFlags) == 0L && (usageFlags & allowedFlags) != 0L;
        int surfaceFormat = SurfaceUtils.getSurfaceFormat(surface);
        return previewConsumer;
    }

    public static boolean isSurfaceForHwVideoEncoder(Surface surface) {
        Preconditions.checkNotNull(surface);
        long usageFlags = SurfaceUtils.nativeDetectSurfaceUsageFlags(surface);
        long disallowedFlags = 1050627L;
        long allowedFlags = 65536L;
        boolean videoEncoderConsumer = (usageFlags & disallowedFlags) == 0L && (usageFlags & allowedFlags) != 0L;
        int surfaceFormat = SurfaceUtils.getSurfaceFormat(surface);
        return videoEncoderConsumer;
    }

    public static long getSurfaceId(Surface surface) {
        Preconditions.checkNotNull(surface);
        try {
            return SurfaceUtils.nativeGetSurfaceId(surface);
        }
        catch (IllegalArgumentException e) {
            return 0L;
        }
    }

    public static long getSurfaceUsage(Surface surface) {
        Preconditions.checkNotNull(surface);
        try {
            return SurfaceUtils.nativeDetectSurfaceUsageFlags(surface);
        }
        catch (IllegalArgumentException e) {
            return 0L;
        }
    }

    @UnsupportedAppUsage
    public static Size getSurfaceSize(Surface surface) {
        Preconditions.checkNotNull(surface);
        int[] dimens = new int[2];
        int errorFlag = SurfaceUtils.nativeDetectSurfaceDimens(surface, dimens);
        if (errorFlag == BAD_VALUE) {
            throw new IllegalArgumentException("Surface was abandoned");
        }
        return new Size(dimens[0], dimens[1]);
    }

    public static int getSurfaceFormat(Surface surface) {
        Preconditions.checkNotNull(surface);
        int surfaceType = SurfaceUtils.nativeDetectSurfaceType(surface);
        if (surfaceType == BAD_VALUE) {
            throw new IllegalArgumentException("Surface was abandoned");
        }
        if (surfaceType >= 1 && surfaceType <= 5) {
            surfaceType = 34;
        }
        return surfaceType;
    }

    public static int detectSurfaceFormat(Surface surface) {
        Preconditions.checkNotNull(surface);
        int surfaceType = SurfaceUtils.nativeDetectSurfaceType(surface);
        if (surfaceType == BAD_VALUE) {
            throw new IllegalArgumentException("Surface was abandoned");
        }
        return surfaceType;
    }

    public static int getSurfaceDataspace(Surface surface) {
        Preconditions.checkNotNull(surface);
        int dataSpace = SurfaceUtils.nativeDetectSurfaceDataspace(surface);
        if (dataSpace == BAD_VALUE) {
            throw new IllegalArgumentException("Surface was abandoned");
        }
        return dataSpace;
    }

    public static boolean isFlexibleConsumer(Surface output) {
        Preconditions.checkNotNull(output);
        long usageFlags = SurfaceUtils.nativeDetectSurfaceUsageFlags(output);
        long disallowedFlags = 0x110000L;
        long allowedFlags = 2307L;
        boolean flexibleConsumer = (usageFlags & disallowedFlags) == 0L && (usageFlags & allowedFlags) != 0L;
        return flexibleConsumer;
    }

    private static void checkHighSpeedSurfaceFormat(Surface surface) {
        int surfaceFormat = SurfaceUtils.getSurfaceFormat(surface);
        if (surfaceFormat != 34) {
            throw new IllegalArgumentException("Surface format(" + surfaceFormat + ") is not for preview or hardware video encoding!");
        }
    }

    public static void checkConstrainedHighSpeedSurfaces(Collection<Surface> surfaces, Range<Integer> fpsRange, StreamConfigurationMap config) {
        boolean isSecondSurfacePreview;
        Iterator<Surface> iterator;
        boolean isFirstSurfacePreview;
        if (surfaces == null || surfaces.size() == 0 || surfaces.size() > 2) {
            throw new IllegalArgumentException("Output target surface list must not be null and the size must be 1 or 2");
        }
        List<Size> highSpeedSizes = null;
        if (fpsRange == null) {
            highSpeedSizes = Arrays.asList(config.getHighSpeedVideoSizes());
        } else {
            Range<Integer>[] highSpeedFpsRanges = config.getHighSpeedVideoFpsRanges();
            if (!Arrays.asList(highSpeedFpsRanges).contains(fpsRange)) {
                throw new IllegalArgumentException("Fps range " + fpsRange.toString() + " in the request is not a supported high speed fps range " + Arrays.toString(highSpeedFpsRanges));
            }
            highSpeedSizes = Arrays.asList(config.getHighSpeedVideoSizesFor(fpsRange));
        }
        for (Surface surface : surfaces) {
            SurfaceUtils.checkHighSpeedSurfaceFormat(surface);
            Size surfaceSize = SurfaceUtils.getSurfaceSize(surface);
            if (!highSpeedSizes.contains(surfaceSize)) {
                throw new IllegalArgumentException("Surface size " + surfaceSize.toString() + " is not part of the high speed supported size list " + Arrays.toString(highSpeedSizes.toArray()));
            }
            if (!SurfaceUtils.isSurfaceForPreview(surface) && !SurfaceUtils.isSurfaceForHwVideoEncoder(surface)) {
                throw new IllegalArgumentException("This output surface is neither preview nor hardware video encoding surface");
            }
            if (!SurfaceUtils.isSurfaceForPreview(surface) || !SurfaceUtils.isSurfaceForHwVideoEncoder(surface)) continue;
            throw new IllegalArgumentException("This output surface can not be both preview and hardware video encoding surface");
        }
        if (surfaces.size() == 2 && (isFirstSurfacePreview = SurfaceUtils.isSurfaceForPreview((iterator = surfaces.iterator()).next())) == (isSecondSurfacePreview = SurfaceUtils.isSurfaceForPreview(iterator.next()))) {
            throw new IllegalArgumentException("The 2 output surfaces must have different type");
        }
    }

    private static int nativeDetectSurfaceType(Surface surface) {
        return OverrideMethod.invokeI("android.hardware.camera2.utils.SurfaceUtils#nativeDetectSurfaceType(Landroid/view/Surface;)I", true, null);
    }

    private static int nativeDetectSurfaceDataspace(Surface surface) {
        return OverrideMethod.invokeI("android.hardware.camera2.utils.SurfaceUtils#nativeDetectSurfaceDataspace(Landroid/view/Surface;)I", true, null);
    }

    private static long nativeDetectSurfaceUsageFlags(Surface surface) {
        return OverrideMethod.invokeL("android.hardware.camera2.utils.SurfaceUtils#nativeDetectSurfaceUsageFlags(Landroid/view/Surface;)J", true, null);
    }

    private static int nativeDetectSurfaceDimens(Surface surface, int[] nArray) {
        return OverrideMethod.invokeI("android.hardware.camera2.utils.SurfaceUtils#nativeDetectSurfaceDimens(Landroid/view/Surface;[I)I", true, null);
    }

    private static long nativeGetSurfaceId(Surface surface) {
        return OverrideMethod.invokeL("android.hardware.camera2.utils.SurfaceUtils#nativeGetSurfaceId(Landroid/view/Surface;)J", true, null);
    }
}

