/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.camera2.params;

import android.hardware.camera2.params.RggbChannelVector;
import android.hardware.camera2.utils.HashCodeHelpers;
import com.android.internal.util.Preconditions;
import java.util.Arrays;
import java.util.Objects;

public class LensShadingMap {
    public static final float MINIMUM_GAIN_FACTOR = 1.0f;
    private final int mRows;
    private final int mColumns;
    private final float[] mElements;

    public LensShadingMap(float[] elements, int rows, int columns) {
        this.mRows = Preconditions.checkArgumentPositive(rows, "rows must be positive");
        this.mColumns = Preconditions.checkArgumentPositive(columns, "columns must be positive");
        this.mElements = Objects.requireNonNull(elements, "elements must not be null");
        if (elements.length != this.getGainFactorCount()) {
            throw new IllegalArgumentException("elements must be " + this.getGainFactorCount() + " length, received " + elements.length);
        }
        Preconditions.checkArrayElementsInRange(elements, 1.0f, Float.MAX_VALUE, "elements");
    }

    public int getRowCount() {
        return this.mRows;
    }

    public int getColumnCount() {
        return this.mColumns;
    }

    public int getGainFactorCount() {
        return this.mRows * this.mColumns * 4;
    }

    public float getGainFactor(int colorChannel, int column, int row) {
        if (colorChannel < 0 || colorChannel > 4) {
            throw new IllegalArgumentException("colorChannel out of range");
        }
        if (column < 0 || column >= this.mColumns) {
            throw new IllegalArgumentException("column out of range");
        }
        if (row < 0 || row >= this.mRows) {
            throw new IllegalArgumentException("row out of range");
        }
        return this.mElements[colorChannel + (row * this.mColumns + column) * 4];
    }

    public RggbChannelVector getGainFactorVector(int column, int row) {
        if (column < 0 || column >= this.mColumns) {
            throw new IllegalArgumentException("column out of range");
        }
        if (row < 0 || row >= this.mRows) {
            throw new IllegalArgumentException("row out of range");
        }
        int offset = (row * this.mColumns + column) * 4;
        float red = this.mElements[0 + offset];
        float greenEven = this.mElements[1 + offset];
        float greenOdd = this.mElements[2 + offset];
        float blue = this.mElements[3 + offset];
        return new RggbChannelVector(red, greenEven, greenOdd, blue);
    }

    public void copyGainFactors(float[] destination, int offset) {
        Preconditions.checkArgumentNonnegative(offset, "offset must not be negative");
        Objects.requireNonNull(destination, "destination must not be null");
        if (destination.length + offset < this.getGainFactorCount()) {
            throw new ArrayIndexOutOfBoundsException("destination too small to fit elements");
        }
        System.arraycopy(this.mElements, 0, destination, offset, this.getGainFactorCount());
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (obj instanceof LensShadingMap) {
            LensShadingMap other = (LensShadingMap)obj;
            return this.mRows == other.mRows && this.mColumns == other.mColumns && Arrays.equals(this.mElements, other.mElements);
        }
        return false;
    }

    public int hashCode() {
        int elemsHash = HashCodeHelpers.hashCode(this.mElements);
        return HashCodeHelpers.hashCode(this.mRows, this.mColumns, elemsHash);
    }

    public String toString() {
        StringBuilder str = new StringBuilder();
        str.append("LensShadingMap{");
        String[] channelPrefix = new String[]{"R:(", "G_even:(", "G_odd:(", "B:("};
        for (int ch = 0; ch < 4; ++ch) {
            str.append(channelPrefix[ch]);
            for (int r = 0; r < this.mRows; ++r) {
                str.append("[");
                for (int c = 0; c < this.mColumns; ++c) {
                    float gain = this.getGainFactor(ch, c, r);
                    str.append(gain);
                    if (c >= this.mColumns - 1) continue;
                    str.append(", ");
                }
                str.append("]");
                if (r >= this.mRows - 1) continue;
                str.append(", ");
            }
            str.append(")");
            if (ch >= 3) continue;
            str.append(", ");
        }
        str.append("}");
        return str.toString();
    }
}

