/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.camera2.params;

import android.annotation.NonNull;
import android.hardware.camera2.utils.HashCodeHelpers;
import android.text.TextUtils;
import com.android.internal.util.Preconditions;
import java.util.Arrays;

public class LensIntrinsicsSample {
    private final long mTimestampNs;
    private final float[] mLensIntrinsics;

    public LensIntrinsicsSample(long timestampNs, @NonNull float[] lensIntrinsics) {
        this.mTimestampNs = timestampNs;
        Preconditions.checkArgument(lensIntrinsics.length == 5);
        this.mLensIntrinsics = lensIntrinsics;
    }

    public long getTimestampNanos() {
        return this.mTimestampNs;
    }

    @NonNull
    public float[] getLensIntrinsics() {
        return this.mLensIntrinsics;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (obj instanceof LensIntrinsicsSample) {
            LensIntrinsicsSample other = (LensIntrinsicsSample)obj;
            return this.mTimestampNs == other.mTimestampNs && Arrays.equals(this.mLensIntrinsics, other.getLensIntrinsics());
        }
        return false;
    }

    public int hashCode() {
        int timestampHash = HashCodeHelpers.hashCode(this.mTimestampNs);
        return HashCodeHelpers.hashCode(Arrays.hashCode(this.mLensIntrinsics), timestampHash);
    }

    public String toString() {
        return TextUtils.formatSimple("LensIntrinsicsSample{timestamp:%d, sample:%s}", this.mTimestampNs, Arrays.toString(this.mLensIntrinsics));
    }
}

