/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.camera2.impl;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.hardware.camera2.CameraCharacteristics;
import android.hardware.camera2.impl.CameraMetadataNative;
import android.hardware.camera2.params.OutputConfiguration;
import android.hardware.camera2.utils.SurfaceUtils;
import android.os.Handler;
import android.util.Log;
import android.util.Size;
import android.view.Surface;
import com.android.internal.camera.flags.Flags;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.RejectedExecutionException;

public class CameraExtensionUtils {
    private static final String TAG = "CameraExtensionUtils";
    public static final int JPEG_DEFAULT_QUALITY = 100;
    public static final int JPEG_DEFAULT_ROTATION = 0;
    public static HashSet<Integer> SUPPORTED_CAPTURE_OUTPUT_FORMATS = new HashSet();

    @NonNull
    public static SurfaceInfo querySurface(@NonNull Surface s) {
        Object writer = null;
        Object img = null;
        SurfaceInfo surfaceInfo = new SurfaceInfo();
        int nativeFormat = SurfaceUtils.detectSurfaceFormat(s);
        int dataspace = SurfaceUtils.getSurfaceDataspace(s);
        Size surfaceSize = SurfaceUtils.getSurfaceSize(s);
        surfaceInfo.mFormat = nativeFormat;
        surfaceInfo.mWidth = surfaceSize.getWidth();
        surfaceInfo.mHeight = surfaceSize.getHeight();
        surfaceInfo.mUsage = SurfaceUtils.getSurfaceUsage(s);
        if (nativeFormat == 33 && dataspace == 146931712) {
            surfaceInfo.mFormat = 256;
            return surfaceInfo;
        }
        if (nativeFormat == 33 && dataspace == 4101) {
            surfaceInfo.mFormat = 4101;
            return surfaceInfo;
        }
        if (Flags.depthJpegExtensions() && nativeFormat == 33 && dataspace == 4098) {
            surfaceInfo.mFormat = 1768253795;
            return surfaceInfo;
        }
        return surfaceInfo;
    }

    @Nullable
    public static Surface getPostviewSurface(@Nullable OutputConfiguration outputConfig, @NonNull HashMap<Integer, List<Size>> supportedPostviewSizes, @NonNull int captureFormat) {
        if (outputConfig == null) {
            return null;
        }
        SurfaceInfo surfaceInfo = CameraExtensionUtils.querySurface(outputConfig.getSurface());
        Size postviewSize = new Size(surfaceInfo.mWidth, surfaceInfo.mHeight);
        if (supportedPostviewSizes.get(surfaceInfo.mFormat).contains(postviewSize)) {
            return outputConfig.getSurface();
        }
        throw new IllegalArgumentException("Postview size not supported!");
    }

    public static Surface getBurstCaptureSurface(@NonNull List<OutputConfiguration> outputConfigs, @NonNull HashMap<Integer, List<Size>> supportedCaptureSizes) {
        Integer[] supportedCaptureOutputFormats = new Integer[SUPPORTED_CAPTURE_OUTPUT_FORMATS.size()];
        supportedCaptureOutputFormats = SUPPORTED_CAPTURE_OUTPUT_FORMATS.toArray(supportedCaptureOutputFormats);
        for (OutputConfiguration config : outputConfigs) {
            SurfaceInfo surfaceInfo = CameraExtensionUtils.querySurface(config.getSurface());
            Integer[] integerArray = supportedCaptureOutputFormats;
            int n = integerArray.length;
            for (int i = 0; i < n; ++i) {
                int supportedFormat = integerArray[i];
                if (surfaceInfo.mFormat != supportedFormat) continue;
                Size captureSize = new Size(surfaceInfo.mWidth, surfaceInfo.mHeight);
                if (supportedCaptureSizes.containsKey(supportedFormat)) {
                    if (supportedCaptureSizes.get(surfaceInfo.mFormat).contains(captureSize)) {
                        return config.getSurface();
                    }
                    throw new IllegalArgumentException("Capture size not supported!");
                }
                return config.getSurface();
            }
        }
        return null;
    }

    @Nullable
    public static Surface getRepeatingRequestSurface(@NonNull List<OutputConfiguration> outputConfigs, @Nullable List<Size> supportedPreviewSizes) {
        for (OutputConfiguration config : outputConfigs) {
            SurfaceInfo surfaceInfo = CameraExtensionUtils.querySurface(config.getSurface());
            if (surfaceInfo.mFormat != 34 && (surfaceInfo.mUsage & 0x800L) == 0L && surfaceInfo.mFormat != 1) continue;
            Size repeatingRequestSurfaceSize = new Size(surfaceInfo.mWidth, surfaceInfo.mHeight);
            if (supportedPreviewSizes == null || !supportedPreviewSizes.contains(repeatingRequestSurfaceSize)) {
                throw new IllegalArgumentException("Repeating request surface size " + repeatingRequestSurfaceSize + " not supported!");
            }
            return config.getSurface();
        }
        return null;
    }

    public static Map<String, CameraMetadataNative> getCharacteristicsMapNative(Map<String, CameraCharacteristics> charsMap) {
        HashMap<String, CameraMetadataNative> ret = new HashMap<String, CameraMetadataNative>();
        for (Map.Entry<String, CameraCharacteristics> entry : charsMap.entrySet()) {
            ret.put(entry.getKey(), entry.getValue().getNativeMetadata());
        }
        return ret;
    }

    static {
        SUPPORTED_CAPTURE_OUTPUT_FORMATS.addAll(Arrays.asList(35, 256, 54, 4101));
        if (Flags.depthJpegExtensions()) {
            SUPPORTED_CAPTURE_OUTPUT_FORMATS.add(1768253795);
        }
    }

    public static class SurfaceInfo {
        public int mWidth = 0;
        public int mHeight = 0;
        public int mFormat = 1;
        public long mUsage = 0L;
    }

    public static class HandlerExecutor
    implements Executor {
        private final Handler mHandler;

        public HandlerExecutor(Handler handler) {
            this.mHandler = handler;
        }

        @Override
        public void execute(Runnable runCmd) {
            try {
                this.mHandler.post(runCmd);
            }
            catch (RejectedExecutionException e) {
                Log.w(CameraExtensionUtils.TAG, "Handler thread unavailable, skipping message!");
            }
        }
    }
}

