/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.camera2;

import android.annotation.FlaggedApi;
import android.annotation.NonNull;
import android.annotation.Nullable;
import android.annotation.SuppressLint;
import android.content.ComponentName;
import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.graphics.SurfaceTexture;
import android.hardware.camera2.CameraCharacteristics;
import android.hardware.camera2.CaptureRequest;
import android.hardware.camera2.CaptureResult;
import android.hardware.camera2.extension.IAdvancedExtenderImpl;
import android.hardware.camera2.extension.ICameraExtensionsProxyService;
import android.hardware.camera2.extension.IImageCaptureExtenderImpl;
import android.hardware.camera2.extension.IInitializeSessionCallback;
import android.hardware.camera2.extension.IPreviewExtenderImpl;
import android.hardware.camera2.extension.LatencyRange;
import android.hardware.camera2.extension.Size;
import android.hardware.camera2.extension.SizeList;
import android.hardware.camera2.impl.CameraExtensionUtils;
import android.hardware.camera2.impl.CameraMetadataNative;
import android.hardware.camera2.params.StreamConfigurationMap;
import android.os.AsyncTask;
import android.os.Binder;
import android.os.ConditionVariable;
import android.os.IBinder;
import android.os.RemoteException;
import android.os.SystemProperties;
import android.provider.Settings;
import android.util.IntArray;
import android.util.Log;
import android.util.Pair;
import android.util.Range;
import android.view.SurfaceView;
import com.android.internal.camera.flags.Flags;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class CameraExtensionCharacteristics {
    private static final String TAG = "CameraExtensionCharacteristics";
    public static final int EXTENSION_AUTOMATIC = 0;
    public static final int EXTENSION_FACE_RETOUCH = 1;
    @Deprecated
    public static final int EXTENSION_BEAUTY = 1;
    public static final int EXTENSION_BOKEH = 2;
    public static final int EXTENSION_HDR = 3;
    public static final int EXTENSION_NIGHT = 4;
    public static final int NON_PROCESSING_INPUT_FORMAT = 34;
    public static final int PROCESSING_INPUT_FORMAT = 35;
    private static final int[] EXTENSION_LIST = new int[]{0, 1, 2, 3, 4};
    private static final List<CameraCharacteristics.Key> SUPPORTED_SYNTHETIC_CAMERA_CHARACTERISTICS = Arrays.asList(CameraCharacteristics.REQUEST_AVAILABLE_DYNAMIC_RANGE_PROFILES, CameraCharacteristics.REQUEST_AVAILABLE_COLOR_SPACE_PROFILES);
    private final Context mContext;
    private final String mCameraId;
    private final Map<String, CameraCharacteristics> mCharacteristicsMap;
    private final Map<String, CameraMetadataNative> mCharacteristicsMapNative;

    public CameraExtensionCharacteristics(Context context, String cameraId, Map<String, CameraCharacteristics> characteristicsMap) {
        this.mContext = context;
        this.mCameraId = cameraId;
        this.mCharacteristicsMap = characteristicsMap;
        this.mCharacteristicsMapNative = CameraExtensionUtils.getCharacteristicsMapNative(characteristicsMap);
    }

    private static ArrayList<android.util.Size> getSupportedSizes(List<SizeList> sizesList, Integer format) {
        ArrayList<android.util.Size> ret = new ArrayList<android.util.Size>();
        if (sizesList != null && !sizesList.isEmpty()) {
            for (SizeList entry : sizesList) {
                if (entry.format != format || entry.sizes.isEmpty()) continue;
                for (Size sz : entry.sizes) {
                    ret.add(new android.util.Size(sz.width, sz.height));
                }
                return ret;
            }
        }
        return ret;
    }

    private static List<android.util.Size> generateSupportedSizes(List<SizeList> sizesList, Integer format, StreamConfigurationMap streamMap) {
        ArrayList<android.util.Size> ret = CameraExtensionCharacteristics.getSupportedSizes(sizesList, format);
        if (format == 256 || format == 35 || format == 34) {
            android.util.Size[] supportedSizes = streamMap.getOutputSizes(format);
            if (ret.isEmpty() && supportedSizes != null) {
                ret.addAll(Arrays.asList(supportedSizes));
            }
        }
        return ret;
    }

    private static List<android.util.Size> generateJpegSupportedSizes(List<SizeList> sizesList, StreamConfigurationMap streamMap) {
        ArrayList<android.util.Size> extensionSizes = CameraExtensionCharacteristics.getSupportedSizes(sizesList, 35);
        HashSet<android.util.Size> supportedSizes = extensionSizes.isEmpty() ? new HashSet<android.util.Size>(Arrays.asList(streamMap.getOutputSizes(35))) : new HashSet<android.util.Size>(extensionSizes);
        HashSet<android.util.Size> supportedJpegSizes = new HashSet<android.util.Size>(Arrays.asList(streamMap.getOutputSizes(256)));
        supportedSizes.retainAll(supportedJpegSizes);
        return new ArrayList<android.util.Size>(supportedSizes);
    }

    public static boolean registerClient(Context ctx, IBinder token, int extension, String cameraId, Map<String, CameraMetadataNative> characteristicsMapNative) {
        return CameraExtensionManagerGlobal.get().registerClient(ctx, token, extension, cameraId, characteristicsMapNative);
    }

    public static void unregisterClient(Context ctx, IBinder token, int extension) {
        CameraExtensionManagerGlobal.get().unregisterClient(ctx, token, extension);
    }

    public static void initializeSession(IInitializeSessionCallback cb, int extension) throws RemoteException {
        CameraExtensionManagerGlobal.get().initializeSession(cb, extension);
    }

    public static void releaseSession(int extension) {
        CameraExtensionManagerGlobal.get().releaseSession(extension);
    }

    public static boolean areAdvancedExtensionsSupported(int extension) {
        return CameraExtensionManagerGlobal.get().areAdvancedExtensionsSupported(extension);
    }

    public static boolean isExtensionSupported(String cameraId, int extensionType, Map<String, CameraMetadataNative> characteristicsMap) {
        Pair<IPreviewExtenderImpl, IImageCaptureExtenderImpl> extenders;
        if (CameraExtensionCharacteristics.areAdvancedExtensionsSupported(extensionType)) {
            try {
                IAdvancedExtenderImpl extender = CameraExtensionCharacteristics.initializeAdvancedExtension(extensionType);
                return extender.isExtensionAvailable(cameraId, characteristicsMap);
            }
            catch (RemoteException e) {
                Log.e(TAG, "Failed to query extension availability! Extension service does not respond!");
                return false;
            }
        }
        try {
            extenders = CameraExtensionCharacteristics.initializeExtension(extensionType);
        }
        catch (IllegalArgumentException e) {
            return false;
        }
        try {
            return ((IPreviewExtenderImpl)extenders.first).isExtensionAvailable(cameraId, characteristicsMap.get(cameraId)) && ((IImageCaptureExtenderImpl)extenders.second).isExtensionAvailable(cameraId, characteristicsMap.get(cameraId));
        }
        catch (RemoteException e) {
            Log.e(TAG, "Failed to query extension availability! Extension service does not respond!");
            return false;
        }
    }

    public static IAdvancedExtenderImpl initializeAdvancedExtension(int extensionType) {
        IAdvancedExtenderImpl extender;
        try {
            extender = CameraExtensionManagerGlobal.get().initializeAdvancedExtension(extensionType);
        }
        catch (RemoteException e) {
            throw new IllegalStateException("Failed to initialize extension: " + extensionType);
        }
        if (extender == null) {
            throw new IllegalArgumentException("Unknown extension: " + extensionType);
        }
        return extender;
    }

    public static Pair<IPreviewExtenderImpl, IImageCaptureExtenderImpl> initializeExtension(int extensionType) {
        IImageCaptureExtenderImpl imageExtender;
        IPreviewExtenderImpl previewExtender;
        try {
            previewExtender = CameraExtensionManagerGlobal.get().initializePreviewExtension(extensionType);
            imageExtender = CameraExtensionManagerGlobal.get().initializeImageExtension(extensionType);
        }
        catch (RemoteException e) {
            throw new IllegalStateException("Failed to initialize extension: " + extensionType);
        }
        if (imageExtender == null || previewExtender == null) {
            throw new IllegalArgumentException("Unknown extension: " + extensionType);
        }
        return new Pair<IPreviewExtenderImpl, IImageCaptureExtenderImpl>(previewExtender, imageExtender);
    }

    private static <T> boolean isOutputSupportedFor(Class<T> klass) {
        Objects.requireNonNull(klass, "klass must not be null");
        return klass == SurfaceTexture.class || klass == SurfaceView.class;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    public List<Integer> getSupportedExtensions() {
        ArrayList<Integer> ret = new ArrayList<Integer>();
        Binder token = new Binder("CameraExtensionCharacteristics#getSupportedExtensions:" + this.mCameraId);
        IntArray extensionList = new IntArray(EXTENSION_LIST.length);
        extensionList.addAll(EXTENSION_LIST);
        for (int extensionType : extensionList.toArray()) {
            try {
                boolean success = CameraExtensionCharacteristics.registerClient(this.mContext, token, extensionType, this.mCameraId, this.mCharacteristicsMapNative);
                if (!success || !CameraExtensionCharacteristics.isExtensionSupported(this.mCameraId, extensionType, this.mCharacteristicsMapNative)) continue;
                ret.add(extensionType);
            }
            finally {
                CameraExtensionCharacteristics.unregisterClient(this.mContext, token, extensionType);
            }
        }
        return Collections.unmodifiableList(ret);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @FlaggedApi(value="com.android.internal.camera.flags.camera_extensions_characteristics_get")
    @Nullable
    public <T> T get(int extension, @NonNull CameraCharacteristics.Key<T> key) {
        Binder token = new Binder("CameraExtensionCharacteristics#get:" + this.mCameraId);
        boolean success = CameraExtensionCharacteristics.registerClient(this.mContext, token, extension, this.mCameraId, this.mCharacteristicsMapNative);
        if (!success) {
            throw new IllegalArgumentException("Unsupported extensions");
        }
        try {
            if (!CameraExtensionCharacteristics.isExtensionSupported(this.mCameraId, extension, this.mCharacteristicsMapNative)) {
                throw new IllegalArgumentException("Unsupported extension");
            }
            if (CameraExtensionCharacteristics.areAdvancedExtensionsSupported(extension) && this.getKeys(extension).contains(key)) {
                IAdvancedExtenderImpl extender = CameraExtensionCharacteristics.initializeAdvancedExtension(extension);
                extender.init(this.mCameraId, this.mCharacteristicsMapNative);
                CameraMetadataNative metadata = extender.getAvailableCharacteristicsKeyValues(this.mCameraId);
                if (metadata == null) {
                    T t = null;
                    return t;
                }
                CameraCharacteristics characteristics = new CameraCharacteristics(metadata);
                T t = characteristics.get(key);
                return t;
            }
        }
        catch (RemoteException e) {
            Log.e(TAG, "Failed to query the extension for the specified key! Extension service does not respond!");
        }
        finally {
            CameraExtensionCharacteristics.unregisterClient(this.mContext, token, extension);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @FlaggedApi(value="com.android.internal.camera.flags.camera_extensions_characteristics_get")
    @NonNull
    public Set<CameraCharacteristics.Key> getKeys(int extension) {
        Binder token = new Binder("CameraExtensionCharacteristics#getKeys:" + this.mCameraId);
        boolean success = CameraExtensionCharacteristics.registerClient(this.mContext, token, extension, this.mCameraId, this.mCharacteristicsMapNative);
        if (!success) {
            throw new IllegalArgumentException("Unsupported extensions");
        }
        HashSet<CameraCharacteristics.Key> ret = new HashSet<CameraCharacteristics.Key>();
        try {
            if (!CameraExtensionCharacteristics.isExtensionSupported(this.mCameraId, extension, this.mCharacteristicsMapNative)) {
                throw new IllegalArgumentException("Unsupported extension");
            }
            if (CameraExtensionCharacteristics.areAdvancedExtensionsSupported(extension)) {
                Class<CameraCharacteristics.Key> key;
                IAdvancedExtenderImpl extender = CameraExtensionCharacteristics.initializeAdvancedExtension(extension);
                extender.init(this.mCameraId, this.mCharacteristicsMapNative);
                CameraMetadataNative metadata = extender.getAvailableCharacteristicsKeyValues(this.mCameraId);
                if (metadata == null) {
                    Set<CameraCharacteristics.Key> set = Collections.emptySet();
                    return set;
                }
                int[] keys = metadata.get(CameraCharacteristics.REQUEST_AVAILABLE_CHARACTERISTICS_KEYS);
                if (keys == null) {
                    throw new AssertionError((Object)"android.request.availableCharacteristicsKeys must be non-null in the characteristics");
                }
                CameraCharacteristics chars = new CameraCharacteristics(metadata);
                Class<CameraCharacteristics.Key> keyTyped = key = CameraCharacteristics.Key.class;
                ret.addAll(chars.getAvailableKeyList(CameraCharacteristics.class, keyTyped, keys, false));
                for (CameraCharacteristics.Key charKey : SUPPORTED_SYNTHETIC_CAMERA_CHARACTERISTICS) {
                    if (chars.get(charKey) == null) continue;
                    ret.add(charKey);
                }
            }
        }
        catch (RemoteException e) {
            Log.e(TAG, "Failed to query the extension for all available keys! Extension service does not respond!");
        }
        finally {
            CameraExtensionCharacteristics.unregisterClient(this.mContext, token, extension);
        }
        return Collections.unmodifiableSet(ret);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isPostviewAvailable(int extension) {
        Binder token = new Binder("CameraExtensionCharacteristics#isPostviewAvailable:" + this.mCameraId);
        boolean success = CameraExtensionCharacteristics.registerClient(this.mContext, token, extension, this.mCameraId, this.mCharacteristicsMapNative);
        if (!success) {
            throw new IllegalArgumentException("Unsupported extensions");
        }
        try {
            if (!CameraExtensionCharacteristics.isExtensionSupported(this.mCameraId, extension, this.mCharacteristicsMapNative)) {
                throw new IllegalArgumentException("Unsupported extension");
            }
            if (CameraExtensionCharacteristics.areAdvancedExtensionsSupported(extension)) {
                IAdvancedExtenderImpl extender = CameraExtensionCharacteristics.initializeAdvancedExtension(extension);
                extender.init(this.mCameraId, this.mCharacteristicsMapNative);
                boolean bl = extender.isPostviewAvailable();
                return bl;
            }
            Pair<IPreviewExtenderImpl, IImageCaptureExtenderImpl> extenders = CameraExtensionCharacteristics.initializeExtension(extension);
            ((IImageCaptureExtenderImpl)extenders.second).init(this.mCameraId, this.mCharacteristicsMapNative.get(this.mCameraId));
            boolean bl = ((IImageCaptureExtenderImpl)extenders.second).isPostviewAvailable();
            return bl;
        }
        catch (RemoteException e) {
            Log.e(TAG, "Failed to query the extension for postview availability! Extension service does not respond!");
        }
        finally {
            CameraExtensionCharacteristics.unregisterClient(this.mContext, token, extension);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    public List<android.util.Size> getPostviewSupportedSizes(int extension, @NonNull android.util.Size captureSize, int format) {
        Binder token = new Binder("CameraExtensionCharacteristics#getPostviewSupportedSizes:" + this.mCameraId);
        boolean success = CameraExtensionCharacteristics.registerClient(this.mContext, token, extension, this.mCameraId, this.mCharacteristicsMapNative);
        if (!success) {
            throw new IllegalArgumentException("Unsupported extensions");
        }
        try {
            if (!CameraExtensionCharacteristics.isExtensionSupported(this.mCameraId, extension, this.mCharacteristicsMapNative)) {
                throw new IllegalArgumentException("Unsupported extension");
            }
            Size sz = new Size();
            sz.width = captureSize.getWidth();
            sz.height = captureSize.getHeight();
            StreamConfigurationMap streamMap = this.mCharacteristicsMap.get(this.mCameraId).get(CameraCharacteristics.SCALER_STREAM_CONFIGURATION_MAP);
            if (CameraExtensionCharacteristics.areAdvancedExtensionsSupported(extension)) {
                switch (format) {
                    case 35: 
                    case 54: 
                    case 256: 
                    case 4101: 
                    case 1768253795: {
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Unsupported format: " + format);
                    }
                }
                IAdvancedExtenderImpl extender = CameraExtensionCharacteristics.initializeAdvancedExtension(extension);
                extender.init(this.mCameraId, this.mCharacteristicsMapNative);
                ArrayList<android.util.Size> arrayList = CameraExtensionCharacteristics.getSupportedSizes(extender.getSupportedPostviewResolutions(sz), format);
                return arrayList;
            }
            Pair<IPreviewExtenderImpl, IImageCaptureExtenderImpl> extenders = CameraExtensionCharacteristics.initializeExtension(extension);
            ((IImageCaptureExtenderImpl)extenders.second).init(this.mCameraId, this.mCharacteristicsMapNative.get(this.mCameraId));
            if (((IImageCaptureExtenderImpl)extenders.second).getCaptureProcessor() == null || !this.isPostviewAvailable(extension)) {
                throw new IllegalArgumentException("Extension does not support postview feature");
            }
            if (format == 35) {
                ArrayList<android.util.Size> arrayList = CameraExtensionCharacteristics.getSupportedSizes(((IImageCaptureExtenderImpl)extenders.second).getSupportedPostviewResolutions(sz), format);
                return arrayList;
            }
            if (format == 256) {
                ArrayList<android.util.Size> arrayList = CameraExtensionCharacteristics.getSupportedSizes(((IImageCaptureExtenderImpl)extenders.second).getSupportedPostviewResolutions(sz), format);
                return arrayList;
            }
            if (format == 4101 || format == 54 || Flags.depthJpegExtensions() && format == 1768253795) {
                ArrayList<android.util.Size> arrayList = new ArrayList<android.util.Size>();
                return arrayList;
            }
            try {
                throw new IllegalArgumentException("Unsupported format: " + format);
            }
            catch (RemoteException e) {
                Log.e(TAG, "Failed to query the extension postview supported sizes! Extension service does not respond!");
                List<android.util.Size> list = Collections.emptyList();
                return list;
            }
        }
        finally {
            CameraExtensionCharacteristics.unregisterClient(this.mContext, token, extension);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    public <T> List<android.util.Size> getExtensionSupportedSizes(int extension, @NonNull Class<T> klass) {
        if (!CameraExtensionCharacteristics.isOutputSupportedFor(klass)) {
            return new ArrayList<android.util.Size>();
        }
        Binder token = new Binder("CameraExtensionCharacteristics#getExtensionSupportedSizes:" + this.mCameraId);
        boolean success = CameraExtensionCharacteristics.registerClient(this.mContext, token, extension, this.mCameraId, this.mCharacteristicsMapNative);
        if (!success) {
            throw new IllegalArgumentException("Unsupported extensions");
        }
        try {
            if (!CameraExtensionCharacteristics.isExtensionSupported(this.mCameraId, extension, this.mCharacteristicsMapNative)) {
                throw new IllegalArgumentException("Unsupported extension");
            }
            StreamConfigurationMap streamMap = this.mCharacteristicsMap.get(this.mCameraId).get(CameraCharacteristics.SCALER_STREAM_CONFIGURATION_MAP);
            if (CameraExtensionCharacteristics.areAdvancedExtensionsSupported(extension)) {
                IAdvancedExtenderImpl extender = CameraExtensionCharacteristics.initializeAdvancedExtension(extension);
                extender.init(this.mCameraId, this.mCharacteristicsMapNative);
                List<android.util.Size> list = CameraExtensionCharacteristics.generateSupportedSizes(extender.getSupportedPreviewOutputResolutions(this.mCameraId), 34, streamMap);
                return list;
            }
            Pair<IPreviewExtenderImpl, IImageCaptureExtenderImpl> extenders = CameraExtensionCharacteristics.initializeExtension(extension);
            ((IPreviewExtenderImpl)extenders.first).init(this.mCameraId, this.mCharacteristicsMapNative.get(this.mCameraId));
            List<android.util.Size> list = CameraExtensionCharacteristics.generateSupportedSizes(((IPreviewExtenderImpl)extenders.first).getSupportedResolutions(), 34, streamMap);
            return list;
        }
        catch (RemoteException e) {
            Log.e(TAG, "Failed to query the extension supported sizes! Extension service does not respond!");
            ArrayList<android.util.Size> arrayList = new ArrayList<android.util.Size>();
            return arrayList;
        }
        finally {
            CameraExtensionCharacteristics.unregisterClient(this.mContext, token, extension);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NonNull
    public List<android.util.Size> getExtensionSupportedSizes(int extension, int format) {
        try {
            Binder token = new Binder("CameraExtensionCharacteristics#getExtensionSupportedSizes:" + this.mCameraId);
            boolean success = CameraExtensionCharacteristics.registerClient(this.mContext, token, extension, this.mCameraId, this.mCharacteristicsMapNative);
            if (!success) {
                throw new IllegalArgumentException("Unsupported extensions");
            }
            try {
                if (!CameraExtensionCharacteristics.isExtensionSupported(this.mCameraId, extension, this.mCharacteristicsMapNative)) {
                    throw new IllegalArgumentException("Unsupported extension");
                }
                StreamConfigurationMap streamMap = this.mCharacteristicsMap.get(this.mCameraId).get(CameraCharacteristics.SCALER_STREAM_CONFIGURATION_MAP);
                if (CameraExtensionCharacteristics.areAdvancedExtensionsSupported(extension)) {
                    switch (format) {
                        case 35: 
                        case 54: 
                        case 256: 
                        case 4101: 
                        case 1768253795: {
                            break;
                        }
                        default: {
                            throw new IllegalArgumentException("Unsupported format: " + format);
                        }
                    }
                    IAdvancedExtenderImpl extender = CameraExtensionCharacteristics.initializeAdvancedExtension(extension);
                    extender.init(this.mCameraId, this.mCharacteristicsMapNative);
                    List<android.util.Size> list = CameraExtensionCharacteristics.generateSupportedSizes(extender.getSupportedCaptureOutputResolutions(this.mCameraId), format, streamMap);
                    return list;
                }
                if (format == 35) {
                    Pair<IPreviewExtenderImpl, IImageCaptureExtenderImpl> extenders = CameraExtensionCharacteristics.initializeExtension(extension);
                    ((IImageCaptureExtenderImpl)extenders.second).init(this.mCameraId, this.mCharacteristicsMapNative.get(this.mCameraId));
                    if (((IImageCaptureExtenderImpl)extenders.second).getCaptureProcessor() == null) {
                        ArrayList<android.util.Size> arrayList = new ArrayList<android.util.Size>();
                        return arrayList;
                    }
                    List<android.util.Size> list = CameraExtensionCharacteristics.generateSupportedSizes(((IImageCaptureExtenderImpl)extenders.second).getSupportedResolutions(), format, streamMap);
                    return list;
                }
                if (format == 256) {
                    Pair<IPreviewExtenderImpl, IImageCaptureExtenderImpl> extenders = CameraExtensionCharacteristics.initializeExtension(extension);
                    ((IImageCaptureExtenderImpl)extenders.second).init(this.mCameraId, this.mCharacteristicsMapNative.get(this.mCameraId));
                    if (((IImageCaptureExtenderImpl)extenders.second).getCaptureProcessor() != null) {
                        List<android.util.Size> list = CameraExtensionCharacteristics.generateJpegSupportedSizes(((IImageCaptureExtenderImpl)extenders.second).getSupportedResolutions(), streamMap);
                        return list;
                    }
                    List<android.util.Size> list = CameraExtensionCharacteristics.generateSupportedSizes(null, format, streamMap);
                    return list;
                }
                if (format != 4101 && format != 54) {
                    if (!Flags.depthJpegExtensions()) throw new IllegalArgumentException("Unsupported format: " + format);
                    if (format != 1768253795) throw new IllegalArgumentException("Unsupported format: " + format);
                }
                ArrayList<android.util.Size> arrayList = new ArrayList<android.util.Size>();
                return arrayList;
            }
            finally {
                CameraExtensionCharacteristics.unregisterClient(this.mContext, token, extension);
            }
        }
        catch (RemoteException e) {
            Log.e(TAG, "Failed to query the extension supported sizes! Extension service does not respond!");
            return new ArrayList<android.util.Size>();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public Range<Long> getEstimatedCaptureLatencyRangeMillis(int extension, @NonNull android.util.Size captureOutputSize, int format) {
        switch (format) {
            case 35: 
            case 54: 
            case 256: 
            case 4101: 
            case 1768253795: {
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported format: " + format);
            }
        }
        Binder token = new Binder("CameraExtensionCharacteristics#getEstimatedCaptureLatencyRangeMillis:" + this.mCameraId);
        boolean success = CameraExtensionCharacteristics.registerClient(this.mContext, token, extension, this.mCameraId, this.mCharacteristicsMapNative);
        if (!success) {
            throw new IllegalArgumentException("Unsupported extensions");
        }
        try {
            if (!CameraExtensionCharacteristics.isExtensionSupported(this.mCameraId, extension, this.mCharacteristicsMapNative)) {
                throw new IllegalArgumentException("Unsupported extension");
            }
            Size sz = new Size();
            sz.width = captureOutputSize.getWidth();
            sz.height = captureOutputSize.getHeight();
            if (CameraExtensionCharacteristics.areAdvancedExtensionsSupported(extension)) {
                IAdvancedExtenderImpl extender = CameraExtensionCharacteristics.initializeAdvancedExtension(extension);
                extender.init(this.mCameraId, this.mCharacteristicsMapNative);
                LatencyRange latencyRange = extender.getEstimatedCaptureLatencyRange(this.mCameraId, sz, format);
                if (latencyRange != null) {
                    Range<Long> range = new Range<Long>(latencyRange.min, latencyRange.max);
                    return range;
                }
            } else {
                Pair<IPreviewExtenderImpl, IImageCaptureExtenderImpl> extenders = CameraExtensionCharacteristics.initializeExtension(extension);
                ((IImageCaptureExtenderImpl)extenders.second).init(this.mCameraId, this.mCharacteristicsMapNative.get(this.mCameraId));
                if (format == 35 && ((IImageCaptureExtenderImpl)extenders.second).getCaptureProcessor() == null) {
                    Range<Long> latencyRange = null;
                    return latencyRange;
                }
                if (format == 256 && ((IImageCaptureExtenderImpl)extenders.second).getCaptureProcessor() != null) {
                    Range<Long> latencyRange = null;
                    return latencyRange;
                }
                if (format == 4101 || format == 54 || Flags.depthJpegExtensions() && format == 1768253795) {
                    Range<Long> latencyRange = null;
                    return latencyRange;
                }
                LatencyRange latencyRange = ((IImageCaptureExtenderImpl)extenders.second).getEstimatedCaptureLatencyRange(sz);
                if (latencyRange != null) {
                    Range<Long> range = new Range<Long>(latencyRange.min, latencyRange.max);
                    return range;
                }
            }
        }
        catch (RemoteException e) {
            Log.e(TAG, "Failed to query the extension capture latency! Extension service does not respond!");
        }
        finally {
            CameraExtensionCharacteristics.unregisterClient(this.mContext, token, extension);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isCaptureProcessProgressAvailable(int extension) {
        Binder token = new Binder("CameraExtensionCharacteristics#isCaptureProcessProgressAvailable:" + this.mCameraId);
        boolean success = CameraExtensionCharacteristics.registerClient(this.mContext, token, extension, this.mCameraId, this.mCharacteristicsMapNative);
        if (!success) {
            throw new IllegalArgumentException("Unsupported extensions");
        }
        try {
            if (!CameraExtensionCharacteristics.isExtensionSupported(this.mCameraId, extension, this.mCharacteristicsMapNative)) {
                throw new IllegalArgumentException("Unsupported extension");
            }
            if (CameraExtensionCharacteristics.areAdvancedExtensionsSupported(extension)) {
                IAdvancedExtenderImpl extender = CameraExtensionCharacteristics.initializeAdvancedExtension(extension);
                extender.init(this.mCameraId, this.mCharacteristicsMapNative);
                boolean bl = extender.isCaptureProcessProgressAvailable();
                return bl;
            }
            Pair<IPreviewExtenderImpl, IImageCaptureExtenderImpl> extenders = CameraExtensionCharacteristics.initializeExtension(extension);
            ((IImageCaptureExtenderImpl)extenders.second).init(this.mCameraId, this.mCharacteristicsMapNative.get(this.mCameraId));
            boolean bl = ((IImageCaptureExtenderImpl)extenders.second).isCaptureProcessProgressAvailable();
            return bl;
        }
        catch (RemoteException e) {
            Log.e(TAG, "Failed to query the extension progress callbacks! Extension service does not respond!");
        }
        finally {
            CameraExtensionCharacteristics.unregisterClient(this.mContext, token, extension);
        }
        return false;
    }

    @NonNull
    public Set<CaptureRequest.Key> getAvailableCaptureRequestKeys(int extension) {
        Binder token = new Binder("CameraExtensionCharacteristics#getAvailableCaptureRequestKeys:" + this.mCameraId);
        boolean success = CameraExtensionCharacteristics.registerClient(this.mContext, token, extension, this.mCameraId, this.mCharacteristicsMapNative);
        if (!success) {
            throw new IllegalArgumentException("Unsupported extensions");
        }
        HashSet<CaptureRequest.Key<Number>> ret = new HashSet<CaptureRequest.Key<Number>>();
        try {
            if (!CameraExtensionCharacteristics.isExtensionSupported(this.mCameraId, extension, this.mCharacteristicsMapNative)) {
                throw new IllegalArgumentException("Unsupported extension");
            }
            CameraMetadataNative captureRequestMeta = null;
            if (CameraExtensionCharacteristics.areAdvancedExtensionsSupported(extension)) {
                IAdvancedExtenderImpl extender = CameraExtensionCharacteristics.initializeAdvancedExtension(extension);
                extender.init(this.mCameraId, this.mCharacteristicsMapNative);
                captureRequestMeta = extender.getAvailableCaptureRequestKeys(this.mCameraId);
            } else {
                Pair<IPreviewExtenderImpl, IImageCaptureExtenderImpl> extenders = CameraExtensionCharacteristics.initializeExtension(extension);
                ((IImageCaptureExtenderImpl)extenders.second).onInit(token, this.mCameraId, this.mCharacteristicsMapNative.get(this.mCameraId));
                ((IImageCaptureExtenderImpl)extenders.second).init(this.mCameraId, this.mCharacteristicsMapNative.get(this.mCameraId));
                captureRequestMeta = ((IImageCaptureExtenderImpl)extenders.second).getAvailableCaptureRequestKeys();
                ((IImageCaptureExtenderImpl)extenders.second).onDeInit(token);
            }
            if (captureRequestMeta != null) {
                Class<CaptureRequest.Key> crKey;
                int[] requestKeys = captureRequestMeta.get(CameraCharacteristics.REQUEST_AVAILABLE_REQUEST_KEYS);
                if (requestKeys == null) {
                    throw new AssertionError((Object)"android.request.availableRequestKeys must be non-null in the characteristics");
                }
                CameraCharacteristics requestChars = new CameraCharacteristics(captureRequestMeta);
                Class<CaptureRequest.Key> crKeyTyped = crKey = CaptureRequest.Key.class;
                ret.addAll(requestChars.getAvailableKeyList(CaptureRequest.class, crKeyTyped, requestKeys, true));
            }
            if (!ret.contains(CaptureRequest.JPEG_QUALITY)) {
                ret.add(CaptureRequest.JPEG_QUALITY);
            }
            if (!ret.contains(CaptureRequest.JPEG_ORIENTATION)) {
                ret.add(CaptureRequest.JPEG_ORIENTATION);
            }
        }
        catch (RemoteException e) {
            throw new IllegalStateException("Failed to query the available capture request keys!");
        }
        finally {
            CameraExtensionCharacteristics.unregisterClient(this.mContext, token, extension);
        }
        return Collections.unmodifiableSet(ret);
    }

    @NonNull
    public Set<CaptureResult.Key> getAvailableCaptureResultKeys(int extension) {
        Binder token = new Binder("CameraExtensionCharacteristics#getAvailableCaptureResultKeys:" + this.mCameraId);
        boolean success = CameraExtensionCharacteristics.registerClient(this.mContext, token, extension, this.mCameraId, this.mCharacteristicsMapNative);
        if (!success) {
            throw new IllegalArgumentException("Unsupported extensions");
        }
        HashSet<CaptureResult.Key<Number>> ret = new HashSet<CaptureResult.Key<Number>>();
        try {
            if (!CameraExtensionCharacteristics.isExtensionSupported(this.mCameraId, extension, this.mCharacteristicsMapNative)) {
                throw new IllegalArgumentException("Unsupported extension");
            }
            CameraMetadataNative captureResultMeta = null;
            if (CameraExtensionCharacteristics.areAdvancedExtensionsSupported(extension)) {
                IAdvancedExtenderImpl extender = CameraExtensionCharacteristics.initializeAdvancedExtension(extension);
                extender.init(this.mCameraId, this.mCharacteristicsMapNative);
                captureResultMeta = extender.getAvailableCaptureResultKeys(this.mCameraId);
            } else {
                Pair<IPreviewExtenderImpl, IImageCaptureExtenderImpl> extenders = CameraExtensionCharacteristics.initializeExtension(extension);
                ((IImageCaptureExtenderImpl)extenders.second).onInit(token, this.mCameraId, this.mCharacteristicsMapNative.get(this.mCameraId));
                ((IImageCaptureExtenderImpl)extenders.second).init(this.mCameraId, this.mCharacteristicsMapNative.get(this.mCameraId));
                captureResultMeta = ((IImageCaptureExtenderImpl)extenders.second).getAvailableCaptureResultKeys();
                ((IImageCaptureExtenderImpl)extenders.second).onDeInit(token);
            }
            if (captureResultMeta != null) {
                Class<CaptureResult.Key> crKey;
                int[] resultKeys = captureResultMeta.get(CameraCharacteristics.REQUEST_AVAILABLE_RESULT_KEYS);
                if (resultKeys == null) {
                    throw new AssertionError((Object)"android.request.availableResultKeys must be non-null in the characteristics");
                }
                CameraCharacteristics resultChars = new CameraCharacteristics(captureResultMeta);
                Class<CaptureResult.Key> crKeyTyped = crKey = CaptureResult.Key.class;
                ret.addAll(resultChars.getAvailableKeyList(CaptureResult.class, crKeyTyped, resultKeys, true));
                if (!ret.contains(CaptureResult.JPEG_QUALITY)) {
                    ret.add(CaptureResult.JPEG_QUALITY);
                }
                if (!ret.contains(CaptureResult.JPEG_ORIENTATION)) {
                    ret.add(CaptureResult.JPEG_ORIENTATION);
                }
                if (!ret.contains(CaptureResult.SENSOR_TIMESTAMP)) {
                    ret.add(CaptureResult.SENSOR_TIMESTAMP);
                }
            }
        }
        catch (RemoteException e) {
            throw new IllegalStateException("Failed to query the available capture result keys!");
        }
        finally {
            CameraExtensionCharacteristics.unregisterClient(this.mContext, token, extension);
        }
        return Collections.unmodifiableSet(ret);
    }

    private static class CameraExtensionManagerGlobal {
        private static final String TAG = "CameraExtensionManagerGlobal";
        private static final String PROXY_PACKAGE_NAME = "com.android.cameraextensions";
        private static final String PROXY_SERVICE_NAME = "com.android.cameraextensions.CameraExtensionsProxyService";
        private static final int FALLBACK_PACKAGE_NAME = 17039989;
        private static final int FALLBACK_SERVICE_NAME = 17039990;
        private static final CameraExtensionManagerGlobal GLOBAL_CAMERA_MANAGER = new CameraExtensionManagerGlobal();
        private final Object mLock = new Object();
        private final int PROXY_SERVICE_DELAY_MS = 2000;
        private ExtensionConnectionManager mConnectionManager = new ExtensionConnectionManager(this);
        private boolean mPermissionForFallbackEnabled = false;
        private boolean mIsFallbackEnabled = false;

        private CameraExtensionManagerGlobal() {
        }

        public static CameraExtensionManagerGlobal get() {
            return GLOBAL_CAMERA_MANAGER;
        }

        private void releaseProxyConnectionLocked(Context ctx, int extension) {
            if (this.mConnectionManager.getConnection(extension) != null) {
                ctx.unbindService(this.mConnectionManager.getConnection(extension));
                this.mConnectionManager.setConnection(extension, null);
                this.mConnectionManager.setProxy(extension, null);
                this.mConnectionManager.resetConnectionCount(extension);
            }
        }

        private void connectToProxyLocked(Context ctx, final int extension, boolean useFallback) {
            if (this.mConnectionManager.getConnection(extension) == null) {
                Intent intent = new Intent();
                intent.setClassName(PROXY_PACKAGE_NAME, PROXY_SERVICE_NAME);
                String vendorProxyPackage = SystemProperties.get("ro.vendor.camera.extensions.package");
                String vendorProxyService = SystemProperties.get("ro.vendor.camera.extensions.service");
                if (!vendorProxyPackage.isEmpty() && !vendorProxyService.isEmpty()) {
                    Log.v(TAG, "Choosing the vendor camera extensions proxy package: " + vendorProxyPackage);
                    Log.v(TAG, "Choosing the vendor camera extensions proxy service: " + vendorProxyService);
                    intent.setClassName(vendorProxyPackage, vendorProxyService);
                }
                if (useFallback) {
                    String packageName = ctx.getResources().getString(17039989);
                    String serviceName = ctx.getResources().getString(17039990);
                    if (!packageName.isEmpty() && !serviceName.isEmpty()) {
                        Log.v(TAG, "Choosing the fallback software implementation package: " + packageName);
                        Log.v(TAG, "Choosing the fallback software implementation service: " + serviceName);
                        intent.setClassName(packageName, serviceName);
                        this.mIsFallbackEnabled = true;
                    }
                }
                final InitializerFuture initFuture = new InitializerFuture();
                ServiceConnection connection = new ServiceConnection(){

                    @Override
                    public void onServiceDisconnected(ComponentName component) {
                        mConnectionManager.setConnection(extension, null);
                        mConnectionManager.setProxy(extension, null);
                    }

                    @Override
                    public void onServiceConnected(ComponentName component, IBinder binder) {
                        ICameraExtensionsProxyService proxy = ICameraExtensionsProxyService.Stub.asInterface(binder);
                        mConnectionManager.setProxy(extension, proxy);
                        if (mConnectionManager.getProxy(extension) == null) {
                            throw new IllegalStateException("Camera Proxy service is null");
                        }
                        try {
                            mConnectionManager.setAdvancedExtensionsSupported(extension, mConnectionManager.getProxy(extension).advancedExtensionsSupported());
                        }
                        catch (RemoteException e) {
                            Log.e(CameraExtensionManagerGlobal.TAG, "Remote IPC failed!");
                        }
                        initFuture.setStatus(true);
                    }
                };
                ctx.bindService(intent, 0x40000049, AsyncTask.THREAD_POOL_EXECUTOR, connection);
                this.mConnectionManager.setConnection(extension, connection);
                try {
                    initFuture.get(2000L, TimeUnit.MILLISECONDS);
                }
                catch (TimeoutException e) {
                    Log.e(TAG, "Timed out while initializing proxy service!");
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean registerClientHelper(Context ctx, IBinder token, int extension, boolean useFallback) {
            Object object = this.mLock;
            synchronized (object) {
                boolean ret = false;
                this.connectToProxyLocked(ctx, extension, useFallback);
                if (this.mConnectionManager.getProxy(extension) == null) {
                    return false;
                }
                this.mConnectionManager.incrementConnectionCount(extension);
                try {
                    ret = this.mConnectionManager.getProxy(extension).registerClient(token);
                }
                catch (RemoteException e) {
                    Log.e(TAG, "Failed to initialize extension! Extension service does  not respond!");
                }
                if (!ret) {
                    this.mConnectionManager.decrementConnectionCount(extension);
                }
                if (this.mConnectionManager.getConnectionCount(extension) <= 0) {
                    this.releaseProxyConnectionLocked(ctx, extension);
                }
                if (ret && useFallback && this.mIsFallbackEnabled) {
                    try {
                        InitializeSessionHandler cb = new InitializeSessionHandler(ctx);
                        this.initializeSession(cb, extension);
                        ret = this.mPermissionForFallbackEnabled;
                    }
                    catch (RemoteException e) {
                        Log.e(TAG, "Failed to initialize extension. Extension service does not respond!");
                        ret = false;
                    }
                    finally {
                        this.releaseSession(extension);
                    }
                }
                return ret;
            }
        }

        @SuppressLint(value={"NonUserGetterCalled"})
        public boolean registerClient(Context ctx, IBinder token, int extension, String cameraId, Map<String, CameraMetadataNative> characteristicsMapNative) {
            if (!SystemProperties.getBoolean("ro.camerax.extensions.enabled", false)) {
                Log.v(TAG, "Disabled camera extension property!");
                return false;
            }
            boolean ret = this.registerClientHelper(ctx, token, extension, false);
            ContentResolver resolver = ctx.getContentResolver();
            int userEnabled = Settings.Secure.getInt(resolver, "camera_extensions_fallback", 1);
            boolean vendorImpl = true;
            if (ret && this.mConnectionManager.getProxy(extension) != null && userEnabled == 1) {
                vendorImpl = CameraExtensionCharacteristics.isExtensionSupported(cameraId, extension, characteristicsMapNative);
            }
            if (!vendorImpl) {
                this.unregisterClient(ctx, token, extension);
                ret = this.registerClientHelper(ctx, token, extension, true);
            }
            return ret;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void unregisterClient(Context ctx, IBinder token, int extension) {
            Object object = this.mLock;
            synchronized (object) {
                if (this.mConnectionManager.getProxy(extension) != null) {
                    try {
                        this.mConnectionManager.getProxy(extension).unregisterClient(token);
                    }
                    catch (RemoteException e) {
                        Log.e(TAG, "Failed to de-initialize extension! Extension service does not respond!");
                    }
                    finally {
                        this.mConnectionManager.decrementConnectionCount(extension);
                        if (this.mConnectionManager.getConnectionCount(extension) <= 0) {
                            this.releaseProxyConnectionLocked(ctx, extension);
                        }
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void initializeSession(IInitializeSessionCallback cb, int extension) throws RemoteException {
            Object object = this.mLock;
            synchronized (object) {
                if (this.mConnectionManager.getProxy(extension) != null && !this.mConnectionManager.isSessionInitialized()) {
                    this.mConnectionManager.getProxy(extension).initializeSession(cb);
                    this.mConnectionManager.setSessionInitialized(true);
                } else {
                    cb.onFailure();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void releaseSession(int extension) {
            Object object = this.mLock;
            synchronized (object) {
                if (this.mConnectionManager.getProxy(extension) != null) {
                    try {
                        this.mConnectionManager.getProxy(extension).releaseSession();
                        this.mConnectionManager.setSessionInitialized(false);
                        this.mPermissionForFallbackEnabled = false;
                    }
                    catch (RemoteException e) {
                        Log.e(TAG, "Failed to release session! Extension service does not respond!");
                    }
                }
            }
        }

        public boolean areAdvancedExtensionsSupported(int extension) {
            return this.mConnectionManager.areAdvancedExtensionsSupported(extension);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public IPreviewExtenderImpl initializePreviewExtension(int extension) throws RemoteException {
            Object object = this.mLock;
            synchronized (object) {
                if (this.mConnectionManager.getProxy(extension) != null) {
                    return this.mConnectionManager.getProxy(extension).initializePreviewExtension(extension);
                }
                return null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public IImageCaptureExtenderImpl initializeImageExtension(int extension) throws RemoteException {
            Object object = this.mLock;
            synchronized (object) {
                if (this.mConnectionManager.getProxy(extension) != null) {
                    return this.mConnectionManager.getProxy(extension).initializeImageExtension(extension);
                }
                return null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public IAdvancedExtenderImpl initializeAdvancedExtension(int extension) throws RemoteException {
            Object object = this.mLock;
            synchronized (object) {
                if (this.mConnectionManager.getProxy(extension) != null) {
                    return this.mConnectionManager.getProxy(extension).initializeAdvancedExtension(extension);
                }
                return null;
            }
        }

        private class ExtensionConnectionManager {
            private Map<Integer, ExtensionConnection> mConnections = new HashMap<Integer, ExtensionConnection>();
            private boolean mSessionInitialized = false;

            public ExtensionConnectionManager(CameraExtensionManagerGlobal cameraExtensionManagerGlobal) {
                IntArray extensionList = new IntArray(EXTENSION_LIST.length);
                extensionList.addAll(EXTENSION_LIST);
                for (int extensionType : extensionList.toArray()) {
                    this.mConnections.put(extensionType, new ExtensionConnection(this));
                }
            }

            public ICameraExtensionsProxyService getProxy(int extension) {
                return this.mConnections.get((Object)Integer.valueOf((int)extension)).mProxy;
            }

            public ServiceConnection getConnection(int extension) {
                return this.mConnections.get((Object)Integer.valueOf((int)extension)).mConnection;
            }

            public int getConnectionCount(int extension) {
                return this.mConnections.get((Object)Integer.valueOf((int)extension)).mConnectionCount;
            }

            public boolean areAdvancedExtensionsSupported(int extension) {
                return this.mConnections.get((Object)Integer.valueOf((int)extension)).mSupportsAdvancedExtensions;
            }

            public boolean isSessionInitialized() {
                return this.mSessionInitialized;
            }

            public void setProxy(int extension, ICameraExtensionsProxyService proxy) {
                this.mConnections.get((Object)Integer.valueOf((int)extension)).mProxy = proxy;
            }

            public void setConnection(int extension, ServiceConnection connection) {
                this.mConnections.get((Object)Integer.valueOf((int)extension)).mConnection = connection;
            }

            public void incrementConnectionCount(int extension) {
                ++this.mConnections.get((Object)Integer.valueOf((int)extension)).mConnectionCount;
            }

            public void decrementConnectionCount(int extension) {
                --this.mConnections.get((Object)Integer.valueOf((int)extension)).mConnectionCount;
            }

            public void resetConnectionCount(int extension) {
                this.mConnections.get((Object)Integer.valueOf((int)extension)).mConnectionCount = 0;
            }

            public void setAdvancedExtensionsSupported(int extension, boolean advancedExtSupported) {
                this.mConnections.get((Object)Integer.valueOf((int)extension)).mSupportsAdvancedExtensions = advancedExtSupported;
            }

            public void setSessionInitialized(boolean initialized) {
                this.mSessionInitialized = initialized;
            }

            private class ExtensionConnection {
                public ICameraExtensionsProxyService mProxy = null;
                public ServiceConnection mConnection = null;
                public int mConnectionCount = 0;
                public boolean mSupportsAdvancedExtensions = false;

                private ExtensionConnection(ExtensionConnectionManager extensionConnectionManager) {
                }
            }
        }

        private static class InitializerFuture
        implements Future<Boolean> {
            private volatile Boolean mStatus;
            ConditionVariable mCondVar = new ConditionVariable(false);

            private InitializerFuture() {
            }

            public void setStatus(boolean status) {
                this.mStatus = status;
                this.mCondVar.open();
            }

            @Override
            public boolean cancel(boolean mayInterruptIfRunning) {
                return false;
            }

            @Override
            public boolean isCancelled() {
                return false;
            }

            @Override
            public boolean isDone() {
                return this.mStatus != null;
            }

            @Override
            public Boolean get() {
                this.mCondVar.block();
                return this.mStatus;
            }

            @Override
            public Boolean get(long timeout, TimeUnit unit) throws TimeoutException {
                long timeoutMs = unit.convert(timeout, TimeUnit.MILLISECONDS);
                if (!this.mCondVar.block(timeoutMs)) {
                    throw new TimeoutException("Failed to receive status after " + timeout + " " + (Object)((Object)unit));
                }
                if (this.mStatus == null) {
                    throw new AssertionError();
                }
                return this.mStatus;
            }
        }

        private class InitializeSessionHandler
        extends IInitializeSessionCallback.Stub {
            private Context mContext;

            public InitializeSessionHandler(Context context) {
                this.mContext = context;
            }

            @Override
            public void onSuccess() {
                String[] callingUidPackages = this.mContext.getPackageManager().getPackagesForUid(Binder.getCallingUid());
                String fallbackPackageName = this.mContext.getResources().getString(17039989);
                if (!fallbackPackageName.isEmpty()) {
                    if (Arrays.stream(callingUidPackages).anyMatch(fallbackPackageName::equals)) {
                        String[] cameraPermissions = new String[]{"android.permission.SYSTEM_CAMERA", "android.permission.CAMERA"};
                        boolean allPermissionsGranted = true;
                        for (String permission2 : cameraPermissions) {
                            int permissionResult = this.mContext.checkPermission(permission2, Binder.getCallingPid(), Binder.getCallingUid());
                            if (permissionResult == 0) continue;
                            Log.w(CameraExtensionManagerGlobal.TAG, permission2 + " permission not granted for " + fallbackPackageName + ", permission check result: " + permissionResult);
                            allPermissionsGranted = false;
                        }
                        CameraExtensionManagerGlobal.this.mPermissionForFallbackEnabled = allPermissionsGranted;
                    }
                }
            }

            @Override
            public void onFailure() {
                Log.e(CameraExtensionManagerGlobal.TAG, "Failed to initialize proxy service session!");
            }
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface Extension {
    }
}

