/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.biometrics.face;

import android.hardware.biometrics.face.ISession;
import android.hardware.biometrics.face.ISessionCallback;
import android.hardware.biometrics.face.SensorProps;
import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.RemoteException;

public interface IFace
extends IInterface {
    public static final int VERSION = 4;
    public static final String HASH = "c43fbb9be4a662cc9ace640dba21cccdb84c6c21";
    public static final String DESCRIPTOR = "android$hardware$biometrics$face$IFace".replace('$', '.');

    public SensorProps[] getSensorProps() throws RemoteException;

    public ISession createSession(int var1, int var2, ISessionCallback var3) throws RemoteException;

    public int getInterfaceVersion() throws RemoteException;

    public String getInterfaceHash() throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements IFace {
        static final int TRANSACTION_getSensorProps = 1;
        static final int TRANSACTION_createSession = 2;
        static final int TRANSACTION_getInterfaceVersion = 0xFFFFFF;
        static final int TRANSACTION_getInterfaceHash = 0xFFFFFE;

        public Stub() {
            this.markVintfStability();
            this.attachInterface(this, DESCRIPTOR);
        }

        public static IFace asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(DESCRIPTOR);
            if (iin != null && iin instanceof IFace) {
                return (IFace)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 1: {
                    return "getSensorProps";
                }
                case 2: {
                    return "createSession";
                }
                case 0xFFFFFF: {
                    return "getInterfaceVersion";
                }
                case 0xFFFFFE: {
                    return "getInterfaceHash";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = DESCRIPTOR;
            if (code >= 1 && code <= 0xFFFFFF) {
                data.enforceInterface(descriptor);
            }
            if (code == 1598968902) {
                reply.writeString(descriptor);
                return true;
            }
            if (code == 0xFFFFFF) {
                reply.writeNoException();
                reply.writeInt(this.getInterfaceVersion());
                return true;
            }
            if (code == 0xFFFFFE) {
                reply.writeNoException();
                reply.writeString(this.getInterfaceHash());
                return true;
            }
            switch (code) {
                case 1: {
                    Parcelable[] _result = this.getSensorProps();
                    reply.writeNoException();
                    reply.writeTypedArray(_result, 1);
                    break;
                }
                case 2: {
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    ISessionCallback _arg2 = ISessionCallback.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    ISession _result = this.createSession(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    reply.writeStrongInterface(_result);
                    break;
                }
                default: {
                    return super.onTransact(code, data, reply, flags);
                }
            }
            return true;
        }

        @Override
        public int getMaxTransactionId() {
            return 0xFFFFFE;
        }

        private static class Proxy
        implements IFace {
            private IBinder mRemote;
            private int mCachedVersion = -1;
            private String mCachedHash = "-1";

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public SensorProps[] getSensorProps() throws RemoteException {
                SensorProps[] _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(DESCRIPTOR);
                    boolean _status = this.mRemote.transact(1, _data, _reply, 0);
                    if (!_status) {
                        throw new RemoteException("Method getSensorProps is unimplemented.");
                    }
                    _reply.readException();
                    _result = _reply.createTypedArray(SensorProps.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public ISession createSession(int sensorId, int userId, ISessionCallback cb) throws RemoteException {
                ISession _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(DESCRIPTOR);
                    _data.writeInt(sensorId);
                    _data.writeInt(userId);
                    _data.writeStrongInterface(cb);
                    boolean _status = this.mRemote.transact(2, _data, _reply, 0);
                    if (!_status) {
                        throw new RemoteException("Method createSession is unimplemented.");
                    }
                    _reply.readException();
                    _result = ISession.Stub.asInterface(_reply.readStrongBinder());
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int getInterfaceVersion() throws RemoteException {
                if (this.mCachedVersion == -1) {
                    Parcel data = Parcel.obtain(this.asBinder());
                    Parcel reply = Parcel.obtain();
                    try {
                        data.writeInterfaceToken(DESCRIPTOR);
                        boolean _status = this.mRemote.transact(0xFFFFFF, data, reply, 0);
                        reply.readException();
                        this.mCachedVersion = reply.readInt();
                    }
                    finally {
                        reply.recycle();
                        data.recycle();
                    }
                }
                return this.mCachedVersion;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public synchronized String getInterfaceHash() throws RemoteException {
                if ("-1".equals(this.mCachedHash)) {
                    Parcel data = Parcel.obtain(this.asBinder());
                    Parcel reply = Parcel.obtain();
                    try {
                        data.writeInterfaceToken(DESCRIPTOR);
                        boolean _status = this.mRemote.transact(0xFFFFFE, data, reply, 0);
                        reply.readException();
                        this.mCachedHash = reply.readString();
                    }
                    finally {
                        reply.recycle();
                        data.recycle();
                    }
                }
                return this.mCachedHash;
            }
        }
    }

    public static class Default
    implements IFace {
        @Override
        public SensorProps[] getSensorProps() throws RemoteException {
            return null;
        }

        @Override
        public ISession createSession(int sensorId, int userId, ISessionCallback cb) throws RemoteException {
            return null;
        }

        @Override
        public int getInterfaceVersion() {
            return 0;
        }

        @Override
        public String getInterfaceHash() {
            return "";
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

