/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.biometrics.events;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.hardware.biometrics.BiometricRequestConstants;
import android.hardware.biometrics.BiometricSourceType;
import android.os.Parcel;
import android.os.Parcelable;
import com.android.internal.util.AnnotationValidations;
import java.util.Objects;

public class AuthenticationFailedInfo
implements Parcelable {
    @NonNull
    private final BiometricSourceType mBiometricSourceType;
    private final int mRequestReason;
    private final int mUserId;
    @NonNull
    public static final Parcelable.Creator<AuthenticationFailedInfo> CREATOR = new Parcelable.Creator<AuthenticationFailedInfo>(){

        public AuthenticationFailedInfo[] newArray(int size) {
            return new AuthenticationFailedInfo[size];
        }

        @Override
        public AuthenticationFailedInfo createFromParcel(@NonNull Parcel in) {
            return new AuthenticationFailedInfo(in);
        }
    };

    AuthenticationFailedInfo(@NonNull BiometricSourceType biometricSourceType, int requestReason, int userId) {
        this.mBiometricSourceType = biometricSourceType;
        AnnotationValidations.validate(NonNull.class, null, (Object)this.mBiometricSourceType);
        this.mRequestReason = requestReason;
        AnnotationValidations.validate(BiometricRequestConstants.RequestReason.class, null, this.mRequestReason);
        this.mUserId = userId;
    }

    @NonNull
    public BiometricSourceType getBiometricSourceType() {
        return this.mBiometricSourceType;
    }

    public int getRequestReason() {
        return this.mRequestReason;
    }

    public int getUserId() {
        return this.mUserId;
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AuthenticationFailedInfo that = (AuthenticationFailedInfo)o;
        return Objects.equals(this.mBiometricSourceType, that.mBiometricSourceType) && this.mRequestReason == that.mRequestReason && this.mUserId == that.mUserId;
    }

    public int hashCode() {
        int _hash = 1;
        _hash = 31 * _hash + Objects.hashCode(this.mBiometricSourceType);
        _hash = 31 * _hash + this.mRequestReason;
        _hash = 31 * _hash + this.mUserId;
        return _hash;
    }

    @Override
    public void writeToParcel(@NonNull Parcel dest, int flags) {
        dest.writeTypedObject(this.mBiometricSourceType, flags);
        dest.writeInt(this.mRequestReason);
        dest.writeInt(this.mUserId);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    AuthenticationFailedInfo(@NonNull Parcel in) {
        BiometricSourceType biometricSourceType = in.readTypedObject(BiometricSourceType.CREATOR);
        int requestReason = in.readInt();
        int userId = in.readInt();
        this.mBiometricSourceType = biometricSourceType;
        AnnotationValidations.validate(NonNull.class, null, (Object)this.mBiometricSourceType);
        this.mRequestReason = requestReason;
        AnnotationValidations.validate(BiometricRequestConstants.RequestReason.class, null, this.mRequestReason);
        this.mUserId = userId;
    }

    @Deprecated
    private void __metadata() {
    }

    public static class Builder {
        @NonNull
        private BiometricSourceType mBiometricSourceType;
        private int mRequestReason;
        private int mUserId;
        private long mBuilderFieldsSet = 0L;

        public Builder(@NonNull BiometricSourceType biometricSourceType, int requestReason, int userId) {
            this.mBiometricSourceType = biometricSourceType;
            AnnotationValidations.validate(NonNull.class, null, (Object)this.mBiometricSourceType);
            this.mRequestReason = requestReason;
            AnnotationValidations.validate(BiometricRequestConstants.RequestReason.class, null, this.mRequestReason);
            this.mUserId = userId;
        }

        @NonNull
        public Builder setBiometricSourceType(@NonNull BiometricSourceType value) {
            this.checkNotUsed();
            this.mBuilderFieldsSet |= 1L;
            this.mBiometricSourceType = value;
            return this;
        }

        @NonNull
        public Builder setRequestReason(int value) {
            this.checkNotUsed();
            this.mBuilderFieldsSet |= 2L;
            this.mRequestReason = value;
            return this;
        }

        @NonNull
        public Builder setUserId(int value) {
            this.checkNotUsed();
            this.mBuilderFieldsSet |= 4L;
            this.mUserId = value;
            return this;
        }

        @NonNull
        public AuthenticationFailedInfo build() {
            this.checkNotUsed();
            this.mBuilderFieldsSet |= 8L;
            AuthenticationFailedInfo o = new AuthenticationFailedInfo(this.mBiometricSourceType, this.mRequestReason, this.mUserId);
            return o;
        }

        private void checkNotUsed() {
            if ((this.mBuilderFieldsSet & 8L) != 0L) {
                throw new IllegalStateException("This Builder should not be reused. Use a new Builder instance instead");
            }
        }
    }
}

