/*
 * Decompiled with CFR 0.152.
 */
package android.hardware;

import android.annotation.EnforcePermission;
import android.annotation.RequiresNoPermission;
import android.app.ActivityThread;
import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.PermissionEnforcer;
import android.os.RemoteException;

public interface IConsumerIrService
extends IInterface {
    @RequiresNoPermission
    public boolean hasIrEmitter() throws RemoteException;

    @EnforcePermission(value="android.permission.TRANSMIT_IR")
    public void transmit(String var1, int var2, int[] var3) throws RemoteException;

    @EnforcePermission(value="android.permission.TRANSMIT_IR")
    public int[] getCarrierFrequencies() throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements IConsumerIrService {
        private final PermissionEnforcer mEnforcer;
        public static final String DESCRIPTOR = "android.hardware.IConsumerIrService";
        static final int TRANSACTION_hasIrEmitter = 1;
        static final int TRANSACTION_transmit = 2;
        static final int TRANSACTION_getCarrierFrequencies = 3;

        public Stub(PermissionEnforcer enforcer) {
            this.attachInterface(this, DESCRIPTOR);
            if (enforcer == null) {
                throw new IllegalArgumentException("enforcer cannot be null");
            }
            this.mEnforcer = enforcer;
        }

        @Deprecated
        public Stub() {
            this(PermissionEnforcer.fromContext(ActivityThread.currentActivityThread().getSystemContext()));
        }

        public static IConsumerIrService asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(DESCRIPTOR);
            if (iin != null && iin instanceof IConsumerIrService) {
                return (IConsumerIrService)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 1: {
                    return "hasIrEmitter";
                }
                case 2: {
                    return "transmit";
                }
                case 3: {
                    return "getCarrierFrequencies";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = DESCRIPTOR;
            if (code >= 1 && code <= 0xFFFFFF) {
                data.enforceInterface(descriptor);
            }
            if (code == 1598968902) {
                reply.writeString(descriptor);
                return true;
            }
            switch (code) {
                case 1: {
                    boolean _result = this.hasIrEmitter();
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 2: {
                    String _arg0 = data.readString();
                    int _arg1 = data.readInt();
                    int[] _arg2 = data.createIntArray();
                    data.enforceNoDataAvail();
                    this.transmit(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    break;
                }
                case 3: {
                    int[] _result = this.getCarrierFrequencies();
                    reply.writeNoException();
                    reply.writeIntArray(_result);
                    break;
                }
                default: {
                    return super.onTransact(code, data, reply, flags);
                }
            }
            return true;
        }

        protected void transmit_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.TRANSMIT_IR", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void getCarrierFrequencies_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.TRANSMIT_IR", Stub.getCallingPid(), Stub.getCallingUid());
        }

        @Override
        public int getMaxTransactionId() {
            return 2;
        }

        private static class Proxy
        implements IConsumerIrService {
            private IBinder mRemote;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return Stub.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean hasIrEmitter() throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(1, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void transmit(String packageName, int carrierFrequency, int[] pattern) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(packageName);
                    _data.writeInt(carrierFrequency);
                    _data.writeIntArray(pattern);
                    boolean _status = this.mRemote.transact(2, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int[] getCarrierFrequencies() throws RemoteException {
                int[] _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(3, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.createIntArray();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }
        }
    }

    public static class Default
    implements IConsumerIrService {
        @Override
        public boolean hasIrEmitter() throws RemoteException {
            return false;
        }

        @Override
        public void transmit(String packageName, int carrierFrequency, int[] pattern) throws RemoteException {
        }

        @Override
        public int[] getCarrierFrequencies() throws RemoteException {
            return null;
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

