/*
 * Decompiled with CFR 0.152.
 */
package android.graphics.text;

import android.annotation.NonNull;
import android.graphics.Paint;
import android.graphics.text.PositionedGlyphs;
import android.ravenwood.annotation.RavenwoodKeepWholeClass;
import android.text.TextUtils;
import com.android.internal.util.Preconditions;

@RavenwoodKeepWholeClass
public class TextRunShaper {
    private TextRunShaper() {
    }

    @NonNull
    public static PositionedGlyphs shapeTextRun(@NonNull char[] text, int start, int count, int contextStart, int contextCount, float xOffset, float yOffset, boolean isRtl, @NonNull Paint paint) {
        Preconditions.checkNotNull(text);
        Preconditions.checkNotNull(paint);
        return new PositionedGlyphs(TextRunShaper.nativeShapeTextRun(text, start, count, contextStart, contextCount, isRtl, paint.getNativeInstance()), xOffset, yOffset);
    }

    @NonNull
    public static PositionedGlyphs shapeTextRun(@NonNull CharSequence text, int start, int count, int contextStart, int contextCount, float xOffset, float yOffset, boolean isRtl, @NonNull Paint paint) {
        Preconditions.checkNotNull(text);
        Preconditions.checkNotNull(paint);
        if (text instanceof String) {
            return new PositionedGlyphs(TextRunShaper.nativeShapeTextRun((String)text, start, count, contextStart, contextCount, isRtl, paint.getNativeInstance()), xOffset, yOffset);
        }
        char[] buf = new char[contextCount];
        TextUtils.getChars(text, contextStart, contextStart + contextCount, buf, 0);
        return new PositionedGlyphs(TextRunShaper.nativeShapeTextRun(buf, start - contextStart, count, 0, contextCount, isRtl, paint.getNativeInstance()), xOffset, yOffset);
    }

    private static native long nativeShapeTextRun(char[] var0, int var1, int var2, int var3, int var4, boolean var5, long var6);

    private static native long nativeShapeTextRun(String var0, int var1, int var2, int var3, int var4, boolean var5, long var6);
}

