/*
 * Decompiled with CFR 0.152.
 */
package android.graphics.drawable;

import android.content.res.Resources;
import android.graphics.Canvas;
import android.graphics.drawable.AdaptiveIconDrawable;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import com.android.launcher3.icons.MonochromeIconFactory_Accessor;
import com.android.layoutlib.bridge.android.BridgeContext;
import com.android.layoutlib.bridge.impl.RenderAction;
import com.android.tools.layoutlib.annotations.LayoutlibDelegate;

public class AdaptiveIconDrawable_Delegate {
    public static String sPath;

    public static String getResourceString(Resources res, int resId) {
        if (resId == 17040011) {
            return sPath;
        }
        return res.getString(resId);
    }

    @LayoutlibDelegate
    public static void draw(AdaptiveIconDrawable thisDrawable, Canvas canvas) {
        BridgeContext context = RenderAction.getCurrentContext();
        if (context.useThemedIcon()) {
            Drawable mono = thisDrawable.getMonochrome();
            if (mono == null && !context.forceMonochromeIcon()) {
                thisDrawable.draw_Original(canvas);
                return;
            }
            int[] colors = AdaptiveIconDrawable_Delegate.getColors();
            if (mono != null) {
                mono.mutate();
                mono.setTint(colors[1]);
            } else {
                mono = MonochromeIconFactory_Accessor.getMonochromeIcon(thisDrawable, colors[1]);
            }
            AdaptiveIconDrawable themedIcon = new AdaptiveIconDrawable(new ColorDrawable(colors[0]), mono);
            themedIcon.onBoundsChange(thisDrawable.getBounds());
            themedIcon.draw_Original(canvas);
        } else {
            thisDrawable.draw_Original(canvas);
        }
    }

    private static int[] getColors() {
        Resources resources = Resources.getSystem();
        int[] colors = new int[2];
        if (resources.getConfiguration().isNightModeActive()) {
            colors[0] = resources.getColor(17170510, null);
            colors[1] = resources.getColor(17170491, null);
        } else {
            colors[0] = resources.getColor(17170490, null);
            colors[1] = resources.getColor(17170496, null);
        }
        return colors;
    }
}

