/*
 * Decompiled with CFR 0.152.
 */
package android.graphics;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.graphics.Color;
import android.graphics.ColorSpace;
import android.graphics.Matrix;
import android.ravenwood.annotation.RavenwoodKeepWholeClass;
import libcore.util.NativeAllocationRegistry;

@RavenwoodKeepWholeClass
public class Shader {
    private final ColorSpace mColorSpace;
    private long mNativeInstance;
    private Runnable mCleaner;
    private Matrix mLocalMatrix;

    @Deprecated
    public Shader() {
        this.mColorSpace = null;
    }

    protected Shader(ColorSpace colorSpace) {
        this.mColorSpace = colorSpace;
        if (colorSpace == null) {
            throw new IllegalArgumentException("Use Shader() to create a Shader with no ColorSpace");
        }
        this.mColorSpace.getNativeInstance();
    }

    protected ColorSpace colorSpace() {
        return this.mColorSpace;
    }

    public boolean getLocalMatrix(@NonNull Matrix localM) {
        if (this.mLocalMatrix != null) {
            localM.set(this.mLocalMatrix);
            return true;
        }
        return false;
    }

    public void setLocalMatrix(@Nullable Matrix localM) {
        if (localM == null || localM.isIdentity()) {
            if (this.mLocalMatrix != null) {
                this.mLocalMatrix = null;
                this.discardNativeInstance();
            }
        } else if (this.mLocalMatrix == null) {
            this.mLocalMatrix = new Matrix(localM);
            this.discardNativeInstance();
        } else if (!this.mLocalMatrix.equals(localM)) {
            this.mLocalMatrix.set(localM);
            this.discardNativeInstance();
        }
    }

    protected long createNativeInstance(long nativeMatrix, boolean filterFromPaint) {
        return 0L;
    }

    protected final synchronized void discardNativeInstance() {
        this.discardNativeInstanceLocked();
    }

    private void discardNativeInstanceLocked() {
        if (this.mNativeInstance != 0L) {
            this.mCleaner.run();
            this.mCleaner = null;
            this.mNativeInstance = 0L;
        }
    }

    protected boolean shouldDiscardNativeInstance(boolean filterBitmap) {
        return false;
    }

    public final synchronized long getNativeInstance(boolean filterFromPaint) {
        if (this.shouldDiscardNativeInstance(filterFromPaint)) {
            this.discardNativeInstanceLocked();
        }
        if (this.mNativeInstance == 0L) {
            this.mNativeInstance = this.createNativeInstance(this.mLocalMatrix == null ? 0L : this.mLocalMatrix.ni(), filterFromPaint);
            if (this.mNativeInstance != 0L) {
                this.mCleaner = NoImagePreloadHolder.sRegistry.registerNativeAllocation(this, this.mNativeInstance);
            }
        }
        return this.mNativeInstance;
    }

    public final long getNativeInstance() {
        return this.getNativeInstance(false);
    }

    protected static long[] convertColors(@NonNull int[] colors) {
        if (colors.length < 2) {
            throw new IllegalArgumentException("needs >= 2 number of colors");
        }
        long[] colorLongs = new long[colors.length];
        for (int i = 0; i < colors.length; ++i) {
            colorLongs[i] = Color.pack(colors[i]);
        }
        return colorLongs;
    }

    protected static ColorSpace detectColorSpace(@NonNull long[] colors) {
        if (colors.length < 2) {
            throw new IllegalArgumentException("needs >= 2 number of colors");
        }
        ColorSpace colorSpace = Color.colorSpace(colors[0]);
        for (int i = 1; i < colors.length; ++i) {
            if (Color.colorSpace(colors[i]) == colorSpace) continue;
            throw new IllegalArgumentException("All colors must be in the same ColorSpace!");
        }
        return colorSpace;
    }

    private static native long nativeGetFinalizer();

    private static class NoImagePreloadHolder {
        public static final NativeAllocationRegistry sRegistry = NativeAllocationRegistry.createMalloced(Shader.class.getClassLoader(), Shader.nativeGetFinalizer());

        private NoImagePreloadHolder() {
        }
    }

    public static enum TileMode {
        CLAMP(0),
        REPEAT(1),
        MIRROR(2),
        DECAL(3);

        final int nativeInt;

        private TileMode(int nativeInt) {
            this.nativeInt = nativeInt;
        }
    }
}

