/*
 * Decompiled with CFR 0.152.
 */
package android.graphics;

import android.annotation.FlaggedApi;
import android.annotation.NonNull;
import android.annotation.Nullable;
import android.graphics.Matrix;
import android.graphics.PathIterator;
import android.graphics.Path_Delegate;
import android.graphics.RectF;
import android.ravenwood.annotation.RavenwoodClassLoadHook;
import android.ravenwood.annotation.RavenwoodKeepWholeClass;
import dalvik.annotation.optimization.CriticalNative;
import dalvik.annotation.optimization.FastNative;
import libcore.util.NativeAllocationRegistry;

@RavenwoodKeepWholeClass
@RavenwoodClassLoadHook(value="com.android.platform.test.ravenwood.runtimehelper.ClassLoadHook.onClassLoaded")
public class Path {
    public final long mNativePath;
    static final FillType[] sFillTypeArray = new FillType[]{FillType.WINDING, FillType.EVEN_ODD, FillType.INVERSE_WINDING, FillType.INVERSE_EVEN_ODD};

    public Path() {
        this.mNativePath = Path.nInit();
        NoImagePreloadHolder.sRegistry.registerNativeAllocation(this, this.mNativePath);
    }

    public Path(@Nullable Path src) {
        this.mNativePath = Path_Delegate.nInit(src != null ? src.mNativePath : 0L);
        NoImagePreloadHolder.sRegistry.registerNativeAllocation(this, this.mNativePath);
    }

    public void reset() {
        FillType fillType = this.getFillType();
        Path.nReset(this.mNativePath);
        this.setFillType(fillType);
    }

    public void rewind() {
        Path.nRewind(this.mNativePath);
    }

    public void set(@NonNull Path src) {
        if (this == src) {
            return;
        }
        Path.nSet(this.mNativePath, src.mNativePath);
    }

    @NonNull
    public PathIterator getPathIterator() {
        return new PathIterator(this);
    }

    public boolean op(@NonNull Path path, @NonNull Op op) {
        return this.op(this, path, op);
    }

    public boolean op(@NonNull Path path1, @NonNull Path path2, @NonNull Op op) {
        return Path.nOp(path1.mNativePath, path2.mNativePath, op.ordinal(), this.mNativePath);
    }

    @Deprecated
    public boolean isConvex() {
        return Path.nIsConvex(this.mNativePath);
    }

    @NonNull
    public FillType getFillType() {
        return sFillTypeArray[Path.nGetFillType(this.mNativePath)];
    }

    public void setFillType(@NonNull FillType ft) {
        Path.nSetFillType(this.mNativePath, ft.nativeInt);
    }

    public boolean isInverseFillType() {
        int ft = Path.nGetFillType(this.mNativePath);
        return (ft & FillType.INVERSE_WINDING.nativeInt) != 0;
    }

    public void toggleInverseFillType() {
        int ft = Path.nGetFillType(this.mNativePath);
        Path.nSetFillType(this.mNativePath, ft ^= FillType.INVERSE_WINDING.nativeInt);
    }

    public boolean isEmpty() {
        return Path.nIsEmpty(this.mNativePath);
    }

    public boolean isRect(@Nullable RectF rect) {
        return Path.nIsRect(this.mNativePath, rect);
    }

    public void computeBounds(@NonNull RectF bounds, boolean exact) {
        this.computeBounds(bounds);
    }

    @FlaggedApi(value="com.android.graphics.flags.exact_compute_bounds")
    public void computeBounds(@NonNull RectF bounds) {
        Path.nComputeBounds(this.mNativePath, bounds);
    }

    public void incReserve(int extraPtCount) {
        Path.nIncReserve(this.mNativePath, extraPtCount);
    }

    public void moveTo(float x, float y) {
        Path.nMoveTo(this.mNativePath, x, y);
    }

    public void rMoveTo(float dx, float dy) {
        Path.nRMoveTo(this.mNativePath, dx, dy);
    }

    public void lineTo(float x, float y) {
        Path.nLineTo(this.mNativePath, x, y);
    }

    public void rLineTo(float dx, float dy) {
        Path.nRLineTo(this.mNativePath, dx, dy);
    }

    public void quadTo(float x1, float y1, float x2, float y2) {
        Path.nQuadTo(this.mNativePath, x1, y1, x2, y2);
    }

    public void rQuadTo(float dx1, float dy1, float dx2, float dy2) {
        Path.nRQuadTo(this.mNativePath, dx1, dy1, dx2, dy2);
    }

    public void conicTo(float x1, float y1, float x2, float y2, float weight) {
        Path.nConicTo(this.mNativePath, x1, y1, x2, y2, weight);
    }

    public void rConicTo(float dx1, float dy1, float dx2, float dy2, float weight) {
        Path.nRConicTo(this.mNativePath, dx1, dy1, dx2, dy2, weight);
    }

    public void cubicTo(float x1, float y1, float x2, float y2, float x3, float y3) {
        Path.nCubicTo(this.mNativePath, x1, y1, x2, y2, x3, y3);
    }

    public void rCubicTo(float x1, float y1, float x2, float y2, float x3, float y3) {
        Path.nRCubicTo(this.mNativePath, x1, y1, x2, y2, x3, y3);
    }

    public void arcTo(@NonNull RectF oval, float startAngle, float sweepAngle, boolean forceMoveTo) {
        this.arcTo(oval.left, oval.top, oval.right, oval.bottom, startAngle, sweepAngle, forceMoveTo);
    }

    public void arcTo(@NonNull RectF oval, float startAngle, float sweepAngle) {
        this.arcTo(oval.left, oval.top, oval.right, oval.bottom, startAngle, sweepAngle, false);
    }

    public void arcTo(float left, float top, float right, float bottom, float startAngle, float sweepAngle, boolean forceMoveTo) {
        Path.nArcTo(this.mNativePath, left, top, right, bottom, startAngle, sweepAngle, forceMoveTo);
    }

    public void close() {
        Path.nClose(this.mNativePath);
    }

    public void addRect(@NonNull RectF rect, @NonNull Direction dir) {
        this.addRect(rect.left, rect.top, rect.right, rect.bottom, dir);
    }

    public void addRect(float left, float top, float right, float bottom, @NonNull Direction dir) {
        Path.nAddRect(this.mNativePath, left, top, right, bottom, dir.nativeInt);
    }

    public void addOval(@NonNull RectF oval, @NonNull Direction dir) {
        this.addOval(oval.left, oval.top, oval.right, oval.bottom, dir);
    }

    public void addOval(float left, float top, float right, float bottom, @NonNull Direction dir) {
        Path.nAddOval(this.mNativePath, left, top, right, bottom, dir.nativeInt);
    }

    public void addCircle(float x, float y, float radius, @NonNull Direction dir) {
        Path.nAddCircle(this.mNativePath, x, y, radius, dir.nativeInt);
    }

    public void addArc(@NonNull RectF oval, float startAngle, float sweepAngle) {
        this.addArc(oval.left, oval.top, oval.right, oval.bottom, startAngle, sweepAngle);
    }

    public void addArc(float left, float top, float right, float bottom, float startAngle, float sweepAngle) {
        Path.nAddArc(this.mNativePath, left, top, right, bottom, startAngle, sweepAngle);
    }

    public void addRoundRect(@NonNull RectF rect, float rx, float ry, @NonNull Direction dir) {
        this.addRoundRect(rect.left, rect.top, rect.right, rect.bottom, rx, ry, dir);
    }

    public void addRoundRect(float left, float top, float right, float bottom, float rx, float ry, @NonNull Direction dir) {
        Path.nAddRoundRect(this.mNativePath, left, top, right, bottom, rx, ry, dir.nativeInt);
    }

    public void addRoundRect(@NonNull RectF rect, @NonNull float[] radii, @NonNull Direction dir) {
        if (rect == null) {
            throw new NullPointerException("need rect parameter");
        }
        this.addRoundRect(rect.left, rect.top, rect.right, rect.bottom, radii, dir);
    }

    public void addRoundRect(float left, float top, float right, float bottom, @NonNull float[] radii, @NonNull Direction dir) {
        if (radii.length < 8) {
            throw new ArrayIndexOutOfBoundsException("radii[] needs 8 values");
        }
        Path.nAddRoundRect(this.mNativePath, left, top, right, bottom, radii, dir.nativeInt);
    }

    public void addPath(@NonNull Path src, float dx, float dy) {
        Path.nAddPath(this.mNativePath, src.mNativePath, dx, dy);
    }

    public void addPath(@NonNull Path src) {
        Path.nAddPath(this.mNativePath, src.mNativePath);
    }

    public void addPath(@NonNull Path src, @NonNull Matrix matrix) {
        Path.nAddPath(this.mNativePath, src.mNativePath, matrix.ni());
    }

    public void offset(float dx, float dy, @Nullable Path dst) {
        if (dst != null) {
            dst.set(this);
        } else {
            dst = this;
        }
        dst.offset(dx, dy);
    }

    public void offset(float dx, float dy) {
        Path.nOffset(this.mNativePath, dx, dy);
    }

    public void setLastPoint(float dx, float dy) {
        Path.nSetLastPoint(this.mNativePath, dx, dy);
    }

    public void transform(@NonNull Matrix matrix, @Nullable Path dst) {
        Path.nTransform(this.mNativePath, matrix.ni(), dst != null ? dst.mNativePath : 0L);
    }

    public void transform(@NonNull Matrix matrix) {
        Path.nTransform(this.mNativePath, matrix.ni());
    }

    public final long readOnlyNI() {
        return this.mNativePath;
    }

    final long mutateNI() {
        return this.mNativePath;
    }

    @NonNull
    public float[] approximate(float acceptableError) {
        if (acceptableError < 0.0f) {
            throw new IllegalArgumentException("AcceptableError must be greater than or equal to 0");
        }
        return Path.nApproximate(this.mNativePath, acceptableError);
    }

    public int getGenerationId() {
        return Path.nGetGenerationID(this.mNativePath);
    }

    public boolean isInterpolatable(@NonNull Path otherPath) {
        return Path.nIsInterpolatable(this.mNativePath, otherPath.mNativePath);
    }

    public boolean interpolate(@NonNull Path otherPath, float t, @NonNull Path interpolatedPath) {
        return Path.nInterpolate(this.mNativePath, otherPath.mNativePath, t, interpolatedPath.mNativePath);
    }

    public static native long nInit();

    public static native long nInit(long var0);

    private static native long nGetFinalizer();

    private static native void nSet(long var0, long var2);

    private static native void nComputeBounds(long var0, RectF var2);

    private static native void nIncReserve(long var0, int var2);

    private static native void nMoveTo(long var0, float var2, float var3);

    private static native void nRMoveTo(long var0, float var2, float var3);

    private static native void nLineTo(long var0, float var2, float var3);

    private static native void nRLineTo(long var0, float var2, float var3);

    private static native void nQuadTo(long var0, float var2, float var3, float var4, float var5);

    private static native void nRQuadTo(long var0, float var2, float var3, float var4, float var5);

    private static native void nConicTo(long var0, float var2, float var3, float var4, float var5, float var6);

    private static native void nRConicTo(long var0, float var2, float var3, float var4, float var5, float var6);

    private static native void nCubicTo(long var0, float var2, float var3, float var4, float var5, float var6, float var7);

    private static native void nRCubicTo(long var0, float var2, float var3, float var4, float var5, float var6, float var7);

    private static native void nArcTo(long var0, float var2, float var3, float var4, float var5, float var6, float var7, boolean var8);

    private static native void nClose(long var0);

    private static native void nAddRect(long var0, float var2, float var3, float var4, float var5, int var6);

    private static native void nAddOval(long var0, float var2, float var3, float var4, float var5, int var6);

    private static native void nAddCircle(long var0, float var2, float var3, float var4, int var5);

    private static native void nAddArc(long var0, float var2, float var3, float var4, float var5, float var6, float var7);

    private static native void nAddRoundRect(long var0, float var2, float var3, float var4, float var5, float var6, float var7, int var8);

    private static native void nAddRoundRect(long var0, float var2, float var3, float var4, float var5, float[] var6, int var7);

    private static native void nAddPath(long var0, long var2, float var4, float var5);

    private static native void nAddPath(long var0, long var2);

    private static native void nAddPath(long var0, long var2, long var4);

    private static native void nOffset(long var0, float var2, float var3);

    private static native void nSetLastPoint(long var0, float var2, float var3);

    private static native void nTransform(long var0, long var2, long var4);

    private static native void nTransform(long var0, long var2);

    private static native boolean nOp(long var0, long var2, int var4, long var5);

    private static native float[] nApproximate(long var0, float var2);

    private static native boolean nInterpolate(long var0, long var2, float var4, long var5);

    @FastNative
    private static native boolean nIsRect(long var0, RectF var2);

    @CriticalNative
    private static native int nGetGenerationID(long var0);

    @CriticalNative
    private static native boolean nIsInterpolatable(long var0, long var2);

    @CriticalNative
    private static native void nReset(long var0);

    @CriticalNative
    private static native void nRewind(long var0);

    @CriticalNative
    private static native boolean nIsEmpty(long var0);

    @CriticalNative
    private static native boolean nIsConvex(long var0);

    @CriticalNative
    private static native int nGetFillType(long var0);

    @CriticalNative
    private static native void nSetFillType(long var0, int var2);

    private static class NoImagePreloadHolder {
        static final NativeAllocationRegistry sRegistry = NativeAllocationRegistry.createMalloced(Path.class.getClassLoader(), Path.nGetFinalizer());

        private NoImagePreloadHolder() {
        }
    }

    public static enum FillType {
        WINDING(0),
        EVEN_ODD(1),
        INVERSE_WINDING(2),
        INVERSE_EVEN_ODD(3);

        final int nativeInt;

        private FillType(int ni) {
            this.nativeInt = ni;
        }
    }

    public static enum Op {
        DIFFERENCE,
        INTERSECT,
        UNION,
        XOR,
        REVERSE_DIFFERENCE;

    }

    public static enum Direction {
        CW(0),
        CCW(1);

        final int nativeInt;

        private Direction(int ni) {
            this.nativeInt = ni;
        }
    }
}

