/*
 * Decompiled with CFR 0.152.
 */
package android.graphics;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.graphics.Rect;
import android.os.Parcel;
import android.os.Parcelable;
import android.ravenwood.annotation.RavenwoodKeepWholeClass;

@RavenwoodKeepWholeClass
public class Insets
implements Parcelable {
    @NonNull
    public static final Insets NONE = new Insets(0, 0, 0, 0);
    public final int left;
    public final int top;
    public final int right;
    public final int bottom;
    @NonNull
    public static final Parcelable.Creator<Insets> CREATOR = new Parcelable.Creator<Insets>(){

        @Override
        public Insets createFromParcel(Parcel in) {
            return new Insets(in.readInt(), in.readInt(), in.readInt(), in.readInt());
        }

        public Insets[] newArray(int size) {
            return new Insets[size];
        }
    };

    private Insets(int left, int top, int right, int bottom) {
        this.left = left;
        this.top = top;
        this.right = right;
        this.bottom = bottom;
    }

    @NonNull
    public static Insets of(int left, int top, int right, int bottom) {
        if (left == 0 && top == 0 && right == 0 && bottom == 0) {
            return NONE;
        }
        return new Insets(left, top, right, bottom);
    }

    @NonNull
    public static Insets of(@Nullable Rect r) {
        return r == null ? NONE : Insets.of(r.left, r.top, r.right, r.bottom);
    }

    @NonNull
    public Rect toRect() {
        return new Rect(this.left, this.top, this.right, this.bottom);
    }

    @NonNull
    public static Insets add(@NonNull Insets a, @NonNull Insets b) {
        return Insets.of(a.left + b.left, a.top + b.top, a.right + b.right, a.bottom + b.bottom);
    }

    @NonNull
    public static Insets subtract(@NonNull Insets a, @NonNull Insets b) {
        return Insets.of(a.left - b.left, a.top - b.top, a.right - b.right, a.bottom - b.bottom);
    }

    @NonNull
    public static Insets max(@NonNull Insets a, @NonNull Insets b) {
        return Insets.of(Math.max(a.left, b.left), Math.max(a.top, b.top), Math.max(a.right, b.right), Math.max(a.bottom, b.bottom));
    }

    @NonNull
    public static Insets min(@NonNull Insets a, @NonNull Insets b) {
        return Insets.of(Math.min(a.left, b.left), Math.min(a.top, b.top), Math.min(a.right, b.right), Math.min(a.bottom, b.bottom));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Insets insets = (Insets)o;
        if (this.bottom != insets.bottom) {
            return false;
        }
        if (this.left != insets.left) {
            return false;
        }
        if (this.right != insets.right) {
            return false;
        }
        return this.top == insets.top;
    }

    public int hashCode() {
        int result = this.left;
        result = 31 * result + this.top;
        result = 31 * result + this.right;
        result = 31 * result + this.bottom;
        return result;
    }

    public String toString() {
        return "Insets{left=" + this.left + ", top=" + this.top + ", right=" + this.right + ", bottom=" + this.bottom + '}';
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel out, int flags) {
        out.writeInt(this.left);
        out.writeInt(this.top);
        out.writeInt(this.right);
        out.writeInt(this.bottom);
    }
}

