/*
 * Decompiled with CFR 0.152.
 */
package android.graphics;

import android.annotation.NonNull;
import android.os.Handler;
import android.ravenwood.annotation.RavenwoodKeepWholeClass;
import com.android.internal.util.VirtualRefBasePtr;
import java.lang.ref.WeakReference;

@RavenwoodKeepWholeClass
public final class HardwareRendererObserver {
    private final long[] mFrameMetrics;
    private final Handler mHandler;
    private final OnFrameMetricsAvailableListener mListener;
    private VirtualRefBasePtr mNativePtr;

    public HardwareRendererObserver(@NonNull OnFrameMetricsAvailableListener listener, @NonNull long[] frameMetrics, @NonNull Handler handler, boolean waitForPresentTime) {
        if (handler == null || handler.getLooper() == null) {
            throw new NullPointerException("handler and its looper cannot be null");
        }
        if (handler.getLooper().getQueue() == null) {
            throw new IllegalStateException("invalid looper, null message queue\n");
        }
        this.mFrameMetrics = frameMetrics;
        this.mHandler = handler;
        this.mListener = listener;
        this.mNativePtr = new VirtualRefBasePtr(HardwareRendererObserver.nCreateObserver(new WeakReference<HardwareRendererObserver>(this), waitForPresentTime));
    }

    long getNativeInstance() {
        return this.mNativePtr.get();
    }

    private void notifyDataAvailable() {
        this.mHandler.post(() -> {
            boolean hasMoreData = true;
            while (hasMoreData) {
                int dropCount = HardwareRendererObserver.nGetNextBuffer(this.mNativePtr.get(), this.mFrameMetrics);
                if (dropCount >= 0) {
                    this.mListener.onFrameMetricsAvailable(dropCount);
                    continue;
                }
                hasMoreData = false;
            }
        });
    }

    static boolean invokeDataAvailable(WeakReference<HardwareRendererObserver> weakObserver) {
        HardwareRendererObserver observer = (HardwareRendererObserver)weakObserver.get();
        if (observer != null) {
            observer.notifyDataAvailable();
            return true;
        }
        return false;
    }

    private static native long nCreateObserver(WeakReference<HardwareRendererObserver> var0, boolean var1);

    private static native int nGetNextBuffer(long var0, long[] var2);

    public static interface OnFrameMetricsAvailableListener {
        public void onFrameMetricsAvailable(int var1);
    }
}

