/*
 * Decompiled with CFR 0.152.
 */
package android.federatedcompute.common;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.content.ComponentName;
import android.federatedcompute.common.TrainingInterval;
import android.os.Parcel;
import android.os.Parcelable;
import com.android.internal.util.Preconditions;
import com.android.ondevicepersonalization.internal.util.AnnotationValidations;
import java.util.Arrays;
import java.util.Objects;

public class TrainingOptions
implements Parcelable {
    @NonNull
    private String mPopulationName = "";
    @NonNull
    private String mServerAddress = "";
    @Nullable
    private ComponentName mOwnerComponentName = null;
    @Nullable
    private TrainingInterval mTrainingInterval = null;
    @Nullable
    private final byte[] mContextData;
    @NonNull
    public static final Parcelable.Creator<TrainingOptions> CREATOR = new Parcelable.Creator<TrainingOptions>(){

        public TrainingOptions[] newArray(int size) {
            return new TrainingOptions[size];
        }

        @Override
        public TrainingOptions createFromParcel(@NonNull Parcel in) {
            return new TrainingOptions(in);
        }
    };

    TrainingOptions(@NonNull String populationName, @NonNull String serverAddress, @Nullable ComponentName ownerComponentName, @Nullable TrainingInterval trainingInterval, @Nullable byte[] contextData) {
        this.mPopulationName = populationName;
        AnnotationValidations.validate(NonNull.class, null, (Object)this.mPopulationName);
        this.mServerAddress = serverAddress;
        AnnotationValidations.validate(NonNull.class, null, (Object)this.mServerAddress);
        this.mOwnerComponentName = ownerComponentName;
        this.mTrainingInterval = trainingInterval;
        this.mContextData = contextData;
    }

    @NonNull
    public String getPopulationName() {
        return this.mPopulationName;
    }

    @NonNull
    public String getServerAddress() {
        return this.mServerAddress;
    }

    @Nullable
    public ComponentName getOwnerComponentName() {
        return this.mOwnerComponentName;
    }

    @Nullable
    public TrainingInterval getTrainingInterval() {
        return this.mTrainingInterval;
    }

    @Nullable
    public byte[] getContextData() {
        return this.mContextData;
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TrainingOptions that = (TrainingOptions)o;
        return Objects.equals(this.mPopulationName, that.mPopulationName) && Objects.equals(this.mServerAddress, that.mServerAddress) && Objects.equals(this.mOwnerComponentName, that.mOwnerComponentName) && Objects.equals(this.mTrainingInterval, that.mTrainingInterval) && Arrays.equals(this.mContextData, that.mContextData);
    }

    public int hashCode() {
        int _hash = 1;
        _hash = 31 * _hash + Objects.hashCode(this.mPopulationName);
        _hash = 31 * _hash + Objects.hashCode(this.mServerAddress);
        _hash = 31 * _hash + Objects.hashCode(this.mOwnerComponentName);
        _hash = 31 * _hash + Objects.hashCode(this.mTrainingInterval);
        _hash = 31 * _hash + Arrays.hashCode(this.mContextData);
        return _hash;
    }

    @Override
    public void writeToParcel(@NonNull Parcel dest, int flags) {
        byte flg = 0;
        if (this.mOwnerComponentName != null) {
            flg = (byte)(flg | 4);
        }
        if (this.mTrainingInterval != null) {
            flg = (byte)(flg | 8);
        }
        dest.writeByte(flg);
        dest.writeString(this.mPopulationName);
        dest.writeString(this.mServerAddress);
        if (this.mOwnerComponentName != null) {
            dest.writeTypedObject(this.mOwnerComponentName, flags);
        }
        if (this.mTrainingInterval != null) {
            dest.writeTypedObject(this.mTrainingInterval, flags);
        }
        dest.writeByteArray(this.mContextData);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    TrainingOptions(@NonNull Parcel in) {
        byte flg = in.readByte();
        String populationName = in.readString();
        String serverAddress = in.readString();
        ComponentName ownerComponentName = (flg & 4) == 0 ? null : in.readTypedObject(ComponentName.CREATOR);
        TrainingInterval trainingInterval = (flg & 8) == 0 ? null : in.readTypedObject(TrainingInterval.CREATOR);
        byte[] contextData = in.createByteArray();
        this.mPopulationName = populationName;
        AnnotationValidations.validate(NonNull.class, null, (Object)this.mPopulationName);
        this.mServerAddress = serverAddress;
        AnnotationValidations.validate(NonNull.class, null, (Object)this.mServerAddress);
        this.mOwnerComponentName = ownerComponentName;
        this.mTrainingInterval = trainingInterval;
        this.mContextData = contextData;
    }

    @Deprecated
    private void __metadata() {
    }

    public static class Builder {
        @NonNull
        private String mPopulationName;
        @NonNull
        private String mServerAddress;
        @Nullable
        private ComponentName mOwnerComponentName;
        @Nullable
        private TrainingInterval mTrainingInterval;
        @Nullable
        private byte[] mContextData;
        private long mBuilderFieldsSet = 0L;

        @NonNull
        public Builder setPopulationName(@NonNull String value) {
            this.checkNotUsed();
            Preconditions.checkStringNotEmpty(value);
            this.mBuilderFieldsSet |= 1L;
            this.mPopulationName = value;
            return this;
        }

        @NonNull
        public Builder setServerAddress(@NonNull String value) {
            this.checkNotUsed();
            Preconditions.checkStringNotEmpty(value);
            this.mBuilderFieldsSet |= 2L;
            this.mServerAddress = value;
            return this;
        }

        @NonNull
        public Builder setOwnerComponentName(@NonNull ComponentName value) {
            this.checkNotUsed();
            this.mBuilderFieldsSet |= 4L;
            this.mOwnerComponentName = value;
            return this;
        }

        @NonNull
        public Builder setTrainingInterval(@NonNull TrainingInterval value) {
            this.checkNotUsed();
            this.mBuilderFieldsSet |= 8L;
            this.mTrainingInterval = value;
            return this;
        }

        @NonNull
        public Builder setContextData(byte ... value) {
            this.checkNotUsed();
            this.mBuilderFieldsSet |= 0x10L;
            this.mContextData = value;
            return this;
        }

        @NonNull
        public TrainingOptions build() {
            this.checkNotUsed();
            this.mBuilderFieldsSet |= 0x20L;
            if ((this.mBuilderFieldsSet & 1L) == 0L) {
                this.mPopulationName = "";
            }
            if ((this.mBuilderFieldsSet & 2L) == 0L) {
                this.mServerAddress = "";
            }
            if ((this.mBuilderFieldsSet & 4L) == 0L) {
                this.mOwnerComponentName = null;
            }
            if ((this.mBuilderFieldsSet & 8L) == 0L) {
                this.mTrainingInterval = null;
            }
            TrainingOptions o = new TrainingOptions(this.mPopulationName, this.mServerAddress, this.mOwnerComponentName, this.mTrainingInterval, this.mContextData);
            return o;
        }

        private void checkNotUsed() {
            if ((this.mBuilderFieldsSet & 0x20L) != 0L) {
                throw new IllegalStateException("This Builder should not be reused. Use a new Builder instance instead");
            }
        }
    }
}

